// Package decrypt contains the Decrypt function.
package decrypt

import (
	"encoding/base64"
	"fmt"

	"golang.org/x/crypto/nacl/secretbox"
)

// Decrypt decrypts the configuration with the given key.
func Decrypt(key string, byts []byte) ([]byte, error) {
	enc, err := base64.StdEncoding.DecodeString(string(byts))
	if err != nil {
		return nil, err
	}

	var secretKey [32]byte
	copy(secretKey[:], key)

	var decryptNonce [24]byte
	copy(decryptNonce[:], enc[:24])
	decrypted, ok := secretbox.Open(nil, enc[24:], &decryptNonce, &secretKey)
	if !ok {
		return nil, fmt.Errorf("decryption error")
	}

	return decrypted, nil
}
