//nolint:dupl
package mpegts

import (
	"bytes"
	"testing"

	"github.com/stretchr/testify/require"

	"github.com/bluenviron/mediacommon/v2/pkg/codecs/mpeg4audio"
)

func TestTrackUnmarshalExternal(t *testing.T) {
	for _, ca := range []struct {
		name  string
		byts  []byte
		track *Track
	}{
		{
			"h264 gstreamer",
			[]byte{
				0x47, 0x40, 0x00, 0x31, 0xa6, 0x00, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0x00, 0x00, 0xb0, 0x0d, 0x00,
				0x01, 0xc1, 0x00, 0x00, 0x00, 0x01, 0xe0, 0x20,
				0xa2, 0xc3, 0x29, 0x41,
				0x47, 0x40, 0x20, 0x31, 0x97, 0x00, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0x00, 0x02, 0xb0, 0x1c,
				0x00, 0x01, 0xc1, 0x00, 0x00, 0xe0, 0x41, 0xf0,
				0x00, 0x1b, 0xe0, 0x41, 0xf0, 0x0a, 0x05, 0x08,
				0x48, 0x44, 0x4d, 0x56, 0xff, 0x1b, 0x44, 0x3f,
				0x45, 0xdd, 0x4e, 0x12,
			},
			&Track{
				PID:   65,
				Codec: &CodecH264{},
			},
		},
		{
			"h264 ffmpeg",
			[]byte{
				0x47, 0x40, 0x00, 0x10,
				0x00, 0x00, 0xb0, 0x0d, 0x00, 0x01, 0xc1, 0x00,
				0x00, 0x00, 0x01, 0xf0, 0x00, 0x2a, 0xb1, 0x04,
				0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0x47, 0x50, 0x00, 0x10, 0x00, 0x02, 0xb0, 0x12,
				0x00, 0x01, 0xc1, 0x00, 0x00, 0xe1, 0x00, 0xf0,
				0x00, 0x1b, 0xe1, 0x00, 0xf0, 0x00, 0x15, 0xbd,
				0x4d, 0x56, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff,
			},
			&Track{
				PID:   256,
				Codec: &CodecH264{},
			},
		},
		{
			"h265",
			[]byte{
				0x47, 0x40, 0x00, 0x10,
				0x00, 0x00, 0xb0, 0x0d, 0x00, 0x01, 0xc1, 0x00,
				0x00, 0x00, 0x01, 0xf0, 0x00, 0x2a, 0xb1, 0x04,
				0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0x47, 0x50, 0x00, 0x10, 0x00, 0x02, 0xb0, 0x18,
				0x00, 0x01, 0xc1, 0x00, 0x00, 0xe1, 0x00, 0xf0,
				0x00, 0x24, 0xe1, 0x00, 0xf0, 0x06, 0x05, 0x04,
				0x48, 0x45, 0x56, 0x43, 0xcb, 0x9e, 0x00, 0x52,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff,
			},
			&Track{
				PID:   256,
				Codec: &CodecH265{},
			},
		},
		{
			"mpeg4-audio",
			[]byte{
				0x47, 0x40, 0x00, 0x10,
				0x00, 0x00, 0xb0, 0x0d, 0x00, 0x01, 0xc1, 0x00,
				0x00, 0x00, 0x01, 0xf0, 0x00, 0x2a, 0xb1, 0x04,
				0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0x47, 0x50, 0x00, 0x10, 0x00, 0x02, 0xb0, 0x18,
				0x00, 0x01, 0xc1, 0x00, 0x00, 0xe1, 0x00, 0xf0,
				0x00, 0x0f, 0xe1, 0x00, 0xf0, 0x06, 0x0a, 0x04,
				0x65, 0x6e, 0x67, 0x00, 0x90, 0xd3, 0x1b, 0x58,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0x47, 0x41, 0x00, 0x30,
				0x07, 0x50, 0x00, 0x00, 0x7b, 0x0c, 0x7e, 0x00,
				0x00, 0x00, 0x01, 0xc0, 0x0b, 0x11, 0x80, 0x80,
				0x05, 0x21, 0x00, 0x07, 0xd8, 0x61, 0xff, 0xf1,
				0x4c, 0x80, 0x03, 0xdf, 0xfc, 0xde, 0x02, 0x00,
				0x4c, 0x61, 0x76, 0x63, 0x35, 0x38, 0x2e, 0x31,
				0x34, 0x2e, 0x31, 0x30, 0x30, 0x00, 0x42, 0x20,
				0x08, 0xc1, 0x18, 0x38, 0xff, 0xf1, 0x4c, 0x80,
				0x01, 0xbf, 0xfc, 0x21, 0x10, 0x04, 0x60, 0x8c,
				0x1c, 0xff, 0xf1, 0x4c, 0x80, 0x01, 0xbf, 0xfc,
				0x21, 0x20, 0x04, 0x60, 0x8c, 0x1c, 0xff, 0xf1,
				0x4c, 0x80, 0x2f, 0x5f, 0xfc, 0x21, 0x4c, 0xcc,
				0x80, 0x01, 0x80, 0x7f, 0xff, 0xff, 0x39, 0x07,
				0xa0, 0x91, 0x07, 0x37, 0xe3, 0x9b, 0xf0, 0x09,
				0xfb, 0x01, 0x15, 0xc7, 0x5f, 0x20, 0x12, 0xc4,
				0x08, 0xff, 0x06, 0x4c, 0x49, 0x27, 0xcb, 0xf7,
				0xb2, 0x7c, 0xa2, 0x58, 0xfd, 0x24, 0xb9, 0x28,
				0x9c, 0x05, 0xd8, 0xe0, 0x95, 0x2d, 0x91, 0x05,
				0xb2, 0x71, 0xb0, 0xd8, 0x2e, 0x70, 0x99, 0xa3,
				0x13, 0x97, 0x18, 0x8e, 0x1b, 0x18, 0x43, 0x38,
				0xbe, 0x13, 0x0c, 0x42, 0x8c, 0x02, 0x6b, 0x31,
				0x35, 0xc0, 0x26, 0x0a, 0xc4, 0x38, 0x3e, 0x5f,
				0x85, 0xc6, 0x60, 0xf5, 0x89, 0xc2, 0x8c, 0x4e,
				0x34, 0x22, 0x39, 0x0b, 0xa4, 0x06, 0x32, 0x1a,
				0x47, 0x01, 0x00, 0x11, 0xf1, 0xe0, 0xc9, 0x97,
				0x86, 0x40, 0x69, 0x20, 0xa6, 0x10, 0x52, 0x6a,
				0x6c, 0x15, 0x4c, 0x99, 0x6d, 0x24, 0x26, 0x2b,
				0x3b, 0x98, 0x9c, 0x04, 0xcb, 0x75, 0xc9, 0x8c,
				0x44, 0x0a, 0x0c, 0xe3, 0xf0, 0x79, 0xdc, 0x16,
				0xed, 0x29, 0x44, 0xd9, 0x54, 0x15, 0x98, 0x25,
				0x8b, 0x73, 0x3b, 0x3b, 0xf3, 0x2b, 0x0f, 0x1f,
				0x87, 0xd8, 0xe1, 0xfd, 0x37, 0x69, 0x33, 0xe6,
				0xa5, 0x71, 0x11, 0x0a, 0xc8, 0x1a, 0x04, 0xaa,
				0x49, 0x45, 0x96, 0x98, 0x49, 0x84, 0x44, 0xc4,
				0x1f, 0xed, 0xf3, 0x5e, 0x93, 0xfa, 0xfe, 0x3d,
				0x5e, 0x61, 0xed, 0x9e, 0x87, 0x22, 0x73, 0xe5,
				0x78, 0x1d, 0x1d, 0xcb, 0x79, 0x59, 0x7d, 0x3d,
				0x0f, 0xad, 0xe7, 0xfb, 0x1b, 0xf9, 0xa1, 0x81,
				0x81, 0xac, 0x80, 0x8f, 0x97, 0xd8, 0x6e, 0x40,
				0x7e, 0x5d, 0xb3, 0xf4, 0x87, 0xe6, 0xd5, 0x6b,
				0x2f, 0xcd, 0x0e, 0xfa, 0x11, 0x49, 0xd8, 0xa7,
				0x51, 0x1b, 0xfc, 0x79, 0x2b, 0x73, 0x67, 0xff,
				0x6c, 0x96, 0x43, 0x29, 0x07, 0x63, 0x79, 0x27,
				0x57, 0xfb, 0x6f, 0xfd, 0xf4, 0xb1, 0xe5, 0xe9,
				0xce, 0x79, 0x80, 0x00, 0x58, 0x9e, 0x40, 0x21,
				0x91, 0xb6, 0x4a, 0x56, 0x60, 0x9d, 0xf8, 0xa4,
				0x0b, 0x38, 0x8e, 0x1c, 0xa4, 0xaf, 0x5e, 0x23,
				0x2a, 0x2c, 0xff, 0xac, 0x47, 0x01, 0x00, 0x12,
				0xc1, 0xe3, 0x11, 0x34, 0x02, 0x12, 0x92, 0x41,
				0xc6, 0x23, 0x3e, 0x01, 0x2a, 0x70, 0x25, 0x29,
				0xa4, 0x4d, 0x43, 0x2a, 0xb4, 0x8b, 0x01, 0x66,
				0x8c, 0x98, 0xa3, 0x4b, 0x60, 0xf1, 0x3e, 0x6c,
				0xa1, 0x03, 0x74, 0x87, 0x20, 0x18, 0x85, 0x11,
				0x58, 0xb4, 0x26, 0x3c, 0xec, 0x4e, 0x48, 0x67,
				0xf6, 0x6f, 0x9a, 0xf1, 0x3f, 0x51, 0xd4, 0x1e,
				0x5d, 0x2a, 0x91, 0xc8, 0x3d, 0x04, 0x28, 0x39,
				0x1f, 0x47, 0xc0, 0x27, 0xec, 0x04, 0x57, 0x1d,
				0x7c, 0x80, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
				0xff, 0xf1, 0x4c, 0x80, 0x64, 0xbf, 0xfc, 0x21,
				0x7a, 0x14, 0x65, 0xfd, 0x27, 0xde, 0x6b, 0xc5,
				0xfe, 0xbf, 0xc4, 0x66, 0x71, 0xbc, 0xe3, 0x16,
				0xb6, 0x37, 0x72, 0x5e, 0xab, 0x99, 0xd4, 0xa8,
				0xf6, 0x04, 0xb5, 0xbe, 0x19, 0x21, 0xed, 0xee,
				0x3d, 0x66, 0xf1, 0x12, 0x34, 0x90, 0x47, 0x65,
				0x14, 0x8a, 0xad, 0x93, 0x95, 0xa8, 0x23, 0x59,
				0xa4, 0x33, 0x91, 0x49, 0x8b, 0x08, 0x47, 0x6f,
				0x8f, 0x21, 0x81, 0x94, 0x4a, 0x44, 0x12, 0x7b,
				0x2a, 0x64, 0xc3, 0xc7, 0x78, 0x5a, 0x84, 0xf6,
				0xf8, 0xc2, 0x4f, 0x79, 0x1d, 0xbe, 0x5e, 0xa2,
				0x80, 0x43, 0x5b, 0x0e, 0xea, 0xc5, 0x11, 0x56,
				0x47, 0x01, 0x00, 0x13, 0x02, 0xa4, 0x86, 0x42,
				0x91, 0x88, 0xd2, 0xaf, 0x53, 0x40, 0x23, 0x73,
				0x4c, 0x4e, 0xb0, 0x48, 0x52, 0x29, 0x19, 0xda,
				0xd2, 0x37, 0xf0, 0x64, 0xed, 0x00, 0x92, 0xa5,
				0x12, 0xaf, 0xad, 0xba, 0x68, 0x4b, 0x93, 0x09,
				0xe3, 0x31, 0x04, 0xb3, 0x36, 0x78, 0x42, 0x10,
				0x9f, 0xaa, 0x23, 0x33, 0x22, 0x4c, 0xc6, 0x27,
				0x08, 0x44, 0x28, 0x68, 0xc9, 0xd8, 0x94, 0x4a,
				0x2a, 0x48, 0xe1, 0x2f, 0x13, 0x45, 0x92, 0x53,
				0x35, 0xb5, 0x86, 0x20, 0x96, 0x44, 0x84, 0x89,
				0x07, 0x8f, 0x89, 0x4c, 0xc6, 0x12, 0x99, 0x66,
				0xde, 0xbb, 0x95, 0xe2, 0x92, 0xc8, 0xe3, 0x09,
				0xd0, 0xa8, 0x42, 0x86, 0x10, 0x95, 0x08, 0xa4,
				0x70, 0x99, 0xd2, 0x29, 0x4f, 0xe8, 0x4c, 0xb2,
				0x89, 0xd3, 0xcd, 0x12, 0xa7, 0x14, 0x9d, 0xe2,
				0x13, 0x8a, 0x4a, 0x82, 0x11, 0x2c, 0x66, 0x1c,
				0x9b, 0x69, 0xc1, 0xa8, 0x3a, 0x75, 0xbd, 0x09,
				0x3b, 0x1a, 0x40, 0xc2, 0x27, 0x31, 0xa4, 0xb2,
				0x39, 0x12, 0x18, 0x29, 0x04, 0x29, 0xd3, 0x97,
				0x26, 0x50, 0x10, 0x65, 0xc9, 0x84, 0x32, 0x32,
				0x08, 0x5e, 0x98, 0x42, 0x63, 0x49, 0x32, 0x15,
				0x8d, 0x20, 0x82, 0x52, 0x4c, 0xf1, 0x48, 0xc5,
				0xa6, 0x43, 0x02, 0x7c, 0x19, 0x92, 0x86, 0x3e,
				0x50, 0xbc, 0x46, 0x45,
				0x47, 0x01, 0x00, 0x14, 0x3b, 0x4a, 0x55, 0x17,
				0x16, 0x5a, 0x84, 0x48, 0x96, 0xc9, 0x92, 0xb4,
				0xb6, 0xc2, 0x14, 0xd9, 0x2d, 0xca, 0x21, 0x36,
				0x29, 0x3c, 0xd1, 0x08, 0xc0, 0x39, 0x3a, 0x93,
				0x09, 0x0f, 0x02, 0x44, 0xf5, 0x88, 0xc2, 0x85,
				0x32, 0xdd, 0xe3, 0xb5, 0x88, 0xb5, 0x37, 0x6a,
				0x72, 0xb4, 0x22, 0x77, 0x72, 0x04, 0xaa, 0x24,
				0x85, 0xe8, 0xa4, 0x20, 0x45, 0x21, 0x37, 0x0a,
				0x40, 0xc6, 0x23, 0x5d, 0xd3, 0xa4, 0x82, 0x4e,
				0x0e, 0x74, 0x8b, 0xe5, 0x14, 0x15, 0x42, 0x01,
				0x80, 0x42, 0xa4, 0x5a, 0x8e, 0x84, 0xb1, 0x28,
				0x9d, 0x69, 0x04, 0xe4, 0x50, 0x22, 0x90, 0x91,
				0xb7, 0x9a, 0x21, 0x78, 0xe4, 0x8e, 0x12, 0x49,
				0x95, 0x80, 0x87, 0x06, 0x90, 0x40, 0xf0, 0xa5,
				0x34, 0xee, 0x72, 0x55, 0xe1, 0x93, 0xa7, 0x6a,
				0xea, 0x86, 0x4d, 0x56, 0xa6, 0x4c, 0x69, 0x08,
				0x74, 0xee, 0x96, 0xf2, 0x39, 0x03, 0x1a, 0xa6,
				0xa1, 0x76, 0xb7, 0x81, 0x65, 0x75, 0x13, 0x1a,
				0xb2, 0x02, 0x72, 0x03, 0x72, 0x14, 0x52, 0x05,
				0x94, 0x42, 0xd3, 0x48, 0x95, 0xb2, 0x74, 0xef,
				0x4f, 0xff, 0x72, 0x69, 0x95, 0x44, 0x45, 0x93,
				0xe0, 0xd1, 0x70, 0x49, 0xc5, 0x6c, 0xbf, 0x38,
				0x8b, 0x6b, 0x13, 0x14, 0xb2, 0x29, 0xa2, 0x41,
				0xf1, 0x6a, 0x2a, 0x24,
				0x47, 0x01, 0x00, 0x15,
				0x13, 0x2f, 0x84, 0xaf, 0xc7, 0x68, 0xe8, 0x13,
				0x3a, 0x48, 0xa4, 0x59, 0x0d, 0x24, 0x92, 0x9e,
				0xb8, 0xb3, 0xd3, 0xa7, 0x7f, 0xdc, 0x80, 0x23,
				0x71, 0xd0, 0x10, 0x5a, 0xc9, 0xd6, 0x01, 0x28,
				0x06, 0xe2, 0x64, 0x57, 0x1b, 0x06, 0x8c, 0x49,
				0x60, 0xe3, 0xa0, 0x9e, 0x38, 0x6e, 0x0b, 0x8c,
				0xe3, 0xab, 0xc1, 0x81, 0x63, 0x46, 0x23, 0x0e,
				0x3f, 0x1d, 0x37, 0x0a, 0x32, 0x74, 0x07, 0x50,
				0x36, 0xea, 0x31, 0x38, 0xf0, 0x25, 0x05, 0x54,
				0xd1, 0xfb, 0x5e, 0xe8, 0x6d, 0x4a, 0x62, 0x43,
				0x86, 0x4d, 0x4d, 0x21, 0x43, 0x00, 0x46, 0x9e,
				0x50, 0x9d, 0x39, 0x04, 0x29, 0xe8, 0xf3, 0xb4,
				0x1a, 0x02, 0x2e, 0x0b, 0x23, 0xe8, 0x7a, 0xaf,
				0xaa, 0x60, 0xdf, 0x51, 0xea, 0x8e, 0x92, 0xfa,
				0x87, 0xd1, 0xc1, 0x36, 0xc2, 0x0c, 0x61, 0x22,
				0xb3, 0xfc, 0x08, 0x15, 0x84, 0x4b, 0x47, 0x6c,
				0xc0, 0x61, 0xf1, 0xc2, 0xd6, 0xa5, 0xc0, 0xd8,
				0x44, 0xa5, 0xcc, 0x38, 0x0c, 0x3e, 0x38, 0x5c,
				0x98, 0xce, 0x10, 0xa4, 0x80, 0x00, 0x26, 0x00,
				0x10, 0x04, 0x0a, 0x26, 0x45, 0xa2, 0x8e, 0x16,
				0x06, 0xc5, 0x20, 0x88, 0x04, 0xd0, 0x02, 0x48,
				0x41, 0x34, 0x00, 0x98, 0x10, 0x46, 0x04, 0x0e,
				0x11, 0x1c, 0x70, 0x1f, 0xf4, 0xc9, 0xf2, 0x89,
				0x47, 0x01, 0x00, 0x16, 0x95, 0x9e, 0x86, 0x4d,
				0x85, 0xc9, 0xc5, 0xe3, 0x90, 0xc8, 0xc3, 0x2e,
				0x06, 0x5f, 0xf2, 0x66, 0x3c, 0x9d, 0x0e, 0xb4,
				0x87, 0x41, 0xb2, 0xb5, 0x86, 0x4c, 0xa5, 0xe1,
				0x40, 0x4a, 0x04, 0x02, 0x68, 0x06, 0xc4, 0x24,
				0x04, 0x51, 0x08, 0xa2, 0x41, 0x44, 0x02, 0x8a,
				0x41, 0x30, 0x40, 0xd8, 0xc4, 0xd0, 0x82, 0x32,
				0x00, 0x4d, 0x10, 0x38, 0x54, 0x10, 0x44, 0x0a,
				0x20, 0x1c, 0x71, 0x1c, 0x71, 0x04, 0x80, 0x02,
				0x20, 0x05, 0x10, 0x8e, 0x3a, 0x0d, 0x8b, 0x44,
				0x20, 0x92, 0x00, 0x40, 0x00, 0xa2, 0x50, 0x4a,
				0x02, 0x2d, 0x24, 0x70, 0x88, 0x22, 0x84, 0x13,
				0x91, 0x70, 0x95, 0xc2, 0x70, 0xa4, 0x26, 0x42,
				0x10, 0x24, 0x82, 0x17, 0x24, 0x71, 0xd2, 0x00,
				0x00, 0x00, 0x00, 0x04, 0x60, 0xfd, 0x27, 0xde,
				0x6b, 0xc5, 0xfe, 0xbf, 0xc4, 0x66, 0x71, 0xbc,
				0xe3, 0x16, 0xb6, 0x37, 0x72, 0x5e, 0xab, 0x99,
				0xd4, 0xa8, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x1c, 0xff, 0xf1, 0x4c, 0x80, 0x62, 0xff, 0xfc,
				0x21, 0x1a, 0x14, 0x25, 0xfd, 0x20, 0xe3, 0x9f,
				0x3e, 0x00, 0x00, 0x01, 0xa6, 0xde, 0xdf, 0x7f,
				0x94, 0xfa, 0x04, 0xfe,
				0x47, 0x01, 0x00, 0x17,
				0x11, 0x7d, 0x07, 0x23, 0xfa, 0x3e, 0xfb, 0x78,
				0x43, 0xb6, 0xd8, 0x23, 0x87, 0xbc, 0x4b, 0x1e,
				0x42, 0x74, 0xc8, 0x41, 0xec, 0x25, 0x62, 0x29,
				0x26, 0x42, 0x25, 0x40, 0x24, 0x70, 0x73, 0xff,
				0xce, 0x4c, 0x39, 0x5c, 0x1a, 0x41, 0x39, 0x71,
				0x48, 0xe4, 0x04, 0x48, 0xf8, 0x7a, 0x89, 0x84,
				0xd9, 0xa9, 0xa8, 0xce, 0x40, 0xf2, 0x88, 0x42,
				0x3c, 0xcb, 0x28, 0x8e, 0x32, 0x2e, 0x4d, 0xcd,
				0x10, 0x95, 0x14, 0x85, 0x8c, 0x09, 0x12, 0x42,
				0x96, 0xa1, 0x13, 0xbc, 0x12, 0x14, 0xe2, 0x93,
				0xc3, 0xd3, 0x25, 0x4c, 0x84, 0x93, 0x78, 0x94,
				0xd0, 0x91, 0x8b, 0x5b, 0x01, 0xd4, 0x93, 0xa7,
				0x78, 0x8e, 0x07, 0x19, 0xc7, 0x22, 0x92, 0x95,
				0x08, 0x9e, 0xf3, 0x2a, 0x41, 0x98, 0x12, 0x18,
				0x12, 0x13, 0xcd, 0x63, 0x28, 0xbc, 0x09, 0x03,
				0xd8, 0x23, 0x9a, 0x61, 0x1c, 0x25, 0x3c, 0x16,
				0xb1, 0x1c, 0x3a, 0x49, 0xe4, 0xa1, 0x4b, 0x11,
				0x49, 0xa6, 0x11, 0x14, 0x86, 0xa2, 0xc2, 0x12,
				0xb0, 0x92, 0x41, 0xb0, 0x4b, 0x52, 0x92, 0x49,
				0xc7, 0xcc, 0x94, 0x09, 0xe3, 0x31, 0x84, 0x35,
				0x7c, 0xb0, 0x8f, 0x08, 0xdb, 0x91, 0xa0, 0x92,
				0x74, 0x30, 0x24, 0x1f, 0x92, 0x22, 0x9e, 0x26,
				0x42, 0x85, 0x62, 0x61, 0xc0, 0x92, 0xb6, 0xf2,
				0x47, 0x01, 0x00, 0x18, 0x41, 0xc6, 0x10, 0x3c,
				0x52, 0x36, 0x18, 0x46, 0x56, 0x1f, 0x00, 0xa1,
				0x50, 0x9c, 0x86, 0x06, 0x99, 0x02, 0x53, 0x21,
				0xa3, 0xbc, 0x4a, 0xb4, 0x2b, 0x1e, 0x16, 0x01,
				0x20, 0x8d, 0x09, 0x58, 0x04, 0xa2, 0x49, 0x3c,
				0xcb, 0x08, 0x99, 0xd9, 0x51, 0x07, 0xa5, 0xea,
				0x1b, 0xc4, 0x24, 0x1c, 0x82, 0x42, 0x46, 0x16,
				0x60, 0x95, 0x38, 0x53, 0x2e, 0x80, 0x95, 0x09,
				0x04, 0x13, 0x14, 0x84, 0xa6, 0x10, 0x90, 0x7f,
				0xaa, 0x92, 0xa1, 0x08, 0x95, 0xba, 0x18, 0x14,
				0xa2, 0x50, 0xb2, 0xb8, 0x0c, 0xae, 0x39, 0x6f,
				0x68, 0x51, 0x3a, 0x3a, 0x26, 0xb1, 0x3a, 0xd7,
				0x88, 0x6b, 0xaf, 0x51, 0x1a, 0x3e, 0x3a, 0x1a,
				0x2f, 0x24, 0x4a, 0x68, 0x48, 0xc5, 0x0f, 0x1c,
				0xc4, 0x90, 0x9b, 0xb7, 0x25, 0x9a, 0xd7, 0x10,
				0xad, 0x7a, 0x89, 0x21, 0x39, 0xba, 0x02, 0x52,
				0xa1, 0x54, 0x77, 0xaa, 0x32, 0x10, 0xc0, 0x84,
				0x89, 0x2f, 0x12, 0xc0, 0xcd, 0xc1, 0xe9, 0x91,
				0x4c, 0x8a, 0x24, 0x92, 0x93, 0xc9, 0x30, 0x35,
				0x13, 0x08, 0xe0, 0x61, 0x11, 0x7a, 0x49, 0x1d,
				0x24, 0xa4, 0x3e, 0x8b, 0xb0, 0x45, 0xe4, 0x24,
				0x98, 0x44, 0x93, 0x22, 0x50, 0x4c, 0xa4, 0xca,
				0x2d, 0xe4, 0xc9, 0x36, 0xc4, 0x85, 0x51, 0xc8,
				0x94, 0x6c, 0x10, 0x3d,
				0x47, 0x01, 0x00, 0x19,
				0x8b, 0x4e, 0x6d, 0x8b, 0x5a, 0xc4, 0x0d, 0x15,
				0x28, 0x83, 0x22, 0x90, 0xad, 0x08, 0x9c, 0x88,
				0x44, 0x62, 0x86, 0x88, 0x0c, 0xa6, 0xc2, 0x04,
				0x4d, 0xe7, 0xc2, 0xc2, 0x94, 0xd9, 0x81, 0x3c,
				0x81, 0x08, 0x4d, 0x32, 0xbe, 0xa0, 0x4a, 0x99,
				0xc8, 0x04, 0xf2, 0x81, 0x08, 0xd0, 0x3d, 0xa4,
				0x42, 0x41, 0x65, 0x14, 0x92, 0x69, 0x95, 0x66,
				0xb6, 0xd3, 0x0e, 0x40, 0x8b, 0x26, 0x97, 0x21,
				0x17, 0x21, 0x04, 0x98, 0x4a, 0x40, 0x25, 0xf4,
				0xdf, 0xcf, 0x13, 0x0a, 0x67, 0x36, 0x88, 0x68,
				0x90, 0xe4, 0x00, 0xe4, 0x14, 0xe1, 0xbc, 0x29,
				0x68, 0x80, 0xc9, 0xe9, 0x9a, 0x49, 0xc1, 0x26,
				0x54, 0xcb, 0xa5, 0x22, 0x54, 0xf1, 0xd4, 0xd9,
				0xa9, 0x20, 0x16, 0xff, 0xb1, 0x36, 0xa4, 0x84,
				0x56, 0xe0, 0x04, 0x99, 0x03, 0x23, 0x4b, 0x47,
				0xbc, 0xb0, 0x03, 0xe0, 0x8f, 0x26, 0x12, 0x7f,
				0x9c, 0x9a, 0x5f, 0x80, 0x04, 0x89, 0xcf, 0x68,
				0xb0, 0x89, 0x26, 0x92, 0x7d, 0x02, 0x0f, 0x09,
				0x0a, 0x6c, 0x21, 0x41, 0xe4, 0x65, 0x42, 0xd8,
				0xf8, 0x0b, 0x09, 0x3c, 0xf2, 0x81, 0xf6, 0x3e,
				0xc7, 0xfb, 0xdc, 0x86, 0xd5, 0xfc, 0xd3, 0x38,
				0x7a, 0xf7, 0x6e, 0x13, 0x87, 0x47, 0x30, 0xe6,
				0x22, 0x30, 0xe5, 0x13, 0x64, 0x3c, 0x9f, 0x46,
				0x47, 0x01, 0x00, 0x1a, 0x82, 0x2e, 0x4c, 0x2d,
				0x6e, 0xca, 0xd9, 0x99, 0x8f, 0x27, 0x97, 0x30,
				0x7b, 0xa1, 0x32, 0xb2, 0xb7, 0x29, 0x1d, 0x3a,
				0xb8, 0xe2, 0x88, 0x29, 0x44, 0x29, 0xd3, 0x25,
				0x4e, 0x99, 0x15, 0x28, 0x8d, 0x35, 0x70, 0xaa,
				0x27, 0x4e, 0x9f, 0x1c, 0xc6, 0x90, 0x55, 0x32,
				0x2a, 0x57, 0x1c, 0xc6, 0x90, 0xc6, 0xd3, 0x20,
				0xa5, 0x12, 0xa7, 0x4e, 0xd1, 0x07, 0x84, 0x26,
				0x88, 0x04, 0x20, 0x00, 0x94, 0x88, 0x16, 0x8c,
				0x82, 0x40, 0x01, 0x10, 0x50, 0x24, 0x88, 0x14,
				0x48, 0x2d, 0x30, 0x5a, 0x20, 0x26, 0x04, 0x12,
				0x80, 0x02, 0x10, 0x10, 0x42, 0xc0, 0x08, 0x21,
				0x04, 0x40, 0x0b, 0x4d, 0x04, 0x80, 0x0a, 0x2c,
				0x04, 0x81, 0x23, 0x85, 0x07, 0x5f, 0xe1, 0x11,
				0x44, 0x02, 0xd0, 0x91, 0x44, 0x40, 0x21, 0x21,
				0x04, 0x2c, 0x40, 0x21, 0x42, 0x45, 0xa6, 0x02,
				0x02, 0x59, 0x31, 0x2c, 0x9c, 0x45, 0x90, 0x10,
				0xab, 0x31, 0x12, 0x14, 0xd2, 0x4b, 0x15, 0x61,
				0x13, 0x84, 0x17, 0x64, 0x76, 0x41, 0x05, 0x8b,
				0x84, 0x59, 0x08, 0x91, 0x2d, 0xfa, 0xe4, 0xeb,
				0xcd, 0x24, 0xd6, 0x91, 0xb7, 0x98, 0x24, 0xdc,
				0xc7, 0x09, 0x6c, 0x38, 0x4b, 0x60, 0x00, 0x00,
				0x00, 0x00, 0x10, 0x83, 0xf4, 0x83, 0x8e, 0x7c,
				0xf8, 0x00, 0x00, 0x06,
				0x47, 0x01, 0x00, 0x1b, 0x9b, 0x7b, 0x7d, 0xfe,
				0x53, 0xe8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
				0xff, 0xf1, 0x4c, 0x80, 0x63, 0x7f, 0xfc, 0x21,
				0x1a, 0x14, 0x35, 0xfd, 0x27, 0x1c, 0xf9, 0xd7,
				0x75, 0x5f, 0x1f, 0x6b, 0xc0, 0x00, 0x07, 0xc5,
				0x7a, 0xd7, 0xde, 0xf9, 0xba, 0xf8, 0x04, 0x74,
				0x9f, 0x16, 0x48, 0xf8, 0xb7, 0xc1, 0x64, 0xbc,
				0x11, 0xc4, 0xf8, 0x5b, 0x79, 0xde, 0x71, 0x19,
				0xd7, 0x49, 0x54, 0x79, 0x02, 0xbc, 0x96, 0x0f,
				0x07, 0x95, 0xe4, 0x13, 0x87, 0x86, 0x21, 0x97,
				0xa9, 0xff, 0xa2, 0x2f, 0xc6, 0xf1, 0xc9, 0x19,
				0x5b, 0x06, 0x41, 0x6b, 0xca, 0xf8, 0x32, 0x79,
				0x8b, 0x64, 0x6d, 0xdb, 0xb3, 0x61, 0x92, 0xb6,
				0x8e, 0x38, 0x8e, 0x39, 0x6e, 0xcd, 0x45, 0x9d,
				0x3c, 0x94, 0x38, 0x64, 0x21, 0xc3, 0xbb, 0x16,
				0x4e, 0xb6, 0x46, 0xed, 0x91, 0x95, 0xe4, 0x67,
				0x57, 0x90, 0xc6, 0xce, 0x26, 0xf9, 0xc4, 0x5f,
				0x38, 0x8c, 0x97, 0xd4, 0x85, 0xe1, 0x0a, 0x4e,
				0xf3, 0xc8, 0xc8, 0xb8, 0x43, 0x1e, 0x42, 0x12,
				0x2e, 0x10, 0xd1, 0xdc, 0x27, 0xc2, 0x38, 0xf1,
				0x1c, 0x21, 0xc8, 0xcd, 0x9b, 0xc7, 0x26, 0x91,
				0xad, 0x91, 0x23, 0x5a,
				0x47, 0x01, 0x00, 0x1c,
				0x41, 0x25, 0xc8, 0x23, 0x59, 0x64, 0xa4, 0x48,
				0xfd, 0x71, 0x18, 0x75, 0x38, 0x40, 0x93, 0xa9,
				0x53, 0x84, 0x09, 0x0a, 0x95, 0x08, 0x6e, 0xaa,
				0x12, 0xc7, 0xc8, 0x25, 0x8f, 0x21, 0x02, 0x70,
				0xb2, 0x57, 0x24, 0x12, 0xb9, 0x23, 0x85, 0x91,
				0xf9, 0xa4, 0xe4, 0xc9, 0x20, 0x52, 0xf0, 0x8f,
				0x20, 0x59, 0x3c, 0x72, 0xa6, 0xc7, 0x23, 0x22,
				0x05, 0xa2, 0x82, 0x72, 0x20, 0x70, 0x90, 0x09,
				0xc8, 0x05, 0x14, 0x82, 0x08, 0x80, 0x43, 0x3c,
				0x82, 0x68, 0x46, 0x43, 0x9e, 0x46, 0x7c, 0x32,
				0x08, 0x86, 0x4d, 0x08, 0xc8, 0x08, 0x25, 0x0e,
				0x1f, 0x08, 0xbe, 0x3a, 0x2b, 0x7e, 0x6d, 0x65,
				0x34, 0x84, 0x49, 0xbd, 0x93, 0x59, 0xcd, 0x24,
				0x28, 0x96, 0xec, 0xdb, 0x71, 0x75, 0x23, 0xc9,
				0x3c, 0xa4, 0x24, 0xbf, 0x84, 0x93, 0x53, 0xbc,
				0x8c, 0x97, 0x91, 0x7b, 0xff, 0x37, 0x8e, 0xe4,
				0xc9, 0xbc, 0xa4, 0xf2, 0x2b, 0x22, 0xba, 0xd9,
				0x52, 0x41, 0x29, 0x0b, 0x27, 0x83, 0x59, 0x19,
				0x12, 0x32, 0xa2, 0xc8, 0xaf, 0x23, 0x95, 0x64,
				0x11, 0x5c, 0x82, 0x4b, 0xc1, 0xe5, 0x69, 0x04,
				0x62, 0x57, 0x21, 0x11, 0x75, 0x94, 0x4b, 0x72,
				0x27, 0x64, 0x11, 0x89, 0x37, 0x85, 0x59, 0x05,
				0x88, 0x9a, 0xd7, 0xd9, 0x24, 0x26, 0xc4, 0xac,
				0x47, 0x01, 0x00, 0x1d, 0x96, 0x4d, 0x62, 0xe3,
				0x93, 0x6d, 0xc8, 0x84, 0xa6, 0x88, 0x82, 0xd7,
				0xef, 0x08, 0xac, 0x44, 0x17, 0x34, 0x90, 0x85,
				0xc2, 0x44, 0xac, 0xd6, 0x40, 0x42, 0xb7, 0x44,
				0x40, 0x4b, 0xac, 0x44, 0x44, 0x4b, 0xac, 0x56,
				0x49, 0x71, 0x2b, 0x29, 0xa4, 0x05, 0x36, 0xb1,
				0x59, 0x01, 0x2c, 0x90, 0xb0, 0x04, 0x26, 0x8a,
				0xb1, 0x89, 0x6e, 0x0a, 0xb3, 0x15, 0xbc, 0x2e,
				0xb8, 0xa8, 0x05, 0xc2, 0x3f, 0xae, 0xb8, 0x51,
				0x7e, 0x72, 0xa3, 0x17, 0xe7, 0x32, 0x08, 0xad,
				0xbe, 0xb8, 0xb6, 0x66, 0x74, 0xf0, 0xb1, 0x6a,
				0x17, 0x92, 0x8a, 0x22, 0x70, 0x00, 0x42, 0x44,
				0x82, 0x00, 0x41, 0x2c, 0x00, 0x2d, 0x28, 0x04,
				0x20, 0x20, 0x88, 0x10, 0x46, 0x40, 0x38, 0x54,
				0x13, 0x80, 0x02, 0x12, 0x11, 0x69, 0x02, 0x8a,
				0x05, 0xa6, 0x82, 0x28, 0x05, 0xa0, 0x02, 0x28,
				0x87, 0x67, 0x23, 0xfd, 0xff, 0x3e, 0x19, 0x0d,
				0x1c, 0x22, 0x2c, 0xc4, 0x12, 0x45, 0xbc, 0x82,
				0x82, 0x48, 0x41, 0x14, 0x43, 0xc8, 0x48, 0xe1,
				0x61, 0xe4, 0x18, 0x64, 0x21, 0xc3, 0xe3, 0x90,
				0x08, 0x81, 0x1b, 0x1f, 0xaf, 0x51, 0x60, 0xa2,
				0xc1, 0x68, 0x00, 0x98, 0x01, 0xc2, 0x80, 0x9a,
				0x00, 0x1c, 0x2a, 0x36, 0x35, 0xa4, 0x82, 0x32,
				0x24, 0x12, 0x81, 0x20,
				0x47, 0x01, 0x00, 0x1e,
				0x98, 0x00, 0x4a, 0x02, 0x28, 0x84, 0x11, 0x90,
				0x8e, 0x12, 0x01, 0x20, 0x20, 0x8a, 0x11, 0x69,
				0x20, 0x80, 0x01, 0x45, 0x23, 0xc2, 0xf5, 0xee,
				0x3a, 0x8f, 0x09, 0xc7, 0x11, 0x69, 0x80, 0x9b,
				0xe7, 0x13, 0x7b, 0xff, 0xfc, 0xce, 0xb9, 0xcc,
				0xeb, 0x3b, 0x1f, 0xce, 0xce, 0xf3, 0x88, 0xbf,
				0x1a, 0x46, 0x74, 0xec, 0x7b, 0x3b, 0xff, 0xce,
				0x38, 0xf2, 0x13, 0xa7, 0x63, 0xe7, 0xff, 0xf9,
				0x8f, 0x9e, 0x46, 0xa4, 0x32, 0x21, 0x86, 0x4c,
				0x30, 0xc9, 0x86, 0xa1, 0x30, 0xc3, 0x23, 0x97,
				0x09, 0x2a, 0x95, 0x38, 0xed, 0x4e, 0x38, 0x12,
				0x01, 0x09, 0x30, 0xd4, 0x27, 0x0e, 0x19, 0x20,
				0xd4, 0x27, 0x0f, 0x2e, 0x46, 0xa0, 0x48, 0x06,
				0x19, 0x28, 0x68, 0x24, 0x88, 0x7c, 0x75, 0x04,
				0x50, 0x8c, 0x81, 0x3e, 0xce, 0x41, 0x04, 0x4f,
				0x20, 0x84, 0x11, 0x42, 0x32, 0x1a, 0x32, 0x04,
				0x32, 0x56, 0xd1, 0xff, 0x62, 0x76, 0xd0, 0x45,
				0x13, 0xec, 0xdc, 0x3e, 0x3e, 0x9d, 0x8f, 0x9f,
				0xff, 0xb2, 0x6f, 0x7e, 0x3d, 0x9d, 0x9d, 0xa7,
				0x10, 0x7c, 0xe2, 0x0f, 0xc6, 0x93, 0xbb, 0x3b,
				0x85, 0x9c, 0x49, 0xef, 0xff, 0xfb, 0x1e, 0xce,
				0x25, 0x3a, 0x71, 0x0b, 0xb3, 0x89, 0x4e, 0x79,
				0x24, 0x43, 0x26, 0x89, 0xe4, 0xd1, 0x6f, 0x84,
				0x47, 0x01, 0x00, 0x3f, 0x60, 0x00, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0x41, 0x1b, 0x68,
				0x24, 0x84, 0x13, 0x9f, 0x0f, 0x8e, 0xdb, 0xe1,
				0x6d, 0xfe, 0x78, 0x2c, 0xeb, 0x7c, 0x25, 0xbb,
				0x39, 0x16, 0x6a, 0x3f, 0x3c, 0x46, 0x0c, 0x12,
				0x3a, 0x48, 0x3c, 0x77, 0x06, 0x46, 0x0c, 0x1e,
				0x13, 0x83, 0x70, 0x9a, 0x40, 0x00, 0x00, 0x00,
				0x00, 0x08, 0x61, 0xfa, 0x4e, 0x39, 0xf3, 0xae,
				0xea, 0xbe, 0x3e, 0xd7, 0x80, 0x00, 0x0f, 0x8a,
				0xf5, 0xaf, 0xbd, 0xf3, 0x75, 0xf0, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x38,
			},
			&Track{
				PID: 256,
				Codec: &CodecMPEG4Audio{
					Config: mpeg4audio.AudioSpecificConfig{
						Type:         2,
						SampleRate:   48000,
						ChannelCount: 2,
					},
				},
			},
		},
		{
			"opus",
			[]byte{
				0x47, 0x40, 0x00, 0x10, 0x00, 0x00, 0xb0, 0x0d,
				0x00, 0x01, 0xc1, 0x00, 0x00, 0x00, 0x01, 0xf0,
				0x00, 0x2a, 0xb1, 0x04, 0xb2, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff,
				0x47, 0x50, 0x00, 0x10,
				0x00, 0x02, 0xb0, 0x22, 0x00, 0x01, 0xc1, 0x00,
				0x00, 0xe1, 0x00, 0xf0, 0x00, 0x06, 0xe1, 0x00,
				0xf0, 0x10, 0x05, 0x04, 0x4f, 0x70, 0x75, 0x73,
				0x7f, 0x02, 0x80, 0x02, 0x0a, 0x04, 0x64, 0x65,
				0x75, 0x00, 0xc4, 0x80, 0xf8, 0x2f, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
				0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
			},
			&Track{
				PID: 256,
				Codec: &CodecOpus{
					ChannelCount: 2,
				},
			},
		},
	} {
		t.Run(ca.name, func(t *testing.T) {
			dem := &robustDemuxer{R: bytes.NewReader(ca.byts)}
			dem.initialize()

			pmt, err := findPMT(dem)
			require.NoError(t, err)

			var track Track
			err = track.unmarshal(dem, pmt.ElementaryStreams[0])
			require.NoError(t, err)
			require.Equal(t, ca.track, &track)
		})
	}
}
