package av1

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestIsRandomAccess(t *testing.T) {
	ok := IsRandomAccess2([][]byte{
		{
			0x12, 0x00, 0x0d, 0x0a, 0x0b, 0x00, 0x00, 0x00,
			0x42, 0xab, 0xbf, 0xc3, 0x71, 0xab, 0xe6, 0x01,
			0xa0, 0x0b, 0x32, 0x9c,
		},
		{
			0x0a, 0x0b, 0x00, 0x00, 0x00, 0x42, 0xab, 0xbf,
			0xc3, 0x71, 0xab, 0xe6, 0x01, 0xa0, 0x0b, 0x32,
			0x9c, 0x73, 0x10, 0xe0,
		},
	})
	require.True(t, ok)

	ok = IsRandomAccess2([][]byte{})
	require.False(t, ok)

	ok = IsRandomAccess2([][]byte{{}})
	require.False(t, ok)
}
