-- Copyright 2004-2025 H2 Group. Multiple-Licensed under the MPL 2.0,
-- and the EPL 1.0 (https://h2database.com/html/license.html).
-- Initial Developer: H2 Group
--

select bitor(null, 1) vn, bitor(1, null) vn1, bitor(null, null) vn2, bitor(3, 6) e7;
> VN   VN1  VN2  E7
> ---- ---- ---- --
> null null null 7
> rows: 1

SELECT BITOR(10, 12);
>> 14

SELECT BITNOR(10, 12);
>> -15

CREATE TABLE TEST(A BIGINT, B BIGINT);
> ok

EXPLAIN SELECT BITNOT(BITOR(A, B)), BITNOT(BITNOR(A, B)) FROM TEST;
>> SELECT BITNOR("A", "B"), BITOR("A", "B") FROM "PUBLIC"."TEST" /* PUBLIC.TEST.tableScan */

DROP TABLE TEST;
> ok

EXPLAIN SELECT
    BITOR(CAST((0xC5 - 0x100) AS TINYINT), CAST(0x63 AS TINYINT)),
    BITOR(CAST(0xC5 AS SMALLINT), CAST(0x63 AS SMALLINT)),
    BITOR(CAST(0xC5 AS INTEGER), CAST(0x63 AS INTEGER)),
    BITOR(CAST(0xC5 AS BIGINT), CAST(0x63 AS BIGINT)),
    BITOR(CAST(X'C5' AS VARBINARY), CAST(X'63' AS VARBINARY)),
    BITOR(CAST(X'C5' AS BINARY), CAST(X'63' AS BINARY));
>> SELECT CAST(-25 AS TINYINT), CAST(231 AS SMALLINT), 231, CAST(231 AS BIGINT), X'e7', CAST(X'e7' AS BINARY(1))

EXPLAIN SELECT
    BITOR(CAST(X'C501' AS VARBINARY), CAST(X'63' AS VARBINARY)),
    BITOR(CAST(X'63' AS VARBINARY), CAST(X'C501' AS VARBINARY)),
    BITOR(CAST(X'C501' AS BINARY(2)), CAST(X'63' AS BINARY)),
    BITOR(CAST(X'63' AS BINARY), CAST(X'C501' AS BINARY(2)));
>> SELECT X'e701', X'e701', CAST(X'e701' AS BINARY(2)), CAST(X'e701' AS BINARY(2))

EXPLAIN SELECT
    BITOR(CAST(X'C501' AS VARBINARY), CAST(X'63' AS BINARY)),
    BITOR(CAST(X'63' AS BINARY), CAST(X'C501' AS VARBINARY));
>> SELECT CAST(X'e7' AS BINARY(1)), CAST(X'e7' AS BINARY(1))

EXPLAIN SELECT
    BITNOR(CAST((0xC5 - 0x100) AS TINYINT), CAST(0x63 AS TINYINT)),
    BITNOR(CAST(0xC5 AS SMALLINT), CAST(0x63 AS SMALLINT)),
    BITNOR(CAST(0xC5 AS INTEGER), CAST(0x63 AS INTEGER)),
    BITNOR(CAST(0xC5 AS BIGINT), CAST(0x63 AS BIGINT)),
    BITNOR(CAST(X'C5' AS VARBINARY), CAST(X'63' AS VARBINARY)),
    BITNOR(CAST(X'C5' AS BINARY), CAST(X'63' AS BINARY));
>> SELECT CAST(24 AS TINYINT), CAST(-232 AS SMALLINT), -232, CAST(-232 AS BIGINT), X'18', CAST(X'18' AS BINARY(1))

EXPLAIN SELECT
    BITNOR(CAST(X'C501' AS VARBINARY), CAST(X'63' AS VARBINARY)),
    BITNOR(CAST(X'63' AS VARBINARY), CAST(X'C501' AS VARBINARY)),
    BITNOR(CAST(X'C501' AS BINARY(2)), CAST(X'63' AS BINARY)),
    BITNOR(CAST(X'63' AS BINARY), CAST(X'C501' AS BINARY(2)));
>> SELECT X'18fe', X'18fe', CAST(X'18fe' AS BINARY(2)), CAST(X'18fe' AS BINARY(2))

EXPLAIN SELECT
    BITNOR(CAST(X'C501' AS VARBINARY), CAST(X'63' AS BINARY)),
    BITNOR(CAST(X'63' AS BINARY), CAST(X'C501' AS VARBINARY));
>> SELECT CAST(X'18' AS BINARY(1)), CAST(X'18' AS BINARY(1))

SELECT BITOR('AA', 'BB');
> exception INVALID_VALUE_2

SELECT BITOR(1, X'AA');
> exception INVALID_VALUE_2

SELECT BITNOR('AA', 'BB');
> exception INVALID_VALUE_2

SELECT BITNOR(1, X'AA');
> exception INVALID_VALUE_2
