-- Copyright 2004-2025 H2 Group. Multiple-Licensed under the MPL 2.0,
-- and the EPL 1.0 (https://h2database.com/html/license.html).
-- Initial Developer: H2 Group
--

CREATE MEMORY TABLE TEST1(ID BIGINT PRIMARY KEY);
> ok

CREATE MEMORY TABLE TEST2(ID BIGINT PRIMARY KEY);
> ok

CREATE USER TEST_USER PASSWORD 'test';
> ok

GRANT SELECT, INSERT ON TEST1, TEST2 TO TEST_USER;
> ok

SCRIPT NODATA NOPASSWORDS NOSETTINGS NOVERSION;
> SCRIPT
> ---------------------------------------------------------------------------------------
> CREATE USER IF NOT EXISTS "SA" PASSWORD '' ADMIN;
> CREATE USER IF NOT EXISTS "TEST_USER" PASSWORD '';
> CREATE MEMORY TABLE "PUBLIC"."TEST1"( "ID" BIGINT NOT NULL );
> ALTER TABLE "PUBLIC"."TEST1" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_4" PRIMARY KEY("ID");
> -- 0 +/- SELECT COUNT(*) FROM PUBLIC.TEST1;
> CREATE MEMORY TABLE "PUBLIC"."TEST2"( "ID" BIGINT NOT NULL );
> ALTER TABLE "PUBLIC"."TEST2" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_4C" PRIMARY KEY("ID");
> -- 0 +/- SELECT COUNT(*) FROM PUBLIC.TEST2;
> GRANT SELECT, INSERT ON "PUBLIC"."TEST1" TO "TEST_USER";
> GRANT SELECT, INSERT ON "PUBLIC"."TEST2" TO "TEST_USER";
> rows (ordered): 10

REVOKE INSERT ON TEST1 FROM TEST_USER;
> ok

REVOKE ALL ON TEST2 FROM TEST_USER;
> ok

SCRIPT NODATA NOPASSWORDS NOSETTINGS NOVERSION;
> SCRIPT
> ---------------------------------------------------------------------------------------
> CREATE USER IF NOT EXISTS "SA" PASSWORD '' ADMIN;
> CREATE USER IF NOT EXISTS "TEST_USER" PASSWORD '';
> CREATE MEMORY TABLE "PUBLIC"."TEST1"( "ID" BIGINT NOT NULL );
> ALTER TABLE "PUBLIC"."TEST1" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_4" PRIMARY KEY("ID");
> -- 0 +/- SELECT COUNT(*) FROM PUBLIC.TEST1;
> CREATE MEMORY TABLE "PUBLIC"."TEST2"( "ID" BIGINT NOT NULL );
> ALTER TABLE "PUBLIC"."TEST2" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_4C" PRIMARY KEY("ID");
> -- 0 +/- SELECT COUNT(*) FROM PUBLIC.TEST2;
> GRANT SELECT ON "PUBLIC"."TEST1" TO "TEST_USER";
> rows (ordered): 9

DROP USER TEST_USER;
> ok

DROP TABLE TEST1, TEST2;
> ok
