-- Copyright 2004-2025 H2 Group. Multiple-Licensed under the MPL 2.0,
-- and the EPL 1.0 (https://h2database.com/html/license.html).
-- Initial Developer: H2 Group
--

CREATE TABLE TEST(X INT, B BLOB(1));
> ok

INSERT INTO TEST(X) VALUES 1, 2, 3, 3, NULL, NULL;
> update count: 6

ANALYZE TABLE TEST;
> ok

SELECT SELECTIVITY FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TEST' AND COLUMN_NAME = 'X';
>> 66

INSERT INTO TEST(X) VALUES 6, 7, 8, 9;
> update count: 4

ANALYZE TABLE TEST;
> ok

SELECT SELECTIVITY FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TEST' AND COLUMN_NAME = 'X';
>> 80

TRUNCATE TABLE TEST;
> update count: 10

INSERT INTO TEST(X) VALUES 1, 2, 3;
> update count: 3

ANALYZE TABLE TEST;
> ok

SELECT SELECTIVITY FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TEST' AND COLUMN_NAME = 'X';
>> 100

TRUNCATE TABLE TEST;
> update count: 3

INSERT INTO TEST(X) VALUES 1, 1, 1, 1;
> update count: 4

ANALYZE TABLE TEST;
> ok

SELECT SELECTIVITY FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TEST' AND COLUMN_NAME = 'X';
>> 25

ANALYZE TABLE TEST SAMPLE_SIZE 3;
> ok

SELECT SELECTIVITY FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TEST' AND COLUMN_NAME = 'X';
>> 33

TRUNCATE TABLE TEST;
> update count: 4

ANALYZE TABLE TEST;
> ok

SELECT SELECTIVITY FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TEST' AND COLUMN_NAME = 'X';
>> 50

DROP TABLE TEST;
> ok
