package messages

const (
	AliasedCommands                  = "Aliased commands: %s\n"
	APIParentBranchLookupStart       = "Looking for parent of %s ... "
	APIProposalLookupStart           = "Looking for proposal online ... "
	APIProposalUpdateBody            = "Update proposal body for proposal #%s ... "
	APIProposalUpdateStart           = "Updating proposal online ... "
	APIUnexpectedResultDataStructure = "unexpected result data structure"
	APIUpdateProposalSource          = "Updating source branch of proposal %s to %s ... "
	APIUpdateProposalTarget          = "Updating target branch of proposal %s to %s ... "
	AppendDetachedHead               = "please check out the branch to which you want to append a child"
	ArgumentUnknown                  = "unknown argument: %q"
	AuthenticationMissing            = "not logged in"
	AuthorizationMissing             = `cannot find "repo" scope: %v`
	AutoDetect                       = "auto-detect"
	AutoSync                         = "auto-sync: %s\n"

	BitBucketAppPasswordPrompt      = "Bitbucket App Password: "
	BitBucketAppPasswordResult      = "Bitbucket App Password: %s"
	BitBucketUsernamePrompt         = "Bitbucket username: "
	BitBucketUsernameResult         = "Bitbucket username: %s"
	BranchAlreadyExistsLocally      = "there is already a branch %q"
	BranchAlreadyExistsRemotely     = "there is already a branch %q at the \"origin\" remote"
	BranchAuthorMultiple            = "\nMultiple people authored the %q branch.\n\n"
	BranchCheckoutProblem           = "cannot check out branch %q: %w"
	BranchContainsMergeCommits      = "branch %q contains merge commits, please compress and try again"
	BranchCurrentProblem            = "cannot determine current branch: %w"
	BranchDeleted                   = "deleted branch %q"
	BranchDeletedAtRemote           = "branch %q was deleted at the remote"
	BranchDeletedHasUnmergedChanges = "Branch %q was deleted at the remote but the local branch contains unshipped changes.\nI am therefore not removing this branch. You can see the unshipped changes by running \"git town diff-parent\"."
	BranchDiffProblem               = "cannot determine if branch %q has unmerged commits: %w"
	BranchDoesntContainCommit       = "branch %q does not contain commit %q. Found commits %s"
	BranchDoesntExist               = "there is no branch %q"
	BranchHasWrongSHA               = "cannot reset branch %q to %q because it received additional commits in the meantime. It should have SHA %q but has %q"
	BranchInfoNoContent             = "BranchInfo has neither a local nor remote name"
	BranchInfoNotFound              = "cannot find branch info for %q"
	BranchInfosNotProvided          = "An opcode that requires BranchInfos was called from the Light engine"
	BranchIsAlreadyContribution     = "branch %q is already a contribution branch"
	BranchIsAlreadyObserved         = "branch %q is already observed"
	BranchIsAlreadyParked           = "branch %q is already parked"
	BranchIsAlreadyPrototype        = "branch %q is already a prototype branch"
	BranchIsNowContribution         = "branch %q is now a contribution branch\n"
	BranchIsNowFeature              = "branch %q is now a feature branch\n"
	BranchIsNowObserved             = "branch %q is now an observed branch\n"
	BranchIsNowParked               = "branch %q is now parked\n"
	BranchIsNowPerennial            = "branch %q is now perennial\n"
	BranchIsNowPrototype            = "branch %q is now a prototype branch\n"
	BranchLocalProblem              = "cannot determine whether the local branch %q exists: %w"
	BranchLocalSHAProblem           = "cannot determine SHA of local branch %q: %w"
	BranchNotAvailable              = "there is no other branch to switch to"
	BranchNotInSyncWithParent       = `branch %q is not in sync with its parent, please run "git town sync" and try again`
	BranchOtherWorktree             = `branch %q is active in another worktree`
	BranchParentChanged             = "branch %q is now a child of %q"
	BranchPrefixPrompt              = "Branch prefix: "
	BranchPrefixResult              = "Branch prefix: %s\n"
	BranchTypeCannotDetermine       = "cannot determine type of branch %q"
	BrowserOpen                     = "Please open in a browser: %s\n"

	CacheUnitialized                   = "using a cached value before initialization"
	CannotParse                        = "cannot parse %q: %w"
	CommandsRun                        = "Ran %d shell commands."
	CommitMessageProblem               = "cannot determine last commit message: %w"
	CommitsSelected                    = "%d commits selected"
	CompletionTypeUnknown              = "unknown completion type: %q"
	CompressAlreadyOneCommit           = "branch %q has already just one commit"
	CompressBranchNoParent             = "cannot compress branch %q because it has no parent"
	CompressContributionBranch         = "you are merely contributing to branch %q and should leave compressing it to the branch owner"
	CompressDetachedHead               = "please check out the branch to compress"
	CompressIsPerennial                = "better not compress perennial branches"
	CompressNoBranchInfo               = "no branch info for branch %q"
	CompressNoCommits                  = "branch %q has no commits"
	CompressObservedBranch             = "you are merely observing branch %q and should leave compressing it to the branch owner"
	CompressParkedBranch               = "branch %q and should not compress it"
	CompressUnsynced                   = "please sync branch %q before compressing it"
	ConfigBranchTypeOverrideEmpty      = "removing empty branch type entry"
	ConfigFile                         = "config file"
	ConfigFileCannotRead               = "cannot read the configuration file %q: %w"
	ConfigFileInvalidContent           = "the configuration file %q does not contain TOML-formatted content: %w"
	ConfigLineageEmptyChild            = "removing empty lineage entry"
	ConfigLineageParentIsChild         = "removing lineage entry for %q because the parent is the child"
	ConfigMainbranchInConfigFile       = "please configure the main branch in the config file"
	ConfigNeeded                       = "Git Town needs to be configured\n\n"
	ConfigRemoveError                  = "unexpected error while removing the 'git-town' section from the Git configuration: %w"
	ConfigScopeUnknown                 = "unknown configuration scope"
	ConfigShipStrategyUnknown          = "unknown ship strategy in %q: %q"
	ConfigStorage                      = "Config storage: %s\n"
	ConfigSyncStrategyUnknown          = "unknown sync strategy: %q"
	ConflictDetectionProblem           = "cannot determine conflicts: %w"
	ConflictMerge                      = "git merge conflict"
	ConflictRebase                     = "git rebase conflict"
	ContinueMessage                    = `You can run "git town continue" to finish it.`
	ContinueNothingToDo                = "nothing to continue"
	ContinueSkipGuidance               = "To continue by skipping the current branch, run \"git town skip\"."
	ContinueUnresolvedConflicts        = "you must resolve the conflicts before continuing"
	ContinueUntrackedChanges           = "please stage or commit the untracked changes first"
	ContributeBranchIsLocal            = "branch %q is local only - branches you want to contribute to must have a remote branch because they are per definition other people's branches"
	ContributeDetachedHead             = "please check out the branch you want to convert into a contribution branch"
	ContributionBranchCannotPark       = "cannot park contribution branches"
	ContributionBranchCannotPropose    = "cannot propose contribution branches"
	ContributionBranchCannotShip       = "cannot ship contribution branches"
	ContributionRegex                  = "Contribution regex: %s\n"
	ContributionRegexPrompt            = "Contribution regex: "
	ContributionRegexResult            = "Contribution regex: %s\n"
	CreatePrototypeBranchesDeprecation = `The Git Town configuration file contains the deprecated setting "create-prototype-branches".
Please upgrade to the new format: create.new-branch-type = "prototype"`
	CredentialsAccess            = "API token permits access to pull requests"
	CredentialsForgeUserName     = "Forge access as %s\n"
	CredentialsNoAccess          = "Credentials don't provide access: %s\n"
	CurrentBranchCannotDetermine = "cannot determine the current branch"

	DeleteCannotDeleteMainBranch        = "you cannot delete the main branch"
	DeleteCannotDeletePerennialBranches = "you cannot delete perennial branches"
	DeleteNoActiveBranch                = "please check out the branch to delete"
	DeleteRepoHasDetachedHead           = "please check out the branch to delete"
	DetachedResult                      = "Detached: %s\n"
	DetachNeedsSync                     = "please sync this stack before detaching branches from it"
	DetachNoActiveBranch                = "please check out the branch to detach"
	DetachNoParent                      = "cannot detach branches without parent"
	DetachOtherWorkTree                 = "cannot detach because branch %q it is active in another worktree"
	DetachRemoteBranch                  = "cannot detach a remote branch"
	DetachRepoHasDetachedHead           = "please check out the branch to detach"
	DetachUnsupportedBranchType         = "cannot detach %s branches since you don't own them"
	DevRemote                           = "Development remote: %s\n"
	DialogResultAll                     = "(all)"
	DialogResultNone                    = "(none)"
	DialogResultUnknownBranchType       = "unknown branch type defined in %q: %q"
	DialogUnexpectedResponse            = "unexpected response: %s"
	DialogUseGlobalValue                = "use global value (%s)"
	DiffConflictWithMain                = "conflicts between your uncommmitted changes and the main branch"
	DiffParentDetachedHead              = "please check out the branch to diff"
	DiffParentNoFeatureBranch           = "you can only diff-parent feature branches"
	DiffProblem                         = "cannot list diff of %q and %q: %w"
	DirCurrentProblem                   = "cannot determine the current directory"
	DownNoCurrentBranch                 = "you need to be on a branch to go down"
	DownNoParent                        = "branch %q has no parent"
	DryRun                              = "In dry run mode. No commands will be run. When run in normal mode, the command output will appear beneath the command. Some commands will only be run if necessary. For example: 'git push' will run if and only if there are local commits not on origin."

	FeatureDetachedHead          = "please check out the branch to make a feature branch"
	FeatureRegexPrompt           = "Feature regex: "
	FeatureRegexResult           = "Feature regex: %s\n"
	FileContentInvalidJSON       = "cannot parse JSON content of file %q: %w"
	FileDeleteProblem            = "cannot delete file %q: %w"
	FileReadProblem              = "cannot read file %q: %w"
	FileStatProblem              = "cannot check file %q: %w"
	FileWriteProblem             = "cannot write file %q: %w"
	Forge                        = "Forge: %s\n"
	ForgeAPITokenLocation        = "API token scope: %s\n"
	ForgeBitbucketMergingViaAPI  = "Bitbucket API: merging PR %s ... "
	ForgeBitbucketNotImplemented = "shipping pull requests via the Bitbucket API is currently not supported. If you need this functionality, please vote for it by opening a ticket at https://github.com/git-town/git-town/issues"
	ForgeForgejoMergingViaAPI    = "Forgejo API: merging PR %s ... "
	ForgeGiteaNotImplemented     = "shipping pull requests via the Gitea API is currently not supported. If you need this functionality, please vote for it by opening a ticket at https://github.com/git-town/git-town/issues"
	ForgeGiteaUpdatePRViaAPI     = "Gitea API: Updating base branch for PR #%d to #%s"
	ForgeGitHubMergingViaAPI     = "GitHub API: merging PR %s ... "
	ForgeGitLabMergingViaAPI     = "Merging MR !%d ... "
	ForgeGitLabUpdateMRViaAPI    = "Updating target branch for MR !%d to %q ... "
	ForgejoTokenPrompt           = "Forgejo API token: "
	ForgejoTokenResult           = "Forgejo token: %s\n"
	ForgeTypeUnknown             = "unknown forge type defined in %q: %q"

	GitAnotherProcessIsRunningRetry = "another git process seems to be running in this repository, retrying in 1 sec ..."
	GitDirMissing                   = "cannot determine the '.git' directory: %w"
	GiteaTokenPrompt                = "Gitea token: "
	GiteaTokenResult                = "Gitea token: %s\n"
	GitHubConnectorTypeResult       = "GitHub connector: %s\n"
	GitHubConnectorTypeUnknown      = "unknown GitHubConnectorType defined in %q: %q"
	GitHubEnterpriseInitializeError = "cannot initialize GitHub Enterprise client: %s"
	GitHubTokenPrompt               = "GitHub API token: "
	GitHubTokenResult               = "GitHub token: %s\n"
	GitLabConnectorTypePrompt       = "GitLab connector: "
	GitLabConnectorTypeResult       = "GitLab connector: %s\n"
	GitLabConnectorTypeUnknown      = "unknown GitLabConnectorType defined in %q: %q"
	GitLabTokenPrompt               = "GitLab token: "
	GitLabTokenResult               = "GitLab token: %s\n"
	GitURLCannotParse               = "cannot parse Git URL %q"
	GitVersionMajorNotNumber        = "cannot convert major version %q to int: %w"
	GitVersionMinorNotNumber        = "cannot convert minor version %q to int: %w"
	GitVersionProblem               = "cannot determine Git version: %w"
	GitVersionTooLow                = "this app requires Git 2.30 or higher"
	GitVersionUnexpectedOutput      = "'git version' returned unexpected output: %q.\nPlease open an issue and supply the output of running 'git version'"

	HackBranchIsAlreadyFeature = "branch %q is already a feature branch"
	HackTooManyArguments       = "please provide only one branch to create"

	IgnoreUncommitted   = "Ship ignores uncommitted changes: %s\n"
	InputAddOrRemove    = `invalid argument %q. Please provide either "add" or "remove"`
	InputYesOrNo        = `invalid argument: %q. Please provide either "yes" or "no".\n`
	InvalidStatusOutput = `invalid "git status -z" output: %q`

	MainBranch                       = "Main branch: %s\n"
	MainBranchCannotMakeContribution = "cannot make the main branch a contribution branch"
	MainBranchCannotMakeFeature      = "cannot make the main branch a feature branch"
	MainBranchCannotObserve          = "cannot observe the main branch"
	MainBranchCannotPark             = "cannot park the main branch"
	MainBranchCannotPropose          = "cannot propose the main branch"
	MainBranchCannotPrototype        = "cannot prototype the main branch"
	MainBranchCannotShip             = "cannot ship the main branch"
	MainBranchNotFound               = "cannot find the main branch"
	MergeBranchNotLocal              = "cannot merge: branch %q is not local"
	MergeDetachedHead                = "please check out the branch to merge"
	MergeNoGrandParent               = "cannot merge branch %q because its parent branch (%s) has no parent"
	MergeNoParent                    = "cannot merge branch %q because it has no parent"
	MergeNotInSyncWithTracking       = `branch %q is not in sync with its tracking branch, please run "git town sync" and try again`
	MergeOpenChanges                 = "please commit or remove the open changes first"
	MergeWrongBranchType             = "cannot merge %s branches"

	NewBranchType = "New branch type:"

	ObserveBranchIsLocal        = "branch %q is local only - branches you want to observe must have a remote branch because they are per definition other people's branches"
	ObservedBranchCannotPark    = "cannot park observed branches"
	ObservedBranchCannotPropose = "cannot propose observed branches"
	ObservedBranchCannotShip    = "cannot ship observed branches"
	ObserveDetachedHead         = "please check out the branch to make observed"
	ObservedRegexCannotParse    = "unknown observed regex value (%q) defined in %q: %w"
	ObservedRegexPrompt         = "Observed regex: "
	ObservedRegexResult         = "Observed regex: %s\n"
	OfflineNotAllowed           = "this command requires an active internet connection"
	OpcodeNotRunnable           = "unrunnable opcode: %q"
	OpcodeUnknown               = "unknown opcode: %q, run \"git town status reset\" to reset it"
	OpenChangesProblem          = "cannot determine open changes: %w"
	Order                       = "Order: %s\n"
	OrderInvalid                = "invalid order defined in %s: %q"
	OriginHostnamePrompt        = "Origin hostname override: "
	OriginHostnameResult        = "Origin hostname: %s\n"

	ParentBranchTitle                       = `Parent branch for %s`
	ParkDetachedHead                        = "please check out the branch to park"
	ParkedRemoved                           = "branch %q is no longer parked"
	PerennialBranchCannotMakeContribution   = "cannot make perennial branches contribution branches"
	PerennialBranchCannotMakeFeature        = "cannot make perennial branches feature branches"
	PerennialBranchCannotObserve            = "cannot observe perennial branches"
	PerennialBranchCannotPark               = "cannot park perennial branches"
	PerennialBranchCannotPropose            = "cannot propose perennial branches"
	PerennialBranchCannotPrototype          = "cannot prototype perennial branches"
	PerennialBranchCannotShip               = "cannot ship perennial branches"
	PerennialBranches                       = "Perennial branches: %s\n"
	PerennialBranchRemovedParentEntry       = "Removed parent entry for perennial branch %q\n"
	PerennialRegexPrompt                    = "Perennial regex: "
	PerennialRegexResult                    = "Perennial regex: %s\n"
	PrependDetachedHead                     = "please check out the branch for which you want to prepend a parent"
	PreviousCommandFinished                 = "The previous Git Town command (%s) finished successfully.\n"
	PreviousCommandProblem                  = "The last Git Town command (%s) hit a problem %v ago.\n"
	ProposalFindProblem                     = "cannot find proposal: %s"
	ProposalLineageUnsupportedForBranchType = "Proposal stack lineage unsupported for branch type %s"
	ProposalMultipleFromFound               = "found %d proposals for branch %q"
	ProposalMultipleFromToFound             = "found %d proposals from branch %q to branch %q"
	ProposalNoNumberGiven                   = "no proposal number given"
	ProposalNoParent                        = "branch %q has no parent and can therefore not be proposed"
	ProposalsLineage                        = "Proposals display the stack lineage: %s\n"
	ProposalsLineageInvalid                 = "invalid value for whether proposals should show the lineage in %q: %q. Valid values are: none, ci, cli"
	ProposalSourceCannotUpdate              = "cannot update the proposal source branch on your forge"
	ProposalTargetBranchUpdateProblem       = "cannot update the target branch of proposal %d on your forge"
	ProposalURLProblem                      = "cannot determine proposal URL from %q to %q: %w"
	ProposeDetached                         = "please check out the branch to propose"
	PrototypeDetachedHead                   = "please check out the branch to make a prototype branch"
	PrototypeRemoved                        = "branch %q is no longer a prototype branch"
	PullRequestDeprecation                  = `DEPRECATION NOTICE

This command has been renamed to "git town propose"
and will be removed in future versions of Git Town.`
	PushBranches               = "Push branches: %s\n"
	PushHook                   = "Push hook: %s\n"
	PushNewBranchesDeprecation = `The Git Town configuration file contains the deprecated setting "push-new-branches".
Please upgrade to the new format: share-new-branches = "push"`

	RebaseProblem           = "cannot determine rebase in progress: %w"
	RemoteExistsProblem     = "cannot determine if remote %q exists: %w"
	RemotesProblem          = "cannot determine remotes: %w"
	RenameBranchDeprecation = `DEPRECATION NOTICE

This command has been renamed to "git town rename"
and will be removed in future versions of Git Town.`
	RenameDetachedHead             = "please check out the branch to rename"
	RenameMainBranch               = "the main branch cannot be renamed"
	RenamePerennialBranchWarning   = "%q is a perennial branch. Renaming a perennial branch typically requires other updates. If you are sure you want to do this, use '--force'"
	RenameToSameName               = "cannot rename branch to current name"
	RepoOutside                    = "this is not a Git repository"
	RunAutoUndo                    = "%s\nAuto-undo... "
	RunCommandProblem              = "error running command %q: %w"
	RunLogCannotOpen               = "cannot open runlog file %q: %w"
	RunLogCannotRead               = "cannot read runlog file %q: %w"
	RunLogCannotWrite              = "cannot write to runlog file %q: %w"
	RunLogDeleted                  = "Runlog deleted."
	RunlogDisplaying               = "Displaying runlog at %s\n"
	RunLogDoesntExist              = "Runlog doesn't exist."
	RunLogSerializeProblem         = "cannot encode runlog: %w"
	RunstateCannotDetermineUserDir = "cannot determine the user configuration directory: %w"
	RunstateDeleted                = "Runstate file deleted."
	RunstateDeleteProblem          = "cannot delete previous run state: %w"
	RunstateDoesntExist            = "Runstate file doesn't exist."
	RunstateLoadProblem            = "cannot load previous run state: %w"
	RunstateSaveProblem            = "cannot save run state: %w"
	RunstateSerializeProblem       = "cannot encode run-state: %w"

	SetParentNoFeatureBranch              = "the branch %q is not a feature branch. Only feature branches can have parent branches"
	SetParentNoneOption                   = "<none> (make perennial)"
	SetParentRepoHasDetachedHead          = "please check out the branch for which to set the parent"
	SettingCannotRemove                   = "ERROR: cannot remove %s Git setting %q: %v"
	SettingCannotWrite                    = "ERROR: cannot write %s Git setting %q: %v"
	SettingDeprecatedMessage              = "Upgrading deprecated %s setting %q to %q."
	SettingDeprecatedValueMessage         = "Upgrading value of %s Git alias %q from %q to %q."
	SettingIgnoreInvalid                  = "Notice: ignoring invalid dialog input setting %q\n"
	SettingSunsetBranchList               = "Inlining deprecated branch list %q"
	SettingSunsetDeleted                  = "Deleting obsolete setting %q"
	ShareNewBranches                      = "Share new branches: %s\n"
	ShipAPIConnectorRequired              = "please configure API access to your forge, more info at https://www.git-town.com/configuration#access-tokens"
	ShipAPIConnectorUnsupported           = "the Git Town driver for your forge does not support shipping via the API"
	ShipAPINoProposal                     = "cannot ship branch %q via API because it has no proposal"
	ShipAPINoRemoteBranch                 = "cannot ship branch %q via API because it has no remote branch"
	ShipBranchHasNoParent                 = "branch %q has no parent to ship into"
	ShipBranchIsInOtherWorktree           = "branch %q is checked out in another worktree, please ship from there"
	ShipBranchNothingToDo                 = "the branch %q has no shippable changes"
	ShipBranchOtherWorktree               = "branch %q is active in another worktree"
	ShipChildBranch                       = "shipping this branch would ship %s as well,\nplease ship %q first"
	ShipDeletesTrackingBranches           = "Ship deletes tracking branches: %s\n"
	ShipExitMergeError                    = "aborted because merge exited with error"
	ShipMessageWithFastForward            = "shipping with the fast-forward strategy does not use the given commit message"
	ShipNoBranchToShip                    = "please provide the branch to ship"
	ShipOpenChanges                       = "you have uncommitted changes. Did you mean to commit them before shipping?"
	ShipRepoHasDetachedHead               = "please check out the branch to ship"
	ShipStrategy                          = "Ship strategy: %s\n"
	ShipStrategyMissing                   = "no ship strategy provided"
	SkipBranchHasConflicts                = "cannot skip branch that resulted in conflicts"
	SkipMessage                           = `You can run "git town skip" to skip the currently failing operation.`
	SkipNoFinalBranchInfo                 = "found no information about branch %q in the final snapshot"
	SkipNoFinalSnapshot                   = "found no final snapshot"
	SkipNoInitialBranchInfo               = "found no information about branch %q in the initial snapshot"
	SkipNothingToDo                       = "nothing to skip"
	SquashCannotReadFile                  = "cannot read squash message file %q: %w"
	SquashCommitAuthorProblem             = "error getting squash commit author: %w"
	SquashCommitAuthorQuery               = "Please choose an author for the squash commit:"
	SquashCommitAuthorSelection           = "Selected squash commit author: %s\n"
	SquashMessageProblem                  = "cannot comment out the squash commit message: %w"
	StashResult                           = "Stash: %s\n"
	StatusFileNotFound                    = "No status file found for this repository."
	SwapNeedsCompress                     = "cannot swap because branch %q contains merge commits - please compress and try again"
	SwapNeedsSync                         = "please sync your branches before swapping"
	SwapNoGrandParent                     = "cannot swap a branch without grand-parent"
	SwapNoParent                          = "cannot swap a branch without parent"
	SwapOtherWorkTree                     = "cannot swap because branch %q it is active in another worktree"
	SwapParentNotLocal                    = "cannot swap: parent branch %q is not available locally"
	SwapParentWrongBranchType             = "cannot swap: branch %q is a %s branch"
	SwapRemoteBranch                      = "cannot swap: branch %q is remote"
	SwapRepoHasDetachedHead               = "please check out the branch to swap"
	SwapUnsupportedBranchType             = "cannot swap: branch %q is a %s branch"
	SwitchNoBranches                      = "no branches to switch to"
	SwitchUncommittedChanges              = "uncommitted changes"
	SyncFeatureBranches                   = "Sync feature branches: %s\n"
	SyncPerennialBranches                 = "Sync perennial branches: %s\n"
	SyncPerennialBranchHasUnpushedCommits = `cannot sync branch %q because it has unpushed local commits`
	SyncPrototypeBranches                 = "Sync prototype branches: %s\n"
	SyncRepoHasDetachedHead               = "please check out the branch to sync"
	SyncStatusNotRecognized               = "cannot determine the sync status for Git remote %q and branch name %q"
	SyncTags                              = "Sync tags: %s\n"
	SyncWithUpstream                      = "Sync with upstream: %s\n"

	UndoCannotRevertCommitOnPerennialBranch = "Cannot undo commit %q because it is on a perennial branch"
	UndoContinueGuidance                    = "\n\nTo continue after having resolved conflicts, run \"git town continue\".\nTo go back to where you started, run \"git town undo\".\n"
	UndoCreateOpcodeProblem                 = "cannot create undo operations for %q: %w"
	UndoMessage                             = `You can run "git town undo" to go back to where you started.`
	UndoNothingToDo                         = "nothing to undo"
	UnfinishedCommandHandle                 = "Handle unfinished command: %s\n"
	UnfinishedRunStateBoth                  = `Continue the old %q command and then run the current command`
	UnfinishedRunStateContinue              = "Continue the \"%s\" command after having resolved conflicts"
	UnfinishedRunStateDiscard               = "Discard the unfinished state and run the new command"
	UnfinishedRunStateQuit                  = "Quit without running anything"
	UnfinishedRunStateSkip                  = "Skip the current branch and continue the \"%s\" command on the next branch"
	UnfinishedRunStateUndo                  = "Undo the previous \"%s\" command"
	UnknownBranchType                       = "Unknown branch type: %s\n"
	UpdateProposalBodyUnsupported           = "the Git Town driver for your forge does not support updating the proposal body"
	UpNoChild                               = "branch %q has no children"
	UpNoCurrentBranch                       = "you need to be on a branch to go up"

	ValueInvalid = "invalid value for %s: %q. Please provide either \"yes\" or \"no\""

	WalkAllOrStack   = "please provide either --all or --stack"
	WalkDetachedHead = "please check out the branch from which to walk"
	WalkDone         = "Branch walk done."
	WalkNoDryRun     = "there is no dry-run mode for walking through branches on your shell, please call with a command to run on each branch"
)
