Feature: walk each branch verbosely

  Background:
    Given a Git repo with origin
    And the branches
      | NAME     | TYPE    | PARENT   | LOCATIONS |
      | branch-1 | feature | main     | local     |
      | branch-2 | feature | branch-1 | local     |
    And the current branch is "branch-2"
    When I run "git-town walk --stack --verbose echo hello"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH   | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |          | git version                                                                                                                                                                                                                                                                                                                                      |
      |          | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |          | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |          | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |          | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |          | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |          | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |          | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |          | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |          | git remote                                                                                                                                                                                                                                                                                                                                       |
      | branch-2 | git checkout branch-1                                                                                                                                                                                                                                                                                                                            |
      | branch-1 | echo hello                                                                                                                                                                                                                                                                                                                                       |
      |          | git checkout branch-2                                                                                                                                                                                                                                                                                                                            |
      | branch-2 | echo hello                                                                                                                                                                                                                                                                                                                                       |
      |          | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | git stash list                                                                                                                                                                                                                                                                                                                                   |
    And Git Town prints:
      """
      Branch walk done.
      """

  Scenario: undo
    When I run "git-town undo --verbose"
    Then Git Town runs the commands
      | BRANCH | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |        | git version                                                                                                                                                                                                                                                                                                                                      |
      |        | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |        | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |        | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |        | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |        | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |        | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |        | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |        | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |        | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |        | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |        | git remote                                                                                                                                                                                                                                                                                                                                       |
      |        | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
