@skipWindows
Feature: shipping a prototype branch

  Background:
    Given a Git repo with origin
    And the branches
      | NAME      | TYPE      | PARENT | LOCATIONS     |
      | prototype | prototype | main   | local, origin |
    And the commits
      | BRANCH    | LOCATION      | MESSAGE          |
      | prototype | local, origin | prototype commit |
    And Git setting "git-town.ship-strategy" is "squash-merge"
    And the current branch is "prototype"
    When I run "git-town ship" and enter "prototype done" for the commit message

  Scenario: result
    Then Git Town runs the commands
      | BRANCH    | COMMAND                           |
      | prototype | git fetch --prune --tags          |
      |           | git checkout main                 |
      | main      | git merge --squash --ff prototype |
      |           | git commit                        |
      |           | git push                          |
      |           | git push origin :prototype        |
      |           | git branch -D prototype           |
    And no lineage exists now
    And the branches are now
      | REPOSITORY    | BRANCHES |
      | local, origin | main     |
    And these commits exist now
      | BRANCH | LOCATION      | MESSAGE        |
      | main   | local, origin | prototype done |

  Scenario: undo
    When I run "git-town undo"
    Then Git Town runs the commands
      | BRANCH | COMMAND                                           |
      | main   | git revert {{ sha 'prototype done' }}             |
      |        | git push                                          |
      |        | git branch prototype {{ sha 'prototype commit' }} |
      |        | git push -u origin prototype                      |
      |        | git checkout prototype                            |
    And the initial branches and lineage exist now
    And these commits exist now
      | BRANCH    | LOCATION      | MESSAGE                 |
      | main      | local, origin | prototype done          |
      |           |               | Revert "prototype done" |
      | prototype | local, origin | prototype commit        |
    And branch "prototype" now has type "prototype"
