package opcodes

import (
	"github.com/git-town/git-town/v22/internal/forge"
	"github.com/git-town/git-town/v22/internal/forge/forgedomain"
	"github.com/git-town/git-town/v22/internal/git/gitdomain"
	"github.com/git-town/git-town/v22/internal/vm/shared"
	. "github.com/git-town/git-town/v22/pkg/prelude"
)

type ProposalUpdateLineage struct {
	Current         gitdomain.LocalBranchName
	CurrentProposal Option[forgedomain.Proposal]
	LineageTree     OptionalMutable[forge.ProposalStackLineageTree]
}

func (self *ProposalUpdateLineage) Run(args shared.RunArgs) error {
	connector, hasConnector := args.Connector.Get()
	if !hasConnector {
		return nil
	}
	proposal, hasProposal := self.CurrentProposal.Get()
	if !hasProposal {
		return nil
	}
	proposalFinder, canFindProposals := connector.(forgedomain.ProposalFinder)
	if !canFindProposals {
		return nil
	}
	lineageArgs := forge.ProposalStackLineageArgs{
		Connector:                proposalFinder,
		CurrentBranch:            self.Current,
		Lineage:                  args.Config.Value.NormalConfig.Lineage,
		MainAndPerennialBranches: args.Config.Value.MainAndPerennials(),
	}
	builder, hasBuilder := forge.NewProposalStackLineageBuilder(lineageArgs, self.LineageTree).Get()
	if !hasBuilder {
		return nil
	}
	if err := builder.UpdateStack(lineageArgs); err != nil {
		return err
	}
	args.PrependOpcodes(&ProposalUpdateBody{
		Proposal:    proposal,
		UpdatedBody: forge.ProposalBodyUpdateWithStackLineage(proposal.Data.Data().Body.GetOrZero(), builder.Build(lineageArgs)),
	})
	return nil
}
