Feature: cannot delete a detached head

  Background:
    Given a Git repo with origin
    And the branches
      | NAME   | TYPE    | PARENT | LOCATIONS     |
      | branch | feature | main   | local, origin |
    And the commits
      | BRANCH | LOCATION | MESSAGE  |
      | branch | local    | commit 1 |
      | branch | local    | commit 2 |
    And the current branch is "branch"
    And I ran "git checkout HEAD^"
    When I run "git-town delete"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH                     | COMMAND                  |
      | {{ sha-short 'commit 1' }} | git fetch --prune --tags |
    And Git Town prints the error:
      """
      please check out the branch to delete
      """
    And the initial commits exist now
    And the initial branches and lineage exist now
