Feature: compress the commits on a feature branch verbosely

  Background:
    Given a Git repo with origin
    And the branches
      | NAME    | TYPE    | PARENT | LOCATIONS     |
      | feature | feature | main   | local, origin |
    And the commits
      | BRANCH  | LOCATION      | MESSAGE  | FILE NAME | FILE CONTENT |
      | feature | local, origin | commit 1 | file_1    | content 1    |
      |         |               | commit 2 | file_2    | content 2    |
      |         |               | commit 3 | file_3    | content 3    |
    And the current branch is "feature"
    When I run "git-town compress --verbose" and enter "compressed commit" for the commit message

  Scenario: result
    Then Git Town runs the commands
      | BRANCH  | TYPE     | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |         | backend  | git version                                                                                                                                                                                                                                                                                                                                      |
      |         | backend  | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |         | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |         | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |         | backend  | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |         | backend  | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |         | backend  | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |         | backend  | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |         | backend  | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |         | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |         | backend  | git remote                                                                                                                                                                                                                                                                                                                                       |
      |         | backend  | git branch --show-current                                                                                                                                                                                                                                                                                                                        |
      | feature | frontend | git fetch --prune --tags                                                                                                                                                                                                                                                                                                                         |
      |         | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |         | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |         | backend  | git log "--format=%H %s" main..feature                                                                                                                                                                                                                                                                                                           |
      |         | backend  | git show --no-patch --format=%B {{ sha-initial 'commit 1' }}                                                                                                                                                                                                                                                                                     |
      |         | backend  | git log --no-merges --format=%H refs/heads/main ^refs/heads/feature                                                                                                                                                                                                                                                                              |
      |         | frontend | git reset --soft main                                                                                                                                                                                                                                                                                                                            |
      |         | frontend | git commit -m "commit 1"                                                                                                                                                                                                                                                                                                                         |
      |         | backend  | git rev-parse feature origin/feature                                                                                                                                                                                                                                                                                                             |
      |         | frontend | git push --force-with-lease --force-if-includes                                                                                                                                                                                                                                                                                                  |
      |         | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |         | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |         | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |         | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
    And Git Town prints:
      """
      Ran 26 shell commands
      """
    And all branches are now synchronized
    And these commits exist now
      | BRANCH  | LOCATION      | MESSAGE  |
      | feature | local, origin | commit 1 |
    And file "file_1" still has content "content 1"
    And file "file_2" still has content "content 2"
    And file "file_3" still has content "content 3"

  Scenario: undo
    When I run "git-town undo --verbose"
    Then Git Town runs the commands
      | BRANCH  | TYPE     | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |         | backend  | git version                                                                                                                                                                                                                                                                                                                                      |
      |         | backend  | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |         | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |         | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |         | backend  | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |         | backend  | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |         | backend  | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |         | backend  | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |         | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |         | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |         | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |         | backend  | git remote                                                                                                                                                                                                                                                                                                                                       |
      |         | backend  | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |         | backend  | git rev-parse HEAD                                                                                                                                                                                                                                                                                                                               |
      | feature | frontend | git reset --hard {{ sha 'commit 3' }}                                                                                                                                                                                                                                                                                                            |
      |         | backend  | git rev-parse feature origin/feature                                                                                                                                                                                                                                                                                                             |
      |         | frontend | git push --force-with-lease --force-if-includes                                                                                                                                                                                                                                                                                                  |
    And the initial commits exist now
    And the initial branches and lineage exist now
