// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/firestore/v1beta1/firestore.proto

package firestore

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf4 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The type of change.
type TargetChange_TargetChangeType int32

const (
	// No change has occurred. Used only to send an updated `resume_token`.
	TargetChange_NO_CHANGE TargetChange_TargetChangeType = 0
	// The targets have been added.
	TargetChange_ADD TargetChange_TargetChangeType = 1
	// The targets have been removed.
	TargetChange_REMOVE TargetChange_TargetChangeType = 2
	// The targets reflect all changes committed before the targets were added
	// to the stream.
	//
	// This will be sent after or with a `read_time` that is greater than or
	// equal to the time at which the targets were added.
	//
	// Listeners can wait for this change if read-after-write semantics
	// are desired.
	TargetChange_CURRENT TargetChange_TargetChangeType = 3
	// The targets have been reset, and a new initial state for the targets
	// will be returned in subsequent changes.
	//
	// After the initial state is complete, `CURRENT` will be returned even
	// if the target was previously indicated to be `CURRENT`.
	TargetChange_RESET TargetChange_TargetChangeType = 4
)

var TargetChange_TargetChangeType_name = map[int32]string{
	0: "NO_CHANGE",
	1: "ADD",
	2: "REMOVE",
	3: "CURRENT",
	4: "RESET",
}
var TargetChange_TargetChangeType_value = map[string]int32{
	"NO_CHANGE": 0,
	"ADD":       1,
	"REMOVE":    2,
	"CURRENT":   3,
	"RESET":     4,
}

func (x TargetChange_TargetChangeType) String() string {
	return proto.EnumName(TargetChange_TargetChangeType_name, int32(x))
}
func (TargetChange_TargetChangeType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor2, []int{20, 0}
}

// The request for [Firestore.GetDocument][google.firestore.v1beta1.Firestore.GetDocument].
type GetDocumentRequest struct {
	// The resource name of the Document to get. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The fields to return. If not set, returns all fields.
	//
	// If the document has a field that is not present in this mask, that field
	// will not be returned in the response.
	Mask *DocumentMask `protobuf:"bytes,2,opt,name=mask" json:"mask,omitempty"`
	// The consistency mode for this transaction.
	// If not set, defaults to strong consistency.
	//
	// Types that are valid to be assigned to ConsistencySelector:
	//	*GetDocumentRequest_Transaction
	//	*GetDocumentRequest_ReadTime
	ConsistencySelector isGetDocumentRequest_ConsistencySelector `protobuf_oneof:"consistency_selector"`
}

func (m *GetDocumentRequest) Reset()                    { *m = GetDocumentRequest{} }
func (m *GetDocumentRequest) String() string            { return proto.CompactTextString(m) }
func (*GetDocumentRequest) ProtoMessage()               {}
func (*GetDocumentRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

type isGetDocumentRequest_ConsistencySelector interface {
	isGetDocumentRequest_ConsistencySelector()
}

type GetDocumentRequest_Transaction struct {
	Transaction []byte `protobuf:"bytes,3,opt,name=transaction,proto3,oneof"`
}
type GetDocumentRequest_ReadTime struct {
	ReadTime *google_protobuf1.Timestamp `protobuf:"bytes,5,opt,name=read_time,json=readTime,oneof"`
}

func (*GetDocumentRequest_Transaction) isGetDocumentRequest_ConsistencySelector() {}
func (*GetDocumentRequest_ReadTime) isGetDocumentRequest_ConsistencySelector()    {}

func (m *GetDocumentRequest) GetConsistencySelector() isGetDocumentRequest_ConsistencySelector {
	if m != nil {
		return m.ConsistencySelector
	}
	return nil
}

func (m *GetDocumentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetDocumentRequest) GetMask() *DocumentMask {
	if m != nil {
		return m.Mask
	}
	return nil
}

func (m *GetDocumentRequest) GetTransaction() []byte {
	if x, ok := m.GetConsistencySelector().(*GetDocumentRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (m *GetDocumentRequest) GetReadTime() *google_protobuf1.Timestamp {
	if x, ok := m.GetConsistencySelector().(*GetDocumentRequest_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*GetDocumentRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _GetDocumentRequest_OneofMarshaler, _GetDocumentRequest_OneofUnmarshaler, _GetDocumentRequest_OneofSizer, []interface{}{
		(*GetDocumentRequest_Transaction)(nil),
		(*GetDocumentRequest_ReadTime)(nil),
	}
}

func _GetDocumentRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*GetDocumentRequest)
	// consistency_selector
	switch x := m.ConsistencySelector.(type) {
	case *GetDocumentRequest_Transaction:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Transaction)
	case *GetDocumentRequest_ReadTime:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReadTime); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("GetDocumentRequest.ConsistencySelector has unexpected type %T", x)
	}
	return nil
}

func _GetDocumentRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*GetDocumentRequest)
	switch tag {
	case 3: // consistency_selector.transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.ConsistencySelector = &GetDocumentRequest_Transaction{x}
		return true, err
	case 5: // consistency_selector.read_time
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf1.Timestamp)
		err := b.DecodeMessage(msg)
		m.ConsistencySelector = &GetDocumentRequest_ReadTime{msg}
		return true, err
	default:
		return false, nil
	}
}

func _GetDocumentRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*GetDocumentRequest)
	// consistency_selector
	switch x := m.ConsistencySelector.(type) {
	case *GetDocumentRequest_Transaction:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Transaction)))
		n += len(x.Transaction)
	case *GetDocumentRequest_ReadTime:
		s := proto.Size(x.ReadTime)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The request for [Firestore.ListDocuments][google.firestore.v1beta1.Firestore.ListDocuments].
type ListDocumentsRequest struct {
	// The parent resource name. In the format:
	// `projects/{project_id}/databases/{database_id}/documents` or
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// For example:
	// `projects/my-project/databases/my-database/documents` or
	// `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The collection ID, relative to `parent`, to list. For example: `chatrooms`
	// or `messages`.
	CollectionId string `protobuf:"bytes,2,opt,name=collection_id,json=collectionId" json:"collection_id,omitempty"`
	// The maximum number of documents to return.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The `next_page_token` value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The order to sort results by. For example: `priority desc, name`.
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy" json:"order_by,omitempty"`
	// The fields to return. If not set, returns all fields.
	//
	// If a document has a field that is not present in this mask, that field
	// will not be returned in the response.
	Mask *DocumentMask `protobuf:"bytes,7,opt,name=mask" json:"mask,omitempty"`
	// The consistency mode for this transaction.
	// If not set, defaults to strong consistency.
	//
	// Types that are valid to be assigned to ConsistencySelector:
	//	*ListDocumentsRequest_Transaction
	//	*ListDocumentsRequest_ReadTime
	ConsistencySelector isListDocumentsRequest_ConsistencySelector `protobuf_oneof:"consistency_selector"`
	// If the list should show missing documents. A missing document is a
	// document that does not exist but has sub-documents. These documents will
	// be returned with a key but will not have fields, [Document.create_time][google.firestore.v1beta1.Document.create_time],
	// or [Document.update_time][google.firestore.v1beta1.Document.update_time] set.
	//
	// Requests with `show_missing` may not specify `where` or
	// `order_by`.
	ShowMissing bool `protobuf:"varint,12,opt,name=show_missing,json=showMissing" json:"show_missing,omitempty"`
}

func (m *ListDocumentsRequest) Reset()                    { *m = ListDocumentsRequest{} }
func (m *ListDocumentsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListDocumentsRequest) ProtoMessage()               {}
func (*ListDocumentsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{1} }

type isListDocumentsRequest_ConsistencySelector interface {
	isListDocumentsRequest_ConsistencySelector()
}

type ListDocumentsRequest_Transaction struct {
	Transaction []byte `protobuf:"bytes,8,opt,name=transaction,proto3,oneof"`
}
type ListDocumentsRequest_ReadTime struct {
	ReadTime *google_protobuf1.Timestamp `protobuf:"bytes,10,opt,name=read_time,json=readTime,oneof"`
}

func (*ListDocumentsRequest_Transaction) isListDocumentsRequest_ConsistencySelector() {}
func (*ListDocumentsRequest_ReadTime) isListDocumentsRequest_ConsistencySelector()    {}

func (m *ListDocumentsRequest) GetConsistencySelector() isListDocumentsRequest_ConsistencySelector {
	if m != nil {
		return m.ConsistencySelector
	}
	return nil
}

func (m *ListDocumentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDocumentsRequest) GetCollectionId() string {
	if m != nil {
		return m.CollectionId
	}
	return ""
}

func (m *ListDocumentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDocumentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListDocumentsRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

func (m *ListDocumentsRequest) GetMask() *DocumentMask {
	if m != nil {
		return m.Mask
	}
	return nil
}

func (m *ListDocumentsRequest) GetTransaction() []byte {
	if x, ok := m.GetConsistencySelector().(*ListDocumentsRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (m *ListDocumentsRequest) GetReadTime() *google_protobuf1.Timestamp {
	if x, ok := m.GetConsistencySelector().(*ListDocumentsRequest_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

func (m *ListDocumentsRequest) GetShowMissing() bool {
	if m != nil {
		return m.ShowMissing
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ListDocumentsRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ListDocumentsRequest_OneofMarshaler, _ListDocumentsRequest_OneofUnmarshaler, _ListDocumentsRequest_OneofSizer, []interface{}{
		(*ListDocumentsRequest_Transaction)(nil),
		(*ListDocumentsRequest_ReadTime)(nil),
	}
}

func _ListDocumentsRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ListDocumentsRequest)
	// consistency_selector
	switch x := m.ConsistencySelector.(type) {
	case *ListDocumentsRequest_Transaction:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Transaction)
	case *ListDocumentsRequest_ReadTime:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReadTime); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ListDocumentsRequest.ConsistencySelector has unexpected type %T", x)
	}
	return nil
}

func _ListDocumentsRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ListDocumentsRequest)
	switch tag {
	case 8: // consistency_selector.transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.ConsistencySelector = &ListDocumentsRequest_Transaction{x}
		return true, err
	case 10: // consistency_selector.read_time
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf1.Timestamp)
		err := b.DecodeMessage(msg)
		m.ConsistencySelector = &ListDocumentsRequest_ReadTime{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ListDocumentsRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ListDocumentsRequest)
	// consistency_selector
	switch x := m.ConsistencySelector.(type) {
	case *ListDocumentsRequest_Transaction:
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Transaction)))
		n += len(x.Transaction)
	case *ListDocumentsRequest_ReadTime:
		s := proto.Size(x.ReadTime)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response for [Firestore.ListDocuments][google.firestore.v1beta1.Firestore.ListDocuments].
type ListDocumentsResponse struct {
	// The Documents found.
	Documents []*Document `protobuf:"bytes,1,rep,name=documents" json:"documents,omitempty"`
	// The next page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListDocumentsResponse) Reset()                    { *m = ListDocumentsResponse{} }
func (m *ListDocumentsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListDocumentsResponse) ProtoMessage()               {}
func (*ListDocumentsResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{2} }

func (m *ListDocumentsResponse) GetDocuments() []*Document {
	if m != nil {
		return m.Documents
	}
	return nil
}

func (m *ListDocumentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for [Firestore.CreateDocument][google.firestore.v1beta1.Firestore.CreateDocument].
type CreateDocumentRequest struct {
	// The parent resource. For example:
	// `projects/{project_id}/databases/{database_id}/documents` or
	// `projects/{project_id}/databases/{database_id}/documents/chatrooms/{chatroom_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The collection ID, relative to `parent`, to list. For example: `chatrooms`.
	CollectionId string `protobuf:"bytes,2,opt,name=collection_id,json=collectionId" json:"collection_id,omitempty"`
	// The client-assigned document ID to use for this document.
	//
	// Optional. If not specified, an ID will be assigned by the service.
	DocumentId string `protobuf:"bytes,3,opt,name=document_id,json=documentId" json:"document_id,omitempty"`
	// The document to create. `name` must not be set.
	Document *Document `protobuf:"bytes,4,opt,name=document" json:"document,omitempty"`
	// The fields to return. If not set, returns all fields.
	//
	// If the document has a field that is not present in this mask, that field
	// will not be returned in the response.
	Mask *DocumentMask `protobuf:"bytes,5,opt,name=mask" json:"mask,omitempty"`
}

func (m *CreateDocumentRequest) Reset()                    { *m = CreateDocumentRequest{} }
func (m *CreateDocumentRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateDocumentRequest) ProtoMessage()               {}
func (*CreateDocumentRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{3} }

func (m *CreateDocumentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDocumentRequest) GetCollectionId() string {
	if m != nil {
		return m.CollectionId
	}
	return ""
}

func (m *CreateDocumentRequest) GetDocumentId() string {
	if m != nil {
		return m.DocumentId
	}
	return ""
}

func (m *CreateDocumentRequest) GetDocument() *Document {
	if m != nil {
		return m.Document
	}
	return nil
}

func (m *CreateDocumentRequest) GetMask() *DocumentMask {
	if m != nil {
		return m.Mask
	}
	return nil
}

// The request for [Firestore.UpdateDocument][google.firestore.v1beta1.Firestore.UpdateDocument].
type UpdateDocumentRequest struct {
	// The updated document.
	// Creates the document if it does not already exist.
	Document *Document `protobuf:"bytes,1,opt,name=document" json:"document,omitempty"`
	// The fields to update.
	// None of the field paths in the mask may contain a reserved name.
	//
	// If the document exists on the server and has fields not referenced in the
	// mask, they are left unchanged.
	// Fields referenced in the mask, but not present in the input document, are
	// deleted from the document on the server.
	UpdateMask *DocumentMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
	// The fields to return. If not set, returns all fields.
	//
	// If the document has a field that is not present in this mask, that field
	// will not be returned in the response.
	Mask *DocumentMask `protobuf:"bytes,3,opt,name=mask" json:"mask,omitempty"`
	// An optional precondition on the document.
	// The request will fail if this is set and not met by the target document.
	CurrentDocument *Precondition `protobuf:"bytes,4,opt,name=current_document,json=currentDocument" json:"current_document,omitempty"`
}

func (m *UpdateDocumentRequest) Reset()                    { *m = UpdateDocumentRequest{} }
func (m *UpdateDocumentRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateDocumentRequest) ProtoMessage()               {}
func (*UpdateDocumentRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{4} }

func (m *UpdateDocumentRequest) GetDocument() *Document {
	if m != nil {
		return m.Document
	}
	return nil
}

func (m *UpdateDocumentRequest) GetUpdateMask() *DocumentMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateDocumentRequest) GetMask() *DocumentMask {
	if m != nil {
		return m.Mask
	}
	return nil
}

func (m *UpdateDocumentRequest) GetCurrentDocument() *Precondition {
	if m != nil {
		return m.CurrentDocument
	}
	return nil
}

// The request for [Firestore.DeleteDocument][google.firestore.v1beta1.Firestore.DeleteDocument].
type DeleteDocumentRequest struct {
	// The resource name of the Document to delete. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// An optional precondition on the document.
	// The request will fail if this is set and not met by the target document.
	CurrentDocument *Precondition `protobuf:"bytes,2,opt,name=current_document,json=currentDocument" json:"current_document,omitempty"`
}

func (m *DeleteDocumentRequest) Reset()                    { *m = DeleteDocumentRequest{} }
func (m *DeleteDocumentRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteDocumentRequest) ProtoMessage()               {}
func (*DeleteDocumentRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{5} }

func (m *DeleteDocumentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteDocumentRequest) GetCurrentDocument() *Precondition {
	if m != nil {
		return m.CurrentDocument
	}
	return nil
}

// The request for [Firestore.BatchGetDocuments][google.firestore.v1beta1.Firestore.BatchGetDocuments].
type BatchGetDocumentsRequest struct {
	// The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database" json:"database,omitempty"`
	// The names of the documents to retrieve. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// The request will fail if any of the document is not a child resource of the
	// given `database`. Duplicate names will be elided.
	Documents []string `protobuf:"bytes,2,rep,name=documents" json:"documents,omitempty"`
	// The fields to return. If not set, returns all fields.
	//
	// If a document has a field that is not present in this mask, that field will
	// not be returned in the response.
	Mask *DocumentMask `protobuf:"bytes,3,opt,name=mask" json:"mask,omitempty"`
	// The consistency mode for this transaction.
	// If not set, defaults to strong consistency.
	//
	// Types that are valid to be assigned to ConsistencySelector:
	//	*BatchGetDocumentsRequest_Transaction
	//	*BatchGetDocumentsRequest_NewTransaction
	//	*BatchGetDocumentsRequest_ReadTime
	ConsistencySelector isBatchGetDocumentsRequest_ConsistencySelector `protobuf_oneof:"consistency_selector"`
}

func (m *BatchGetDocumentsRequest) Reset()                    { *m = BatchGetDocumentsRequest{} }
func (m *BatchGetDocumentsRequest) String() string            { return proto.CompactTextString(m) }
func (*BatchGetDocumentsRequest) ProtoMessage()               {}
func (*BatchGetDocumentsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{6} }

type isBatchGetDocumentsRequest_ConsistencySelector interface {
	isBatchGetDocumentsRequest_ConsistencySelector()
}

type BatchGetDocumentsRequest_Transaction struct {
	Transaction []byte `protobuf:"bytes,4,opt,name=transaction,proto3,oneof"`
}
type BatchGetDocumentsRequest_NewTransaction struct {
	NewTransaction *TransactionOptions `protobuf:"bytes,5,opt,name=new_transaction,json=newTransaction,oneof"`
}
type BatchGetDocumentsRequest_ReadTime struct {
	ReadTime *google_protobuf1.Timestamp `protobuf:"bytes,7,opt,name=read_time,json=readTime,oneof"`
}

func (*BatchGetDocumentsRequest_Transaction) isBatchGetDocumentsRequest_ConsistencySelector()    {}
func (*BatchGetDocumentsRequest_NewTransaction) isBatchGetDocumentsRequest_ConsistencySelector() {}
func (*BatchGetDocumentsRequest_ReadTime) isBatchGetDocumentsRequest_ConsistencySelector()       {}

func (m *BatchGetDocumentsRequest) GetConsistencySelector() isBatchGetDocumentsRequest_ConsistencySelector {
	if m != nil {
		return m.ConsistencySelector
	}
	return nil
}

func (m *BatchGetDocumentsRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *BatchGetDocumentsRequest) GetDocuments() []string {
	if m != nil {
		return m.Documents
	}
	return nil
}

func (m *BatchGetDocumentsRequest) GetMask() *DocumentMask {
	if m != nil {
		return m.Mask
	}
	return nil
}

func (m *BatchGetDocumentsRequest) GetTransaction() []byte {
	if x, ok := m.GetConsistencySelector().(*BatchGetDocumentsRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (m *BatchGetDocumentsRequest) GetNewTransaction() *TransactionOptions {
	if x, ok := m.GetConsistencySelector().(*BatchGetDocumentsRequest_NewTransaction); ok {
		return x.NewTransaction
	}
	return nil
}

func (m *BatchGetDocumentsRequest) GetReadTime() *google_protobuf1.Timestamp {
	if x, ok := m.GetConsistencySelector().(*BatchGetDocumentsRequest_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*BatchGetDocumentsRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _BatchGetDocumentsRequest_OneofMarshaler, _BatchGetDocumentsRequest_OneofUnmarshaler, _BatchGetDocumentsRequest_OneofSizer, []interface{}{
		(*BatchGetDocumentsRequest_Transaction)(nil),
		(*BatchGetDocumentsRequest_NewTransaction)(nil),
		(*BatchGetDocumentsRequest_ReadTime)(nil),
	}
}

func _BatchGetDocumentsRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*BatchGetDocumentsRequest)
	// consistency_selector
	switch x := m.ConsistencySelector.(type) {
	case *BatchGetDocumentsRequest_Transaction:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Transaction)
	case *BatchGetDocumentsRequest_NewTransaction:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NewTransaction); err != nil {
			return err
		}
	case *BatchGetDocumentsRequest_ReadTime:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReadTime); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("BatchGetDocumentsRequest.ConsistencySelector has unexpected type %T", x)
	}
	return nil
}

func _BatchGetDocumentsRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*BatchGetDocumentsRequest)
	switch tag {
	case 4: // consistency_selector.transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.ConsistencySelector = &BatchGetDocumentsRequest_Transaction{x}
		return true, err
	case 5: // consistency_selector.new_transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransactionOptions)
		err := b.DecodeMessage(msg)
		m.ConsistencySelector = &BatchGetDocumentsRequest_NewTransaction{msg}
		return true, err
	case 7: // consistency_selector.read_time
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf1.Timestamp)
		err := b.DecodeMessage(msg)
		m.ConsistencySelector = &BatchGetDocumentsRequest_ReadTime{msg}
		return true, err
	default:
		return false, nil
	}
}

func _BatchGetDocumentsRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*BatchGetDocumentsRequest)
	// consistency_selector
	switch x := m.ConsistencySelector.(type) {
	case *BatchGetDocumentsRequest_Transaction:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Transaction)))
		n += len(x.Transaction)
	case *BatchGetDocumentsRequest_NewTransaction:
		s := proto.Size(x.NewTransaction)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *BatchGetDocumentsRequest_ReadTime:
		s := proto.Size(x.ReadTime)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The streamed response for [Firestore.BatchGetDocuments][google.firestore.v1beta1.Firestore.BatchGetDocuments].
type BatchGetDocumentsResponse struct {
	// A single result.
	// This can be empty if the server is just returning a transaction.
	//
	// Types that are valid to be assigned to Result:
	//	*BatchGetDocumentsResponse_Found
	//	*BatchGetDocumentsResponse_Missing
	Result isBatchGetDocumentsResponse_Result `protobuf_oneof:"result"`
	// The transaction that was started as part of this request.
	// Will only be set in the first response, and only if
	// [BatchGetDocumentsRequest.new_transaction][google.firestore.v1beta1.BatchGetDocumentsRequest.new_transaction] was set in the request.
	Transaction []byte `protobuf:"bytes,3,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// The time at which the document was read.
	// This may be monotically increasing, in this case the previous documents in
	// the result stream are guaranteed not to have changed between their
	// read_time and this one.
	ReadTime *google_protobuf1.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime" json:"read_time,omitempty"`
}

func (m *BatchGetDocumentsResponse) Reset()                    { *m = BatchGetDocumentsResponse{} }
func (m *BatchGetDocumentsResponse) String() string            { return proto.CompactTextString(m) }
func (*BatchGetDocumentsResponse) ProtoMessage()               {}
func (*BatchGetDocumentsResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{7} }

type isBatchGetDocumentsResponse_Result interface {
	isBatchGetDocumentsResponse_Result()
}

type BatchGetDocumentsResponse_Found struct {
	Found *Document `protobuf:"bytes,1,opt,name=found,oneof"`
}
type BatchGetDocumentsResponse_Missing struct {
	Missing string `protobuf:"bytes,2,opt,name=missing,oneof"`
}

func (*BatchGetDocumentsResponse_Found) isBatchGetDocumentsResponse_Result()   {}
func (*BatchGetDocumentsResponse_Missing) isBatchGetDocumentsResponse_Result() {}

func (m *BatchGetDocumentsResponse) GetResult() isBatchGetDocumentsResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *BatchGetDocumentsResponse) GetFound() *Document {
	if x, ok := m.GetResult().(*BatchGetDocumentsResponse_Found); ok {
		return x.Found
	}
	return nil
}

func (m *BatchGetDocumentsResponse) GetMissing() string {
	if x, ok := m.GetResult().(*BatchGetDocumentsResponse_Missing); ok {
		return x.Missing
	}
	return ""
}

func (m *BatchGetDocumentsResponse) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *BatchGetDocumentsResponse) GetReadTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*BatchGetDocumentsResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _BatchGetDocumentsResponse_OneofMarshaler, _BatchGetDocumentsResponse_OneofUnmarshaler, _BatchGetDocumentsResponse_OneofSizer, []interface{}{
		(*BatchGetDocumentsResponse_Found)(nil),
		(*BatchGetDocumentsResponse_Missing)(nil),
	}
}

func _BatchGetDocumentsResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*BatchGetDocumentsResponse)
	// result
	switch x := m.Result.(type) {
	case *BatchGetDocumentsResponse_Found:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Found); err != nil {
			return err
		}
	case *BatchGetDocumentsResponse_Missing:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Missing)
	case nil:
	default:
		return fmt.Errorf("BatchGetDocumentsResponse.Result has unexpected type %T", x)
	}
	return nil
}

func _BatchGetDocumentsResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*BatchGetDocumentsResponse)
	switch tag {
	case 1: // result.found
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Document)
		err := b.DecodeMessage(msg)
		m.Result = &BatchGetDocumentsResponse_Found{msg}
		return true, err
	case 2: // result.missing
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Result = &BatchGetDocumentsResponse_Missing{x}
		return true, err
	default:
		return false, nil
	}
}

func _BatchGetDocumentsResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*BatchGetDocumentsResponse)
	// result
	switch x := m.Result.(type) {
	case *BatchGetDocumentsResponse_Found:
		s := proto.Size(x.Found)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *BatchGetDocumentsResponse_Missing:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Missing)))
		n += len(x.Missing)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The request for [Firestore.BeginTransaction][google.firestore.v1beta1.Firestore.BeginTransaction].
type BeginTransactionRequest struct {
	// The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database" json:"database,omitempty"`
	// The options for the transaction.
	// Defaults to a read-write transaction.
	Options *TransactionOptions `protobuf:"bytes,2,opt,name=options" json:"options,omitempty"`
}

func (m *BeginTransactionRequest) Reset()                    { *m = BeginTransactionRequest{} }
func (m *BeginTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*BeginTransactionRequest) ProtoMessage()               {}
func (*BeginTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{8} }

func (m *BeginTransactionRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *BeginTransactionRequest) GetOptions() *TransactionOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// The response for [Firestore.BeginTransaction][google.firestore.v1beta1.Firestore.BeginTransaction].
type BeginTransactionResponse struct {
	// The transaction that was started.
	Transaction []byte `protobuf:"bytes,1,opt,name=transaction,proto3" json:"transaction,omitempty"`
}

func (m *BeginTransactionResponse) Reset()                    { *m = BeginTransactionResponse{} }
func (m *BeginTransactionResponse) String() string            { return proto.CompactTextString(m) }
func (*BeginTransactionResponse) ProtoMessage()               {}
func (*BeginTransactionResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{9} }

func (m *BeginTransactionResponse) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The request for [Firestore.Commit][google.firestore.v1beta1.Firestore.Commit].
type CommitRequest struct {
	// The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database" json:"database,omitempty"`
	// The writes to apply.
	//
	// Always executed atomically and in order.
	Writes []*Write `protobuf:"bytes,2,rep,name=writes" json:"writes,omitempty"`
	// If set, applies all writes in this transaction, and commits it.
	Transaction []byte `protobuf:"bytes,3,opt,name=transaction,proto3" json:"transaction,omitempty"`
}

func (m *CommitRequest) Reset()                    { *m = CommitRequest{} }
func (m *CommitRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()               {}
func (*CommitRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{10} }

func (m *CommitRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *CommitRequest) GetWrites() []*Write {
	if m != nil {
		return m.Writes
	}
	return nil
}

func (m *CommitRequest) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The response for [Firestore.Commit][google.firestore.v1beta1.Firestore.Commit].
type CommitResponse struct {
	// The result of applying the writes.
	//
	// This i-th write result corresponds to the i-th write in the
	// request.
	WriteResults []*WriteResult `protobuf:"bytes,1,rep,name=write_results,json=writeResults" json:"write_results,omitempty"`
	// The time at which the commit occurred.
	CommitTime *google_protobuf1.Timestamp `protobuf:"bytes,2,opt,name=commit_time,json=commitTime" json:"commit_time,omitempty"`
}

func (m *CommitResponse) Reset()                    { *m = CommitResponse{} }
func (m *CommitResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()               {}
func (*CommitResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{11} }

func (m *CommitResponse) GetWriteResults() []*WriteResult {
	if m != nil {
		return m.WriteResults
	}
	return nil
}

func (m *CommitResponse) GetCommitTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CommitTime
	}
	return nil
}

// The request for [Firestore.Rollback][google.firestore.v1beta1.Firestore.Rollback].
type RollbackRequest struct {
	// The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database" json:"database,omitempty"`
	// The transaction to roll back.
	Transaction []byte `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
}

func (m *RollbackRequest) Reset()                    { *m = RollbackRequest{} }
func (m *RollbackRequest) String() string            { return proto.CompactTextString(m) }
func (*RollbackRequest) ProtoMessage()               {}
func (*RollbackRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{12} }

func (m *RollbackRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *RollbackRequest) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The request for [Firestore.RunQuery][google.firestore.v1beta1.Firestore.RunQuery].
type RunQueryRequest struct {
	// The parent resource name. In the format:
	// `projects/{project_id}/databases/{database_id}/documents` or
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// For example:
	// `projects/my-project/databases/my-database/documents` or
	// `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The query to run.
	//
	// Types that are valid to be assigned to QueryType:
	//	*RunQueryRequest_StructuredQuery
	QueryType isRunQueryRequest_QueryType `protobuf_oneof:"query_type"`
	// The consistency mode for this transaction.
	// If not set, defaults to strong consistency.
	//
	// Types that are valid to be assigned to ConsistencySelector:
	//	*RunQueryRequest_Transaction
	//	*RunQueryRequest_NewTransaction
	//	*RunQueryRequest_ReadTime
	ConsistencySelector isRunQueryRequest_ConsistencySelector `protobuf_oneof:"consistency_selector"`
}

func (m *RunQueryRequest) Reset()                    { *m = RunQueryRequest{} }
func (m *RunQueryRequest) String() string            { return proto.CompactTextString(m) }
func (*RunQueryRequest) ProtoMessage()               {}
func (*RunQueryRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{13} }

type isRunQueryRequest_QueryType interface {
	isRunQueryRequest_QueryType()
}
type isRunQueryRequest_ConsistencySelector interface {
	isRunQueryRequest_ConsistencySelector()
}

type RunQueryRequest_StructuredQuery struct {
	StructuredQuery *StructuredQuery `protobuf:"bytes,2,opt,name=structured_query,json=structuredQuery,oneof"`
}
type RunQueryRequest_Transaction struct {
	Transaction []byte `protobuf:"bytes,5,opt,name=transaction,proto3,oneof"`
}
type RunQueryRequest_NewTransaction struct {
	NewTransaction *TransactionOptions `protobuf:"bytes,6,opt,name=new_transaction,json=newTransaction,oneof"`
}
type RunQueryRequest_ReadTime struct {
	ReadTime *google_protobuf1.Timestamp `protobuf:"bytes,7,opt,name=read_time,json=readTime,oneof"`
}

func (*RunQueryRequest_StructuredQuery) isRunQueryRequest_QueryType()          {}
func (*RunQueryRequest_Transaction) isRunQueryRequest_ConsistencySelector()    {}
func (*RunQueryRequest_NewTransaction) isRunQueryRequest_ConsistencySelector() {}
func (*RunQueryRequest_ReadTime) isRunQueryRequest_ConsistencySelector()       {}

func (m *RunQueryRequest) GetQueryType() isRunQueryRequest_QueryType {
	if m != nil {
		return m.QueryType
	}
	return nil
}
func (m *RunQueryRequest) GetConsistencySelector() isRunQueryRequest_ConsistencySelector {
	if m != nil {
		return m.ConsistencySelector
	}
	return nil
}

func (m *RunQueryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *RunQueryRequest) GetStructuredQuery() *StructuredQuery {
	if x, ok := m.GetQueryType().(*RunQueryRequest_StructuredQuery); ok {
		return x.StructuredQuery
	}
	return nil
}

func (m *RunQueryRequest) GetTransaction() []byte {
	if x, ok := m.GetConsistencySelector().(*RunQueryRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (m *RunQueryRequest) GetNewTransaction() *TransactionOptions {
	if x, ok := m.GetConsistencySelector().(*RunQueryRequest_NewTransaction); ok {
		return x.NewTransaction
	}
	return nil
}

func (m *RunQueryRequest) GetReadTime() *google_protobuf1.Timestamp {
	if x, ok := m.GetConsistencySelector().(*RunQueryRequest_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RunQueryRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RunQueryRequest_OneofMarshaler, _RunQueryRequest_OneofUnmarshaler, _RunQueryRequest_OneofSizer, []interface{}{
		(*RunQueryRequest_StructuredQuery)(nil),
		(*RunQueryRequest_Transaction)(nil),
		(*RunQueryRequest_NewTransaction)(nil),
		(*RunQueryRequest_ReadTime)(nil),
	}
}

func _RunQueryRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RunQueryRequest)
	// query_type
	switch x := m.QueryType.(type) {
	case *RunQueryRequest_StructuredQuery:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StructuredQuery); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RunQueryRequest.QueryType has unexpected type %T", x)
	}
	// consistency_selector
	switch x := m.ConsistencySelector.(type) {
	case *RunQueryRequest_Transaction:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Transaction)
	case *RunQueryRequest_NewTransaction:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NewTransaction); err != nil {
			return err
		}
	case *RunQueryRequest_ReadTime:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReadTime); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RunQueryRequest.ConsistencySelector has unexpected type %T", x)
	}
	return nil
}

func _RunQueryRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RunQueryRequest)
	switch tag {
	case 2: // query_type.structured_query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StructuredQuery)
		err := b.DecodeMessage(msg)
		m.QueryType = &RunQueryRequest_StructuredQuery{msg}
		return true, err
	case 5: // consistency_selector.transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.ConsistencySelector = &RunQueryRequest_Transaction{x}
		return true, err
	case 6: // consistency_selector.new_transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransactionOptions)
		err := b.DecodeMessage(msg)
		m.ConsistencySelector = &RunQueryRequest_NewTransaction{msg}
		return true, err
	case 7: // consistency_selector.read_time
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf1.Timestamp)
		err := b.DecodeMessage(msg)
		m.ConsistencySelector = &RunQueryRequest_ReadTime{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RunQueryRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RunQueryRequest)
	// query_type
	switch x := m.QueryType.(type) {
	case *RunQueryRequest_StructuredQuery:
		s := proto.Size(x.StructuredQuery)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// consistency_selector
	switch x := m.ConsistencySelector.(type) {
	case *RunQueryRequest_Transaction:
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Transaction)))
		n += len(x.Transaction)
	case *RunQueryRequest_NewTransaction:
		s := proto.Size(x.NewTransaction)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RunQueryRequest_ReadTime:
		s := proto.Size(x.ReadTime)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response for [Firestore.RunQuery][google.firestore.v1beta1.Firestore.RunQuery].
type RunQueryResponse struct {
	// The transaction that was started as part of this request.
	// Can only be set in the first response, and only if
	// [RunQueryRequest.new_transaction][google.firestore.v1beta1.RunQueryRequest.new_transaction] was set in the request.
	// If set, no other fields will be set in this response.
	Transaction []byte `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// A query result.
	// Not set when reporting partial progress.
	Document *Document `protobuf:"bytes,1,opt,name=document" json:"document,omitempty"`
	// The time at which the document was read. This may be monotonically
	// increasing; in this case, the previous documents in the result stream are
	// guaranteed not to have changed between their `read_time` and this one.
	//
	// If the query returns no results, a response with `read_time` and no
	// `document` will be sent, and this represents the time at which the query
	// was run.
	ReadTime *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=read_time,json=readTime" json:"read_time,omitempty"`
	// The number of results that have been skipped due to an offset between
	// the last response and the current response.
	SkippedResults int32 `protobuf:"varint,4,opt,name=skipped_results,json=skippedResults" json:"skipped_results,omitempty"`
}

func (m *RunQueryResponse) Reset()                    { *m = RunQueryResponse{} }
func (m *RunQueryResponse) String() string            { return proto.CompactTextString(m) }
func (*RunQueryResponse) ProtoMessage()               {}
func (*RunQueryResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{14} }

func (m *RunQueryResponse) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *RunQueryResponse) GetDocument() *Document {
	if m != nil {
		return m.Document
	}
	return nil
}

func (m *RunQueryResponse) GetReadTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *RunQueryResponse) GetSkippedResults() int32 {
	if m != nil {
		return m.SkippedResults
	}
	return 0
}

// The request for [Firestore.Write][google.firestore.v1beta1.Firestore.Write].
//
// The first request creates a stream, or resumes an existing one from a token.
//
// When creating a new stream, the server replies with a response containing
// only an ID and a token, to use in the next request.
//
// When resuming a stream, the server first streams any responses later than the
// given token, then a response containing only an up-to-date token, to use in
// the next request.
type WriteRequest struct {
	// The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	// This is only required in the first message.
	Database string `protobuf:"bytes,1,opt,name=database" json:"database,omitempty"`
	// The ID of the write stream to resume.
	// This may only be set in the first message. When left empty, a new write
	// stream will be created.
	StreamId string `protobuf:"bytes,2,opt,name=stream_id,json=streamId" json:"stream_id,omitempty"`
	// The writes to apply.
	//
	// Always executed atomically and in order.
	// This must be empty on the first request.
	// This may be empty on the last request.
	// This must not be empty on all other requests.
	Writes []*Write `protobuf:"bytes,3,rep,name=writes" json:"writes,omitempty"`
	// A stream token that was previously sent by the server.
	//
	// The client should set this field to the token from the most recent
	// [WriteResponse][google.firestore.v1beta1.WriteResponse] it has received. This acknowledges that the client has
	// received responses up to this token. After sending this token, earlier
	// tokens may not be used anymore.
	//
	// The server may close the stream if there are too many unacknowledged
	// responses.
	//
	// Leave this field unset when creating a new stream. To resume a stream at
	// a specific point, set this field and the `stream_id` field.
	//
	// Leave this field unset when creating a new stream.
	StreamToken []byte `protobuf:"bytes,4,opt,name=stream_token,json=streamToken,proto3" json:"stream_token,omitempty"`
	// Labels associated with this write request.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *WriteRequest) Reset()                    { *m = WriteRequest{} }
func (m *WriteRequest) String() string            { return proto.CompactTextString(m) }
func (*WriteRequest) ProtoMessage()               {}
func (*WriteRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{15} }

func (m *WriteRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *WriteRequest) GetStreamId() string {
	if m != nil {
		return m.StreamId
	}
	return ""
}

func (m *WriteRequest) GetWrites() []*Write {
	if m != nil {
		return m.Writes
	}
	return nil
}

func (m *WriteRequest) GetStreamToken() []byte {
	if m != nil {
		return m.StreamToken
	}
	return nil
}

func (m *WriteRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// The response for [Firestore.Write][google.firestore.v1beta1.Firestore.Write].
type WriteResponse struct {
	// The ID of the stream.
	// Only set on the first message, when a new stream was created.
	StreamId string `protobuf:"bytes,1,opt,name=stream_id,json=streamId" json:"stream_id,omitempty"`
	// A token that represents the position of this response in the stream.
	// This can be used by a client to resume the stream at this point.
	//
	// This field is always set.
	StreamToken []byte `protobuf:"bytes,2,opt,name=stream_token,json=streamToken,proto3" json:"stream_token,omitempty"`
	// The result of applying the writes.
	//
	// This i-th write result corresponds to the i-th write in the
	// request.
	WriteResults []*WriteResult `protobuf:"bytes,3,rep,name=write_results,json=writeResults" json:"write_results,omitempty"`
	// The time at which the commit occurred.
	CommitTime *google_protobuf1.Timestamp `protobuf:"bytes,4,opt,name=commit_time,json=commitTime" json:"commit_time,omitempty"`
}

func (m *WriteResponse) Reset()                    { *m = WriteResponse{} }
func (m *WriteResponse) String() string            { return proto.CompactTextString(m) }
func (*WriteResponse) ProtoMessage()               {}
func (*WriteResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{16} }

func (m *WriteResponse) GetStreamId() string {
	if m != nil {
		return m.StreamId
	}
	return ""
}

func (m *WriteResponse) GetStreamToken() []byte {
	if m != nil {
		return m.StreamToken
	}
	return nil
}

func (m *WriteResponse) GetWriteResults() []*WriteResult {
	if m != nil {
		return m.WriteResults
	}
	return nil
}

func (m *WriteResponse) GetCommitTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CommitTime
	}
	return nil
}

// A request for [Firestore.Listen][google.firestore.v1beta1.Firestore.Listen]
type ListenRequest struct {
	// The database name. In the format:
	// `projects/{project_id}/databases/{database_id}`.
	Database string `protobuf:"bytes,1,opt,name=database" json:"database,omitempty"`
	// The supported target changes.
	//
	// Types that are valid to be assigned to TargetChange:
	//	*ListenRequest_AddTarget
	//	*ListenRequest_RemoveTarget
	TargetChange isListenRequest_TargetChange `protobuf_oneof:"target_change"`
	// Labels associated with this target change.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ListenRequest) Reset()                    { *m = ListenRequest{} }
func (m *ListenRequest) String() string            { return proto.CompactTextString(m) }
func (*ListenRequest) ProtoMessage()               {}
func (*ListenRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{17} }

type isListenRequest_TargetChange interface {
	isListenRequest_TargetChange()
}

type ListenRequest_AddTarget struct {
	AddTarget *Target `protobuf:"bytes,2,opt,name=add_target,json=addTarget,oneof"`
}
type ListenRequest_RemoveTarget struct {
	RemoveTarget int32 `protobuf:"varint,3,opt,name=remove_target,json=removeTarget,oneof"`
}

func (*ListenRequest_AddTarget) isListenRequest_TargetChange()    {}
func (*ListenRequest_RemoveTarget) isListenRequest_TargetChange() {}

func (m *ListenRequest) GetTargetChange() isListenRequest_TargetChange {
	if m != nil {
		return m.TargetChange
	}
	return nil
}

func (m *ListenRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *ListenRequest) GetAddTarget() *Target {
	if x, ok := m.GetTargetChange().(*ListenRequest_AddTarget); ok {
		return x.AddTarget
	}
	return nil
}

func (m *ListenRequest) GetRemoveTarget() int32 {
	if x, ok := m.GetTargetChange().(*ListenRequest_RemoveTarget); ok {
		return x.RemoveTarget
	}
	return 0
}

func (m *ListenRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ListenRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ListenRequest_OneofMarshaler, _ListenRequest_OneofUnmarshaler, _ListenRequest_OneofSizer, []interface{}{
		(*ListenRequest_AddTarget)(nil),
		(*ListenRequest_RemoveTarget)(nil),
	}
}

func _ListenRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ListenRequest)
	// target_change
	switch x := m.TargetChange.(type) {
	case *ListenRequest_AddTarget:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AddTarget); err != nil {
			return err
		}
	case *ListenRequest_RemoveTarget:
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.RemoveTarget))
	case nil:
	default:
		return fmt.Errorf("ListenRequest.TargetChange has unexpected type %T", x)
	}
	return nil
}

func _ListenRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ListenRequest)
	switch tag {
	case 2: // target_change.add_target
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Target)
		err := b.DecodeMessage(msg)
		m.TargetChange = &ListenRequest_AddTarget{msg}
		return true, err
	case 3: // target_change.remove_target
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.TargetChange = &ListenRequest_RemoveTarget{int32(x)}
		return true, err
	default:
		return false, nil
	}
}

func _ListenRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ListenRequest)
	// target_change
	switch x := m.TargetChange.(type) {
	case *ListenRequest_AddTarget:
		s := proto.Size(x.AddTarget)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListenRequest_RemoveTarget:
		n += proto.SizeVarint(3<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.RemoveTarget))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response for [Firestore.Listen][google.firestore.v1beta1.Firestore.Listen].
type ListenResponse struct {
	// The supported responses.
	//
	// Types that are valid to be assigned to ResponseType:
	//	*ListenResponse_TargetChange
	//	*ListenResponse_DocumentChange
	//	*ListenResponse_DocumentDelete
	//	*ListenResponse_DocumentRemove
	//	*ListenResponse_Filter
	ResponseType isListenResponse_ResponseType `protobuf_oneof:"response_type"`
}

func (m *ListenResponse) Reset()                    { *m = ListenResponse{} }
func (m *ListenResponse) String() string            { return proto.CompactTextString(m) }
func (*ListenResponse) ProtoMessage()               {}
func (*ListenResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{18} }

type isListenResponse_ResponseType interface {
	isListenResponse_ResponseType()
}

type ListenResponse_TargetChange struct {
	TargetChange *TargetChange `protobuf:"bytes,2,opt,name=target_change,json=targetChange,oneof"`
}
type ListenResponse_DocumentChange struct {
	DocumentChange *DocumentChange `protobuf:"bytes,3,opt,name=document_change,json=documentChange,oneof"`
}
type ListenResponse_DocumentDelete struct {
	DocumentDelete *DocumentDelete `protobuf:"bytes,4,opt,name=document_delete,json=documentDelete,oneof"`
}
type ListenResponse_DocumentRemove struct {
	DocumentRemove *DocumentRemove `protobuf:"bytes,6,opt,name=document_remove,json=documentRemove,oneof"`
}
type ListenResponse_Filter struct {
	Filter *ExistenceFilter `protobuf:"bytes,5,opt,name=filter,oneof"`
}

func (*ListenResponse_TargetChange) isListenResponse_ResponseType()   {}
func (*ListenResponse_DocumentChange) isListenResponse_ResponseType() {}
func (*ListenResponse_DocumentDelete) isListenResponse_ResponseType() {}
func (*ListenResponse_DocumentRemove) isListenResponse_ResponseType() {}
func (*ListenResponse_Filter) isListenResponse_ResponseType()         {}

func (m *ListenResponse) GetResponseType() isListenResponse_ResponseType {
	if m != nil {
		return m.ResponseType
	}
	return nil
}

func (m *ListenResponse) GetTargetChange() *TargetChange {
	if x, ok := m.GetResponseType().(*ListenResponse_TargetChange); ok {
		return x.TargetChange
	}
	return nil
}

func (m *ListenResponse) GetDocumentChange() *DocumentChange {
	if x, ok := m.GetResponseType().(*ListenResponse_DocumentChange); ok {
		return x.DocumentChange
	}
	return nil
}

func (m *ListenResponse) GetDocumentDelete() *DocumentDelete {
	if x, ok := m.GetResponseType().(*ListenResponse_DocumentDelete); ok {
		return x.DocumentDelete
	}
	return nil
}

func (m *ListenResponse) GetDocumentRemove() *DocumentRemove {
	if x, ok := m.GetResponseType().(*ListenResponse_DocumentRemove); ok {
		return x.DocumentRemove
	}
	return nil
}

func (m *ListenResponse) GetFilter() *ExistenceFilter {
	if x, ok := m.GetResponseType().(*ListenResponse_Filter); ok {
		return x.Filter
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ListenResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ListenResponse_OneofMarshaler, _ListenResponse_OneofUnmarshaler, _ListenResponse_OneofSizer, []interface{}{
		(*ListenResponse_TargetChange)(nil),
		(*ListenResponse_DocumentChange)(nil),
		(*ListenResponse_DocumentDelete)(nil),
		(*ListenResponse_DocumentRemove)(nil),
		(*ListenResponse_Filter)(nil),
	}
}

func _ListenResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ListenResponse)
	// response_type
	switch x := m.ResponseType.(type) {
	case *ListenResponse_TargetChange:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TargetChange); err != nil {
			return err
		}
	case *ListenResponse_DocumentChange:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DocumentChange); err != nil {
			return err
		}
	case *ListenResponse_DocumentDelete:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DocumentDelete); err != nil {
			return err
		}
	case *ListenResponse_DocumentRemove:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DocumentRemove); err != nil {
			return err
		}
	case *ListenResponse_Filter:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Filter); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ListenResponse.ResponseType has unexpected type %T", x)
	}
	return nil
}

func _ListenResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ListenResponse)
	switch tag {
	case 2: // response_type.target_change
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TargetChange)
		err := b.DecodeMessage(msg)
		m.ResponseType = &ListenResponse_TargetChange{msg}
		return true, err
	case 3: // response_type.document_change
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DocumentChange)
		err := b.DecodeMessage(msg)
		m.ResponseType = &ListenResponse_DocumentChange{msg}
		return true, err
	case 4: // response_type.document_delete
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DocumentDelete)
		err := b.DecodeMessage(msg)
		m.ResponseType = &ListenResponse_DocumentDelete{msg}
		return true, err
	case 6: // response_type.document_remove
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DocumentRemove)
		err := b.DecodeMessage(msg)
		m.ResponseType = &ListenResponse_DocumentRemove{msg}
		return true, err
	case 5: // response_type.filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ExistenceFilter)
		err := b.DecodeMessage(msg)
		m.ResponseType = &ListenResponse_Filter{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ListenResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ListenResponse)
	// response_type
	switch x := m.ResponseType.(type) {
	case *ListenResponse_TargetChange:
		s := proto.Size(x.TargetChange)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListenResponse_DocumentChange:
		s := proto.Size(x.DocumentChange)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListenResponse_DocumentDelete:
		s := proto.Size(x.DocumentDelete)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListenResponse_DocumentRemove:
		s := proto.Size(x.DocumentRemove)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListenResponse_Filter:
		s := proto.Size(x.Filter)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A specification of a set of documents to listen to.
type Target struct {
	// The type of target to listen to.
	//
	// Types that are valid to be assigned to TargetType:
	//	*Target_Query
	//	*Target_Documents
	TargetType isTarget_TargetType `protobuf_oneof:"target_type"`
	// When to start listening.
	//
	// If not specified, all matching Documents are returned before any
	// subsequent changes.
	//
	// Types that are valid to be assigned to ResumeType:
	//	*Target_ResumeToken
	//	*Target_ReadTime
	ResumeType isTarget_ResumeType `protobuf_oneof:"resume_type"`
	// A client provided target ID.
	//
	// If not set, the server will assign an ID for the target.
	//
	// Used for resuming a target without changing IDs. The IDs can either be
	// client-assigned or be server-assigned in a previous stream. All targets
	// with client provided IDs must be added before adding a target that needs
	// a server-assigned id.
	TargetId int32 `protobuf:"varint,5,opt,name=target_id,json=targetId" json:"target_id,omitempty"`
	// If the target should be removed once it is current and consistent.
	Once bool `protobuf:"varint,6,opt,name=once" json:"once,omitempty"`
}

func (m *Target) Reset()                    { *m = Target{} }
func (m *Target) String() string            { return proto.CompactTextString(m) }
func (*Target) ProtoMessage()               {}
func (*Target) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{19} }

type isTarget_TargetType interface {
	isTarget_TargetType()
}
type isTarget_ResumeType interface {
	isTarget_ResumeType()
}

type Target_Query struct {
	Query *Target_QueryTarget `protobuf:"bytes,2,opt,name=query,oneof"`
}
type Target_Documents struct {
	Documents *Target_DocumentsTarget `protobuf:"bytes,3,opt,name=documents,oneof"`
}
type Target_ResumeToken struct {
	ResumeToken []byte `protobuf:"bytes,4,opt,name=resume_token,json=resumeToken,proto3,oneof"`
}
type Target_ReadTime struct {
	ReadTime *google_protobuf1.Timestamp `protobuf:"bytes,11,opt,name=read_time,json=readTime,oneof"`
}

func (*Target_Query) isTarget_TargetType()       {}
func (*Target_Documents) isTarget_TargetType()   {}
func (*Target_ResumeToken) isTarget_ResumeType() {}
func (*Target_ReadTime) isTarget_ResumeType()    {}

func (m *Target) GetTargetType() isTarget_TargetType {
	if m != nil {
		return m.TargetType
	}
	return nil
}
func (m *Target) GetResumeType() isTarget_ResumeType {
	if m != nil {
		return m.ResumeType
	}
	return nil
}

func (m *Target) GetQuery() *Target_QueryTarget {
	if x, ok := m.GetTargetType().(*Target_Query); ok {
		return x.Query
	}
	return nil
}

func (m *Target) GetDocuments() *Target_DocumentsTarget {
	if x, ok := m.GetTargetType().(*Target_Documents); ok {
		return x.Documents
	}
	return nil
}

func (m *Target) GetResumeToken() []byte {
	if x, ok := m.GetResumeType().(*Target_ResumeToken); ok {
		return x.ResumeToken
	}
	return nil
}

func (m *Target) GetReadTime() *google_protobuf1.Timestamp {
	if x, ok := m.GetResumeType().(*Target_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

func (m *Target) GetTargetId() int32 {
	if m != nil {
		return m.TargetId
	}
	return 0
}

func (m *Target) GetOnce() bool {
	if m != nil {
		return m.Once
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Target) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Target_OneofMarshaler, _Target_OneofUnmarshaler, _Target_OneofSizer, []interface{}{
		(*Target_Query)(nil),
		(*Target_Documents)(nil),
		(*Target_ResumeToken)(nil),
		(*Target_ReadTime)(nil),
	}
}

func _Target_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Target)
	// target_type
	switch x := m.TargetType.(type) {
	case *Target_Query:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Query); err != nil {
			return err
		}
	case *Target_Documents:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Documents); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Target.TargetType has unexpected type %T", x)
	}
	// resume_type
	switch x := m.ResumeType.(type) {
	case *Target_ResumeToken:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.ResumeToken)
	case *Target_ReadTime:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReadTime); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Target.ResumeType has unexpected type %T", x)
	}
	return nil
}

func _Target_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Target)
	switch tag {
	case 2: // target_type.query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Target_QueryTarget)
		err := b.DecodeMessage(msg)
		m.TargetType = &Target_Query{msg}
		return true, err
	case 3: // target_type.documents
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Target_DocumentsTarget)
		err := b.DecodeMessage(msg)
		m.TargetType = &Target_Documents{msg}
		return true, err
	case 4: // resume_type.resume_token
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.ResumeType = &Target_ResumeToken{x}
		return true, err
	case 11: // resume_type.read_time
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf1.Timestamp)
		err := b.DecodeMessage(msg)
		m.ResumeType = &Target_ReadTime{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Target_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Target)
	// target_type
	switch x := m.TargetType.(type) {
	case *Target_Query:
		s := proto.Size(x.Query)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Target_Documents:
		s := proto.Size(x.Documents)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// resume_type
	switch x := m.ResumeType.(type) {
	case *Target_ResumeToken:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ResumeToken)))
		n += len(x.ResumeToken)
	case *Target_ReadTime:
		s := proto.Size(x.ReadTime)
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A target specified by a set of documents names.
type Target_DocumentsTarget struct {
	// The names of the documents to retrieve. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// The request will fail if any of the document is not a child resource of
	// the given `database`. Duplicate names will be elided.
	Documents []string `protobuf:"bytes,2,rep,name=documents" json:"documents,omitempty"`
}

func (m *Target_DocumentsTarget) Reset()                    { *m = Target_DocumentsTarget{} }
func (m *Target_DocumentsTarget) String() string            { return proto.CompactTextString(m) }
func (*Target_DocumentsTarget) ProtoMessage()               {}
func (*Target_DocumentsTarget) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{19, 0} }

func (m *Target_DocumentsTarget) GetDocuments() []string {
	if m != nil {
		return m.Documents
	}
	return nil
}

// A target specified by a query.
type Target_QueryTarget struct {
	// The parent resource name. In the format:
	// `projects/{project_id}/databases/{database_id}/documents` or
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// For example:
	// `projects/my-project/databases/my-database/documents` or
	// `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The query to run.
	//
	// Types that are valid to be assigned to QueryType:
	//	*Target_QueryTarget_StructuredQuery
	QueryType isTarget_QueryTarget_QueryType `protobuf_oneof:"query_type"`
}

func (m *Target_QueryTarget) Reset()                    { *m = Target_QueryTarget{} }
func (m *Target_QueryTarget) String() string            { return proto.CompactTextString(m) }
func (*Target_QueryTarget) ProtoMessage()               {}
func (*Target_QueryTarget) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{19, 1} }

type isTarget_QueryTarget_QueryType interface {
	isTarget_QueryTarget_QueryType()
}

type Target_QueryTarget_StructuredQuery struct {
	StructuredQuery *StructuredQuery `protobuf:"bytes,2,opt,name=structured_query,json=structuredQuery,oneof"`
}

func (*Target_QueryTarget_StructuredQuery) isTarget_QueryTarget_QueryType() {}

func (m *Target_QueryTarget) GetQueryType() isTarget_QueryTarget_QueryType {
	if m != nil {
		return m.QueryType
	}
	return nil
}

func (m *Target_QueryTarget) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *Target_QueryTarget) GetStructuredQuery() *StructuredQuery {
	if x, ok := m.GetQueryType().(*Target_QueryTarget_StructuredQuery); ok {
		return x.StructuredQuery
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Target_QueryTarget) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Target_QueryTarget_OneofMarshaler, _Target_QueryTarget_OneofUnmarshaler, _Target_QueryTarget_OneofSizer, []interface{}{
		(*Target_QueryTarget_StructuredQuery)(nil),
	}
}

func _Target_QueryTarget_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Target_QueryTarget)
	// query_type
	switch x := m.QueryType.(type) {
	case *Target_QueryTarget_StructuredQuery:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StructuredQuery); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Target_QueryTarget.QueryType has unexpected type %T", x)
	}
	return nil
}

func _Target_QueryTarget_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Target_QueryTarget)
	switch tag {
	case 2: // query_type.structured_query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StructuredQuery)
		err := b.DecodeMessage(msg)
		m.QueryType = &Target_QueryTarget_StructuredQuery{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Target_QueryTarget_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Target_QueryTarget)
	// query_type
	switch x := m.QueryType.(type) {
	case *Target_QueryTarget_StructuredQuery:
		s := proto.Size(x.StructuredQuery)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Targets being watched have changed.
type TargetChange struct {
	// The type of change that occurred.
	TargetChangeType TargetChange_TargetChangeType `protobuf:"varint,1,opt,name=target_change_type,json=targetChangeType,enum=google.firestore.v1beta1.TargetChange_TargetChangeType" json:"target_change_type,omitempty"`
	// The target IDs of targets that have changed.
	//
	// If empty, the change applies to all targets.
	//
	// For `target_change_type=ADD`, the order of the target IDs matches the order
	// of the requests to add the targets. This allows clients to unambiguously
	// associate server-assigned target IDs with added targets.
	//
	// For other states, the order of the target IDs is not defined.
	TargetIds []int32 `protobuf:"varint,2,rep,packed,name=target_ids,json=targetIds" json:"target_ids,omitempty"`
	// The error that resulted in this change, if applicable.
	Cause *google_rpc.Status `protobuf:"bytes,3,opt,name=cause" json:"cause,omitempty"`
	// A token that can be used to resume the stream for the given `target_ids`,
	// or all targets if `target_ids` is empty.
	//
	// Not set on every target change.
	ResumeToken []byte `protobuf:"bytes,4,opt,name=resume_token,json=resumeToken,proto3" json:"resume_token,omitempty"`
	// The consistent `read_time` for the given `target_ids` (omitted when the
	// target_ids are not at a consistent snapshot).
	//
	// The stream is guaranteed to send a `read_time` with `target_ids` empty
	// whenever the entire stream reaches a new consistent snapshot. ADD,
	// CURRENT, and RESET messages are guaranteed to (eventually) result in a
	// new consistent snapshot (while NO_CHANGE and REMOVE messages are not).
	//
	// For a given stream, `read_time` is guaranteed to be monotonically
	// increasing.
	ReadTime *google_protobuf1.Timestamp `protobuf:"bytes,6,opt,name=read_time,json=readTime" json:"read_time,omitempty"`
}

func (m *TargetChange) Reset()                    { *m = TargetChange{} }
func (m *TargetChange) String() string            { return proto.CompactTextString(m) }
func (*TargetChange) ProtoMessage()               {}
func (*TargetChange) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{20} }

func (m *TargetChange) GetTargetChangeType() TargetChange_TargetChangeType {
	if m != nil {
		return m.TargetChangeType
	}
	return TargetChange_NO_CHANGE
}

func (m *TargetChange) GetTargetIds() []int32 {
	if m != nil {
		return m.TargetIds
	}
	return nil
}

func (m *TargetChange) GetCause() *google_rpc.Status {
	if m != nil {
		return m.Cause
	}
	return nil
}

func (m *TargetChange) GetResumeToken() []byte {
	if m != nil {
		return m.ResumeToken
	}
	return nil
}

func (m *TargetChange) GetReadTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

// The request for [Firestore.ListCollectionIds][google.firestore.v1beta1.Firestore.ListCollectionIds].
type ListCollectionIdsRequest struct {
	// The parent document. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// For example:
	// `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The maximum number of results to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// A page token. Must be a value from
	// [ListCollectionIdsResponse][google.firestore.v1beta1.ListCollectionIdsResponse].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListCollectionIdsRequest) Reset()                    { *m = ListCollectionIdsRequest{} }
func (m *ListCollectionIdsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListCollectionIdsRequest) ProtoMessage()               {}
func (*ListCollectionIdsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{21} }

func (m *ListCollectionIdsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListCollectionIdsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListCollectionIdsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response from [Firestore.ListCollectionIds][google.firestore.v1beta1.Firestore.ListCollectionIds].
type ListCollectionIdsResponse struct {
	// The collection ids.
	CollectionIds []string `protobuf:"bytes,1,rep,name=collection_ids,json=collectionIds" json:"collection_ids,omitempty"`
	// A page token that may be used to continue the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListCollectionIdsResponse) Reset()                    { *m = ListCollectionIdsResponse{} }
func (m *ListCollectionIdsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListCollectionIdsResponse) ProtoMessage()               {}
func (*ListCollectionIdsResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{22} }

func (m *ListCollectionIdsResponse) GetCollectionIds() []string {
	if m != nil {
		return m.CollectionIds
	}
	return nil
}

func (m *ListCollectionIdsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetDocumentRequest)(nil), "google.firestore.v1beta1.GetDocumentRequest")
	proto.RegisterType((*ListDocumentsRequest)(nil), "google.firestore.v1beta1.ListDocumentsRequest")
	proto.RegisterType((*ListDocumentsResponse)(nil), "google.firestore.v1beta1.ListDocumentsResponse")
	proto.RegisterType((*CreateDocumentRequest)(nil), "google.firestore.v1beta1.CreateDocumentRequest")
	proto.RegisterType((*UpdateDocumentRequest)(nil), "google.firestore.v1beta1.UpdateDocumentRequest")
	proto.RegisterType((*DeleteDocumentRequest)(nil), "google.firestore.v1beta1.DeleteDocumentRequest")
	proto.RegisterType((*BatchGetDocumentsRequest)(nil), "google.firestore.v1beta1.BatchGetDocumentsRequest")
	proto.RegisterType((*BatchGetDocumentsResponse)(nil), "google.firestore.v1beta1.BatchGetDocumentsResponse")
	proto.RegisterType((*BeginTransactionRequest)(nil), "google.firestore.v1beta1.BeginTransactionRequest")
	proto.RegisterType((*BeginTransactionResponse)(nil), "google.firestore.v1beta1.BeginTransactionResponse")
	proto.RegisterType((*CommitRequest)(nil), "google.firestore.v1beta1.CommitRequest")
	proto.RegisterType((*CommitResponse)(nil), "google.firestore.v1beta1.CommitResponse")
	proto.RegisterType((*RollbackRequest)(nil), "google.firestore.v1beta1.RollbackRequest")
	proto.RegisterType((*RunQueryRequest)(nil), "google.firestore.v1beta1.RunQueryRequest")
	proto.RegisterType((*RunQueryResponse)(nil), "google.firestore.v1beta1.RunQueryResponse")
	proto.RegisterType((*WriteRequest)(nil), "google.firestore.v1beta1.WriteRequest")
	proto.RegisterType((*WriteResponse)(nil), "google.firestore.v1beta1.WriteResponse")
	proto.RegisterType((*ListenRequest)(nil), "google.firestore.v1beta1.ListenRequest")
	proto.RegisterType((*ListenResponse)(nil), "google.firestore.v1beta1.ListenResponse")
	proto.RegisterType((*Target)(nil), "google.firestore.v1beta1.Target")
	proto.RegisterType((*Target_DocumentsTarget)(nil), "google.firestore.v1beta1.Target.DocumentsTarget")
	proto.RegisterType((*Target_QueryTarget)(nil), "google.firestore.v1beta1.Target.QueryTarget")
	proto.RegisterType((*TargetChange)(nil), "google.firestore.v1beta1.TargetChange")
	proto.RegisterType((*ListCollectionIdsRequest)(nil), "google.firestore.v1beta1.ListCollectionIdsRequest")
	proto.RegisterType((*ListCollectionIdsResponse)(nil), "google.firestore.v1beta1.ListCollectionIdsResponse")
	proto.RegisterEnum("google.firestore.v1beta1.TargetChange_TargetChangeType", TargetChange_TargetChangeType_name, TargetChange_TargetChangeType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Firestore service

type FirestoreClient interface {
	// Gets a single document.
	GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Lists documents.
	ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error)
	// Creates a new document.
	CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Updates or inserts a document.
	UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Deletes a document.
	DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error)
	// Gets multiple documents.
	//
	// Documents returned by this method are not guaranteed to be returned in the
	// same order that they were requested.
	BatchGetDocuments(ctx context.Context, in *BatchGetDocumentsRequest, opts ...grpc.CallOption) (Firestore_BatchGetDocumentsClient, error)
	// Starts a new transaction.
	BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error)
	// Commits a transaction, while optionally updating documents.
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error)
	// Runs a query.
	RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (Firestore_RunQueryClient, error)
	// Streams batches of document updates and deletes, in order.
	Write(ctx context.Context, opts ...grpc.CallOption) (Firestore_WriteClient, error)
	// Listens to changes.
	Listen(ctx context.Context, opts ...grpc.CallOption) (Firestore_ListenClient, error)
	// Lists all the collection IDs underneath a document.
	ListCollectionIds(ctx context.Context, in *ListCollectionIdsRequest, opts ...grpc.CallOption) (*ListCollectionIdsResponse, error)
}

type firestoreClient struct {
	cc *grpc.ClientConn
}

func NewFirestoreClient(cc *grpc.ClientConn) FirestoreClient {
	return &firestoreClient{cc}
}

func (c *firestoreClient) GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := grpc.Invoke(ctx, "/google.firestore.v1beta1.Firestore/GetDocument", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error) {
	out := new(ListDocumentsResponse)
	err := grpc.Invoke(ctx, "/google.firestore.v1beta1.Firestore/ListDocuments", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := grpc.Invoke(ctx, "/google.firestore.v1beta1.Firestore/CreateDocument", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := grpc.Invoke(ctx, "/google.firestore.v1beta1.Firestore/UpdateDocument", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error) {
	out := new(google_protobuf4.Empty)
	err := grpc.Invoke(ctx, "/google.firestore.v1beta1.Firestore/DeleteDocument", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) BatchGetDocuments(ctx context.Context, in *BatchGetDocumentsRequest, opts ...grpc.CallOption) (Firestore_BatchGetDocumentsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Firestore_serviceDesc.Streams[0], c.cc, "/google.firestore.v1beta1.Firestore/BatchGetDocuments", opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreBatchGetDocumentsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Firestore_BatchGetDocumentsClient interface {
	Recv() (*BatchGetDocumentsResponse, error)
	grpc.ClientStream
}

type firestoreBatchGetDocumentsClient struct {
	grpc.ClientStream
}

func (x *firestoreBatchGetDocumentsClient) Recv() (*BatchGetDocumentsResponse, error) {
	m := new(BatchGetDocumentsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error) {
	out := new(BeginTransactionResponse)
	err := grpc.Invoke(ctx, "/google.firestore.v1beta1.Firestore/BeginTransaction", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	out := new(CommitResponse)
	err := grpc.Invoke(ctx, "/google.firestore.v1beta1.Firestore/Commit", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error) {
	out := new(google_protobuf4.Empty)
	err := grpc.Invoke(ctx, "/google.firestore.v1beta1.Firestore/Rollback", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreClient) RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (Firestore_RunQueryClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Firestore_serviceDesc.Streams[1], c.cc, "/google.firestore.v1beta1.Firestore/RunQuery", opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreRunQueryClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Firestore_RunQueryClient interface {
	Recv() (*RunQueryResponse, error)
	grpc.ClientStream
}

type firestoreRunQueryClient struct {
	grpc.ClientStream
}

func (x *firestoreRunQueryClient) Recv() (*RunQueryResponse, error) {
	m := new(RunQueryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) Write(ctx context.Context, opts ...grpc.CallOption) (Firestore_WriteClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Firestore_serviceDesc.Streams[2], c.cc, "/google.firestore.v1beta1.Firestore/Write", opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreWriteClient{stream}
	return x, nil
}

type Firestore_WriteClient interface {
	Send(*WriteRequest) error
	Recv() (*WriteResponse, error)
	grpc.ClientStream
}

type firestoreWriteClient struct {
	grpc.ClientStream
}

func (x *firestoreWriteClient) Send(m *WriteRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *firestoreWriteClient) Recv() (*WriteResponse, error) {
	m := new(WriteResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) Listen(ctx context.Context, opts ...grpc.CallOption) (Firestore_ListenClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Firestore_serviceDesc.Streams[3], c.cc, "/google.firestore.v1beta1.Firestore/Listen", opts...)
	if err != nil {
		return nil, err
	}
	x := &firestoreListenClient{stream}
	return x, nil
}

type Firestore_ListenClient interface {
	Send(*ListenRequest) error
	Recv() (*ListenResponse, error)
	grpc.ClientStream
}

type firestoreListenClient struct {
	grpc.ClientStream
}

func (x *firestoreListenClient) Send(m *ListenRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *firestoreListenClient) Recv() (*ListenResponse, error) {
	m := new(ListenResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *firestoreClient) ListCollectionIds(ctx context.Context, in *ListCollectionIdsRequest, opts ...grpc.CallOption) (*ListCollectionIdsResponse, error) {
	out := new(ListCollectionIdsResponse)
	err := grpc.Invoke(ctx, "/google.firestore.v1beta1.Firestore/ListCollectionIds", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Firestore service

type FirestoreServer interface {
	// Gets a single document.
	GetDocument(context.Context, *GetDocumentRequest) (*Document, error)
	// Lists documents.
	ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error)
	// Creates a new document.
	CreateDocument(context.Context, *CreateDocumentRequest) (*Document, error)
	// Updates or inserts a document.
	UpdateDocument(context.Context, *UpdateDocumentRequest) (*Document, error)
	// Deletes a document.
	DeleteDocument(context.Context, *DeleteDocumentRequest) (*google_protobuf4.Empty, error)
	// Gets multiple documents.
	//
	// Documents returned by this method are not guaranteed to be returned in the
	// same order that they were requested.
	BatchGetDocuments(*BatchGetDocumentsRequest, Firestore_BatchGetDocumentsServer) error
	// Starts a new transaction.
	BeginTransaction(context.Context, *BeginTransactionRequest) (*BeginTransactionResponse, error)
	// Commits a transaction, while optionally updating documents.
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(context.Context, *RollbackRequest) (*google_protobuf4.Empty, error)
	// Runs a query.
	RunQuery(*RunQueryRequest, Firestore_RunQueryServer) error
	// Streams batches of document updates and deletes, in order.
	Write(Firestore_WriteServer) error
	// Listens to changes.
	Listen(Firestore_ListenServer) error
	// Lists all the collection IDs underneath a document.
	ListCollectionIds(context.Context, *ListCollectionIdsRequest) (*ListCollectionIdsResponse, error)
}

func RegisterFirestoreServer(s *grpc.Server, srv FirestoreServer) {
	s.RegisterService(&_Firestore_serviceDesc, srv)
}

func _Firestore_GetDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).GetDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1beta1.Firestore/GetDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).GetDocument(ctx, req.(*GetDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_ListDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).ListDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1beta1.Firestore/ListDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).ListDocuments(ctx, req.(*ListDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_CreateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).CreateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1beta1.Firestore/CreateDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).CreateDocument(ctx, req.(*CreateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_UpdateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).UpdateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1beta1.Firestore/UpdateDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).UpdateDocument(ctx, req.(*UpdateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_DeleteDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).DeleteDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1beta1.Firestore/DeleteDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).DeleteDocument(ctx, req.(*DeleteDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_BatchGetDocuments_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BatchGetDocumentsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(FirestoreServer).BatchGetDocuments(m, &firestoreBatchGetDocumentsServer{stream})
}

type Firestore_BatchGetDocumentsServer interface {
	Send(*BatchGetDocumentsResponse) error
	grpc.ServerStream
}

type firestoreBatchGetDocumentsServer struct {
	grpc.ServerStream
}

func (x *firestoreBatchGetDocumentsServer) Send(m *BatchGetDocumentsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Firestore_BeginTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BeginTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).BeginTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1beta1.Firestore/BeginTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).BeginTransaction(ctx, req.(*BeginTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1beta1.Firestore/Commit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_Rollback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).Rollback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1beta1.Firestore/Rollback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).Rollback(ctx, req.(*RollbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firestore_RunQuery_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RunQueryRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(FirestoreServer).RunQuery(m, &firestoreRunQueryServer{stream})
}

type Firestore_RunQueryServer interface {
	Send(*RunQueryResponse) error
	grpc.ServerStream
}

type firestoreRunQueryServer struct {
	grpc.ServerStream
}

func (x *firestoreRunQueryServer) Send(m *RunQueryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Firestore_Write_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(FirestoreServer).Write(&firestoreWriteServer{stream})
}

type Firestore_WriteServer interface {
	Send(*WriteResponse) error
	Recv() (*WriteRequest, error)
	grpc.ServerStream
}

type firestoreWriteServer struct {
	grpc.ServerStream
}

func (x *firestoreWriteServer) Send(m *WriteResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *firestoreWriteServer) Recv() (*WriteRequest, error) {
	m := new(WriteRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Firestore_Listen_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(FirestoreServer).Listen(&firestoreListenServer{stream})
}

type Firestore_ListenServer interface {
	Send(*ListenResponse) error
	Recv() (*ListenRequest, error)
	grpc.ServerStream
}

type firestoreListenServer struct {
	grpc.ServerStream
}

func (x *firestoreListenServer) Send(m *ListenResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *firestoreListenServer) Recv() (*ListenRequest, error) {
	m := new(ListenRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Firestore_ListCollectionIds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCollectionIdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreServer).ListCollectionIds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.v1beta1.Firestore/ListCollectionIds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreServer).ListCollectionIds(ctx, req.(*ListCollectionIdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Firestore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.firestore.v1beta1.Firestore",
	HandlerType: (*FirestoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetDocument",
			Handler:    _Firestore_GetDocument_Handler,
		},
		{
			MethodName: "ListDocuments",
			Handler:    _Firestore_ListDocuments_Handler,
		},
		{
			MethodName: "CreateDocument",
			Handler:    _Firestore_CreateDocument_Handler,
		},
		{
			MethodName: "UpdateDocument",
			Handler:    _Firestore_UpdateDocument_Handler,
		},
		{
			MethodName: "DeleteDocument",
			Handler:    _Firestore_DeleteDocument_Handler,
		},
		{
			MethodName: "BeginTransaction",
			Handler:    _Firestore_BeginTransaction_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _Firestore_Commit_Handler,
		},
		{
			MethodName: "Rollback",
			Handler:    _Firestore_Rollback_Handler,
		},
		{
			MethodName: "ListCollectionIds",
			Handler:    _Firestore_ListCollectionIds_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "BatchGetDocuments",
			Handler:       _Firestore_BatchGetDocuments_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RunQuery",
			Handler:       _Firestore_RunQuery_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Write",
			Handler:       _Firestore_Write_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "Listen",
			Handler:       _Firestore_Listen_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/firestore/v1beta1/firestore.proto",
}

func init() { proto.RegisterFile("google/firestore/v1beta1/firestore.proto", fileDescriptor2) }

var fileDescriptor2 = []byte{
	// 2166 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0xcd, 0x8f, 0x1b, 0x49,
	0x15, 0x77, 0xf9, 0x6b, 0xec, 0xe7, 0x8f, 0xf1, 0x96, 0x92, 0xac, 0xe3, 0x64, 0xc9, 0xd0, 0x4b,
	0x12, 0x63, 0xad, 0xec, 0x64, 0x22, 0x14, 0xd6, 0x21, 0xcb, 0x66, 0x66, 0x3c, 0xe3, 0x09, 0x49,
	0x66, 0xd2, 0x33, 0x9b, 0x48, 0x5c, 0xac, 0x9e, 0xee, 0x8a, 0xd3, 0x3b, 0x76, 0xb7, 0xb7, 0xbb,
	0x9c, 0xd9, 0xd9, 0xd5, 0x20, 0xe0, 0xc0, 0x05, 0x89, 0x0b, 0x07, 0x40, 0x48, 0x1c, 0xd8, 0x03,
	0xd2, 0x22, 0xe0, 0x82, 0xc4, 0x0d, 0x89, 0x1b, 0x12, 0xe2, 0x84, 0x84, 0x90, 0x38, 0xc0, 0x81,
	0x13, 0x37, 0xfe, 0x03, 0xd4, 0x55, 0xd5, 0xed, 0xee, 0xf6, 0x57, 0xdb, 0x13, 0xed, 0xad, 0xeb,
	0xf9, 0xd5, 0xab, 0xf7, 0xf1, 0x7b, 0xaf, 0x5e, 0x3d, 0x43, 0xb5, 0x6b, 0x9a, 0xdd, 0x1e, 0x69,
	0xbc, 0xd0, 0x2d, 0x62, 0x53, 0xd3, 0x22, 0x8d, 0x57, 0xb7, 0x8f, 0x08, 0x55, 0x6e, 0x8f, 0x28,
	0xf5, 0x81, 0x65, 0x52, 0x13, 0x97, 0x39, 0x67, 0x7d, 0x44, 0x17, 0x9c, 0x95, 0xab, 0x42, 0x86,
	0x32, 0xd0, 0x1b, 0x8a, 0x61, 0x98, 0x54, 0xa1, 0xba, 0x69, 0xd8, 0x7c, 0x5f, 0xe5, 0xfa, 0xd4,
	0x13, 0x54, 0xb3, 0xdf, 0x37, 0x0d, 0xc1, 0x76, 0x73, 0x2a, 0x9b, 0x66, 0xaa, 0xc3, 0x3e, 0x31,
	0xa8, 0x60, 0xfc, 0xca, 0x54, 0xc6, 0x8f, 0x86, 0xc4, 0x3a, 0x9d, 0xcb, 0x75, 0x62, 0xe9, 0x54,
	0xd8, 0x54, 0xb9, 0x22, 0xb8, 0xd8, 0xea, 0x68, 0xf8, 0xa2, 0x41, 0xfa, 0x03, 0xea, 0x8a, 0xb8,
	0x16, 0xfe, 0x91, 0xea, 0x7d, 0x62, 0x53, 0xa5, 0x3f, 0x10, 0x0c, 0x6f, 0x0a, 0x06, 0x6b, 0xa0,
	0x36, 0x6c, 0xaa, 0xd0, 0xa1, 0x30, 0x59, 0xfa, 0x27, 0x02, 0xbc, 0x43, 0xe8, 0x96, 0x50, 0x5c,
	0x26, 0x1f, 0x0d, 0x89, 0x4d, 0x31, 0x86, 0xa4, 0xa1, 0xf4, 0x49, 0x19, 0xad, 0xa1, 0x6a, 0x56,
	0x66, 0xdf, 0xb8, 0x09, 0xc9, 0xbe, 0x62, 0x1f, 0x97, 0xe3, 0x6b, 0xa8, 0x9a, 0x5b, 0xbf, 0x51,
	0x9f, 0xe6, 0xe4, 0xba, 0x2b, 0xec, 0xb1, 0x62, 0x1f, 0xcb, 0x6c, 0x0f, 0x96, 0x20, 0x47, 0x2d,
	0xc5, 0xb0, 0x15, 0xd5, 0xf1, 0x77, 0x39, 0xb1, 0x86, 0xaa, 0xf9, 0x76, 0x4c, 0xf6, 0x13, 0xf1,
	0xbb, 0x90, 0xb5, 0x88, 0xa2, 0x75, 0x1c, 0xdd, 0xcb, 0x29, 0x76, 0x48, 0xc5, 0x3d, 0xc4, 0x35,
	0xac, 0x7e, 0xe8, 0x1a, 0xd6, 0x8e, 0xc9, 0x19, 0x87, 0xdd, 0x21, 0x6c, 0x5c, 0x82, 0x0b, 0xaa,
	0x69, 0xd8, 0xba, 0x4d, 0x89, 0xa1, 0x9e, 0x76, 0x6c, 0xd2, 0x23, 0x2a, 0x35, 0x2d, 0xe9, 0xbb,
	0x09, 0xb8, 0xf0, 0x48, 0xb7, 0x3d, 0xf3, 0x6c, 0xd7, 0xbe, 0x4b, 0x90, 0x1e, 0x28, 0x16, 0x31,
	0xa8, 0xb0, 0x50, 0xac, 0xf0, 0xdb, 0x50, 0x50, 0xcd, 0x9e, 0xb3, 0x5b, 0x37, 0x8d, 0x8e, 0xae,
	0x31, 0x63, 0xb3, 0x72, 0x7e, 0x44, 0xdc, 0xd5, 0xf0, 0x15, 0xc8, 0x0e, 0x94, 0x2e, 0xe9, 0xd8,
	0xfa, 0x27, 0x84, 0x99, 0x92, 0x92, 0x33, 0x0e, 0xe1, 0x40, 0xff, 0x84, 0xe0, 0xb7, 0x00, 0xd8,
	0x8f, 0xd4, 0x3c, 0x26, 0x46, 0x39, 0xc9, 0xb6, 0x33, 0xf6, 0x43, 0x87, 0x80, 0x2f, 0x43, 0xc6,
	0xb4, 0x34, 0x62, 0x75, 0x8e, 0x4e, 0xcb, 0x69, 0xf6, 0xe3, 0x0a, 0x5b, 0x6f, 0x9c, 0x7a, 0xfe,
	0x5d, 0x39, 0xbf, 0x7f, 0x33, 0x73, 0xfd, 0x0b, 0x8b, 0xf8, 0x17, 0x7f, 0x19, 0xf2, 0xf6, 0x4b,
	0xf3, 0xa4, 0xd3, 0xd7, 0x6d, 0x5b, 0x37, 0xba, 0xe5, 0xfc, 0x1a, 0xaa, 0x66, 0xe4, 0x9c, 0x43,
	0x7b, 0xcc, 0x49, 0x53, 0x43, 0xf0, 0x3d, 0x04, 0x17, 0x43, 0x21, 0xb0, 0x07, 0xa6, 0x61, 0x13,
	0xfc, 0x3e, 0x64, 0xdd, 0x7c, 0xb1, 0xcb, 0x68, 0x2d, 0x51, 0xcd, 0xad, 0x4b, 0xf3, 0x8d, 0x96,
	0x47, 0x9b, 0xf0, 0x0d, 0x58, 0x35, 0xc8, 0xc7, 0xb4, 0xe3, 0x73, 0x38, 0x8f, 0x57, 0xc1, 0x21,
	0xef, 0xbb, 0x4e, 0x97, 0xfe, 0x87, 0xe0, 0xe2, 0xa6, 0x45, 0x14, 0x4a, 0xc2, 0x38, 0x3f, 0x17,
	0x0e, 0xae, 0x41, 0xce, 0xd5, 0xc5, 0x61, 0x49, 0x30, 0x16, 0x70, 0x49, 0xbb, 0x1a, 0x7e, 0x0f,
	0x32, 0xee, 0x8a, 0x21, 0x21, 0x9a, 0x81, 0xde, 0x1e, 0x0f, 0x11, 0xa9, 0xc5, 0x11, 0x21, 0xfd,
	0x2e, 0x0e, 0x17, 0x3f, 0x18, 0x68, 0x13, 0x6c, 0xf6, 0x6b, 0x85, 0x96, 0xd0, 0x6a, 0x07, 0x72,
	0x43, 0x26, 0xb8, 0xb3, 0x44, 0x39, 0x00, 0xbe, 0xd5, 0xf9, 0xf6, 0xcc, 0x4b, 0x2c, 0x01, 0xf8,
	0xa7, 0x50, 0x52, 0x87, 0x96, 0x13, 0xab, 0x4e, 0xc8, 0xc5, 0x33, 0xe4, 0xec, 0x5b, 0x44, 0x35,
	0x0d, 0x4d, 0x77, 0xe2, 0x27, 0xaf, 0x8a, 0xfd, 0xae, 0x70, 0xe9, 0x3b, 0x70, 0x71, 0x8b, 0xf4,
	0xc8, 0xb8, 0xc3, 0x26, 0x15, 0xc3, 0x49, 0xe7, 0xc7, 0xcf, 0x77, 0xfe, 0xbf, 0xe3, 0x50, 0xde,
	0x50, 0xa8, 0xfa, 0xd2, 0x57, 0x8f, 0xbd, 0x82, 0x55, 0x81, 0x8c, 0xa6, 0x50, 0xe5, 0x48, 0xb1,
	0x5d, 0x3d, 0xbc, 0x35, 0xbe, 0xea, 0x4f, 0xa4, 0xf8, 0x5a, 0xc2, 0xa9, 0x38, 0xa3, 0x24, 0x39,
	0x8f, 0x97, 0x43, 0x65, 0x25, 0x39, 0xa9, 0xac, 0x3c, 0x77, 0x92, 0xf0, 0xa4, 0xe3, 0xe7, 0xe3,
	0x78, 0x7d, 0x67, 0xfa, 0x51, 0x87, 0x23, 0xe6, 0xbd, 0x01, 0xbb, 0x81, 0xdb, 0x31, 0xb9, 0x68,
	0x90, 0x93, 0xc3, 0x69, 0xf5, 0x6a, 0xe5, 0xb5, 0xdc, 0x07, 0xff, 0x40, 0x70, 0x79, 0x82, 0x8b,
	0x45, 0x41, 0x6a, 0x42, 0xea, 0x85, 0x39, 0x34, 0xb4, 0xe8, 0x59, 0xd1, 0x8e, 0xc9, 0x7c, 0x0b,
	0xae, 0xc0, 0x8a, 0x5b, 0x1c, 0x59, 0xa9, 0x68, 0xc7, 0x64, 0x97, 0x80, 0xd7, 0x26, 0x5c, 0x7e,
	0x41, 0x1f, 0xde, 0xf5, 0x9b, 0x9a, 0x9c, 0x67, 0xaa, 0xcf, 0xd0, 0x0c, 0xa4, 0x2d, 0x62, 0x0f,
	0x7b, 0x54, 0x3a, 0x83, 0x37, 0x37, 0x48, 0x57, 0x37, 0x7c, 0x1e, 0x8c, 0x82, 0x9d, 0x6d, 0x58,
	0x31, 0x79, 0x04, 0x04, 0x7c, 0x17, 0x8a, 0x9a, 0xec, 0x6e, 0x96, 0xbe, 0x01, 0xe5, 0xf1, 0xe3,
	0x85, 0x5f, 0x43, 0xf6, 0xa3, 0x31, 0xfb, 0xa5, 0x1f, 0x20, 0x28, 0x6c, 0x9a, 0xfd, 0xbe, 0x4e,
	0xa3, 0xe8, 0x7c, 0x17, 0xd2, 0xac, 0x33, 0xe2, 0x60, 0xcf, 0xad, 0x5f, 0x9b, 0xae, 0xf2, 0x73,
	0x87, 0x4f, 0x16, 0xec, 0xf3, 0x03, 0x21, 0xfd, 0x0c, 0x41, 0xd1, 0x55, 0x44, 0x68, 0xff, 0x10,
	0x0a, 0x6c, 0x7b, 0x87, 0x3b, 0xda, 0xbd, 0xaa, 0xae, 0xcf, 0x3b, 0x94, 0x71, 0xcb, 0xf9, 0x93,
	0xd1, 0xc2, 0xc6, 0xf7, 0x20, 0xa7, 0x32, 0xe9, 0x3c, 0xd2, 0xf1, 0xb9, 0x91, 0x06, 0xce, 0xee,
	0x10, 0xa4, 0x3d, 0x58, 0x95, 0xcd, 0x5e, 0xef, 0x48, 0x51, 0x8f, 0xa3, 0x78, 0x29, 0x64, 0x6c,
	0x7c, 0xdc, 0xd8, 0x7f, 0xc5, 0x61, 0x55, 0x1e, 0x1a, 0x4f, 0x9d, 0x5e, 0x74, 0xde, 0x85, 0xf8,
	0x0c, 0x4a, 0x36, 0xb5, 0x86, 0x2a, 0x1d, 0x5a, 0x44, 0xeb, 0xb0, 0xf6, 0x55, 0xa8, 0xff, 0xd5,
	0xe9, 0x8e, 0x38, 0xf0, 0x76, 0xb0, 0x33, 0xda, 0x31, 0x79, 0xd5, 0x0e, 0x92, 0xc2, 0x15, 0x26,
	0xc5, 0x2a, 0x0c, 0x9a, 0x5b, 0x61, 0xd2, 0x4b, 0x54, 0x18, 0x74, 0xde, 0x0a, 0x83, 0x7c, 0x89,
	0x97, 0x07, 0x60, 0x4e, 0xe8, 0xd0, 0xd3, 0xc1, 0xf4, 0x7a, 0xf3, 0x77, 0x04, 0xa5, 0x91, 0x87,
	0x27, 0xa7, 0xc3, 0x78, 0x60, 0xce, 0x7d, 0x43, 0x07, 0xca, 0x49, 0x22, 0x7a, 0x39, 0xc1, 0x37,
	0x61, 0xd5, 0x3e, 0xd6, 0x07, 0x03, 0xa2, 0x79, 0x68, 0x4f, 0xb2, 0xfe, 0xb6, 0x28, 0xc8, 0x02,
	0xc8, 0xd2, 0xe7, 0x71, 0xc8, 0x0b, 0x98, 0xcf, 0x47, 0xe2, 0x15, 0xc8, 0xda, 0xd4, 0x22, 0x4a,
	0x7f, 0xd4, 0x48, 0x65, 0x38, 0x61, 0x57, 0xf3, 0x25, 0x73, 0x62, 0xb1, 0x64, 0x76, 0x7a, 0x52,
	0x2e, 0x75, 0xd4, 0x6a, 0xe7, 0xe5, 0x1c, 0xa7, 0xf1, 0x66, 0xfb, 0x21, 0xa4, 0x7b, 0xca, 0x11,
	0xe9, 0xd9, 0xe5, 0x14, 0x93, 0xbd, 0x3e, 0x37, 0x67, 0x99, 0x31, 0xf5, 0x47, 0x6c, 0x53, 0xcb,
	0xa0, 0xd6, 0xa9, 0x2c, 0x24, 0x54, 0xde, 0x85, 0x9c, 0x8f, 0x8c, 0x4b, 0x90, 0x38, 0x26, 0xa7,
	0xc2, 0x54, 0xe7, 0x13, 0x5f, 0x80, 0xd4, 0x2b, 0xa5, 0x37, 0x24, 0xc2, 0x42, 0xbe, 0x68, 0xc6,
	0xbf, 0x8e, 0x9c, 0x5b, 0xa7, 0xe0, 0xd6, 0x04, 0x0e, 0x81, 0x80, 0x47, 0x50, 0xc8, 0x23, 0x61,
	0xc3, 0xe2, 0x93, 0x0c, 0x0b, 0xd5, 0xa4, 0xc4, 0x6b, 0xab, 0x49, 0xc9, 0x85, 0x6a, 0xd2, 0x6f,
	0xe3, 0x50, 0x78, 0xc4, 0x60, 0x1f, 0x05, 0x08, 0x0f, 0x00, 0x14, 0x4d, 0xeb, 0x50, 0xc5, 0xea,
	0x12, 0xb7, 0x5d, 0x5a, 0x9b, 0x91, 0xc3, 0x8c, 0xaf, 0x1d, 0x93, 0xb3, 0x8a, 0xa6, 0xf1, 0x05,
	0xbe, 0x0e, 0x05, 0x8b, 0xf4, 0xcd, 0x57, 0xc4, 0x95, 0xc2, 0xde, 0x5f, 0xed, 0x98, 0x9c, 0xe7,
	0x64, 0xc1, 0xf6, 0x2d, 0x2f, 0xf2, 0x49, 0xe6, 0x99, 0x3b, 0xd3, 0x4f, 0x09, 0xa8, 0xff, 0x9a,
	0x43, 0xbf, 0xb1, 0x0a, 0x05, 0xae, 0x67, 0x47, 0x7d, 0xa9, 0x18, 0x5d, 0x22, 0xfd, 0x3e, 0x01,
	0x45, 0xf7, 0x44, 0x01, 0x86, 0xc7, 0x21, 0x9e, 0xf9, 0x7d, 0x24, 0x37, 0x72, 0x93, 0x71, 0x3b,
	0xa6, 0x53, 0xdf, 0x1a, 0x1f, 0xc0, 0xaa, 0xf7, 0x2a, 0x11, 0x02, 0x79, 0x09, 0xa8, 0xce, 0xaf,
	0x21, 0x9e, 0xc8, 0xa2, 0x16, 0xa0, 0x04, 0x84, 0x6a, 0xac, 0x49, 0x16, 0x40, 0x89, 0x20, 0x94,
	0x37, 0xd5, 0x7e, 0xa1, 0x9c, 0x12, 0x10, 0xca, 0xa3, 0x27, 0xea, 0x7a, 0x04, 0xa1, 0x32, 0xe3,
	0xf7, 0x0b, 0xe5, 0x14, 0xbc, 0x09, 0xe9, 0x17, 0x7a, 0x8f, 0x12, 0x4b, 0x74, 0xa1, 0x33, 0xae,
	0xa7, 0xd6, 0xc7, 0xbc, 0x60, 0x93, 0x6d, 0xb6, 0xa1, 0x1d, 0x93, 0xc5, 0x56, 0x27, 0x6c, 0x96,
	0x08, 0x0f, 0x2b, 0xf0, 0xd2, 0x8f, 0x92, 0x90, 0x16, 0xd0, 0xda, 0x82, 0x94, 0xff, 0xfa, 0x7b,
	0x67, 0x5e, 0x98, 0xea, 0xac, 0xfa, 0x7b, 0x58, 0xe6, 0x9b, 0xf1, 0xbe, 0xbf, 0x67, 0xe7, 0xf1,
	0xb9, 0x35, 0x57, 0x92, 0xd7, 0xb2, 0x8e, 0x32, 0x63, 0xd4, 0xe7, 0xbf, 0x0d, 0x79, 0xa7, 0x1a,
	0xf4, 0xfd, 0xa3, 0x07, 0x76, 0x95, 0x72, 0x2a, 0x2f, 0x1c, 0x81, 0x1b, 0x2f, 0xb7, 0xc8, 0x8d,
	0xe7, 0xd4, 0x2c, 0x01, 0x53, 0x5d, 0x63, 0xbe, 0x4d, 0xc9, 0x19, 0x4e, 0xd8, 0xd5, 0x9c, 0x27,
	0x92, 0x69, 0xa8, 0x3c, 0x7e, 0x19, 0x99, 0x7d, 0x57, 0x1a, 0xb0, 0x1a, 0x52, 0x78, 0xf6, 0x4b,
	0xa5, 0xf2, 0x43, 0x04, 0x39, 0x9f, 0xb3, 0xbe, 0xe8, 0x5e, 0x24, 0x74, 0xa7, 0x17, 0x20, 0x27,
	0xec, 0x75, 0x97, 0xae, 0x7b, 0x1d, 0x40, 0xfc, 0x37, 0x0e, 0x79, 0x7f, 0x1a, 0x62, 0x02, 0x38,
	0x90, 0xc5, 0x8c, 0x8d, 0x29, 0x5e, 0x5c, 0xbf, 0x1b, 0x2d, 0x95, 0x03, 0x8b, 0xc3, 0xd3, 0x01,
	0x91, 0x4b, 0x34, 0x44, 0xc1, 0x6f, 0x01, 0x78, 0x51, 0xe0, 0x2e, 0x4c, 0xc9, 0x59, 0x37, 0x0c,
	0x36, 0xae, 0x42, 0x4a, 0x55, 0x86, 0xb6, 0x9b, 0xf2, 0xd8, 0x3d, 0xd8, 0x1a, 0xa8, 0xf5, 0x03,
	0x36, 0xf7, 0x93, 0x39, 0x83, 0x73, 0xcb, 0x8c, 0xc3, 0x25, 0x08, 0x96, 0x40, 0x1b, 0x91, 0x8e,
	0xde, 0x46, 0x48, 0x4f, 0xa0, 0x14, 0x36, 0x05, 0x17, 0x20, 0xfb, 0x64, 0xaf, 0xb3, 0xd9, 0x7e,
	0xf0, 0x64, 0xa7, 0x55, 0x8a, 0xe1, 0x15, 0x48, 0x3c, 0xd8, 0xda, 0x2a, 0x21, 0x0c, 0x90, 0x96,
	0x5b, 0x8f, 0xf7, 0x9e, 0xb5, 0x4a, 0x71, 0x9c, 0x83, 0x95, 0xcd, 0x0f, 0x64, 0xb9, 0xf5, 0xe4,
	0xb0, 0x94, 0xc0, 0x59, 0x48, 0xc9, 0xad, 0x83, 0xd6, 0x61, 0x29, 0x29, 0x19, 0x50, 0x76, 0x6a,
	0xe6, 0xa6, 0x6f, 0xf8, 0x32, 0x77, 0x92, 0x17, 0x18, 0xd2, 0xc5, 0x67, 0x0e, 0xe9, 0x12, 0xa1,
	0x21, 0x9d, 0xf4, 0x21, 0x5c, 0x9e, 0x70, 0x9e, 0x28, 0xd7, 0xd7, 0xa1, 0x18, 0x18, 0x0d, 0xf1,
	0x07, 0x41, 0x56, 0x2e, 0xf8, 0x67, 0x43, 0x91, 0x67, 0x53, 0xeb, 0xbf, 0xc1, 0x90, 0xdd, 0x76,
	0x61, 0x81, 0x7f, 0x81, 0x20, 0xe7, 0x7b, 0x9b, 0xe2, 0x19, 0xd5, 0x65, 0x7c, 0x6a, 0x5b, 0x89,
	0xd0, 0x25, 0x4a, 0xf7, 0xbf, 0xff, 0xb7, 0xff, 0xfc, 0x38, 0x7e, 0x17, 0x7f, 0xcd, 0x9b, 0x32,
	0x7f, 0x6a, 0x28, 0x7d, 0x72, 0x7f, 0x60, 0x99, 0x1f, 0x12, 0x95, 0xda, 0x8d, 0x5a, 0xc3, 0xbd,
	0xaf, 0xd9, 0xb7, 0x9b, 0x9d, 0x8d, 0x5a, 0xa3, 0x56, 0x3b, 0xc3, 0x7f, 0x42, 0xfc, 0xc2, 0xf7,
	0x32, 0x1b, 0xd7, 0x67, 0x5f, 0xad, 0xe1, 0x49, 0x46, 0xa5, 0x11, 0x99, 0x9f, 0x3b, 0x5c, 0xda,
	0x63, 0x1a, 0xef, 0xe2, 0x9d, 0x91, 0xc6, 0x3c, 0xc6, 0x11, 0x75, 0x6e, 0x7c, 0x1a, 0x88, 0xd7,
	0x19, 0xfe, 0xa3, 0xf3, 0xc8, 0x0b, 0x8c, 0x03, 0xf1, 0x0c, 0xa5, 0x26, 0x0e, 0x0e, 0x23, 0xb9,
	0xfa, 0x39, 0x53, 0xfc, 0xa9, 0xd4, 0x5a, 0x42, 0xf1, 0x71, 0xb5, 0x9b, 0xa3, 0xfe, 0xfe, 0x0f,
	0x08, 0x8a, 0xc1, 0xd9, 0xde, 0x2c, 0x03, 0x26, 0x4e, 0x01, 0x23, 0x19, 0xb0, 0xcf, 0x0c, 0x78,
	0xb8, 0xfe, 0xde, 0xc8, 0x00, 0xef, 0x1f, 0x8e, 0x05, 0x40, 0xe3, 0xd3, 0xfc, 0xa7, 0x08, 0x8a,
	0xc1, 0x21, 0xdb, 0x2c, 0xcd, 0x27, 0x8e, 0xe3, 0x2a, 0x97, 0xc6, 0x6a, 0x50, 0xab, 0x3f, 0xa0,
	0xa7, 0x2e, 0xb2, 0x6b, 0x4b, 0x22, 0xfb, 0xcf, 0x08, 0xde, 0x18, 0x9b, 0x0d, 0xe1, 0x19, 0x4f,
	0x86, 0x69, 0xb3, 0xba, 0xca, 0x9d, 0x85, 0xf6, 0x08, 0x94, 0xb7, 0x99, 0xf6, 0x1b, 0xd2, 0x7d,
	0x9f, 0xaf, 0x85, 0xb6, 0x53, 0x2c, 0x38, 0x1b, 0x99, 0xd0, 0x3c, 0x12, 0x72, 0x9b, 0xa8, 0x76,
	0x0b, 0xe1, 0xbf, 0x20, 0x28, 0x85, 0xa7, 0x31, 0xf8, 0xf6, 0x0c, 0xad, 0x26, 0x0f, 0x8e, 0x2a,
	0xeb, 0x8b, 0x6c, 0x11, 0x76, 0x08, 0xcc, 0xf8, 0x41, 0xbf, 0x88, 0x1d, 0x21, 0xb1, 0x4d, 0x54,
	0xc3, 0x9f, 0x21, 0x48, 0xf3, 0x99, 0x0c, 0xbe, 0x39, 0x23, 0x4d, 0xfd, 0xe3, 0xa3, 0x4a, 0x75,
	0x3e, 0xa3, 0xd0, 0x77, 0x9b, 0xe9, 0xfb, 0xbe, 0x74, 0x6f, 0x29, 0x7d, 0xf9, 0x53, 0xc8, 0xd1,
	0xf2, 0x27, 0x08, 0x32, 0xee, 0x78, 0x06, 0xcf, 0xe8, 0x43, 0x42, 0x23, 0x9c, 0xa9, 0x68, 0x3e,
	0x1f, 0x1e, 0x2c, 0x71, 0x8a, 0xa3, 0xd9, 0xaf, 0x1d, 0xcd, 0xc4, 0x10, 0x62, 0xa6, 0x66, 0xc1,
	0x51, 0x50, 0xa5, 0x16, 0x85, 0x75, 0xba, 0x17, 0x23, 0x96, 0xba, 0xb3, 0xa6, 0x25, 0x84, 0x71,
	0xec, 0x7e, 0x86, 0x20, 0xc5, 0x1e, 0xab, 0xf8, 0x46, 0xb4, 0xd7, 0x7a, 0xe5, 0xe6, 0xfc, 0x57,
	0x2f, 0x57, 0xb2, 0xc5, 0x94, 0xfc, 0xa6, 0xd4, 0x5c, 0xca, 0xa5, 0xec, 0xd1, 0xdc, 0x44, 0xb5,
	0x2a, 0xba, 0x85, 0xf0, 0xaf, 0x10, 0xa4, 0xf9, 0x33, 0x6e, 0x16, 0x26, 0x03, 0x4f, 0xcb, 0x59,
	0x98, 0x0c, 0xbe, 0x08, 0xcf, 0x89, 0xc9, 0x1e, 0x13, 0xe6, 0x6a, 0xfa, 0x57, 0x04, 0x6f, 0x8c,
	0x35, 0x33, 0xb3, 0xca, 0xda, 0xb4, 0x4e, 0xab, 0x72, 0x67, 0xa1, 0x3d, 0xc1, 0xcb, 0x5b, 0xda,
	0x5a, 0x02, 0x18, 0xbd, 0xb0, 0xd4, 0x26, 0xaa, 0x6d, 0xfc, 0x1c, 0xc1, 0x55, 0xd5, 0xec, 0x4f,
	0xd5, 0x65, 0xa3, 0xe8, 0x75, 0x53, 0xfb, 0x4e, 0x46, 0xed, 0xa3, 0x6f, 0x3f, 0x10, 0xbc, 0x5d,
	0xb3, 0xa7, 0x18, 0xdd, 0xba, 0x69, 0x75, 0x1b, 0x5d, 0x62, 0xb0, 0x7c, 0x6b, 0xf0, 0x9f, 0x94,
	0x81, 0x6e, 0x8f, 0xff, 0xff, 0x7e, 0xcf, 0xa3, 0xfc, 0x32, 0x9e, 0xdc, 0xd9, 0xdc, 0x3e, 0xf8,
	0x3c, 0xfe, 0xa5, 0x1d, 0x2e, 0x6a, 0xb3, 0x67, 0x0e, 0xb5, 0xba, 0x77, 0x52, 0xfd, 0xd9, 0xed,
	0x0d, 0x67, 0xc7, 0x51, 0x9a, 0x49, 0xbd, 0xf3, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x7f, 0x4b,
	0x4d, 0x2f, 0xac, 0x20, 0x00, 0x00,
}
