// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1/video_intelligence.proto

/*
Package videointelligence is a generated protocol buffer package.

It is generated from these files:
	google/cloud/videointelligence/v1/video_intelligence.proto

It has these top-level messages:
	AnnotateVideoRequest
	VideoContext
	LabelDetectionConfig
	ShotChangeDetectionConfig
	ExplicitContentDetectionConfig
	FaceDetectionConfig
	VideoSegment
	LabelSegment
	LabelFrame
	Entity
	LabelAnnotation
	ExplicitContentFrame
	ExplicitContentAnnotation
	NormalizedBoundingBox
	FaceSegment
	FaceFrame
	FaceAnnotation
	VideoAnnotationResults
	AnnotateVideoResponse
	VideoAnnotationProgress
	AnnotateVideoProgress
*/
package videointelligence

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf3 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf4 "github.com/golang/protobuf/ptypes/timestamp"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// Human face detection and tracking.
	Feature_FACE_DETECTION Feature = 4
)

var Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "LABEL_DETECTION",
	2: "SHOT_CHANGE_DETECTION",
	3: "EXPLICIT_CONTENT_DETECTION",
	4: "FACE_DETECTION",
}
var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":        0,
	"LABEL_DETECTION":            1,
	"SHOT_CHANGE_DETECTION":      2,
	"EXPLICIT_CONTENT_DETECTION": 3,
	"FACE_DETECTION":             4,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}
func (Feature) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}
var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}
func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}
var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}
func (Likelihood) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](/storage/docs/reference-uris).
	// A video URI may include wildcards in `object-id`, and thus identify
	// multiple videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,enum=google.cloud.videointelligence.v1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext" json:"video_context,omitempty"`
	// Optional location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](/storage/docs/reference-uris).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri" json:"output_uri,omitempty"`
	// Optional cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId" json:"location_id,omitempty"`
}

func (m *AnnotateVideoRequest) Reset()                    { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string            { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()               {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() []byte {
	if m != nil {
		return m.InputContent
	}
	return nil
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video
	// is treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig" json:"explicit_content_detection_config,omitempty"`
	// Config for FACE_DETECTION.
	FaceDetectionConfig *FaceDetectionConfig `protobuf:"bytes,5,opt,name=face_detection_config,json=faceDetectionConfig" json:"face_detection_config,omitempty"`
}

func (m *VideoContext) Reset()                    { *m = VideoContext{} }
func (m *VideoContext) String() string            { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()               {}
func (*VideoContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if m != nil {
		return m.LabelDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if m != nil {
		return m.ShotChangeDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if m != nil {
		return m.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetFaceDetectionConfig() *FaceDetectionConfig {
	if m != nil {
		return m.FaceDetectionConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,enum=google.cloud.videointelligence.v1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,3,opt,name=model" json:"model,omitempty"`
}

func (m *LabelDetectionConfig) Reset()                    { *m = LabelDetectionConfig{} }
func (m *LabelDetectionConfig) String() string            { return proto.CompactTextString(m) }
func (*LabelDetectionConfig) ProtoMessage()               {}
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *LabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *LabelDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model" json:"model,omitempty"`
}

func (m *ShotChangeDetectionConfig) Reset()                    { *m = ShotChangeDetectionConfig{} }
func (m *ShotChangeDetectionConfig) String() string            { return proto.CompactTextString(m) }
func (*ShotChangeDetectionConfig) ProtoMessage()               {}
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ShotChangeDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model" json:"model,omitempty"`
}

func (m *ExplicitContentDetectionConfig) Reset()                    { *m = ExplicitContentDetectionConfig{} }
func (m *ExplicitContentDetectionConfig) String() string            { return proto.CompactTextString(m) }
func (*ExplicitContentDetectionConfig) ProtoMessage()               {}
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ExplicitContentDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for FACE_DETECTION.
type FaceDetectionConfig struct {
	// Model to use for face detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model" json:"model,omitempty"`
	// Whether bounding boxes be included in the face annotation output.
	IncludeBoundingBoxes bool `protobuf:"varint,2,opt,name=include_bounding_boxes,json=includeBoundingBoxes" json:"include_bounding_boxes,omitempty"`
}

func (m *FaceDetectionConfig) Reset()                    { *m = FaceDetectionConfig{} }
func (m *FaceDetectionConfig) String() string            { return proto.CompactTextString(m) }
func (*FaceDetectionConfig) ProtoMessage()               {}
func (*FaceDetectionConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *FaceDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *FaceDetectionConfig) GetIncludeBoundingBoxes() bool {
	if m != nil {
		return m.IncludeBoundingBoxes
	}
	return false
}

// Video segment.
type VideoSegment struct {
	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *google_protobuf3.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset *google_protobuf3.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset" json:"end_time_offset,omitempty"`
}

func (m *VideoSegment) Reset()                    { *m = VideoSegment{} }
func (m *VideoSegment) String() string            { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()               {}
func (*VideoSegment) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *VideoSegment) GetStartTimeOffset() *google_protobuf3.Duration {
	if m != nil {
		return m.StartTimeOffset
	}
	return nil
}

func (m *VideoSegment) GetEndTimeOffset() *google_protobuf3.Duration {
	if m != nil {
		return m.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence" json:"confidence,omitempty"`
}

func (m *LabelSegment) Reset()                    { *m = LabelSegment{} }
func (m *LabelSegment) String() string            { return proto.CompactTextString(m) }
func (*LabelSegment) ProtoMessage()               {}
func (*LabelSegment) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *LabelSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *google_protobuf3.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence" json:"confidence,omitempty"`
}

func (m *LabelFrame) Reset()                    { *m = LabelFrame{} }
func (m *LabelFrame) String() string            { return proto.CompactTextString(m) }
func (*LabelFrame) ProtoMessage()               {}
func (*LabelFrame) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *LabelFrame) GetTimeOffset() *google_protobuf3.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *LabelFrame) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
}

func (m *Entity) Reset()                    { *m = Entity{} }
func (m *Entity) String() string            { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()               {}
func (*Entity) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *Entity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *Entity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entity) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames []*LabelFrame `protobuf:"bytes,4,rep,name=frames" json:"frames,omitempty"`
}

func (m *LabelAnnotation) Reset()                    { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string            { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()               {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *LabelAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LabelAnnotation) GetCategoryEntities() []*Entity {
	if m != nil {
		return m.CategoryEntities
	}
	return nil
}

func (m *LabelAnnotation) GetSegments() []*LabelSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *LabelAnnotation) GetFrames() []*LabelFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *google_protobuf3.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,enum=google.cloud.videointelligence.v1.Likelihood" json:"pornography_likelihood,omitempty"`
}

func (m *ExplicitContentFrame) Reset()                    { *m = ExplicitContentFrame{} }
func (m *ExplicitContentFrame) String() string            { return proto.CompactTextString(m) }
func (*ExplicitContentFrame) ProtoMessage()               {}
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *ExplicitContentFrame) GetTimeOffset() *google_protobuf3.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if m != nil {
		return m.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	// All video frames where explicit content was detected.
	Frames []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames" json:"frames,omitempty"`
}

func (m *ExplicitContentAnnotation) Reset()                    { *m = ExplicitContentAnnotation{} }
func (m *ExplicitContentAnnotation) String() string            { return proto.CompactTextString(m) }
func (*ExplicitContentAnnotation) ProtoMessage()               {}
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Normalized bounding box.
// The normalized vertex coordinates are relative to the original image.
// Range: [0, 1].
type NormalizedBoundingBox struct {
	// Left X coordinate.
	Left float32 `protobuf:"fixed32,1,opt,name=left" json:"left,omitempty"`
	// Top Y coordinate.
	Top float32 `protobuf:"fixed32,2,opt,name=top" json:"top,omitempty"`
	// Right X coordinate.
	Right float32 `protobuf:"fixed32,3,opt,name=right" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom float32 `protobuf:"fixed32,4,opt,name=bottom" json:"bottom,omitempty"`
}

func (m *NormalizedBoundingBox) Reset()                    { *m = NormalizedBoundingBox{} }
func (m *NormalizedBoundingBox) String() string            { return proto.CompactTextString(m) }
func (*NormalizedBoundingBox) ProtoMessage()               {}
func (*NormalizedBoundingBox) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *NormalizedBoundingBox) GetLeft() float32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *NormalizedBoundingBox) GetTop() float32 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *NormalizedBoundingBox) GetRight() float32 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *NormalizedBoundingBox) GetBottom() float32 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

// Video segment level annotation results for face detection.
type FaceSegment struct {
	// Video segment where a face was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment" json:"segment,omitempty"`
}

func (m *FaceSegment) Reset()                    { *m = FaceSegment{} }
func (m *FaceSegment) String() string            { return proto.CompactTextString(m) }
func (*FaceSegment) ProtoMessage()               {}
func (*FaceSegment) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *FaceSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

// Video frame level annotation results for face detection.
type FaceFrame struct {
	// Normalized Bounding boxes in a frame.
	// There can be more than one boxes if the same face is detected in multiple
	// locations within the current frame.
	NormalizedBoundingBoxes []*NormalizedBoundingBox `protobuf:"bytes,1,rep,name=normalized_bounding_boxes,json=normalizedBoundingBoxes" json:"normalized_bounding_boxes,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the video frame for this location.
	TimeOffset *google_protobuf3.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset" json:"time_offset,omitempty"`
}

func (m *FaceFrame) Reset()                    { *m = FaceFrame{} }
func (m *FaceFrame) String() string            { return proto.CompactTextString(m) }
func (*FaceFrame) ProtoMessage()               {}
func (*FaceFrame) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *FaceFrame) GetNormalizedBoundingBoxes() []*NormalizedBoundingBox {
	if m != nil {
		return m.NormalizedBoundingBoxes
	}
	return nil
}

func (m *FaceFrame) GetTimeOffset() *google_protobuf3.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Face annotation.
type FaceAnnotation struct {
	// Thumbnail of a representative face view (in JPEG format).
	Thumbnail []byte `protobuf:"bytes,1,opt,name=thumbnail,proto3" json:"thumbnail,omitempty"`
	// All video segments where a face was detected.
	Segments []*FaceSegment `protobuf:"bytes,2,rep,name=segments" json:"segments,omitempty"`
	// All video frames where a face was detected.
	Frames []*FaceFrame `protobuf:"bytes,3,rep,name=frames" json:"frames,omitempty"`
}

func (m *FaceAnnotation) Reset()                    { *m = FaceAnnotation{} }
func (m *FaceAnnotation) String() string            { return proto.CompactTextString(m) }
func (*FaceAnnotation) ProtoMessage()               {}
func (*FaceAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *FaceAnnotation) GetThumbnail() []byte {
	if m != nil {
		return m.Thumbnail
	}
	return nil
}

func (m *FaceAnnotation) GetSegments() []*FaceSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *FaceAnnotation) GetFrames() []*FaceFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri" json:"input_uri,omitempty"`
	// Label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations" json:"segment_label_annotations,omitempty"`
	// Label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations" json:"shot_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations" json:"frame_label_annotations,omitempty"`
	// Face annotations. There is exactly one element for each unique face.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,5,rep,name=face_annotations,json=faceAnnotations" json:"face_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation" json:"explicit_annotation,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error *google_rpc.Status `protobuf:"bytes,9,opt,name=error" json:"error,omitempty"`
}

func (m *VideoAnnotationResults) Reset()                    { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string            { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()               {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.FrameLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFaceAnnotations() []*FaceAnnotation {
	if m != nil {
		return m.FaceAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *google_rpc.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults" json:"annotation_results,omitempty"`
}

func (m *AnnotateVideoResponse) Reset()                    { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string            { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()               {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far.
	// Guaranteed to be 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *google_protobuf4.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime *google_protobuf4.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
}

func (m *VideoAnnotationProgress) Reset()                    { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string            { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()               {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress" json:"annotation_progress,omitempty"`
}

func (m *AnnotateVideoProgress) Reset()                    { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string            { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()               {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

func init() {
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1.VideoContext")
	proto.RegisterType((*LabelDetectionConfig)(nil), "google.cloud.videointelligence.v1.LabelDetectionConfig")
	proto.RegisterType((*ShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1.ShotChangeDetectionConfig")
	proto.RegisterType((*ExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1.ExplicitContentDetectionConfig")
	proto.RegisterType((*FaceDetectionConfig)(nil), "google.cloud.videointelligence.v1.FaceDetectionConfig")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1.VideoSegment")
	proto.RegisterType((*LabelSegment)(nil), "google.cloud.videointelligence.v1.LabelSegment")
	proto.RegisterType((*LabelFrame)(nil), "google.cloud.videointelligence.v1.LabelFrame")
	proto.RegisterType((*Entity)(nil), "google.cloud.videointelligence.v1.Entity")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1.LabelAnnotation")
	proto.RegisterType((*ExplicitContentFrame)(nil), "google.cloud.videointelligence.v1.ExplicitContentFrame")
	proto.RegisterType((*ExplicitContentAnnotation)(nil), "google.cloud.videointelligence.v1.ExplicitContentAnnotation")
	proto.RegisterType((*NormalizedBoundingBox)(nil), "google.cloud.videointelligence.v1.NormalizedBoundingBox")
	proto.RegisterType((*FaceSegment)(nil), "google.cloud.videointelligence.v1.FaceSegment")
	proto.RegisterType((*FaceFrame)(nil), "google.cloud.videointelligence.v1.FaceFrame")
	proto.RegisterType((*FaceAnnotation)(nil), "google.cloud.videointelligence.v1.FaceAnnotation")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1.AnnotateVideoProgress")
	proto.RegisterEnum("google.cloud.videointelligence.v1.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1.Likelihood", Likelihood_name, Likelihood_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for VideoIntelligenceService service

type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewVideoIntelligenceServiceClient(cc *grpc.ClientConn) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.videointelligence.v1.VideoIntelligenceService/AnnotateVideo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for VideoIntelligenceService service

type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*google_longrunning.Operation, error)
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1/video_intelligence.proto",
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1/video_intelligence.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1691 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0x4f, 0x73, 0xe3, 0x48,
	0x15, 0x47, 0xb6, 0x93, 0x89, 0x5f, 0xfe, 0x79, 0x3a, 0xff, 0x9c, 0x30, 0x93, 0xcd, 0x68, 0xa1,
	0x2a, 0x1b, 0xc0, 0xae, 0x04, 0xd8, 0x65, 0xb3, 0x5c, 0x1c, 0x5b, 0xd9, 0x31, 0x9b, 0xb1, 0x53,
	0x6d, 0xcf, 0xd4, 0xee, 0x16, 0x55, 0x2a, 0x45, 0x6a, 0xcb, 0x9a, 0x91, 0xd5, 0x42, 0x6a, 0xa5,
	0x26, 0x54, 0x71, 0x80, 0xa2, 0xe0, 0xc2, 0x8d, 0x0b, 0x1f, 0x80, 0x13, 0x1f, 0x80, 0xe2, 0x42,
	0xd5, 0x14, 0xc5, 0x99, 0x0b, 0x27, 0xee, 0x7c, 0x10, 0x4a, 0xdd, 0x2d, 0x5b, 0x91, 0x9d, 0x44,
	0x1e, 0xf6, 0xa6, 0x7e, 0xaf, 0xdf, 0xef, 0xfd, 0x7f, 0xdd, 0x2d, 0x38, 0xb5, 0x29, 0xb5, 0x5d,
	0x52, 0x37, 0x5d, 0x1a, 0x59, 0xf5, 0x6b, 0xc7, 0x22, 0xd4, 0xf1, 0x18, 0x71, 0x5d, 0xc7, 0x26,
	0x9e, 0x49, 0xea, 0xd7, 0xc7, 0x82, 0xa8, 0xa7, 0xa9, 0x35, 0x3f, 0xa0, 0x8c, 0xa2, 0x67, 0x42,
	0xb6, 0xc6, 0x65, 0x6b, 0x53, 0xb2, 0xb5, 0xeb, 0xe3, 0xbd, 0x27, 0x12, 0xde, 0xf0, 0x9d, 0xba,
	0xe1, 0x79, 0x94, 0x19, 0xcc, 0xa1, 0x5e, 0x28, 0x00, 0xf6, 0x3e, 0x94, 0x5c, 0x97, 0x7a, 0x76,
	0x10, 0x79, 0x9e, 0xe3, 0xd9, 0x75, 0xea, 0x93, 0xe0, 0xd6, 0xa6, 0x7d, 0xb9, 0x89, 0xaf, 0xae,
	0xa2, 0x41, 0xdd, 0x8a, 0xc4, 0x06, 0xc9, 0xff, 0x20, 0xcb, 0x67, 0xce, 0x88, 0x84, 0xcc, 0x18,
	0xf9, 0x72, 0xc3, 0x8e, 0xdc, 0x10, 0xf8, 0x66, 0x3d, 0x64, 0x06, 0x8b, 0x24, 0xb2, 0xfa, 0xd7,
	0x02, 0x6c, 0x36, 0x84, 0x51, 0xe4, 0x55, 0x6c, 0x3d, 0x26, 0xbf, 0x88, 0x48, 0xc8, 0xd0, 0xb7,
	0xa1, 0xec, 0x78, 0x7e, 0xc4, 0xf4, 0x28, 0x70, 0xaa, 0xca, 0x81, 0x72, 0x58, 0xc6, 0x4b, 0x9c,
	0xf0, 0x32, 0x70, 0xd0, 0x87, 0xb0, 0x2a, 0x98, 0x26, 0xf5, 0x18, 0xf1, 0x58, 0x75, 0xf1, 0x40,
	0x39, 0x5c, 0xc1, 0x2b, 0x9c, 0xd8, 0x14, 0x34, 0x74, 0x0e, 0x4b, 0x03, 0x62, 0xb0, 0x28, 0x20,
	0x61, 0xb5, 0x70, 0x50, 0x3c, 0x5c, 0x3b, 0x39, 0xaa, 0x3d, 0x18, 0xad, 0xda, 0xb9, 0x10, 0xc1,
	0x63, 0x59, 0xd4, 0x87, 0x55, 0x11, 0x7e, 0xae, 0xec, 0x2d, 0xab, 0x16, 0x0f, 0x94, 0xc3, 0xe5,
	0x93, 0x7a, 0x0e, 0x30, 0xee, 0x51, 0x53, 0x88, 0xe1, 0x95, 0xeb, 0xd4, 0x0a, 0x3d, 0x05, 0xa0,
	0x11, 0x4b, 0x1c, 0x2c, 0x71, 0x07, 0xcb, 0x82, 0x12, 0x7b, 0xf8, 0x01, 0x2c, 0xbb, 0xd4, 0xe4,
	0x31, 0xd6, 0x1d, 0xab, 0xba, 0xc0, 0xf9, 0x90, 0x90, 0xda, 0x96, 0xfa, 0xcf, 0x12, 0xac, 0xa4,
	0xe1, 0xd1, 0x17, 0xb0, 0x14, 0x12, 0x7b, 0x44, 0x3c, 0x16, 0x56, 0x95, 0x83, 0xe2, 0x3c, 0x16,
	0xf6, 0x84, 0x1c, 0x1e, 0x03, 0xa0, 0x11, 0x6c, 0xbb, 0xc6, 0x15, 0x71, 0x75, 0x8b, 0x30, 0x62,
	0x72, 0x2b, 0x4c, 0xea, 0x0d, 0x1c, 0xbb, 0x5a, 0xe0, 0xce, 0x7f, 0x92, 0x03, 0xfa, 0x22, 0x06,
	0x68, 0x25, 0xf2, 0x4d, 0x2e, 0x8e, 0x37, 0xdd, 0x19, 0x54, 0xf4, 0x2b, 0x78, 0x12, 0x0e, 0x29,
	0xd3, 0xcd, 0xa1, 0xe1, 0xd9, 0x64, 0x5a, 0xa9, 0x88, 0xf8, 0x4f, 0x73, 0x28, 0xed, 0x0d, 0x29,
	0x6b, 0x72, 0x94, 0xac, 0xe6, 0xdd, 0xf0, 0x2e, 0x16, 0xfa, 0x83, 0x02, 0xcf, 0xc8, 0x5b, 0xdf,
	0x75, 0x4c, 0x67, 0x5c, 0x52, 0xd3, 0x46, 0x94, 0xb8, 0x11, 0x8d, 0x1c, 0x46, 0x68, 0x12, 0x4b,
	0x56, 0x62, 0xd6, 0x92, 0x7d, 0x72, 0x2f, 0x1f, 0xbd, 0x86, 0xad, 0x81, 0x61, 0xce, 0x08, 0xc3,
	0x02, 0xb7, 0xe0, 0xe3, 0x3c, 0x55, 0x6c, 0x98, 0x53, 0x01, 0xd8, 0x18, 0x4c, 0x13, 0xd5, 0x7f,
	0x28, 0xb0, 0x39, 0x2b, 0x51, 0xc8, 0x86, 0xcd, 0x6c, 0x05, 0x8c, 0xa8, 0x45, 0x78, 0x2b, 0xae,
	0x9d, 0xfc, 0x78, 0xee, 0xfc, 0xbf, 0xa0, 0x16, 0xc1, 0xc8, 0x9d, 0xa2, 0xa1, 0xef, 0xc1, 0xe3,
	0x50, 0x8c, 0x24, 0x23, 0xb8, 0xd1, 0x4d, 0x63, 0x44, 0x02, 0x83, 0x57, 0xd9, 0x12, 0xae, 0x4c,
	0x18, 0x4d, 0x4e, 0x47, 0x9b, 0xb0, 0x10, 0x5b, 0xe1, 0xf2, 0x8a, 0x28, 0x63, 0xb1, 0x50, 0x8f,
	0x61, 0xf7, 0xce, 0xbc, 0x4f, 0x44, 0x94, 0xb4, 0xc8, 0xc7, 0xb0, 0x7f, 0x7f, 0x96, 0xee, 0x90,
	0x33, 0x60, 0x63, 0x46, 0x6c, 0x67, 0x6f, 0x46, 0x3f, 0x82, 0x6d, 0xc7, 0x33, 0xdd, 0xc8, 0x22,
	0xfa, 0x15, 0x8d, 0x3c, 0xcb, 0xf1, 0x6c, 0xfd, 0x8a, 0xbe, 0xe5, 0xf3, 0x28, 0xf6, 0x6f, 0x53,
	0x72, 0xcf, 0x24, 0xf3, 0x2c, 0xe6, 0xa9, 0x7f, 0x52, 0x64, 0x67, 0xcb, 0xb6, 0x44, 0x1a, 0x8f,
	0x50, 0xc0, 0xf4, 0x78, 0xaa, 0xea, 0x74, 0x30, 0x08, 0x09, 0xe3, 0x8a, 0x96, 0x4f, 0x76, 0x93,
	0x3c, 0x24, 0x93, 0xb7, 0xd6, 0x92, 0x93, 0x19, 0xaf, 0x73, 0x99, 0xbe, 0x33, 0x22, 0x5d, 0x2e,
	0x81, 0x1a, 0xb0, 0x4e, 0x3c, 0xeb, 0x16, 0x48, 0xe1, 0x21, 0x90, 0x55, 0xe2, 0x59, 0x13, 0x08,
	0xf5, 0x06, 0x56, 0x78, 0x56, 0x13, 0xcb, 0xda, 0xf0, 0x48, 0x8e, 0x0c, 0x69, 0xcf, 0xdc, 0x23,
	0x27, 0x91, 0x47, 0xfb, 0x00, 0xbc, 0xca, 0xad, 0x78, 0x1b, 0x37, 0xac, 0x80, 0x53, 0x14, 0x75,
	0x08, 0xc0, 0x55, 0x9f, 0x07, 0xc6, 0x88, 0xa0, 0x53, 0x58, 0x9e, 0x2b, 0x18, 0xc0, 0x26, 0x71,
	0x78, 0x48, 0x93, 0x0b, 0x8b, 0x9a, 0xc7, 0x1c, 0x76, 0x13, 0x9f, 0x41, 0x84, 0x7f, 0xc5, 0x23,
	0x58, 0x9e, 0x41, 0x82, 0xd0, 0xb6, 0xd0, 0x01, 0x2c, 0x5b, 0x24, 0x34, 0x03, 0xc7, 0x8f, 0x35,
	0x70, 0x9c, 0x32, 0x4e, 0x93, 0xe2, 0x53, 0xca, 0x35, 0x3c, 0x3b, 0x32, 0x6c, 0xa2, 0x9b, 0x71,
	0xef, 0x88, 0xa2, 0x5d, 0x49, 0x88, 0x4d, 0x6a, 0x11, 0xf5, 0x5d, 0x01, 0xd6, 0xb9, 0x63, 0x8d,
	0xf1, 0xd1, 0x8c, 0x1a, 0xb0, 0x28, 0xd4, 0x48, 0xc7, 0x3e, 0xca, 0x33, 0x73, 0xb8, 0x00, 0x96,
	0x82, 0xe8, 0x15, 0x3c, 0x36, 0x0d, 0x46, 0x6c, 0x1a, 0xdc, 0xe8, 0x9c, 0xe4, 0xc8, 0x53, 0x70,
	0x2e, 0xb4, 0x4a, 0x82, 0xa1, 0x49, 0x88, 0x5b, 0xa7, 0x4c, 0x31, 0xf7, 0x29, 0x93, 0x2e, 0x9a,
	0xd4, 0x29, 0xa3, 0xc1, 0xe2, 0x20, 0x4e, 0x67, 0x58, 0x2d, 0x71, 0xa8, 0x1f, 0xe4, 0x85, 0xe2,
	0x45, 0x80, 0xa5, 0xb0, 0xfa, 0x37, 0x05, 0x36, 0x33, 0xcd, 0xfc, 0xff, 0x57, 0x89, 0x05, 0xdb,
	0x3e, 0x0d, 0x3c, 0x6a, 0x07, 0x86, 0x3f, 0xbc, 0xd1, 0x5d, 0xe7, 0x0d, 0x71, 0x9d, 0x21, 0xa5,
	0x16, 0xcf, 0xf4, 0x5a, 0x3e, 0x5b, 0xc7, 0x42, 0x78, 0x2b, 0x05, 0x36, 0x21, 0xab, 0x2e, 0xec,
	0x66, 0x2c, 0x4f, 0x95, 0x41, 0x77, 0x1c, 0x1e, 0x71, 0x9e, 0x7f, 0x32, 0xff, 0xd1, 0x73, 0x3b,
	0x50, 0x6f, 0x60, 0xab, 0x43, 0x83, 0x91, 0xe1, 0x3a, 0xbf, 0x24, 0x56, 0x6a, 0xe8, 0x20, 0x04,
	0x25, 0x97, 0x0c, 0x44, 0x84, 0x0a, 0x98, 0x7f, 0xa3, 0x0a, 0x14, 0x19, 0xf5, 0x65, 0x7f, 0xc4,
	0x9f, 0xf1, 0x90, 0x0b, 0x1c, 0x7b, 0x28, 0x2e, 0x40, 0x05, 0x2c, 0x16, 0x68, 0x1b, 0x16, 0xaf,
	0x28, 0x63, 0x74, 0xc4, 0x0f, 0xc8, 0x02, 0x96, 0x2b, 0xf5, 0x4b, 0x58, 0x8e, 0x27, 0xe5, 0x37,
	0x3f, 0x2a, 0xd4, 0xbf, 0x2b, 0x50, 0x8e, 0xa1, 0x45, 0x92, 0x19, 0xec, 0x7a, 0x63, 0xa7, 0xb2,
	0x73, 0x56, 0x04, 0xee, 0x27, 0x39, 0x54, 0xcd, 0x0c, 0x0c, 0xde, 0xf1, 0x66, 0x91, 0x49, 0x98,
	0x2d, 0xad, 0xc2, 0x1c, 0xa5, 0xa5, 0xbe, 0x53, 0x60, 0x2d, 0xb6, 0x3f, 0x95, 0xea, 0x27, 0x50,
	0x66, 0xc3, 0x68, 0x74, 0xe5, 0x19, 0x8e, 0x38, 0x43, 0x56, 0xf0, 0x84, 0x80, 0x7e, 0x96, 0x6a,
	0x3a, 0xd1, 0xc3, 0xb5, 0x9c, 0x77, 0x80, 0xe9, 0x9e, 0x6b, 0x8d, 0x8b, 0x4a, 0xb4, 0xef, 0xf7,
	0x73, 0x22, 0xdd, 0xae, 0xa4, 0x7f, 0x2d, 0xc0, 0x36, 0x4f, 0xce, 0xc4, 0x07, 0x4c, 0xc2, 0xc8,
	0x65, 0xe1, 0xfd, 0x17, 0x77, 0x0f, 0x76, 0xa5, 0x25, 0xba, 0xb8, 0x5d, 0xa4, 0x1e, 0x24, 0xd2,
	0xb5, 0x93, 0xbc, 0x43, 0x20, 0xa5, 0x7a, 0x47, 0x82, 0x66, 0xe8, 0x21, 0x1a, 0xc2, 0x36, 0xbf,
	0x58, 0x4e, 0x2b, 0x2b, 0xbe, 0xb7, 0xb2, 0xcd, 0x18, 0x71, 0x4a, 0xd3, 0x6b, 0xd8, 0xe1, 0xb1,
	0x99, 0xa1, 0xaa, 0xf4, 0xde, 0xaa, 0xb6, 0x38, 0xe4, 0x94, 0xae, 0x9f, 0x43, 0x85, 0x5f, 0x10,
	0xd3, 0x4a, 0x16, 0xb8, 0x92, 0xe3, 0x9c, 0xd9, 0x4c, 0xe9, 0x58, 0x1f, 0xdc, 0x5a, 0x87, 0xe8,
	0x6b, 0xa8, 0xf0, 0x98, 0xa5, 0xd1, 0x17, 0xdf, 0xef, 0x41, 0xb1, 0x1e, 0x03, 0xa5, 0xb1, 0x47,
	0xb0, 0x31, 0xbe, 0x68, 0x4f, 0xf0, 0xab, 0x8f, 0x72, 0xdf, 0xef, 0xef, 0x9c, 0x96, 0x18, 0x25,
	0xc0, 0xa9, 0xb6, 0x3a, 0x84, 0x05, 0x12, 0x04, 0x34, 0xa8, 0x96, 0xb9, 0x02, 0x94, 0x28, 0x08,
	0x7c, 0xb3, 0xd6, 0xe3, 0xcf, 0x50, 0x2c, 0x36, 0xa8, 0xbf, 0x56, 0x60, 0x2b, 0xf3, 0x0e, 0x0d,
	0x7d, 0xea, 0x85, 0x04, 0x0d, 0x01, 0x4d, 0x2c, 0xd5, 0x03, 0x51, 0xe5, 0x72, 0xb0, 0x7c, 0x9a,
	0x37, 0x20, 0x53, 0x6d, 0x82, 0x1f, 0x1b, 0x59, 0x92, 0xfa, 0x1f, 0x05, 0x76, 0x32, 0xbb, 0x2f,
	0x03, 0x6a, 0x07, 0x24, 0x7c, 0xa0, 0xab, 0x3e, 0x82, 0x8a, 0x2f, 0x37, 0xea, 0x3e, 0x09, 0xcc,
	0x78, 0xc8, 0xc6, 0x13, 0x69, 0x01, 0xaf, 0x27, 0xf4, 0x4b, 0x41, 0x46, 0x9f, 0x02, 0x4c, 0xee,
	0x92, 0xf2, 0x5d, 0xb5, 0x37, 0x35, 0xb6, 0xfa, 0xc9, 0xf3, 0x1d, 0x97, 0xc7, 0xb7, 0x48, 0xf4,
	0x19, 0x2c, 0x47, 0xbe, 0x65, 0x30, 0x22, 0x64, 0x4b, 0x0f, 0xca, 0x82, 0xd8, 0x1e, 0x13, 0xd4,
	0xdf, 0x66, 0xe3, 0x3b, 0xf6, 0xec, 0x0d, 0x6c, 0xa4, 0xe2, 0x9b, 0xd8, 0x2b, 0x03, 0x7c, 0x3a,
	0x7f, 0x80, 0x13, 0x60, 0x9c, 0x4a, 0x5b, 0x42, 0x3b, 0xfa, 0x9d, 0x02, 0x8f, 0xe4, 0x0b, 0x1f,
	0xed, 0xc0, 0xc6, 0xb9, 0xd6, 0xe8, 0xbf, 0xc4, 0x9a, 0xfe, 0xb2, 0xd3, 0xbb, 0xd4, 0x9a, 0xed,
	0xf3, 0xb6, 0xd6, 0xaa, 0x7c, 0x0b, 0x6d, 0xc0, 0xfa, 0x45, 0xe3, 0x4c, 0xbb, 0xd0, 0x5b, 0x5a,
	0x5f, 0x6b, 0xf6, 0xdb, 0xdd, 0x4e, 0x45, 0x41, 0xbb, 0xb0, 0xd5, 0x7b, 0xde, 0xed, 0xeb, 0xcd,
	0xe7, 0x8d, 0xce, 0xe7, 0x5a, 0x8a, 0x55, 0x40, 0xfb, 0xb0, 0xa7, 0x7d, 0x79, 0x79, 0xd1, 0x6e,
	0xb6, 0xfb, 0x7a, 0xb3, 0xdb, 0xe9, 0x6b, 0x9d, 0x7e, 0x8a, 0x5f, 0x44, 0x08, 0xd6, 0xce, 0x1b,
	0xcd, 0xb4, 0x4c, 0xe9, 0x28, 0x00, 0x34, 0xfd, 0x3e, 0x42, 0xdf, 0x81, 0x83, 0x8c, 0x66, 0xfd,
	0x45, 0xb7, 0x95, 0xb5, 0x6f, 0x15, 0xca, 0xdc, 0x94, 0x98, 0x55, 0x51, 0xd0, 0x1a, 0xc0, 0x39,
	0x6e, 0xbc, 0xd0, 0xc4, 0xba, 0x10, 0xfb, 0xc5, 0xd9, 0x8d, 0x4e, 0x4b, 0x4f, 0x31, 0x8a, 0x47,
	0x0c, 0x60, 0x72, 0xf5, 0x40, 0x7b, 0xb0, 0x7d, 0xd1, 0xfe, 0x42, 0xbb, 0x68, 0x3f, 0xef, 0x76,
	0x5b, 0x19, 0x0d, 0x8f, 0x61, 0xf5, 0x95, 0x86, 0xbf, 0xd2, 0x5f, 0x76, 0xf8, 0x96, 0xaf, 0x2a,
	0x0a, 0x5a, 0x81, 0xa5, 0xf1, 0xaa, 0x10, 0xaf, 0x2e, 0xbb, 0xbd, 0x5e, 0xfb, 0xec, 0x42, 0xab,
	0x14, 0x11, 0xc0, 0xa2, 0xe4, 0x94, 0xd0, 0x3a, 0x2c, 0x73, 0x51, 0x49, 0x58, 0x38, 0xf9, 0xb3,
	0x02, 0x55, 0x9e, 0xa2, 0x76, 0x2a, 0x6f, 0x3d, 0x12, 0x5c, 0x3b, 0x26, 0x41, 0xbf, 0x57, 0x60,
	0xf5, 0x56, 0x59, 0xa0, 0x3c, 0x97, 0x9c, 0x59, 0x3f, 0x8c, 0xf6, 0x9e, 0x26, 0x82, 0xa9, 0x3f,
	0x59, 0xb5, 0x6e, 0xf2, 0x27, 0x4b, 0xdd, 0xff, 0xcd, 0xbf, 0xff, 0xfb, 0xc7, 0x42, 0x55, 0xdd,
	0x18, 0xff, 0x4e, 0x0b, 0x4f, 0x65, 0x81, 0x90, 0x53, 0xe5, 0xe8, 0xec, 0x9d, 0x02, 0xdf, 0x35,
	0xe9, 0xe8, 0x61, 0xed, 0x67, 0x4f, 0xef, 0xf2, 0xe6, 0x32, 0x6e, 0x81, 0x4b, 0xe5, 0x6b, 0x2c,
	0x31, 0x6c, 0x1a, 0xdf, 0xf4, 0x6b, 0x34, 0xb0, 0xeb, 0x36, 0xf1, 0x78, 0x83, 0xd4, 0x05, 0xcb,
	0xf0, 0x9d, 0xf0, 0x9e, 0xdf, 0x7d, 0x9f, 0x4d, 0x11, 0xff, 0x52, 0x78, 0xf6, 0xb9, 0x00, 0x6d,
	0x72, 0xc3, 0xa6, 0x4c, 0xa8, 0xbd, 0x3a, 0xbe, 0x5a, 0xe4, 0x2a, 0x7e, 0xf8, 0xbf, 0x00, 0x00,
	0x00, 0xff, 0xff, 0xac, 0x5e, 0x67, 0x3e, 0x50, 0x14, 0x00, 0x00,
}
