# grpc_validator
`import "github.com/grpc-ecosystem/go-grpc-middleware/validator"`

* [Overview](#pkg-overview)
* [Imported Packages](#pkg-imports)
* [Index](#pkg-index)

## <a name="pkg-overview">Overview</a>
`grpc_validator` a generic request contents validator server-side middleware for gRPC.

### Request Validator Middleware
Validating input is important, and hard. It also causes a lot of boiler plate. This middleware
checks for the existance of a `Validate` method on each of the messages of a gRPC request. This
includes the single request of the `Unary` calls, as well as each message of the inbound Stream calls.
In case of a validation failure, a `InvalidArgument` gRPC status is returned, alongside with a
description of the validation failure.

While it is generic, it was indented to be used with <a href="https://github.com/mwitkow/go-proto-validators">https://github.com/mwitkow/go-proto-validators</a>,
a Go protocol buffers codegen plugin that creates the `Validate` methods (including nested messages)
based on declarative options in the `.proto` files themselves. For example:

	syntax = "proto3";
	package validator.examples;
	import "github.com/mwitkow/go-proto-validators/validator.proto";
	
	message InnerMessage {
	  // some_integer can only be in range (1, 100).
	  int32 some_integer = 1 [(validator.field) = {int_gt: 0, int_lt: 100}];
	  // some_float can only be in range (0;1).
	  double some_float = 2 [(validator.field) = {float_gte: 0, float_lte: 1}];
	}
	
	message OuterMessage {
	  // important_string must be a lowercase alpha-numeric of 5 to 30 characters (RE2 syntax).
	  string important_string = 1 [(validator.field) = {regex: "^[a-z]{2,5}$"}];
	  // proto3 doesn't have `required`, the `msg_exist` enforces presence of InnerMessage.
	  InnerMessage inner = 2 [(validator.field) = {msg_exists : true}];
	}

The `OuterMessage.Validate` would include validation of regexes, existance of the InnerMessage and
the range values within it. The `grpc_validator` middleware would then automatically use that to
check all messages processed by the server.

Please consult <a href="https://github.com/mwitkow/go-proto-validators">https://github.com/mwitkow/go-proto-validators</a> for details of `protoc` invoation and
other parameters of customization.

## <a name="pkg-imports">Imported Packages</a>

- [golang.org/x/net/context](https://godoc.org/golang.org/x/net/context)
- [google.golang.org/grpc](https://godoc.org/google.golang.org/grpc)
- [google.golang.org/grpc/codes](https://godoc.org/google.golang.org/grpc/codes)

## <a name="pkg-index">Index</a>
* [func StreamServerInterceptor() grpc.StreamServerInterceptor](#StreamServerInterceptor)
* [func UnaryServerInterceptor() grpc.UnaryServerInterceptor](#UnaryServerInterceptor)

#### <a name="pkg-files">Package files</a>
[doc.go](./doc.go) [validator.go](./validator.go) 

## <a name="StreamServerInterceptor">func</a> [StreamServerInterceptor](./validator.go#L36)
``` go
func StreamServerInterceptor() grpc.StreamServerInterceptor
```
StreamServerInterceptor returns a new streaming server interceptors that validates incoming messages.

The stage at which invalid messages will be rejected with `InvalidArgument` varies based on the
type of the RPC. For `ServerStream` (1:m) requests, it will happen before reaching any userspace
handlers. For `ClientStream` (n:1) or `BidiStream` (n:m) RPCs, the messages will be rejected on
calls to `stream.Recv()`.

## <a name="UnaryServerInterceptor">func</a> [UnaryServerInterceptor](./validator.go#L19)
``` go
func UnaryServerInterceptor() grpc.UnaryServerInterceptor
```
UnaryServerInterceptor returns a new unary server interceptors that validates incoming messages.

Invalid messages will be rejected with `InvalidArgument` before reaching any userspace handlers.

- - -
Generated by [godoc2ghmd](https://github.com/GandalfUK/godoc2ghmd)