# grpc_logging
`import "github.com/grpc-ecosystem/go-grpc-middleware/logging"`

* [Overview](#pkg-overview)
* [Imported Packages](#pkg-imports)
* [Index](#pkg-index)

## <a name="pkg-overview">Overview</a>
grpc_logging is a "parent" package for gRPC logging middlewares.

### General functionality of all middleware
The gRPC logging middleware populates request-scoped data to `grpc_ctxtags.Tags` that relate to the current gRPC call
(e.g. service and method names).

Once the gRPC logging middleware has added the gRPC specific Tags to the ctx they will then be written with the logs
that are made using the `ctx_logrus` or `ctx_zap` loggers.

All logging middleware will emit a final log statement. It is based on the error returned by the handler function,
the gRPC status code, an error (if any) and it will emit at a level controlled via `WithLevels`.

### This parent package
This particular package is intended for use by other middleware, logging or otherwise. It contains interfaces that other
logging middlewares *could* share . This allows code to be shared between different implementations.

### Field names
All field names of loggers follow the OpenTracing semantics definitions, with `grpc.` prefix if needed:
<a href="https://github.com/opentracing/specification/blob/master/semantic_conventions.md">https://github.com/opentracing/specification/blob/master/semantic_conventions.md</a>

### Implementations
There are two implementations at the moment: logrus and zap

See relevant packages below.

## <a name="pkg-imports">Imported Packages</a>

- [golang.org/x/net/context](https://godoc.org/golang.org/x/net/context)
- [google.golang.org/grpc](https://godoc.org/google.golang.org/grpc)
- [google.golang.org/grpc/codes](https://godoc.org/google.golang.org/grpc/codes)

## <a name="pkg-index">Index</a>
* [func DefaultErrorToCode(err error) codes.Code](#DefaultErrorToCode)
* [type ClientPayloadLoggingDecider](#ClientPayloadLoggingDecider)
* [type ErrorToCode](#ErrorToCode)
* [type ServerPayloadLoggingDecider](#ServerPayloadLoggingDecider)

#### <a name="pkg-files">Package files</a>
[common.go](./common.go) [doc.go](./doc.go) 

## <a name="DefaultErrorToCode">func</a> [DefaultErrorToCode](./common.go#L16)
``` go
func DefaultErrorToCode(err error) codes.Code
```

## <a name="ClientPayloadLoggingDecider">type</a> [ClientPayloadLoggingDecider](./common.go#L26)
``` go
type ClientPayloadLoggingDecider func(ctx context.Context, fullMethodName string) bool
```
ClientPayloadLoggingDecider is a user-provided function for deciding whether to log the client-side
request/response payloads

## <a name="ErrorToCode">type</a> [ErrorToCode](./common.go#L14)
``` go
type ErrorToCode func(err error) codes.Code
```
ErrorToCode function determines the error code of an error
This makes using custom errors with grpc middleware easier

## <a name="ServerPayloadLoggingDecider">type</a> [ServerPayloadLoggingDecider](./common.go#L22)
``` go
type ServerPayloadLoggingDecider func(ctx context.Context, fullMethodName string, servingObject interface{}) bool
```
ServerPayloadLoggingDecider is a user-provided function for deciding whether to log the server-side
request/response payloads

- - -
Generated by [godoc2ghmd](https://github.com/GandalfUK/godoc2ghmd)