/*
Copyright 2014 Workiva, LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package btree

import "errors"

// ErrNodeNotFound is returned when the cacher could not find a node.
var ErrNodeNotFound = errors.New(`node not found`)

// ErrTreeNotFound is returned when a tree with the provided key could
// not be loaded.
var ErrTreeNotFound = errors.New(`tree not found`)
