// Code generated by go-swagger; DO NOT EDIT.

package triggers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new triggers API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for triggers API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientService is the interface for Client methods
type ClientService interface {
	CreateTrigger(params *CreateTriggerParams) (*CreateTriggerOK, error)

	DeleteTrigger(params *DeleteTriggerParams) (*DeleteTriggerNoContent, error)

	GetTrigger(params *GetTriggerParams) (*GetTriggerOK, error)

	ListTriggers(params *ListTriggersParams) (*ListTriggersOK, error)

	UpdateTrigger(params *UpdateTriggerParams) (*UpdateTriggerOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
  CreateTrigger creates a new trigger

  Creates a new Trigger, returning the complete entity.
*/
func (a *Client) CreateTrigger(params *CreateTriggerParams) (*CreateTriggerOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateTriggerParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "CreateTrigger",
		Method:             "POST",
		PathPattern:        "/triggers",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateTriggerReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateTriggerOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateTriggerDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
  DeleteTrigger deletes a trigger

  Delete the specified Trigger.
*/
func (a *Client) DeleteTrigger(params *DeleteTriggerParams) (*DeleteTriggerNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteTriggerParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DeleteTrigger",
		Method:             "DELETE",
		PathPattern:        "/triggers/{triggerID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteTriggerReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteTriggerNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteTriggerDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
  GetTrigger gets definition of a trigger

  Gets the definition for the Trigger with the specified ID.
*/
func (a *Client) GetTrigger(params *GetTriggerParams) (*GetTriggerOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetTriggerParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetTrigger",
		Method:             "GET",
		PathPattern:        "/triggers/{triggerID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetTriggerReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetTriggerOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetTriggerDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
  ListTriggers gets a list of triggers within an application or function

  This will list all Triggers for a particular Application or Function, returned in name alphabetical order.
*/
func (a *Client) ListTriggers(params *ListTriggersParams) (*ListTriggersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListTriggersParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListTriggers",
		Method:             "GET",
		PathPattern:        "/triggers",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListTriggersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListTriggersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListTriggersDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
  UpdateTrigger updates a trigger

  Updates a Trigger by merging the provided values.
*/
func (a *Client) UpdateTrigger(params *UpdateTriggerParams) (*UpdateTriggerOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateTriggerParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateTrigger",
		Method:             "PUT",
		PathPattern:        "/triggers/{triggerID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateTriggerReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateTriggerOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateTriggerDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
