// Code generated by go-swagger; DO NOT EDIT.

package fns

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/fnproject/fn_go/modelsv2"
)

// UpdateFnReader is a Reader for the UpdateFn structure.
type UpdateFnReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateFnReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateFnOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateFnBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateFnNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		result := NewUpdateFnDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUpdateFnOK creates a UpdateFnOK with default headers values
func NewUpdateFnOK() *UpdateFnOK {
	return &UpdateFnOK{}
}

/*UpdateFnOK handles this case with default header values.

Updated Function metadata.
*/
type UpdateFnOK struct {
	Payload *modelsv2.Fn
}

func (o *UpdateFnOK) Error() string {
	return fmt.Sprintf("[PUT /fns/{fnID}][%d] updateFnOK  %+v", 200, o.Payload)
}

func (o *UpdateFnOK) GetPayload() *modelsv2.Fn {
	return o.Payload
}

func (o *UpdateFnOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Fn)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateFnBadRequest creates a UpdateFnBadRequest with default headers values
func NewUpdateFnBadRequest() *UpdateFnBadRequest {
	return &UpdateFnBadRequest{}
}

/*UpdateFnBadRequest handles this case with default header values.

Parameters are missing or invalid.
*/
type UpdateFnBadRequest struct {
	Payload *modelsv2.Error
}

func (o *UpdateFnBadRequest) Error() string {
	return fmt.Sprintf("[PUT /fns/{fnID}][%d] updateFnBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateFnBadRequest) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *UpdateFnBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateFnNotFound creates a UpdateFnNotFound with default headers values
func NewUpdateFnNotFound() *UpdateFnNotFound {
	return &UpdateFnNotFound{}
}

/*UpdateFnNotFound handles this case with default header values.

The Function does not exist.
*/
type UpdateFnNotFound struct {
	Payload *modelsv2.Error
}

func (o *UpdateFnNotFound) Error() string {
	return fmt.Sprintf("[PUT /fns/{fnID}][%d] updateFnNotFound  %+v", 404, o.Payload)
}

func (o *UpdateFnNotFound) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *UpdateFnNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateFnDefault creates a UpdateFnDefault with default headers values
func NewUpdateFnDefault(code int) *UpdateFnDefault {
	return &UpdateFnDefault{
		_statusCode: code,
	}
}

/*UpdateFnDefault handles this case with default header values.

An unexpected error occurred.
*/
type UpdateFnDefault struct {
	_statusCode int

	Payload *modelsv2.Error
}

// Code gets the status code for the update fn default response
func (o *UpdateFnDefault) Code() int {
	return o._statusCode
}

func (o *UpdateFnDefault) Error() string {
	return fmt.Sprintf("[PUT /fns/{fnID}][%d] UpdateFn default  %+v", o._statusCode, o.Payload)
}

func (o *UpdateFnDefault) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *UpdateFnDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
