/*
 * Copyright (c) 2019, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package config

import (
	"io/ioutil"

	yaml "gopkg.in/yaml.v2"
)

func DecodeYAMLFile(filename string) (*ContextMap, error) {
	b, err := ioutil.ReadFile(filename)
	if err != nil {
		return nil, err
	}
	yf := &ContextMap{}
	err = yaml.Unmarshal(b, yf)
	return yf, err
}

func WriteYamlFile(filename string, values *ContextMap) error {
	b, err := yaml.Marshal(values)
	if err != nil {
		return err
	}
	return ioutil.WriteFile(filename, b, ReadWritePerms)
}
