'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _stringifier = require('postcss/lib/stringifier');

var _stringifier2 = _interopRequireDefault(_stringifier);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var LessStringifier = function (_Stringifier) {
    _inherits(LessStringifier, _Stringifier);

    function LessStringifier() {
        _classCallCheck(this, LessStringifier);

        return _possibleConstructorReturn(this, Object.getPrototypeOf(LessStringifier).apply(this, arguments));
    }

    _createClass(LessStringifier, [{
        key: 'comment',
        value: function comment(node) {
            var left = this.raw(node, 'left', 'commentLeft');
            var right = this.raw(node, 'right', 'commentRight');

            if (node.inline) {
                this.builder('//' + left + node.text + right, node);
            } else {
                this.builder('/*' + left + node.text + right + '*/', node);
            }
        }
    }, {
        key: 'block',
        value: function block(node, start) {
            var ruleWithoutBody = node.ruleWithoutBody;

            var between = this.raw(node, 'between', 'beforeOpen');
            var after = '';

            if (ruleWithoutBody) {
                this.builder(start + between, node, 'start');
            } else {
                this.builder(start + between + '{', node, 'start');
            }

            if (node.nodes && node.nodes.length) {
                this.body(node);
                after = this.raw(node, 'after');
            } else {
                after = this.raw(node, 'after', 'emptyBody');
            }

            if (after) {
                this.builder(after);
            }

            if (!ruleWithoutBody) {
                this.builder('}', node, 'end');
            }
        }
    }]);

    return LessStringifier;
}(_stringifier2.default);

exports.default = LessStringifier;
module.exports = exports['default'];