// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/cloudtrace/v2/trace.proto

/*
Package cloudtrace is a generated protocol buffer package.

It is generated from these files:
	google/devtools/cloudtrace/v2/trace.proto
	google/devtools/cloudtrace/v2/tracing.proto

It has these top-level messages:
	Span
	AttributeValue
	StackTrace
	Module
	TruncatableString
	BatchWriteSpansRequest
*/
package cloudtrace

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"
import google_protobuf2 "github.com/golang/protobuf/ptypes/wrappers"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Indicates whether the message was sent or received.
type Span_TimeEvent_MessageEvent_Type int32

const (
	// Unknown event type.
	Span_TimeEvent_MessageEvent_TYPE_UNSPECIFIED Span_TimeEvent_MessageEvent_Type = 0
	// Indicates a sent message.
	Span_TimeEvent_MessageEvent_SENT Span_TimeEvent_MessageEvent_Type = 1
	// Indicates a received message.
	Span_TimeEvent_MessageEvent_RECEIVED Span_TimeEvent_MessageEvent_Type = 2
)

var Span_TimeEvent_MessageEvent_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "SENT",
	2: "RECEIVED",
}
var Span_TimeEvent_MessageEvent_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"SENT":             1,
	"RECEIVED":         2,
}

func (x Span_TimeEvent_MessageEvent_Type) String() string {
	return proto.EnumName(Span_TimeEvent_MessageEvent_Type_name, int32(x))
}
func (Span_TimeEvent_MessageEvent_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{0, 1, 1, 0}
}

// The relationship of the current span relative to the linked span: child,
// parent, or unspecified.
type Span_Link_Type int32

const (
	// The relationship of the two spans is unknown.
	Span_Link_TYPE_UNSPECIFIED Span_Link_Type = 0
	// The linked span is a child of the current span.
	Span_Link_CHILD_LINKED_SPAN Span_Link_Type = 1
	// The linked span is a parent of the current span.
	Span_Link_PARENT_LINKED_SPAN Span_Link_Type = 2
)

var Span_Link_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "CHILD_LINKED_SPAN",
	2: "PARENT_LINKED_SPAN",
}
var Span_Link_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":   0,
	"CHILD_LINKED_SPAN":  1,
	"PARENT_LINKED_SPAN": 2,
}

func (x Span_Link_Type) String() string {
	return proto.EnumName(Span_Link_Type_name, int32(x))
}
func (Span_Link_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 3, 0} }

// A span represents a single operation within a trace. Spans can be
// nested to form a trace tree. Often, a trace contains a root span
// that describes the end-to-end latency, and one or more subspans for
// its sub-operations. A trace can also contain multiple root spans,
// or none at all. Spans do not need to be contiguous&mdash;there may be
// gaps or overlaps between spans in a trace.
type Span struct {
	// The resource name of the span in the following format:
	//
	//     projects/[PROJECT_ID]/traces/[TRACE_ID]/spans/[SPAN_ID]
	//
	// [TRACE_ID] is a unique identifier for a trace within a project.
	// [SPAN_ID] is a unique identifier for a span within a trace,
	// assigned when the span is created.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The [SPAN_ID] portion of the span's resource name.
	// The ID is a 16-character hexadecimal encoding of an 8-byte array.
	SpanId string `protobuf:"bytes,2,opt,name=span_id,json=spanId" json:"span_id,omitempty"`
	// The [SPAN_ID] of this span's parent span. If this is a root span,
	// then this field must be empty.
	ParentSpanId string `protobuf:"bytes,3,opt,name=parent_span_id,json=parentSpanId" json:"parent_span_id,omitempty"`
	// A description of the span's operation (up to 128 bytes).
	// Stackdriver Trace displays the description in the
	// {% dynamic print site_values.console_name %}.
	// For example, the display name can be a qualified method name or a file name
	// and a line number where the operation is called. A best practice is to use
	// the same display name within an application and at the same call point.
	// This makes it easier to correlate spans in different traces.
	DisplayName *TruncatableString `protobuf:"bytes,4,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// The start time of the span. On the client side, this is the time kept by
	// the local machine where the span execution starts. On the server side, this
	// is the time when the server's application handler starts running.
	StartTime *google_protobuf1.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// The end time of the span. On the client side, this is the time kept by
	// the local machine where the span execution ends. On the server side, this
	// is the time when the server application handler stops running.
	EndTime *google_protobuf1.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// A set of attributes on the span. There is a limit of 32 attributes per
	// span.
	Attributes *Span_Attributes `protobuf:"bytes,7,opt,name=attributes" json:"attributes,omitempty"`
	// Stack trace captured at the start of the span.
	StackTrace *StackTrace `protobuf:"bytes,8,opt,name=stack_trace,json=stackTrace" json:"stack_trace,omitempty"`
	// The included time events. There can be up to 32 annotations and 128 message
	// events per span.
	TimeEvents *Span_TimeEvents `protobuf:"bytes,9,opt,name=time_events,json=timeEvents" json:"time_events,omitempty"`
	// A maximum of 128 links are allowed per Span.
	Links *Span_Links `protobuf:"bytes,10,opt,name=links" json:"links,omitempty"`
	// An optional final status for this span.
	Status *google_rpc.Status `protobuf:"bytes,11,opt,name=status" json:"status,omitempty"`
	// A highly recommended but not required flag that identifies when a trace
	// crosses a process boundary. True when the parent_span belongs to the
	// same process as the current span.
	SameProcessAsParentSpan *google_protobuf2.BoolValue `protobuf:"bytes,12,opt,name=same_process_as_parent_span,json=sameProcessAsParentSpan" json:"same_process_as_parent_span,omitempty"`
	// An optional number of child spans that were generated while this span
	// was active. If set, allows implementation to detect missing child spans.
	ChildSpanCount *google_protobuf2.Int32Value `protobuf:"bytes,13,opt,name=child_span_count,json=childSpanCount" json:"child_span_count,omitempty"`
}

func (m *Span) Reset()                    { *m = Span{} }
func (m *Span) String() string            { return proto.CompactTextString(m) }
func (*Span) ProtoMessage()               {}
func (*Span) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Span) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Span) GetSpanId() string {
	if m != nil {
		return m.SpanId
	}
	return ""
}

func (m *Span) GetParentSpanId() string {
	if m != nil {
		return m.ParentSpanId
	}
	return ""
}

func (m *Span) GetDisplayName() *TruncatableString {
	if m != nil {
		return m.DisplayName
	}
	return nil
}

func (m *Span) GetStartTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Span) GetEndTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *Span) GetAttributes() *Span_Attributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Span) GetStackTrace() *StackTrace {
	if m != nil {
		return m.StackTrace
	}
	return nil
}

func (m *Span) GetTimeEvents() *Span_TimeEvents {
	if m != nil {
		return m.TimeEvents
	}
	return nil
}

func (m *Span) GetLinks() *Span_Links {
	if m != nil {
		return m.Links
	}
	return nil
}

func (m *Span) GetStatus() *google_rpc.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Span) GetSameProcessAsParentSpan() *google_protobuf2.BoolValue {
	if m != nil {
		return m.SameProcessAsParentSpan
	}
	return nil
}

func (m *Span) GetChildSpanCount() *google_protobuf2.Int32Value {
	if m != nil {
		return m.ChildSpanCount
	}
	return nil
}

// A set of attributes, each in the format `[KEY]:[VALUE]`.
type Span_Attributes struct {
	// The set of attributes. Each attribute's key can be up to 128 bytes
	// long. The value can be a string up to 256 bytes, an integer, or the
	// Boolean values `true` and `false`. For example:
	//
	//     "/instance_id": "my-instance"
	//     "/http/user_agent": ""
	//     "/http/request_bytes": 300
	//     "abc.com/myattribute": true
	AttributeMap map[string]*AttributeValue `protobuf:"bytes,1,rep,name=attribute_map,json=attributeMap" json:"attribute_map,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The number of attributes that were discarded. Attributes can be discarded
	// because their keys are too long or because there are too many attributes.
	// If this value is 0 then all attributes are valid.
	DroppedAttributesCount int32 `protobuf:"varint,2,opt,name=dropped_attributes_count,json=droppedAttributesCount" json:"dropped_attributes_count,omitempty"`
}

func (m *Span_Attributes) Reset()                    { *m = Span_Attributes{} }
func (m *Span_Attributes) String() string            { return proto.CompactTextString(m) }
func (*Span_Attributes) ProtoMessage()               {}
func (*Span_Attributes) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 0} }

func (m *Span_Attributes) GetAttributeMap() map[string]*AttributeValue {
	if m != nil {
		return m.AttributeMap
	}
	return nil
}

func (m *Span_Attributes) GetDroppedAttributesCount() int32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

// A time-stamped annotation or message event in the Span.
type Span_TimeEvent struct {
	// The timestamp indicating the time the event occurred.
	Time *google_protobuf1.Timestamp `protobuf:"bytes,1,opt,name=time" json:"time,omitempty"`
	// A `TimeEvent` can contain either an `Annotation` object or a
	// `MessageEvent` object, but not both.
	//
	// Types that are valid to be assigned to Value:
	//	*Span_TimeEvent_Annotation_
	//	*Span_TimeEvent_MessageEvent_
	Value isSpan_TimeEvent_Value `protobuf_oneof:"value"`
}

func (m *Span_TimeEvent) Reset()                    { *m = Span_TimeEvent{} }
func (m *Span_TimeEvent) String() string            { return proto.CompactTextString(m) }
func (*Span_TimeEvent) ProtoMessage()               {}
func (*Span_TimeEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 1} }

type isSpan_TimeEvent_Value interface {
	isSpan_TimeEvent_Value()
}

type Span_TimeEvent_Annotation_ struct {
	Annotation *Span_TimeEvent_Annotation `protobuf:"bytes,2,opt,name=annotation,oneof"`
}
type Span_TimeEvent_MessageEvent_ struct {
	MessageEvent *Span_TimeEvent_MessageEvent `protobuf:"bytes,3,opt,name=message_event,json=messageEvent,oneof"`
}

func (*Span_TimeEvent_Annotation_) isSpan_TimeEvent_Value()   {}
func (*Span_TimeEvent_MessageEvent_) isSpan_TimeEvent_Value() {}

func (m *Span_TimeEvent) GetValue() isSpan_TimeEvent_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Span_TimeEvent) GetTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *Span_TimeEvent) GetAnnotation() *Span_TimeEvent_Annotation {
	if x, ok := m.GetValue().(*Span_TimeEvent_Annotation_); ok {
		return x.Annotation
	}
	return nil
}

func (m *Span_TimeEvent) GetMessageEvent() *Span_TimeEvent_MessageEvent {
	if x, ok := m.GetValue().(*Span_TimeEvent_MessageEvent_); ok {
		return x.MessageEvent
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Span_TimeEvent) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Span_TimeEvent_OneofMarshaler, _Span_TimeEvent_OneofUnmarshaler, _Span_TimeEvent_OneofSizer, []interface{}{
		(*Span_TimeEvent_Annotation_)(nil),
		(*Span_TimeEvent_MessageEvent_)(nil),
	}
}

func _Span_TimeEvent_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Span_TimeEvent)
	// value
	switch x := m.Value.(type) {
	case *Span_TimeEvent_Annotation_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Annotation); err != nil {
			return err
		}
	case *Span_TimeEvent_MessageEvent_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MessageEvent); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Span_TimeEvent.Value has unexpected type %T", x)
	}
	return nil
}

func _Span_TimeEvent_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Span_TimeEvent)
	switch tag {
	case 2: // value.annotation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Span_TimeEvent_Annotation)
		err := b.DecodeMessage(msg)
		m.Value = &Span_TimeEvent_Annotation_{msg}
		return true, err
	case 3: // value.message_event
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Span_TimeEvent_MessageEvent)
		err := b.DecodeMessage(msg)
		m.Value = &Span_TimeEvent_MessageEvent_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Span_TimeEvent_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Span_TimeEvent)
	// value
	switch x := m.Value.(type) {
	case *Span_TimeEvent_Annotation_:
		s := proto.Size(x.Annotation)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Span_TimeEvent_MessageEvent_:
		s := proto.Size(x.MessageEvent)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Text annotation with a set of attributes.
type Span_TimeEvent_Annotation struct {
	// A user-supplied message describing the event. The maximum length for
	// the description is 256 bytes.
	Description *TruncatableString `protobuf:"bytes,1,opt,name=description" json:"description,omitempty"`
	// A set of attributes on the annotation. There is a limit of 4 attributes
	// per Annotation.
	Attributes *Span_Attributes `protobuf:"bytes,2,opt,name=attributes" json:"attributes,omitempty"`
}

func (m *Span_TimeEvent_Annotation) Reset()                    { *m = Span_TimeEvent_Annotation{} }
func (m *Span_TimeEvent_Annotation) String() string            { return proto.CompactTextString(m) }
func (*Span_TimeEvent_Annotation) ProtoMessage()               {}
func (*Span_TimeEvent_Annotation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 1, 0} }

func (m *Span_TimeEvent_Annotation) GetDescription() *TruncatableString {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *Span_TimeEvent_Annotation) GetAttributes() *Span_Attributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// An event describing a message sent/received between Spans.
type Span_TimeEvent_MessageEvent struct {
	// Type of MessageEvent. Indicates whether the message was sent or
	// received.
	Type Span_TimeEvent_MessageEvent_Type `protobuf:"varint,1,opt,name=type,enum=google.devtools.cloudtrace.v2.Span_TimeEvent_MessageEvent_Type" json:"type,omitempty"`
	// An identifier for the MessageEvent's message that can be used to match
	// SENT and RECEIVED MessageEvents. It is recommended to be unique within
	// a Span.
	Id int64 `protobuf:"varint,2,opt,name=id" json:"id,omitempty"`
	// The number of uncompressed bytes sent or received.
	UncompressedSizeBytes int64 `protobuf:"varint,3,opt,name=uncompressed_size_bytes,json=uncompressedSizeBytes" json:"uncompressed_size_bytes,omitempty"`
	// The number of compressed bytes sent or received. If missing assumed to
	// be the same size as uncompressed.
	CompressedSizeBytes int64 `protobuf:"varint,4,opt,name=compressed_size_bytes,json=compressedSizeBytes" json:"compressed_size_bytes,omitempty"`
}

func (m *Span_TimeEvent_MessageEvent) Reset()         { *m = Span_TimeEvent_MessageEvent{} }
func (m *Span_TimeEvent_MessageEvent) String() string { return proto.CompactTextString(m) }
func (*Span_TimeEvent_MessageEvent) ProtoMessage()    {}
func (*Span_TimeEvent_MessageEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{0, 1, 1}
}

func (m *Span_TimeEvent_MessageEvent) GetType() Span_TimeEvent_MessageEvent_Type {
	if m != nil {
		return m.Type
	}
	return Span_TimeEvent_MessageEvent_TYPE_UNSPECIFIED
}

func (m *Span_TimeEvent_MessageEvent) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Span_TimeEvent_MessageEvent) GetUncompressedSizeBytes() int64 {
	if m != nil {
		return m.UncompressedSizeBytes
	}
	return 0
}

func (m *Span_TimeEvent_MessageEvent) GetCompressedSizeBytes() int64 {
	if m != nil {
		return m.CompressedSizeBytes
	}
	return 0
}

// A collection of `TimeEvent`s. A `TimeEvent` is a time-stamped annotation
// on the span, consisting of either user-supplied key:value pairs, or
// details of a message sent/received between Spans.
type Span_TimeEvents struct {
	// A collection of `TimeEvent`s.
	TimeEvent []*Span_TimeEvent `protobuf:"bytes,1,rep,name=time_event,json=timeEvent" json:"time_event,omitempty"`
	// The number of dropped annotations in all the included time events.
	// If the value is 0, then no annotations were dropped.
	DroppedAnnotationsCount int32 `protobuf:"varint,2,opt,name=dropped_annotations_count,json=droppedAnnotationsCount" json:"dropped_annotations_count,omitempty"`
	// The number of dropped message events in all the included time events.
	// If the value is 0, then no message events were dropped.
	DroppedMessageEventsCount int32 `protobuf:"varint,3,opt,name=dropped_message_events_count,json=droppedMessageEventsCount" json:"dropped_message_events_count,omitempty"`
}

func (m *Span_TimeEvents) Reset()                    { *m = Span_TimeEvents{} }
func (m *Span_TimeEvents) String() string            { return proto.CompactTextString(m) }
func (*Span_TimeEvents) ProtoMessage()               {}
func (*Span_TimeEvents) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 2} }

func (m *Span_TimeEvents) GetTimeEvent() []*Span_TimeEvent {
	if m != nil {
		return m.TimeEvent
	}
	return nil
}

func (m *Span_TimeEvents) GetDroppedAnnotationsCount() int32 {
	if m != nil {
		return m.DroppedAnnotationsCount
	}
	return 0
}

func (m *Span_TimeEvents) GetDroppedMessageEventsCount() int32 {
	if m != nil {
		return m.DroppedMessageEventsCount
	}
	return 0
}

// A pointer from the current span to another span in the same trace or in a
// different trace. For example, this can be used in batching operations,
// where a single batch handler processes multiple requests from different
// traces or when the handler receives a request from a different project.
type Span_Link struct {
	// `TRACE_ID` identifies a trace within a project.
	TraceId string `protobuf:"bytes,1,opt,name=trace_id,json=traceId" json:"trace_id,omitempty"`
	// `SPAN_ID` identifies a span within a trace.
	SpanId string `protobuf:"bytes,2,opt,name=span_id,json=spanId" json:"span_id,omitempty"`
	// The relationship of the current span relative to the linked span.
	Type Span_Link_Type `protobuf:"varint,3,opt,name=type,enum=google.devtools.cloudtrace.v2.Span_Link_Type" json:"type,omitempty"`
	// A set of attributes on the link. There is a limit of 32 attributes per
	// link.
	Attributes *Span_Attributes `protobuf:"bytes,4,opt,name=attributes" json:"attributes,omitempty"`
}

func (m *Span_Link) Reset()                    { *m = Span_Link{} }
func (m *Span_Link) String() string            { return proto.CompactTextString(m) }
func (*Span_Link) ProtoMessage()               {}
func (*Span_Link) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 3} }

func (m *Span_Link) GetTraceId() string {
	if m != nil {
		return m.TraceId
	}
	return ""
}

func (m *Span_Link) GetSpanId() string {
	if m != nil {
		return m.SpanId
	}
	return ""
}

func (m *Span_Link) GetType() Span_Link_Type {
	if m != nil {
		return m.Type
	}
	return Span_Link_TYPE_UNSPECIFIED
}

func (m *Span_Link) GetAttributes() *Span_Attributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// A collection of links, which are references from this span to a span
// in the same or different trace.
type Span_Links struct {
	// A collection of links.
	Link []*Span_Link `protobuf:"bytes,1,rep,name=link" json:"link,omitempty"`
	// The number of dropped links after the maximum size was enforced. If
	// this value is 0, then no links were dropped.
	DroppedLinksCount int32 `protobuf:"varint,2,opt,name=dropped_links_count,json=droppedLinksCount" json:"dropped_links_count,omitempty"`
}

func (m *Span_Links) Reset()                    { *m = Span_Links{} }
func (m *Span_Links) String() string            { return proto.CompactTextString(m) }
func (*Span_Links) ProtoMessage()               {}
func (*Span_Links) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 4} }

func (m *Span_Links) GetLink() []*Span_Link {
	if m != nil {
		return m.Link
	}
	return nil
}

func (m *Span_Links) GetDroppedLinksCount() int32 {
	if m != nil {
		return m.DroppedLinksCount
	}
	return 0
}

// The allowed types for [VALUE] in a `[KEY]:[VALUE]` attribute.
type AttributeValue struct {
	// The type of the value.
	//
	// Types that are valid to be assigned to Value:
	//	*AttributeValue_StringValue
	//	*AttributeValue_IntValue
	//	*AttributeValue_BoolValue
	Value isAttributeValue_Value `protobuf_oneof:"value"`
}

func (m *AttributeValue) Reset()                    { *m = AttributeValue{} }
func (m *AttributeValue) String() string            { return proto.CompactTextString(m) }
func (*AttributeValue) ProtoMessage()               {}
func (*AttributeValue) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type isAttributeValue_Value interface {
	isAttributeValue_Value()
}

type AttributeValue_StringValue struct {
	StringValue *TruncatableString `protobuf:"bytes,1,opt,name=string_value,json=stringValue,oneof"`
}
type AttributeValue_IntValue struct {
	IntValue int64 `protobuf:"varint,2,opt,name=int_value,json=intValue,oneof"`
}
type AttributeValue_BoolValue struct {
	BoolValue bool `protobuf:"varint,3,opt,name=bool_value,json=boolValue,oneof"`
}

func (*AttributeValue_StringValue) isAttributeValue_Value() {}
func (*AttributeValue_IntValue) isAttributeValue_Value()    {}
func (*AttributeValue_BoolValue) isAttributeValue_Value()   {}

func (m *AttributeValue) GetValue() isAttributeValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *AttributeValue) GetStringValue() *TruncatableString {
	if x, ok := m.GetValue().(*AttributeValue_StringValue); ok {
		return x.StringValue
	}
	return nil
}

func (m *AttributeValue) GetIntValue() int64 {
	if x, ok := m.GetValue().(*AttributeValue_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (m *AttributeValue) GetBoolValue() bool {
	if x, ok := m.GetValue().(*AttributeValue_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AttributeValue) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AttributeValue_OneofMarshaler, _AttributeValue_OneofUnmarshaler, _AttributeValue_OneofSizer, []interface{}{
		(*AttributeValue_StringValue)(nil),
		(*AttributeValue_IntValue)(nil),
		(*AttributeValue_BoolValue)(nil),
	}
}

func _AttributeValue_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AttributeValue)
	// value
	switch x := m.Value.(type) {
	case *AttributeValue_StringValue:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StringValue); err != nil {
			return err
		}
	case *AttributeValue_IntValue:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IntValue))
	case *AttributeValue_BoolValue:
		t := uint64(0)
		if x.BoolValue {
			t = 1
		}
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("AttributeValue.Value has unexpected type %T", x)
	}
	return nil
}

func _AttributeValue_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AttributeValue)
	switch tag {
	case 1: // value.string_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TruncatableString)
		err := b.DecodeMessage(msg)
		m.Value = &AttributeValue_StringValue{msg}
		return true, err
	case 2: // value.int_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &AttributeValue_IntValue{int64(x)}
		return true, err
	case 3: // value.bool_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &AttributeValue_BoolValue{x != 0}
		return true, err
	default:
		return false, nil
	}
}

func _AttributeValue_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AttributeValue)
	// value
	switch x := m.Value.(type) {
	case *AttributeValue_StringValue:
		s := proto.Size(x.StringValue)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AttributeValue_IntValue:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.IntValue))
	case *AttributeValue_BoolValue:
		n += proto.SizeVarint(3<<3 | proto.WireVarint)
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A call stack appearing in a trace.
type StackTrace struct {
	// Stack frames in this stack trace. A maximum of 128 frames are allowed.
	StackFrames *StackTrace_StackFrames `protobuf:"bytes,1,opt,name=stack_frames,json=stackFrames" json:"stack_frames,omitempty"`
	// The hash ID is used to conserve network bandwidth for duplicate
	// stack traces within a single trace.
	//
	// Often multiple spans will have identical stack traces.
	// The first occurrence of a stack trace should contain both the
	// `stackFrame` content and a value in `stackTraceHashId`.
	//
	// Subsequent spans within the same request can refer
	// to that stack trace by only setting `stackTraceHashId`.
	StackTraceHashId int64 `protobuf:"varint,2,opt,name=stack_trace_hash_id,json=stackTraceHashId" json:"stack_trace_hash_id,omitempty"`
}

func (m *StackTrace) Reset()                    { *m = StackTrace{} }
func (m *StackTrace) String() string            { return proto.CompactTextString(m) }
func (*StackTrace) ProtoMessage()               {}
func (*StackTrace) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *StackTrace) GetStackFrames() *StackTrace_StackFrames {
	if m != nil {
		return m.StackFrames
	}
	return nil
}

func (m *StackTrace) GetStackTraceHashId() int64 {
	if m != nil {
		return m.StackTraceHashId
	}
	return 0
}

// Represents a single stack frame in a stack trace.
type StackTrace_StackFrame struct {
	// The fully-qualified name that uniquely identifies the function or
	// method that is active in this frame (up to 1024 bytes).
	FunctionName *TruncatableString `protobuf:"bytes,1,opt,name=function_name,json=functionName" json:"function_name,omitempty"`
	// An un-mangled function name, if `function_name` is
	// [mangled](http://www.avabodh.com/cxxin/namemangling.html). The name can
	// be fully-qualified (up to 1024 bytes).
	OriginalFunctionName *TruncatableString `protobuf:"bytes,2,opt,name=original_function_name,json=originalFunctionName" json:"original_function_name,omitempty"`
	// The name of the source file where the function call appears (up to 256
	// bytes).
	FileName *TruncatableString `protobuf:"bytes,3,opt,name=file_name,json=fileName" json:"file_name,omitempty"`
	// The line number in `file_name` where the function call appears.
	LineNumber int64 `protobuf:"varint,4,opt,name=line_number,json=lineNumber" json:"line_number,omitempty"`
	// The column number where the function call appears, if available.
	// This is important in JavaScript because of its anonymous functions.
	ColumnNumber int64 `protobuf:"varint,5,opt,name=column_number,json=columnNumber" json:"column_number,omitempty"`
	// The binary module from where the code was loaded.
	LoadModule *Module `protobuf:"bytes,6,opt,name=load_module,json=loadModule" json:"load_module,omitempty"`
	// The version of the deployed source code (up to 128 bytes).
	SourceVersion *TruncatableString `protobuf:"bytes,7,opt,name=source_version,json=sourceVersion" json:"source_version,omitempty"`
}

func (m *StackTrace_StackFrame) Reset()                    { *m = StackTrace_StackFrame{} }
func (m *StackTrace_StackFrame) String() string            { return proto.CompactTextString(m) }
func (*StackTrace_StackFrame) ProtoMessage()               {}
func (*StackTrace_StackFrame) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 0} }

func (m *StackTrace_StackFrame) GetFunctionName() *TruncatableString {
	if m != nil {
		return m.FunctionName
	}
	return nil
}

func (m *StackTrace_StackFrame) GetOriginalFunctionName() *TruncatableString {
	if m != nil {
		return m.OriginalFunctionName
	}
	return nil
}

func (m *StackTrace_StackFrame) GetFileName() *TruncatableString {
	if m != nil {
		return m.FileName
	}
	return nil
}

func (m *StackTrace_StackFrame) GetLineNumber() int64 {
	if m != nil {
		return m.LineNumber
	}
	return 0
}

func (m *StackTrace_StackFrame) GetColumnNumber() int64 {
	if m != nil {
		return m.ColumnNumber
	}
	return 0
}

func (m *StackTrace_StackFrame) GetLoadModule() *Module {
	if m != nil {
		return m.LoadModule
	}
	return nil
}

func (m *StackTrace_StackFrame) GetSourceVersion() *TruncatableString {
	if m != nil {
		return m.SourceVersion
	}
	return nil
}

// A collection of stack frames, which can be truncated.
type StackTrace_StackFrames struct {
	// Stack frames in this call stack.
	Frame []*StackTrace_StackFrame `protobuf:"bytes,1,rep,name=frame" json:"frame,omitempty"`
	// The number of stack frames that were dropped because there
	// were too many stack frames.
	// If this value is 0, then no stack frames were dropped.
	DroppedFramesCount int32 `protobuf:"varint,2,opt,name=dropped_frames_count,json=droppedFramesCount" json:"dropped_frames_count,omitempty"`
}

func (m *StackTrace_StackFrames) Reset()                    { *m = StackTrace_StackFrames{} }
func (m *StackTrace_StackFrames) String() string            { return proto.CompactTextString(m) }
func (*StackTrace_StackFrames) ProtoMessage()               {}
func (*StackTrace_StackFrames) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 1} }

func (m *StackTrace_StackFrames) GetFrame() []*StackTrace_StackFrame {
	if m != nil {
		return m.Frame
	}
	return nil
}

func (m *StackTrace_StackFrames) GetDroppedFramesCount() int32 {
	if m != nil {
		return m.DroppedFramesCount
	}
	return 0
}

// Binary module.
type Module struct {
	// For example: main binary, kernel modules, and dynamic libraries
	// such as libc.so, sharedlib.so (up to 256 bytes).
	Module *TruncatableString `protobuf:"bytes,1,opt,name=module" json:"module,omitempty"`
	// A unique identifier for the module, usually a hash of its
	// contents (up to 128 bytes).
	BuildId *TruncatableString `protobuf:"bytes,2,opt,name=build_id,json=buildId" json:"build_id,omitempty"`
}

func (m *Module) Reset()                    { *m = Module{} }
func (m *Module) String() string            { return proto.CompactTextString(m) }
func (*Module) ProtoMessage()               {}
func (*Module) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Module) GetModule() *TruncatableString {
	if m != nil {
		return m.Module
	}
	return nil
}

func (m *Module) GetBuildId() *TruncatableString {
	if m != nil {
		return m.BuildId
	}
	return nil
}

// Represents a string that might be shortened to a specified length.
type TruncatableString struct {
	// The shortened string. For example, if the original string was 500
	// bytes long and the limit of the string was 128 bytes, then this
	// value contains the first 128 bytes of the 500-byte string. Note that
	// truncation always happens on the character boundary, to ensure that
	// truncated string is still valid UTF8. In case of multi-byte characters,
	// size of truncated string can be less than truncation limit.
	Value string `protobuf:"bytes,1,opt,name=value" json:"value,omitempty"`
	// The number of bytes removed from the original string. If this
	// value is 0, then the string was not shortened.
	TruncatedByteCount int32 `protobuf:"varint,2,opt,name=truncated_byte_count,json=truncatedByteCount" json:"truncated_byte_count,omitempty"`
}

func (m *TruncatableString) Reset()                    { *m = TruncatableString{} }
func (m *TruncatableString) String() string            { return proto.CompactTextString(m) }
func (*TruncatableString) ProtoMessage()               {}
func (*TruncatableString) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *TruncatableString) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *TruncatableString) GetTruncatedByteCount() int32 {
	if m != nil {
		return m.TruncatedByteCount
	}
	return 0
}

func init() {
	proto.RegisterType((*Span)(nil), "google.devtools.cloudtrace.v2.Span")
	proto.RegisterType((*Span_Attributes)(nil), "google.devtools.cloudtrace.v2.Span.Attributes")
	proto.RegisterType((*Span_TimeEvent)(nil), "google.devtools.cloudtrace.v2.Span.TimeEvent")
	proto.RegisterType((*Span_TimeEvent_Annotation)(nil), "google.devtools.cloudtrace.v2.Span.TimeEvent.Annotation")
	proto.RegisterType((*Span_TimeEvent_MessageEvent)(nil), "google.devtools.cloudtrace.v2.Span.TimeEvent.MessageEvent")
	proto.RegisterType((*Span_TimeEvents)(nil), "google.devtools.cloudtrace.v2.Span.TimeEvents")
	proto.RegisterType((*Span_Link)(nil), "google.devtools.cloudtrace.v2.Span.Link")
	proto.RegisterType((*Span_Links)(nil), "google.devtools.cloudtrace.v2.Span.Links")
	proto.RegisterType((*AttributeValue)(nil), "google.devtools.cloudtrace.v2.AttributeValue")
	proto.RegisterType((*StackTrace)(nil), "google.devtools.cloudtrace.v2.StackTrace")
	proto.RegisterType((*StackTrace_StackFrame)(nil), "google.devtools.cloudtrace.v2.StackTrace.StackFrame")
	proto.RegisterType((*StackTrace_StackFrames)(nil), "google.devtools.cloudtrace.v2.StackTrace.StackFrames")
	proto.RegisterType((*Module)(nil), "google.devtools.cloudtrace.v2.Module")
	proto.RegisterType((*TruncatableString)(nil), "google.devtools.cloudtrace.v2.TruncatableString")
	proto.RegisterEnum("google.devtools.cloudtrace.v2.Span_TimeEvent_MessageEvent_Type", Span_TimeEvent_MessageEvent_Type_name, Span_TimeEvent_MessageEvent_Type_value)
	proto.RegisterEnum("google.devtools.cloudtrace.v2.Span_Link_Type", Span_Link_Type_name, Span_Link_Type_value)
}

func init() { proto.RegisterFile("google/devtools/cloudtrace/v2/trace.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1412 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x57, 0x49, 0x6f, 0xdb, 0xc6,
	0x17, 0x37, 0xb5, 0xeb, 0x49, 0x36, 0xe4, 0x89, 0x1d, 0x2b, 0x4a, 0xf2, 0x4f, 0xfe, 0x6e, 0x0b,
	0x38, 0x05, 0x4c, 0x05, 0x4a, 0x52, 0xa4, 0x69, 0x81, 0xd4, 0x8b, 0x1c, 0x29, 0xb1, 0x55, 0x81,
	0x52, 0xdc, 0x34, 0x3d, 0x10, 0x23, 0x72, 0x2c, 0x13, 0xa1, 0x48, 0x82, 0x33, 0x74, 0xe1, 0xdc,
	0x7a, 0xee, 0xad, 0x40, 0x2f, 0x05, 0x8a, 0x1e, 0x0b, 0xf4, 0x94, 0x4f, 0xd2, 0x6b, 0xbf, 0x4b,
	0x4f, 0xc5, 0x2c, 0x24, 0xa5, 0x2c, 0x5e, 0x94, 0xdb, 0xcc, 0xbc, 0xf7, 0xfb, 0xf1, 0xbd, 0x99,
	0xb7, 0x11, 0xee, 0x8c, 0x7d, 0x7f, 0xec, 0x92, 0xa6, 0x4d, 0x4e, 0x98, 0xef, 0xbb, 0xb4, 0x69,
	0xb9, 0x7e, 0x64, 0xb3, 0x10, 0x5b, 0xa4, 0x79, 0xd2, 0x6a, 0x8a, 0x85, 0x1e, 0x84, 0x3e, 0xf3,
	0xd1, 0x4d, 0xa9, 0xaa, 0xc7, 0xaa, 0x7a, 0xaa, 0xaa, 0x9f, 0xb4, 0x1a, 0x37, 0x14, 0x13, 0x0e,
	0x9c, 0x26, 0xf6, 0x3c, 0x9f, 0x61, 0xe6, 0xf8, 0x1e, 0x95, 0xe0, 0xc6, 0x2d, 0x25, 0x15, 0xbb,
	0x51, 0x74, 0xd4, 0x64, 0xce, 0x84, 0x50, 0x86, 0x27, 0x81, 0x52, 0xf8, 0xdf, 0xdb, 0x0a, 0x3f,
	0x86, 0x38, 0x08, 0x48, 0x18, 0x13, 0xac, 0x29, 0x79, 0x18, 0x58, 0x4d, 0xca, 0x30, 0x8b, 0x94,
	0x60, 0xfd, 0x5f, 0x04, 0xb9, 0x41, 0x80, 0x3d, 0x84, 0x20, 0xe7, 0xe1, 0x09, 0xa9, 0x6b, 0xb7,
	0xb5, 0x8d, 0xb2, 0x21, 0xd6, 0x68, 0x0d, 0x8a, 0x34, 0xc0, 0x9e, 0xe9, 0xd8, 0xf5, 0x8c, 0x38,
	0x2e, 0xf0, 0x6d, 0xd7, 0x46, 0x9f, 0xc2, 0x52, 0x80, 0x43, 0xe2, 0x31, 0x33, 0x96, 0x67, 0x85,
	0xbc, 0x2a, 0x4f, 0x07, 0x52, 0x6b, 0x00, 0x55, 0xdb, 0xa1, 0x81, 0x8b, 0x4f, 0x4d, 0x41, 0x9d,
	0xbb, 0xad, 0x6d, 0x54, 0x5a, 0x77, 0xf5, 0x33, 0x6f, 0x42, 0x1f, 0x86, 0x91, 0x67, 0x61, 0x86,
	0x47, 0x2e, 0x19, 0xb0, 0xd0, 0xf1, 0xc6, 0x46, 0x45, 0xb1, 0xf4, 0xb8, 0x4d, 0x5f, 0x02, 0x50,
	0x86, 0x43, 0x66, 0xf2, 0x2b, 0xa8, 0xe7, 0x05, 0x65, 0x23, 0xa6, 0x8c, 0xdd, 0xd7, 0x87, 0xf1,
	0xfd, 0x18, 0x65, 0xa1, 0xcd, 0xf7, 0xe8, 0x01, 0x94, 0x88, 0x67, 0x4b, 0x60, 0xe1, 0x5c, 0x60,
	0x91, 0x78, 0xb6, 0x80, 0xf5, 0x00, 0x30, 0x63, 0xa1, 0x33, 0x8a, 0x18, 0xa1, 0xf5, 0xa2, 0x00,
	0xea, 0xe7, 0x38, 0xc1, 0x6f, 0x40, 0xdf, 0x4a, 0x50, 0xc6, 0x14, 0x03, 0x7a, 0x0a, 0x15, 0xca,
	0xb0, 0xf5, 0xca, 0x14, 0xda, 0xf5, 0x92, 0x20, 0xbc, 0x73, 0x1e, 0x21, 0x47, 0x0c, 0xf9, 0xce,
	0x00, 0x9a, 0xac, 0xd1, 0xb7, 0x50, 0xe1, 0xee, 0x98, 0xe4, 0x84, 0x78, 0x8c, 0xd6, 0xcb, 0x17,
	0x37, 0x8e, 0xbb, 0xd6, 0x16, 0x28, 0x03, 0x58, 0xb2, 0x46, 0x8f, 0x21, 0xef, 0x3a, 0xde, 0x2b,
	0x5a, 0x87, 0x8b, 0x99, 0xc5, 0xa9, 0xf6, 0x39, 0xc0, 0x90, 0x38, 0xf4, 0x39, 0x14, 0x64, 0x80,
	0xd5, 0x2b, 0x82, 0x01, 0xc5, 0x0c, 0x61, 0x60, 0x71, 0x2f, 0x58, 0x44, 0x0d, 0xa5, 0x81, 0x5e,
	0xc0, 0x75, 0x8a, 0x27, 0xc4, 0x0c, 0x42, 0xdf, 0x22, 0x94, 0x9a, 0x98, 0x9a, 0x53, 0x61, 0x55,
	0xaf, 0x7e, 0xe0, 0x8d, 0xb6, 0x7d, 0xdf, 0x3d, 0xc4, 0x6e, 0x44, 0x8c, 0x35, 0x0e, 0xef, 0x4b,
	0xf4, 0x16, 0xed, 0x27, 0xc1, 0x87, 0xda, 0x50, 0xb3, 0x8e, 0x1d, 0xd7, 0x96, 0xf1, 0x69, 0xf9,
	0x91, 0xc7, 0xea, 0x8b, 0x82, 0xee, 0xfa, 0x3b, 0x74, 0x5d, 0x8f, 0xdd, 0x6b, 0x49, 0xbe, 0x25,
	0x01, 0xe2, 0x0c, 0x3b, 0x1c, 0xd2, 0xf8, 0x3d, 0x03, 0x90, 0xbe, 0x22, 0x22, 0xb0, 0x98, 0xbc,
	0xa3, 0x39, 0xc1, 0x41, 0x5d, 0xbb, 0x9d, 0xdd, 0xa8, 0xb4, 0xbe, 0xb9, 0x5c, 0x30, 0xa4, 0xcb,
	0x03, 0x1c, 0xb4, 0x3d, 0x16, 0x9e, 0x1a, 0x55, 0x3c, 0x75, 0x84, 0x1e, 0x42, 0xdd, 0x0e, 0xfd,
	0x20, 0x20, 0xb6, 0x99, 0x86, 0x8d, 0x72, 0x82, 0xe7, 0x61, 0xde, 0xb8, 0xaa, 0xe4, 0x29, 0xa9,
	0xb4, 0xd7, 0x83, 0xe5, 0x77, 0xc8, 0x51, 0x0d, 0xb2, 0xaf, 0xc8, 0xa9, 0x4a, 0x6c, 0xbe, 0x44,
	0x3b, 0x90, 0x3f, 0xe1, 0xfe, 0x0a, 0xb6, 0x4a, 0x6b, 0xf3, 0x1c, 0xfb, 0x13, 0x4a, 0x79, 0x49,
	0x12, 0xfb, 0x28, 0xf3, 0x50, 0x6b, 0xfc, 0x9d, 0x87, 0x72, 0x12, 0x48, 0x48, 0x87, 0x9c, 0xc8,
	0x2d, 0xed, 0xdc, 0xdc, 0x12, 0x7a, 0xe8, 0x25, 0x40, 0x5a, 0xea, 0x94, 0x2d, 0x0f, 0x2f, 0x15,
	0xbb, 0xfa, 0x56, 0x82, 0xef, 0x2c, 0x18, 0x53, 0x6c, 0x08, 0xc3, 0xe2, 0x84, 0x50, 0x8a, 0xc7,
	0x2a, 0x37, 0x44, 0x81, 0xaa, 0xb4, 0x1e, 0x5d, 0x8e, 0xfe, 0x40, 0x52, 0x88, 0x4d, 0x67, 0xc1,
	0xa8, 0x4e, 0xa6, 0xf6, 0x8d, 0x37, 0x1a, 0x40, 0xfa, 0x7d, 0x64, 0x40, 0xc5, 0x26, 0xd4, 0x0a,
	0x9d, 0x40, 0xb8, 0xa3, 0xcd, 0x5d, 0xec, 0x52, 0x92, 0xb7, 0x4a, 0x4f, 0xe6, 0x63, 0x4b, 0x4f,
	0xe3, 0xd7, 0x0c, 0x54, 0xa7, 0x7d, 0x42, 0x03, 0xc8, 0xb1, 0xd3, 0x40, 0x3e, 0xd9, 0x52, 0xeb,
	0xf1, 0xfc, 0xb7, 0xa3, 0x0f, 0x4f, 0x03, 0x62, 0x08, 0x32, 0xb4, 0x04, 0x19, 0xd5, 0x31, 0xb2,
	0x46, 0xc6, 0xb1, 0xd1, 0x17, 0xb0, 0x16, 0x79, 0x96, 0x3f, 0x09, 0x42, 0x42, 0x29, 0xb1, 0x4d,
	0xea, 0xbc, 0x26, 0xe6, 0xe8, 0x94, 0xbb, 0x94, 0x15, 0x4a, 0xab, 0xd3, 0xe2, 0x81, 0xf3, 0x9a,
	0x6c, 0x73, 0x21, 0x6a, 0xc1, 0xea, 0xfb, 0x51, 0x39, 0x81, 0xba, 0xf2, 0x1e, 0xcc, 0xfa, 0x7d,
	0xc8, 0x71, 0x4b, 0xd0, 0x0a, 0xd4, 0x86, 0xdf, 0xf7, 0xdb, 0xe6, 0xf3, 0xde, 0xa0, 0xdf, 0xde,
	0xe9, 0xee, 0x75, 0xdb, 0xbb, 0xb5, 0x05, 0x54, 0x82, 0xdc, 0xa0, 0xdd, 0x1b, 0xd6, 0x34, 0x54,
	0x85, 0x92, 0xd1, 0xde, 0x69, 0x77, 0x0f, 0xdb, 0xbb, 0xb5, 0xcc, 0x76, 0x51, 0x25, 0x44, 0xe3,
	0x1f, 0x0d, 0x20, 0xad, 0x8c, 0x68, 0x1f, 0x20, 0x2d, 0xaf, 0x2a, 0xdb, 0x37, 0x2f, 0x75, 0x49,
	0x46, 0x39, 0x29, 0xae, 0xe8, 0x11, 0x5c, 0x4b, 0xf2, 0x3a, 0x6d, 0xf1, 0x33, 0x89, 0xbd, 0x16,
	0x27, 0x76, 0x2a, 0x17, 0x99, 0x8d, 0x1e, 0xc3, 0x8d, 0x18, 0x3b, 0x13, 0xd7, 0x31, 0x3c, 0x2b,
	0xe0, 0x31, 0xff, 0xf4, 0xcb, 0xa8, 0xd2, 0xf0, 0x5b, 0x06, 0x72, 0xbc, 0x50, 0xa3, 0x6b, 0x50,
	0x12, 0xb6, 0xf2, 0xae, 0x2d, 0x6b, 0x42, 0x51, 0xec, 0xbb, 0xf6, 0x87, 0xfb, 0xfd, 0x96, 0x0a,
	0x93, 0xac, 0x08, 0x93, 0xcd, 0x8b, 0x36, 0x85, 0xe9, 0xa0, 0x98, 0x0d, 0xe5, 0xdc, 0xc7, 0x86,
	0xf2, 0xfa, 0xb3, 0x33, 0x1f, 0x7a, 0x15, 0x96, 0x77, 0x3a, 0xdd, 0xfd, 0x5d, 0x73, 0xbf, 0xdb,
	0x7b, 0xd6, 0xde, 0x35, 0x07, 0xfd, 0xad, 0x5e, 0x4d, 0x43, 0x57, 0x01, 0xf5, 0xb7, 0x8c, 0x76,
	0x6f, 0x38, 0x73, 0x9e, 0x69, 0x44, 0x90, 0x17, 0x4d, 0x0c, 0x7d, 0x0d, 0x39, 0xde, 0xc6, 0xd4,
	0x53, 0x6f, 0x5c, 0xd4, 0x51, 0x43, 0xa0, 0x90, 0x0e, 0x57, 0xe2, 0x47, 0x12, 0xcd, 0x70, 0xe6,
	0x69, 0x97, 0x95, 0x48, 0x7c, 0x48, 0xbc, 0xc9, 0xfa, 0x1b, 0x0d, 0x96, 0x66, 0x8b, 0x2b, 0x7a,
	0x0e, 0x55, 0x2a, 0x0a, 0x81, 0x29, 0x2b, 0xf4, 0x9c, 0x65, 0xa4, 0xb3, 0x60, 0x54, 0x24, 0x8f,
	0xa4, 0xbd, 0x09, 0x65, 0xc7, 0x63, 0x66, 0x5a, 0xf5, 0xb3, 0x9d, 0x05, 0xa3, 0xe4, 0x78, 0x4c,
	0x8a, 0x6f, 0x01, 0x8c, 0x7c, 0xdf, 0x55, 0x72, 0xfe, 0xca, 0xa5, 0xce, 0x82, 0x51, 0x1e, 0xc5,
	0x8d, 0x36, 0x49, 0x90, 0xf5, 0x3f, 0x0b, 0x00, 0xe9, 0x2c, 0x82, 0x5e, 0x70, 0x73, 0xf9, 0x2c,
	0x73, 0x14, 0xe2, 0x09, 0xa1, 0xca, 0xdc, 0x07, 0x17, 0x1e, 0x66, 0xe4, 0x72, 0x4f, 0x80, 0x0d,
	0x39, 0x16, 0xc9, 0x0d, 0xda, 0x84, 0x2b, 0x53, 0x53, 0x92, 0x79, 0x8c, 0xe9, 0xb1, 0x99, 0x54,
	0x95, 0x5a, 0x3a, 0x02, 0x75, 0x30, 0x3d, 0xee, 0xda, 0x8d, 0x9f, 0x72, 0xca, 0x2e, 0x01, 0x47,
	0xcf, 0x61, 0xf1, 0x28, 0xf2, 0x2c, 0x9e, 0x40, 0x66, 0x32, 0xd6, 0xce, 0x53, 0x8e, 0xab, 0x31,
	0x8d, 0x18, 0x3e, 0x8f, 0xe0, 0xaa, 0x1f, 0x3a, 0x63, 0xc7, 0xc3, 0xae, 0x39, 0xcb, 0x9f, 0x99,
	0x93, 0x7f, 0x25, 0xe6, 0xdb, 0x9b, 0xfe, 0xce, 0x01, 0x94, 0x8f, 0x1c, 0x97, 0x48, 0xea, 0xec,
	0x9c, 0xd4, 0x25, 0x4e, 0x21, 0xe8, 0x6e, 0x41, 0xc5, 0x75, 0x3c, 0x62, 0x7a, 0xd1, 0x64, 0x44,
	0x42, 0x55, 0x3e, 0x81, 0x1f, 0xf5, 0xc4, 0x09, 0xfa, 0x04, 0x16, 0x2d, 0xdf, 0x8d, 0x26, 0x5e,
	0xac, 0x92, 0x17, 0x2a, 0x55, 0x79, 0xa8, 0x94, 0xf6, 0xa0, 0xe2, 0xfa, 0xd8, 0x36, 0x27, 0xbe,
	0x1d, 0xb9, 0xf1, 0x04, 0xfd, 0xd9, 0x39, 0x66, 0x1d, 0x08, 0x65, 0x03, 0x38, 0x52, 0xae, 0xd1,
	0x77, 0xb0, 0x44, 0xfd, 0x28, 0xb4, 0x88, 0x79, 0x42, 0x42, 0xca, 0x7b, 0x65, 0x71, 0x4e, 0x0f,
	0x17, 0x25, 0xcf, 0xa1, 0xa4, 0x69, 0xfc, 0xac, 0x41, 0x65, 0x2a, 0x9e, 0xd0, 0x53, 0xc8, 0x8b,
	0xb0, 0x54, 0xd9, 0x7c, 0x7f, 0x9e, 0xa8, 0x34, 0x24, 0x05, 0xba, 0x0b, 0x2b, 0x71, 0x6a, 0xcb,
	0x50, 0x9f, 0xc9, 0x6d, 0xa4, 0x64, 0xf2, 0xc3, 0x32, 0xb9, 0xff, 0xd0, 0xa0, 0xa0, 0x3c, 0xee,
	0x40, 0x41, 0x5d, 0xda, 0xbc, 0x61, 0xa8, 0xf0, 0xe8, 0x19, 0x94, 0x46, 0x11, 0x9f, 0x6b, 0x55,
	0x2a, 0xcc, 0xc3, 0x55, 0x14, 0x0c, 0x5d, 0x7b, 0xfd, 0x07, 0x58, 0x7e, 0x47, 0x8a, 0x56, 0xe2,
	0xd9, 0x50, 0xf6, 0x06, 0xb9, 0xe1, 0xee, 0x33, 0xa9, 0x4a, 0x6c, 0xd1, 0x84, 0x67, 0xdd, 0x4f,
	0x64, 0xbc, 0x09, 0x0b, 0xf7, 0xb7, 0x7f, 0xd1, 0xe0, 0xff, 0x96, 0x3f, 0x39, 0xdb, 0xba, 0x6d,
	0x10, 0xf7, 0xdd, 0xe7, 0x13, 0x62, 0x5f, 0x7b, 0xf9, 0x44, 0x29, 0x8f, 0x7d, 0x17, 0x7b, 0x63,
	0xdd, 0x0f, 0xc7, 0xcd, 0x31, 0xf1, 0xc4, 0xfc, 0xd8, 0x94, 0x22, 0x1c, 0x38, 0xf4, 0x03, 0x7f,
	0xdb, 0x5f, 0xa5, 0xbb, 0xbf, 0x32, 0xab, 0x4f, 0x24, 0xd3, 0x0e, 0x3f, 0xd3, 0xe5, 0xa3, 0x1e,
	0xb6, 0x46, 0x05, 0xc1, 0x75, 0xef, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x82, 0x68, 0x98, 0xb0,
	0xb8, 0x0f, 0x00, 0x00,
}
