// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/container/v1alpha1/cluster_service.proto

/*
Package container is a generated protocol buffer package.

It is generated from these files:
	google/container/v1alpha1/cluster_service.proto

It has these top-level messages:
	NodeConfig
	NodeTaint
	MasterAuth
	ClientCertificateConfig
	AddonsConfig
	HttpLoadBalancing
	HorizontalPodAutoscaling
	KubernetesDashboard
	NetworkPolicyConfig
	MasterAuthorizedNetworksConfig
	NetworkPolicy
	IPAllocationPolicy
	PodSecurityPolicyConfig
	Cluster
	ClusterUpdate
	Operation
	CreateClusterRequest
	GetClusterRequest
	UpdateClusterRequest
	UpdateNodePoolRequest
	SetNodePoolAutoscalingRequest
	SetLoggingServiceRequest
	SetMonitoringServiceRequest
	SetAddonsConfigRequest
	SetLocationsRequest
	UpdateMasterRequest
	SetMasterAuthRequest
	DeleteClusterRequest
	ListClustersRequest
	ListClustersResponse
	GetOperationRequest
	ListOperationsRequest
	CancelOperationRequest
	ListOperationsResponse
	GetServerConfigRequest
	ServerConfig
	CreateNodePoolRequest
	DeleteNodePoolRequest
	ListNodePoolsRequest
	GetNodePoolRequest
	NodePool
	NodeManagement
	AutoUpgradeOptions
	MaintenancePolicy
	MaintenanceWindow
	DailyMaintenanceWindow
	SetNodePoolManagementRequest
	SetNodePoolSizeRequest
	RollbackNodePoolUpgradeRequest
	ListNodePoolsResponse
	NodePoolAutoscaling
	SetLabelsRequest
	SetLegacyAbacRequest
	StartIPRotationRequest
	CompleteIPRotationRequest
	AcceleratorConfig
	SetNetworkPolicyRequest
	SetMaintenancePolicyRequest
*/
package container

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Possible values for Effect in taint.
type NodeTaint_Effect int32

const (
	// Not set
	NodeTaint_EFFECT_UNSPECIFIED NodeTaint_Effect = 0
	// NoSchedule
	NodeTaint_NO_SCHEDULE NodeTaint_Effect = 1
	// PreferNoSchedule
	NodeTaint_PREFER_NO_SCHEDULE NodeTaint_Effect = 2
	// NoExecute
	NodeTaint_NO_EXECUTE NodeTaint_Effect = 3
)

var NodeTaint_Effect_name = map[int32]string{
	0: "EFFECT_UNSPECIFIED",
	1: "NO_SCHEDULE",
	2: "PREFER_NO_SCHEDULE",
	3: "NO_EXECUTE",
}
var NodeTaint_Effect_value = map[string]int32{
	"EFFECT_UNSPECIFIED": 0,
	"NO_SCHEDULE":        1,
	"PREFER_NO_SCHEDULE": 2,
	"NO_EXECUTE":         3,
}

func (x NodeTaint_Effect) String() string {
	return proto.EnumName(NodeTaint_Effect_name, int32(x))
}
func (NodeTaint_Effect) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1, 0} }

// Allowed Network Policy providers.
type NetworkPolicy_Provider int32

const (
	// Not set
	NetworkPolicy_PROVIDER_UNSPECIFIED NetworkPolicy_Provider = 0
	// Tigera (Calico Felix).
	NetworkPolicy_CALICO NetworkPolicy_Provider = 1
)

var NetworkPolicy_Provider_name = map[int32]string{
	0: "PROVIDER_UNSPECIFIED",
	1: "CALICO",
}
var NetworkPolicy_Provider_value = map[string]int32{
	"PROVIDER_UNSPECIFIED": 0,
	"CALICO":               1,
}

func (x NetworkPolicy_Provider) String() string {
	return proto.EnumName(NetworkPolicy_Provider_name, int32(x))
}
func (NetworkPolicy_Provider) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{10, 0} }

// The current status of the cluster.
type Cluster_Status int32

const (
	// Not set.
	Cluster_STATUS_UNSPECIFIED Cluster_Status = 0
	// The PROVISIONING state indicates the cluster is being created.
	Cluster_PROVISIONING Cluster_Status = 1
	// The RUNNING state indicates the cluster has been created and is fully
	// usable.
	Cluster_RUNNING Cluster_Status = 2
	// The RECONCILING state indicates that some work is actively being done on
	// the cluster, such as upgrading the master or node software. Details can
	// be found in the `statusMessage` field.
	Cluster_RECONCILING Cluster_Status = 3
	// The STOPPING state indicates the cluster is being deleted.
	Cluster_STOPPING Cluster_Status = 4
	// The ERROR state indicates the cluster may be unusable. Details
	// can be found in the `statusMessage` field.
	Cluster_ERROR Cluster_Status = 5
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PROVISIONING",
	2: "RUNNING",
	3: "RECONCILING",
	4: "STOPPING",
	5: "ERROR",
}
var Cluster_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PROVISIONING":       1,
	"RUNNING":            2,
	"RECONCILING":        3,
	"STOPPING":           4,
	"ERROR":              5,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}
func (Cluster_Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{13, 0} }

// Current status of the operation.
type Operation_Status int32

const (
	// Not set.
	Operation_STATUS_UNSPECIFIED Operation_Status = 0
	// The operation has been created.
	Operation_PENDING Operation_Status = 1
	// The operation is currently running.
	Operation_RUNNING Operation_Status = 2
	// The operation is done, either cancelled or completed.
	Operation_DONE Operation_Status = 3
	// The operation is aborting.
	Operation_ABORTING Operation_Status = 4
)

var Operation_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PENDING",
	2: "RUNNING",
	3: "DONE",
	4: "ABORTING",
}
var Operation_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PENDING":            1,
	"RUNNING":            2,
	"DONE":               3,
	"ABORTING":           4,
}

func (x Operation_Status) String() string {
	return proto.EnumName(Operation_Status_name, int32(x))
}
func (Operation_Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{15, 0} }

// Operation type.
type Operation_Type int32

const (
	// Not set.
	Operation_TYPE_UNSPECIFIED Operation_Type = 0
	// Cluster create.
	Operation_CREATE_CLUSTER Operation_Type = 1
	// Cluster delete.
	Operation_DELETE_CLUSTER Operation_Type = 2
	// A master upgrade.
	Operation_UPGRADE_MASTER Operation_Type = 3
	// A node upgrade.
	Operation_UPGRADE_NODES Operation_Type = 4
	// Cluster repair.
	Operation_REPAIR_CLUSTER Operation_Type = 5
	// Cluster update.
	Operation_UPDATE_CLUSTER Operation_Type = 6
	// Node pool create.
	Operation_CREATE_NODE_POOL Operation_Type = 7
	// Node pool delete.
	Operation_DELETE_NODE_POOL Operation_Type = 8
	// Set node pool management.
	Operation_SET_NODE_POOL_MANAGEMENT Operation_Type = 9
	// Automatic node pool repair.
	Operation_AUTO_REPAIR_NODES Operation_Type = 10
	// Automatic node upgrade.
	Operation_AUTO_UPGRADE_NODES Operation_Type = 11
	// Set labels.
	Operation_SET_LABELS Operation_Type = 12
	// Set/generate master auth materials
	Operation_SET_MASTER_AUTH Operation_Type = 13
	// Set node pool size.
	Operation_SET_NODE_POOL_SIZE Operation_Type = 14
	// Updates network policy for a cluster.
	Operation_SET_NETWORK_POLICY Operation_Type = 15
	// Set the maintenance policy.
	Operation_SET_MAINTENANCE_POLICY Operation_Type = 16
)

var Operation_Type_name = map[int32]string{
	0:  "TYPE_UNSPECIFIED",
	1:  "CREATE_CLUSTER",
	2:  "DELETE_CLUSTER",
	3:  "UPGRADE_MASTER",
	4:  "UPGRADE_NODES",
	5:  "REPAIR_CLUSTER",
	6:  "UPDATE_CLUSTER",
	7:  "CREATE_NODE_POOL",
	8:  "DELETE_NODE_POOL",
	9:  "SET_NODE_POOL_MANAGEMENT",
	10: "AUTO_REPAIR_NODES",
	11: "AUTO_UPGRADE_NODES",
	12: "SET_LABELS",
	13: "SET_MASTER_AUTH",
	14: "SET_NODE_POOL_SIZE",
	15: "SET_NETWORK_POLICY",
	16: "SET_MAINTENANCE_POLICY",
}
var Operation_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":         0,
	"CREATE_CLUSTER":           1,
	"DELETE_CLUSTER":           2,
	"UPGRADE_MASTER":           3,
	"UPGRADE_NODES":            4,
	"REPAIR_CLUSTER":           5,
	"UPDATE_CLUSTER":           6,
	"CREATE_NODE_POOL":         7,
	"DELETE_NODE_POOL":         8,
	"SET_NODE_POOL_MANAGEMENT": 9,
	"AUTO_REPAIR_NODES":        10,
	"AUTO_UPGRADE_NODES":       11,
	"SET_LABELS":               12,
	"SET_MASTER_AUTH":          13,
	"SET_NODE_POOL_SIZE":       14,
	"SET_NETWORK_POLICY":       15,
	"SET_MAINTENANCE_POLICY":   16,
}

func (x Operation_Type) String() string {
	return proto.EnumName(Operation_Type_name, int32(x))
}
func (Operation_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{15, 1} }

// Operation type: what type update to perform.
type SetMasterAuthRequest_Action int32

const (
	// Operation is unknown and will error out.
	SetMasterAuthRequest_UNKNOWN SetMasterAuthRequest_Action = 0
	// Set the password to a user generated value.
	SetMasterAuthRequest_SET_PASSWORD SetMasterAuthRequest_Action = 1
	// Generate a new password and set it to that.
	SetMasterAuthRequest_GENERATE_PASSWORD SetMasterAuthRequest_Action = 2
	// Set the username.  If an empty username is provided, basic authentication
	// is disabled for the cluster.  If a non-empty username is provided, basic
	// authentication is enabled, with either a provided password or a generated
	// one.
	SetMasterAuthRequest_SET_USERNAME SetMasterAuthRequest_Action = 3
)

var SetMasterAuthRequest_Action_name = map[int32]string{
	0: "UNKNOWN",
	1: "SET_PASSWORD",
	2: "GENERATE_PASSWORD",
	3: "SET_USERNAME",
}
var SetMasterAuthRequest_Action_value = map[string]int32{
	"UNKNOWN":           0,
	"SET_PASSWORD":      1,
	"GENERATE_PASSWORD": 2,
	"SET_USERNAME":      3,
}

func (x SetMasterAuthRequest_Action) String() string {
	return proto.EnumName(SetMasterAuthRequest_Action_name, int32(x))
}
func (SetMasterAuthRequest_Action) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{26, 0}
}

// The current status of the node pool instance.
type NodePool_Status int32

const (
	// Not set.
	NodePool_STATUS_UNSPECIFIED NodePool_Status = 0
	// The PROVISIONING state indicates the node pool is being created.
	NodePool_PROVISIONING NodePool_Status = 1
	// The RUNNING state indicates the node pool has been created
	// and is fully usable.
	NodePool_RUNNING NodePool_Status = 2
	// The RUNNING_WITH_ERROR state indicates the node pool has been created
	// and is partially usable. Some error state has occurred and some
	// functionality may be impaired. Customer may need to reissue a request
	// or trigger a new update.
	NodePool_RUNNING_WITH_ERROR NodePool_Status = 3
	// The RECONCILING state indicates that some work is actively being done on
	// the node pool, such as upgrading node software. Details can
	// be found in the `statusMessage` field.
	NodePool_RECONCILING NodePool_Status = 4
	// The STOPPING state indicates the node pool is being deleted.
	NodePool_STOPPING NodePool_Status = 5
	// The ERROR state indicates the node pool may be unusable. Details
	// can be found in the `statusMessage` field.
	NodePool_ERROR NodePool_Status = 6
)

var NodePool_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PROVISIONING",
	2: "RUNNING",
	3: "RUNNING_WITH_ERROR",
	4: "RECONCILING",
	5: "STOPPING",
	6: "ERROR",
}
var NodePool_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PROVISIONING":       1,
	"RUNNING":            2,
	"RUNNING_WITH_ERROR": 3,
	"RECONCILING":        4,
	"STOPPING":           5,
	"ERROR":              6,
}

func (x NodePool_Status) String() string {
	return proto.EnumName(NodePool_Status_name, int32(x))
}
func (NodePool_Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{40, 0} }

// Parameters that describe the nodes in a cluster.
type NodeConfig struct {
	// The name of a Google Compute Engine [machine
	// type](/compute/docs/machine-types) (e.g.
	// `n1-standard-1`).
	//
	// If unspecified, the default machine type is
	// `n1-standard-1`.
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType" json:"machine_type,omitempty"`
	// Size of the disk attached to each node, specified in GB.
	// The smallest allowed disk size is 10GB.
	//
	// If unspecified, the default disk size is 100GB.
	DiskSizeGb int32 `protobuf:"varint,2,opt,name=disk_size_gb,json=diskSizeGb" json:"disk_size_gb,omitempty"`
	// The set of Google API scopes to be made available on all of the
	// node VMs under the "default" service account.
	//
	// The following scopes are recommended, but not required, and by default are
	// not included:
	//
	// * `https://www.googleapis.com/auth/compute` is required for mounting
	// persistent storage on your nodes.
	// * `https://www.googleapis.com/auth/devstorage.read_only` is required for
	// communicating with **gcr.io**
	// (the [Google Container Registry](/container-registry/)).
	//
	// If unspecified, no scopes are added, unless Cloud Logging or Cloud
	// Monitoring are enabled, in which case their required scopes will be added.
	OauthScopes []string `protobuf:"bytes,3,rep,name=oauth_scopes,json=oauthScopes" json:"oauth_scopes,omitempty"`
	// The Google Cloud Platform Service Account to be used by the node VMs. If
	// no Service Account is specified, the "default" service account is used.
	ServiceAccount string `protobuf:"bytes,9,opt,name=service_account,json=serviceAccount" json:"service_account,omitempty"`
	// The metadata key/value pairs assigned to instances in the cluster.
	//
	// Keys must conform to the regexp [a-zA-Z0-9-_]+ and be less than 128 bytes
	// in length. These are reflected as part of a URL in the metadata server.
	// Additionally, to avoid ambiguity, keys must not conflict with any other
	// metadata keys for the project or be one of the four reserved keys:
	// "instance-template", "kube-env", "startup-script", and "user-data"
	//
	// Values are free-form strings, and only have meaning as interpreted by
	// the image running in the instance. The only restriction placed on them is
	// that each value's size must be less than or equal to 32 KB.
	//
	// The total size of all keys and values must be less than 512 KB.
	Metadata map[string]string `protobuf:"bytes,4,rep,name=metadata" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The image type to use for this node. Note that for a given image type,
	// the latest version of it will be used.
	ImageType string `protobuf:"bytes,5,opt,name=image_type,json=imageType" json:"image_type,omitempty"`
	// The map of Kubernetes labels (key/value pairs) to be applied to each node.
	// These will added in addition to any default label(s) that
	// Kubernetes may apply to the node.
	// In case of conflict in label keys, the applied set may differ depending on
	// the Kubernetes version -- it's best to assume the behavior is undefined
	// and conflicts should be avoided.
	// For more information, including usage and the valid values, see:
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The number of local SSD disks to be attached to the node.
	//
	// The limit for this value is dependant upon the maximum number of
	// disks available on a machine per zone. See:
	// https://cloud.google.com/compute/docs/disks/local-ssd#local_ssd_limits
	// for more information.
	LocalSsdCount int32 `protobuf:"varint,7,opt,name=local_ssd_count,json=localSsdCount" json:"local_ssd_count,omitempty"`
	// The list of instance tags applied to all nodes. Tags are used to identify
	// valid sources or targets for network firewalls and are specified by
	// the client during cluster or node pool creation. Each tag within the list
	// must comply with RFC1035.
	Tags []string `protobuf:"bytes,8,rep,name=tags" json:"tags,omitempty"`
	// Whether the nodes are created as preemptible VM instances. See:
	// https://cloud.google.com/compute/docs/instances/preemptible for more
	// inforamtion about preemptible VM instances.
	Preemptible bool `protobuf:"varint,10,opt,name=preemptible" json:"preemptible,omitempty"`
	// A list of hardware accelerators to be attached to each node.
	// See https://cloud.google.com/compute/docs/gpus for more information about
	// support for GPUs.
	Accelerators []*AcceleratorConfig `protobuf:"bytes,11,rep,name=accelerators" json:"accelerators,omitempty"`
	// Minimum CPU platform to be used by this instance. The instance may be
	// scheduled on the specified or newer CPU platform. Applicable values are the
	// friendly names of CPU platforms, such as
	// <code>minCpuPlatform: &quot;Intel Haswell&quot;</code> or
	// <code>minCpuPlatform: &quot;Intel Sandy Bridge&quot;</code>. For more
	// information, read [how to specify min CPU platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
	MinCpuPlatform string `protobuf:"bytes,13,opt,name=min_cpu_platform,json=minCpuPlatform" json:"min_cpu_platform,omitempty"`
	// List of kubernetes taints to be applied to each node.
	//
	// For more information, including usage and the valid values, see:
	// https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
	Taints []*NodeTaint `protobuf:"bytes,15,rep,name=taints" json:"taints,omitempty"`
}

func (m *NodeConfig) Reset()                    { *m = NodeConfig{} }
func (m *NodeConfig) String() string            { return proto.CompactTextString(m) }
func (*NodeConfig) ProtoMessage()               {}
func (*NodeConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *NodeConfig) GetMachineType() string {
	if m != nil {
		return m.MachineType
	}
	return ""
}

func (m *NodeConfig) GetDiskSizeGb() int32 {
	if m != nil {
		return m.DiskSizeGb
	}
	return 0
}

func (m *NodeConfig) GetOauthScopes() []string {
	if m != nil {
		return m.OauthScopes
	}
	return nil
}

func (m *NodeConfig) GetServiceAccount() string {
	if m != nil {
		return m.ServiceAccount
	}
	return ""
}

func (m *NodeConfig) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *NodeConfig) GetImageType() string {
	if m != nil {
		return m.ImageType
	}
	return ""
}

func (m *NodeConfig) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *NodeConfig) GetLocalSsdCount() int32 {
	if m != nil {
		return m.LocalSsdCount
	}
	return 0
}

func (m *NodeConfig) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *NodeConfig) GetPreemptible() bool {
	if m != nil {
		return m.Preemptible
	}
	return false
}

func (m *NodeConfig) GetAccelerators() []*AcceleratorConfig {
	if m != nil {
		return m.Accelerators
	}
	return nil
}

func (m *NodeConfig) GetMinCpuPlatform() string {
	if m != nil {
		return m.MinCpuPlatform
	}
	return ""
}

func (m *NodeConfig) GetTaints() []*NodeTaint {
	if m != nil {
		return m.Taints
	}
	return nil
}

// Kubernetes taint is comprised of three fields: key, value, and effect. Effect
// can only be one of three types:  NoSchedule, PreferNoSchedule or NoExecute.
//
// For more information, including usage and the valid values, see:
// https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
type NodeTaint struct {
	// Key for taint.
	Key string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// Value for taint.
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	// Effect for taint.
	Effect NodeTaint_Effect `protobuf:"varint,3,opt,name=effect,enum=google.container.v1alpha1.NodeTaint_Effect" json:"effect,omitempty"`
}

func (m *NodeTaint) Reset()                    { *m = NodeTaint{} }
func (m *NodeTaint) String() string            { return proto.CompactTextString(m) }
func (*NodeTaint) ProtoMessage()               {}
func (*NodeTaint) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *NodeTaint) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *NodeTaint) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *NodeTaint) GetEffect() NodeTaint_Effect {
	if m != nil {
		return m.Effect
	}
	return NodeTaint_EFFECT_UNSPECIFIED
}

// The authentication information for accessing the master endpoint.
// Authentication can be done using HTTP basic auth or using client
// certificates.
type MasterAuth struct {
	// The username to use for HTTP basic authentication to the master endpoint.
	// For clusters v1.6.0 and later, you can disable basic authentication by
	// providing an empty username.
	Username string `protobuf:"bytes,1,opt,name=username" json:"username,omitempty"`
	// The password to use for HTTP basic authentication to the master endpoint.
	// Because the master endpoint is open to the Internet, you should create a
	// strong password.  If a password is provided for cluster creation, username
	// must be non-empty.
	Password string `protobuf:"bytes,2,opt,name=password" json:"password,omitempty"`
	// Configuration for client certificate authentication on the cluster.  If no
	// configuration is specified, a client certificate is issued.
	ClientCertificateConfig *ClientCertificateConfig `protobuf:"bytes,3,opt,name=client_certificate_config,json=clientCertificateConfig" json:"client_certificate_config,omitempty"`
	// [Output only] Base64-encoded public certificate that is the root of
	// trust for the cluster.
	ClusterCaCertificate string `protobuf:"bytes,100,opt,name=cluster_ca_certificate,json=clusterCaCertificate" json:"cluster_ca_certificate,omitempty"`
	// [Output only] Base64-encoded public certificate used by clients to
	// authenticate to the cluster endpoint.
	ClientCertificate string `protobuf:"bytes,101,opt,name=client_certificate,json=clientCertificate" json:"client_certificate,omitempty"`
	// [Output only] Base64-encoded private key used by clients to authenticate
	// to the cluster endpoint.
	ClientKey string `protobuf:"bytes,102,opt,name=client_key,json=clientKey" json:"client_key,omitempty"`
}

func (m *MasterAuth) Reset()                    { *m = MasterAuth{} }
func (m *MasterAuth) String() string            { return proto.CompactTextString(m) }
func (*MasterAuth) ProtoMessage()               {}
func (*MasterAuth) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *MasterAuth) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *MasterAuth) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *MasterAuth) GetClientCertificateConfig() *ClientCertificateConfig {
	if m != nil {
		return m.ClientCertificateConfig
	}
	return nil
}

func (m *MasterAuth) GetClusterCaCertificate() string {
	if m != nil {
		return m.ClusterCaCertificate
	}
	return ""
}

func (m *MasterAuth) GetClientCertificate() string {
	if m != nil {
		return m.ClientCertificate
	}
	return ""
}

func (m *MasterAuth) GetClientKey() string {
	if m != nil {
		return m.ClientKey
	}
	return ""
}

// Configuration for client certificates on the cluster.
type ClientCertificateConfig struct {
	// Issue a client certificate.
	IssueClientCertificate bool `protobuf:"varint,1,opt,name=issue_client_certificate,json=issueClientCertificate" json:"issue_client_certificate,omitempty"`
}

func (m *ClientCertificateConfig) Reset()                    { *m = ClientCertificateConfig{} }
func (m *ClientCertificateConfig) String() string            { return proto.CompactTextString(m) }
func (*ClientCertificateConfig) ProtoMessage()               {}
func (*ClientCertificateConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ClientCertificateConfig) GetIssueClientCertificate() bool {
	if m != nil {
		return m.IssueClientCertificate
	}
	return false
}

// Configuration for the addons that can be automatically spun up in the
// cluster, enabling additional functionality.
type AddonsConfig struct {
	// Configuration for the HTTP (L7) load balancing controller addon, which
	// makes it easy to set up HTTP load balancers for services in a cluster.
	HttpLoadBalancing *HttpLoadBalancing `protobuf:"bytes,1,opt,name=http_load_balancing,json=httpLoadBalancing" json:"http_load_balancing,omitempty"`
	// Configuration for the horizontal pod autoscaling feature, which
	// increases or decreases the number of replica pods a replication controller
	// has based on the resource usage of the existing pods.
	HorizontalPodAutoscaling *HorizontalPodAutoscaling `protobuf:"bytes,2,opt,name=horizontal_pod_autoscaling,json=horizontalPodAutoscaling" json:"horizontal_pod_autoscaling,omitempty"`
	// Configuration for the Kubernetes Dashboard.
	KubernetesDashboard *KubernetesDashboard `protobuf:"bytes,3,opt,name=kubernetes_dashboard,json=kubernetesDashboard" json:"kubernetes_dashboard,omitempty"`
	// Configuration for NetworkPolicy. This only tracks whether the addon
	// is enabled or not on the Master, it does not track whether network policy
	// is enabled for the nodes.
	NetworkPolicyConfig *NetworkPolicyConfig `protobuf:"bytes,4,opt,name=network_policy_config,json=networkPolicyConfig" json:"network_policy_config,omitempty"`
}

func (m *AddonsConfig) Reset()                    { *m = AddonsConfig{} }
func (m *AddonsConfig) String() string            { return proto.CompactTextString(m) }
func (*AddonsConfig) ProtoMessage()               {}
func (*AddonsConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *AddonsConfig) GetHttpLoadBalancing() *HttpLoadBalancing {
	if m != nil {
		return m.HttpLoadBalancing
	}
	return nil
}

func (m *AddonsConfig) GetHorizontalPodAutoscaling() *HorizontalPodAutoscaling {
	if m != nil {
		return m.HorizontalPodAutoscaling
	}
	return nil
}

func (m *AddonsConfig) GetKubernetesDashboard() *KubernetesDashboard {
	if m != nil {
		return m.KubernetesDashboard
	}
	return nil
}

func (m *AddonsConfig) GetNetworkPolicyConfig() *NetworkPolicyConfig {
	if m != nil {
		return m.NetworkPolicyConfig
	}
	return nil
}

// Configuration options for the HTTP (L7) load balancing controller addon,
// which makes it easy to set up HTTP load balancers for services in a cluster.
type HttpLoadBalancing struct {
	// Whether the HTTP Load Balancing controller is enabled in the cluster.
	// When enabled, it runs a small pod in the cluster that manages the load
	// balancers.
	Disabled bool `protobuf:"varint,1,opt,name=disabled" json:"disabled,omitempty"`
}

func (m *HttpLoadBalancing) Reset()                    { *m = HttpLoadBalancing{} }
func (m *HttpLoadBalancing) String() string            { return proto.CompactTextString(m) }
func (*HttpLoadBalancing) ProtoMessage()               {}
func (*HttpLoadBalancing) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *HttpLoadBalancing) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Configuration options for the horizontal pod autoscaling feature, which
// increases or decreases the number of replica pods a replication controller
// has based on the resource usage of the existing pods.
type HorizontalPodAutoscaling struct {
	// Whether the Horizontal Pod Autoscaling feature is enabled in the cluster.
	// When enabled, it ensures that a Heapster pod is running in the cluster,
	// which is also used by the Cloud Monitoring service.
	Disabled bool `protobuf:"varint,1,opt,name=disabled" json:"disabled,omitempty"`
}

func (m *HorizontalPodAutoscaling) Reset()                    { *m = HorizontalPodAutoscaling{} }
func (m *HorizontalPodAutoscaling) String() string            { return proto.CompactTextString(m) }
func (*HorizontalPodAutoscaling) ProtoMessage()               {}
func (*HorizontalPodAutoscaling) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *HorizontalPodAutoscaling) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Configuration for the Kubernetes Dashboard.
type KubernetesDashboard struct {
	// Whether the Kubernetes Dashboard is enabled for this cluster.
	Disabled bool `protobuf:"varint,1,opt,name=disabled" json:"disabled,omitempty"`
}

func (m *KubernetesDashboard) Reset()                    { *m = KubernetesDashboard{} }
func (m *KubernetesDashboard) String() string            { return proto.CompactTextString(m) }
func (*KubernetesDashboard) ProtoMessage()               {}
func (*KubernetesDashboard) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *KubernetesDashboard) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Configuration for NetworkPolicy. This only tracks whether the addon
// is enabled or not on the Master, it does not track whether network policy
// is enabled for the nodes.
type NetworkPolicyConfig struct {
	// Whether NetworkPolicy is enabled for this cluster.
	Disabled bool `protobuf:"varint,1,opt,name=disabled" json:"disabled,omitempty"`
}

func (m *NetworkPolicyConfig) Reset()                    { *m = NetworkPolicyConfig{} }
func (m *NetworkPolicyConfig) String() string            { return proto.CompactTextString(m) }
func (*NetworkPolicyConfig) ProtoMessage()               {}
func (*NetworkPolicyConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *NetworkPolicyConfig) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Configuration options for the master authorized networks feature. Enabled
// master authorized networks will disallow all external traffic to access
// Kubernetes master through HTTPS except traffic from the given CIDR blocks,
// Google Compute Engine Public IPs and Google Prod IPs.
type MasterAuthorizedNetworksConfig struct {
	// Whether or not master authorized networks is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled" json:"enabled,omitempty"`
	// cidr_blocks define up to 10 external networks that could access
	// Kubernetes master through HTTPS.
	CidrBlocks []*MasterAuthorizedNetworksConfig_CidrBlock `protobuf:"bytes,2,rep,name=cidr_blocks,json=cidrBlocks" json:"cidr_blocks,omitempty"`
}

func (m *MasterAuthorizedNetworksConfig) Reset()                    { *m = MasterAuthorizedNetworksConfig{} }
func (m *MasterAuthorizedNetworksConfig) String() string            { return proto.CompactTextString(m) }
func (*MasterAuthorizedNetworksConfig) ProtoMessage()               {}
func (*MasterAuthorizedNetworksConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *MasterAuthorizedNetworksConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *MasterAuthorizedNetworksConfig) GetCidrBlocks() []*MasterAuthorizedNetworksConfig_CidrBlock {
	if m != nil {
		return m.CidrBlocks
	}
	return nil
}

// CidrBlock contains an optional name and one CIDR block.
type MasterAuthorizedNetworksConfig_CidrBlock struct {
	// display_name is an optional field for users to identify CIDR blocks.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// cidr_block must be specified in CIDR notation.
	CidrBlock string `protobuf:"bytes,2,opt,name=cidr_block,json=cidrBlock" json:"cidr_block,omitempty"`
}

func (m *MasterAuthorizedNetworksConfig_CidrBlock) Reset() {
	*m = MasterAuthorizedNetworksConfig_CidrBlock{}
}
func (m *MasterAuthorizedNetworksConfig_CidrBlock) String() string { return proto.CompactTextString(m) }
func (*MasterAuthorizedNetworksConfig_CidrBlock) ProtoMessage()    {}
func (*MasterAuthorizedNetworksConfig_CidrBlock) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{9, 0}
}

func (m *MasterAuthorizedNetworksConfig_CidrBlock) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *MasterAuthorizedNetworksConfig_CidrBlock) GetCidrBlock() string {
	if m != nil {
		return m.CidrBlock
	}
	return ""
}

// Configuration options for the NetworkPolicy feature.
// https://kubernetes.io/docs/concepts/services-networking/networkpolicies/
type NetworkPolicy struct {
	// The selected network policy provider.
	Provider NetworkPolicy_Provider `protobuf:"varint,1,opt,name=provider,enum=google.container.v1alpha1.NetworkPolicy_Provider" json:"provider,omitempty"`
	// Whether network policy is enabled on the cluster.
	Enabled bool `protobuf:"varint,2,opt,name=enabled" json:"enabled,omitempty"`
}

func (m *NetworkPolicy) Reset()                    { *m = NetworkPolicy{} }
func (m *NetworkPolicy) String() string            { return proto.CompactTextString(m) }
func (*NetworkPolicy) ProtoMessage()               {}
func (*NetworkPolicy) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *NetworkPolicy) GetProvider() NetworkPolicy_Provider {
	if m != nil {
		return m.Provider
	}
	return NetworkPolicy_PROVIDER_UNSPECIFIED
}

func (m *NetworkPolicy) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// Configuration for controlling how IPs are allocated in the cluster.
type IPAllocationPolicy struct {
	// Whether alias IPs will be used for pod IPs in the cluster.
	UseIpAliases bool `protobuf:"varint,1,opt,name=use_ip_aliases,json=useIpAliases" json:"use_ip_aliases,omitempty"`
	// Whether a new subnetwork will be created automatically for the cluster.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	CreateSubnetwork bool `protobuf:"varint,2,opt,name=create_subnetwork,json=createSubnetwork" json:"create_subnetwork,omitempty"`
	// A custom subnetwork name to be used if `create_subnetwork` is true.  If
	// this field is empty, then an automatic name will be chosen for the new
	// subnetwork.
	SubnetworkName string `protobuf:"bytes,3,opt,name=subnetwork_name,json=subnetworkName" json:"subnetwork_name,omitempty"`
	// This field is deprecated, use cluster_ipv4_cidr_block.
	ClusterIpv4Cidr string `protobuf:"bytes,4,opt,name=cluster_ipv4_cidr,json=clusterIpv4Cidr" json:"cluster_ipv4_cidr,omitempty"`
	// This field is deprecated, use node_ipv4_cidr_block.
	NodeIpv4Cidr string `protobuf:"bytes,5,opt,name=node_ipv4_cidr,json=nodeIpv4Cidr" json:"node_ipv4_cidr,omitempty"`
	// This field is deprecated, use services_ipv4_cidr_block.
	ServicesIpv4Cidr string `protobuf:"bytes,6,opt,name=services_ipv4_cidr,json=servicesIpv4Cidr" json:"services_ipv4_cidr,omitempty"`
	// The name of the secondary range to be used for the cluster CIDR
	// block.  The secondary range will be used for pod IP
	// addresses. This must be an existing secondary range associated
	// with the cluster subnetwork.
	//
	// This field is only applicable if use_ip_aliases is true and
	// create_subnetwork is false.
	ClusterSecondaryRangeName string `protobuf:"bytes,7,opt,name=cluster_secondary_range_name,json=clusterSecondaryRangeName" json:"cluster_secondary_range_name,omitempty"`
	// The name of the secondary range to be used as for the services
	// CIDR block.  The secondary range will be used for service
	// ClusterIPs. This must be an existing secondary range associated
	// with the cluster subnetwork.
	//
	// This field is only applicable with use_ip_aliases is true and
	// create_subnetwork is false.
	ServicesSecondaryRangeName string `protobuf:"bytes,8,opt,name=services_secondary_range_name,json=servicesSecondaryRangeName" json:"services_secondary_range_name,omitempty"`
	// The IP address range for the cluster pod IPs. If this field is set, then
	// `cluster.cluster_ipv4_cidr` must be left blank.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	ClusterIpv4CidrBlock string `protobuf:"bytes,9,opt,name=cluster_ipv4_cidr_block,json=clusterIpv4CidrBlock" json:"cluster_ipv4_cidr_block,omitempty"`
	// The IP address range of the instance IPs in this cluster.
	//
	// This is applicable only if `create_subnetwork` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	NodeIpv4CidrBlock string `protobuf:"bytes,10,opt,name=node_ipv4_cidr_block,json=nodeIpv4CidrBlock" json:"node_ipv4_cidr_block,omitempty"`
	// The IP address range of the services IPs in this cluster. If blank, a range
	// will be automatically chosen with the default size.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	ServicesIpv4CidrBlock string `protobuf:"bytes,11,opt,name=services_ipv4_cidr_block,json=servicesIpv4CidrBlock" json:"services_ipv4_cidr_block,omitempty"`
}

func (m *IPAllocationPolicy) Reset()                    { *m = IPAllocationPolicy{} }
func (m *IPAllocationPolicy) String() string            { return proto.CompactTextString(m) }
func (*IPAllocationPolicy) ProtoMessage()               {}
func (*IPAllocationPolicy) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *IPAllocationPolicy) GetUseIpAliases() bool {
	if m != nil {
		return m.UseIpAliases
	}
	return false
}

func (m *IPAllocationPolicy) GetCreateSubnetwork() bool {
	if m != nil {
		return m.CreateSubnetwork
	}
	return false
}

func (m *IPAllocationPolicy) GetSubnetworkName() string {
	if m != nil {
		return m.SubnetworkName
	}
	return ""
}

func (m *IPAllocationPolicy) GetClusterIpv4Cidr() string {
	if m != nil {
		return m.ClusterIpv4Cidr
	}
	return ""
}

func (m *IPAllocationPolicy) GetNodeIpv4Cidr() string {
	if m != nil {
		return m.NodeIpv4Cidr
	}
	return ""
}

func (m *IPAllocationPolicy) GetServicesIpv4Cidr() string {
	if m != nil {
		return m.ServicesIpv4Cidr
	}
	return ""
}

func (m *IPAllocationPolicy) GetClusterSecondaryRangeName() string {
	if m != nil {
		return m.ClusterSecondaryRangeName
	}
	return ""
}

func (m *IPAllocationPolicy) GetServicesSecondaryRangeName() string {
	if m != nil {
		return m.ServicesSecondaryRangeName
	}
	return ""
}

func (m *IPAllocationPolicy) GetClusterIpv4CidrBlock() string {
	if m != nil {
		return m.ClusterIpv4CidrBlock
	}
	return ""
}

func (m *IPAllocationPolicy) GetNodeIpv4CidrBlock() string {
	if m != nil {
		return m.NodeIpv4CidrBlock
	}
	return ""
}

func (m *IPAllocationPolicy) GetServicesIpv4CidrBlock() string {
	if m != nil {
		return m.ServicesIpv4CidrBlock
	}
	return ""
}

// Configuration for the PodSecurityPolicy feature.
type PodSecurityPolicyConfig struct {
	// Enable the PodSecurityPolicy controller for this cluster. If enabled, pods
	// must be valid under a PodSecurityPolicy to be created.
	Enabled bool `protobuf:"varint,1,opt,name=enabled" json:"enabled,omitempty"`
}

func (m *PodSecurityPolicyConfig) Reset()                    { *m = PodSecurityPolicyConfig{} }
func (m *PodSecurityPolicyConfig) String() string            { return proto.CompactTextString(m) }
func (*PodSecurityPolicyConfig) ProtoMessage()               {}
func (*PodSecurityPolicyConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *PodSecurityPolicyConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// A Google Container Engine cluster.
type Cluster struct {
	// The name of this cluster. The name must be unique within this project
	// and zone, and can be up to 40 characters with the following restrictions:
	//
	// * Lowercase letters, numbers, and hyphens only.
	// * Must start with a letter.
	// * Must end with a number or a letter.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// An optional description of this cluster.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// The number of nodes to create in this cluster. You must ensure that your
	// Compute Engine <a href="/compute/docs/resource-quotas">resource quota</a>
	// is sufficient for this number of instances. You must also have available
	// firewall and routes quota.
	// For requests, this field should only be used in lieu of a
	// "node_pool" object, since this configuration (along with the
	// "node_config") will be used to create a "NodePool" object with an
	// auto-generated name. Do not use this and a node_pool at the same time.
	InitialNodeCount int32 `protobuf:"varint,3,opt,name=initial_node_count,json=initialNodeCount" json:"initial_node_count,omitempty"`
	// Parameters used in creating the cluster's nodes.
	// See `nodeConfig` for the description of its properties.
	// For requests, this field should only be used in lieu of a
	// "node_pool" object, since this configuration (along with the
	// "initial_node_count") will be used to create a "NodePool" object with an
	// auto-generated name. Do not use this and a node_pool at the same time.
	// For responses, this field will be populated with the node configuration of
	// the first node pool.
	//
	// If unspecified, the defaults are used.
	NodeConfig *NodeConfig `protobuf:"bytes,4,opt,name=node_config,json=nodeConfig" json:"node_config,omitempty"`
	// The authentication information for accessing the master endpoint.
	MasterAuth *MasterAuth `protobuf:"bytes,5,opt,name=master_auth,json=masterAuth" json:"master_auth,omitempty"`
	// The logging service the cluster should use to write logs.
	// Currently available options:
	//
	// * `logging.googleapis.com` - the Google Cloud Logging service.
	// * `none` - no logs will be exported from the cluster.
	// * if left as an empty string,`logging.googleapis.com` will be used.
	LoggingService string `protobuf:"bytes,6,opt,name=logging_service,json=loggingService" json:"logging_service,omitempty"`
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * `monitoring.googleapis.com` - the Google Cloud Monitoring service.
	// * `none` - no metrics will be exported from the cluster.
	// * if left as an empty string, `monitoring.googleapis.com` will be used.
	MonitoringService string `protobuf:"bytes,7,opt,name=monitoring_service,json=monitoringService" json:"monitoring_service,omitempty"`
	// The name of the Google Compute Engine
	// [network](/compute/docs/networks-and-firewalls#networks) to which the
	// cluster is connected. If left unspecified, the `default` network
	// will be used.
	Network string `protobuf:"bytes,8,opt,name=network" json:"network,omitempty"`
	// The IP address range of the container pods in this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`). Leave blank to have
	// one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
	ClusterIpv4Cidr string `protobuf:"bytes,9,opt,name=cluster_ipv4_cidr,json=clusterIpv4Cidr" json:"cluster_ipv4_cidr,omitempty"`
	// Configurations for the various addons available to run in the cluster.
	AddonsConfig *AddonsConfig `protobuf:"bytes,10,opt,name=addons_config,json=addonsConfig" json:"addons_config,omitempty"`
	// The name of the Google Compute Engine
	// [subnetwork](/compute/docs/subnetworks) to which the
	// cluster is connected.
	Subnetwork string `protobuf:"bytes,11,opt,name=subnetwork" json:"subnetwork,omitempty"`
	// The node pools associated with this cluster.
	// This field should not be set if "node_config" or "initial_node_count" are
	// specified.
	NodePools []*NodePool `protobuf:"bytes,12,rep,name=node_pools,json=nodePools" json:"node_pools,omitempty"`
	// The list of Google Compute Engine
	// [locations](/compute/docs/zones#available) in which the cluster's nodes
	// should be located.
	Locations []string `protobuf:"bytes,13,rep,name=locations" json:"locations,omitempty"`
	// Kubernetes alpha features are enabled on this cluster. This includes alpha
	// API groups (e.g. v1alpha1) and features that may not be production ready in
	// the kubernetes version of the master and nodes.
	// The cluster has no SLA for uptime and master/node upgrades are disabled.
	// Alpha enabled clusters are automatically deleted thirty days after
	// creation.
	EnableKubernetesAlpha bool `protobuf:"varint,14,opt,name=enable_kubernetes_alpha,json=enableKubernetesAlpha" json:"enable_kubernetes_alpha,omitempty"`
	// Configuration options for the NetworkPolicy feature.
	NetworkPolicy *NetworkPolicy `protobuf:"bytes,19,opt,name=network_policy,json=networkPolicy" json:"network_policy,omitempty"`
	// Configuration for cluster IP allocation.
	IpAllocationPolicy *IPAllocationPolicy `protobuf:"bytes,20,opt,name=ip_allocation_policy,json=ipAllocationPolicy" json:"ip_allocation_policy,omitempty"`
	// The configuration options for master authorized networks feature.
	MasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `protobuf:"bytes,22,opt,name=master_authorized_networks_config,json=masterAuthorizedNetworksConfig" json:"master_authorized_networks_config,omitempty"`
	// Configure the maintenance policy for this cluster.
	MaintenancePolicy *MaintenancePolicy `protobuf:"bytes,23,opt,name=maintenance_policy,json=maintenancePolicy" json:"maintenance_policy,omitempty"`
	// Configuration for the PodSecurityPolicy feature.
	PodSecurityPolicyConfig *PodSecurityPolicyConfig `protobuf:"bytes,25,opt,name=pod_security_policy_config,json=podSecurityPolicyConfig" json:"pod_security_policy_config,omitempty"`
	// [Output only] Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,100,opt,name=self_link,json=selfLink" json:"self_link,omitempty"`
	// [Output only] The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use location instead.
	Zone string `protobuf:"bytes,101,opt,name=zone" json:"zone,omitempty"`
	// [Output only] The IP address of this cluster's master endpoint.
	// The endpoint can be accessed from the internet at
	// `https://username:password@endpoint/`.
	//
	// See the `masterAuth` property of this resource for username and
	// password information.
	Endpoint string `protobuf:"bytes,102,opt,name=endpoint" json:"endpoint,omitempty"`
	// The initial Kubernetes version for this cluster.  Valid versions are those
	// found in validMasterVersions returned by getServerConfig.  The version can
	// be upgraded over time; such upgrades are reflected in
	// currentMasterVersion and currentNodeVersion.
	InitialClusterVersion string `protobuf:"bytes,103,opt,name=initial_cluster_version,json=initialClusterVersion" json:"initial_cluster_version,omitempty"`
	// [Output only] The current software version of the master endpoint.
	CurrentMasterVersion string `protobuf:"bytes,104,opt,name=current_master_version,json=currentMasterVersion" json:"current_master_version,omitempty"`
	// [Output only] The current version of the node software components.
	// If they are currently at multiple versions because they're in the process
	// of being upgraded, this reflects the minimum version of all nodes.
	CurrentNodeVersion string `protobuf:"bytes,105,opt,name=current_node_version,json=currentNodeVersion" json:"current_node_version,omitempty"`
	// [Output only] The time the cluster was created, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreateTime string `protobuf:"bytes,106,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// [Output only] The current status of this cluster.
	Status Cluster_Status `protobuf:"varint,107,opt,name=status,enum=google.container.v1alpha1.Cluster_Status" json:"status,omitempty"`
	// [Output only] Additional information about the current status of this
	// cluster, if available.
	StatusMessage string `protobuf:"bytes,108,opt,name=status_message,json=statusMessage" json:"status_message,omitempty"`
	// [Output only] The size of the address space on each node for hosting
	// containers. This is provisioned from within the `container_ipv4_cidr`
	// range.
	NodeIpv4CidrSize int32 `protobuf:"varint,109,opt,name=node_ipv4_cidr_size,json=nodeIpv4CidrSize" json:"node_ipv4_cidr_size,omitempty"`
	// [Output only] The IP address range of the Kubernetes services in
	// this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `1.2.3.4/29`). Service addresses are
	// typically put in the last `/16` from the container CIDR.
	ServicesIpv4Cidr string `protobuf:"bytes,110,opt,name=services_ipv4_cidr,json=servicesIpv4Cidr" json:"services_ipv4_cidr,omitempty"`
	// [Output only] The resource URLs of [instance
	// groups](/compute/docs/instance-groups/) associated with this
	// cluster.
	InstanceGroupUrls []string `protobuf:"bytes,111,rep,name=instance_group_urls,json=instanceGroupUrls" json:"instance_group_urls,omitempty"`
	// [Output only] The number of nodes currently in the cluster.
	CurrentNodeCount int32 `protobuf:"varint,112,opt,name=current_node_count,json=currentNodeCount" json:"current_node_count,omitempty"`
	// [Output only] The time the cluster will be automatically
	// deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	ExpireTime string `protobuf:"bytes,113,opt,name=expire_time,json=expireTime" json:"expire_time,omitempty"`
	// [Output only] The name of the Google Compute Engine
	// [zone](/compute/docs/regions-zones/regions-zones#available) or
	// [region](/compute/docs/regions-zones/regions-zones#available) in which
	// the cluster resides.
	Location string `protobuf:"bytes,114,opt,name=location" json:"location,omitempty"`
}

func (m *Cluster) Reset()                    { *m = Cluster{} }
func (m *Cluster) String() string            { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()               {}
func (*Cluster) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Cluster) GetInitialNodeCount() int32 {
	if m != nil {
		return m.InitialNodeCount
	}
	return 0
}

func (m *Cluster) GetNodeConfig() *NodeConfig {
	if m != nil {
		return m.NodeConfig
	}
	return nil
}

func (m *Cluster) GetMasterAuth() *MasterAuth {
	if m != nil {
		return m.MasterAuth
	}
	return nil
}

func (m *Cluster) GetLoggingService() string {
	if m != nil {
		return m.LoggingService
	}
	return ""
}

func (m *Cluster) GetMonitoringService() string {
	if m != nil {
		return m.MonitoringService
	}
	return ""
}

func (m *Cluster) GetNetwork() string {
	if m != nil {
		return m.Network
	}
	return ""
}

func (m *Cluster) GetClusterIpv4Cidr() string {
	if m != nil {
		return m.ClusterIpv4Cidr
	}
	return ""
}

func (m *Cluster) GetAddonsConfig() *AddonsConfig {
	if m != nil {
		return m.AddonsConfig
	}
	return nil
}

func (m *Cluster) GetSubnetwork() string {
	if m != nil {
		return m.Subnetwork
	}
	return ""
}

func (m *Cluster) GetNodePools() []*NodePool {
	if m != nil {
		return m.NodePools
	}
	return nil
}

func (m *Cluster) GetLocations() []string {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *Cluster) GetEnableKubernetesAlpha() bool {
	if m != nil {
		return m.EnableKubernetesAlpha
	}
	return false
}

func (m *Cluster) GetNetworkPolicy() *NetworkPolicy {
	if m != nil {
		return m.NetworkPolicy
	}
	return nil
}

func (m *Cluster) GetIpAllocationPolicy() *IPAllocationPolicy {
	if m != nil {
		return m.IpAllocationPolicy
	}
	return nil
}

func (m *Cluster) GetMasterAuthorizedNetworksConfig() *MasterAuthorizedNetworksConfig {
	if m != nil {
		return m.MasterAuthorizedNetworksConfig
	}
	return nil
}

func (m *Cluster) GetMaintenancePolicy() *MaintenancePolicy {
	if m != nil {
		return m.MaintenancePolicy
	}
	return nil
}

func (m *Cluster) GetPodSecurityPolicyConfig() *PodSecurityPolicyConfig {
	if m != nil {
		return m.PodSecurityPolicyConfig
	}
	return nil
}

func (m *Cluster) GetSelfLink() string {
	if m != nil {
		return m.SelfLink
	}
	return ""
}

func (m *Cluster) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *Cluster) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *Cluster) GetInitialClusterVersion() string {
	if m != nil {
		return m.InitialClusterVersion
	}
	return ""
}

func (m *Cluster) GetCurrentMasterVersion() string {
	if m != nil {
		return m.CurrentMasterVersion
	}
	return ""
}

func (m *Cluster) GetCurrentNodeVersion() string {
	if m != nil {
		return m.CurrentNodeVersion
	}
	return ""
}

func (m *Cluster) GetCreateTime() string {
	if m != nil {
		return m.CreateTime
	}
	return ""
}

func (m *Cluster) GetStatus() Cluster_Status {
	if m != nil {
		return m.Status
	}
	return Cluster_STATUS_UNSPECIFIED
}

func (m *Cluster) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Cluster) GetNodeIpv4CidrSize() int32 {
	if m != nil {
		return m.NodeIpv4CidrSize
	}
	return 0
}

func (m *Cluster) GetServicesIpv4Cidr() string {
	if m != nil {
		return m.ServicesIpv4Cidr
	}
	return ""
}

func (m *Cluster) GetInstanceGroupUrls() []string {
	if m != nil {
		return m.InstanceGroupUrls
	}
	return nil
}

func (m *Cluster) GetCurrentNodeCount() int32 {
	if m != nil {
		return m.CurrentNodeCount
	}
	return 0
}

func (m *Cluster) GetExpireTime() string {
	if m != nil {
		return m.ExpireTime
	}
	return ""
}

func (m *Cluster) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

// ClusterUpdate describes an update to the cluster. Exactly one update can
// be applied to a cluster with each request, so at most one field can be
// provided.
type ClusterUpdate struct {
	// The Kubernetes version to change the nodes to (typically an
	// upgrade). Use `-` to upgrade to the latest version supported by
	// the server.
	DesiredNodeVersion string `protobuf:"bytes,4,opt,name=desired_node_version,json=desiredNodeVersion" json:"desired_node_version,omitempty"`
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "monitoring.googleapis.com" - the Google Cloud Monitoring service
	// * "none" - no metrics will be exported from the cluster
	DesiredMonitoringService string `protobuf:"bytes,5,opt,name=desired_monitoring_service,json=desiredMonitoringService" json:"desired_monitoring_service,omitempty"`
	// Configurations for the various addons available to run in the cluster.
	DesiredAddonsConfig *AddonsConfig `protobuf:"bytes,6,opt,name=desired_addons_config,json=desiredAddonsConfig" json:"desired_addons_config,omitempty"`
	// The node pool to be upgraded. This field is mandatory if
	// "desired_node_version", "desired_image_family" or
	// "desired_node_pool_autoscaling" is specified and there is more than one
	// node pool on the cluster.
	DesiredNodePoolId string `protobuf:"bytes,7,opt,name=desired_node_pool_id,json=desiredNodePoolId" json:"desired_node_pool_id,omitempty"`
	// The desired image type for the node pool.
	// NOTE: Set the "desired_node_pool" field as well.
	DesiredImageType string `protobuf:"bytes,8,opt,name=desired_image_type,json=desiredImageType" json:"desired_image_type,omitempty"`
	// Autoscaler configuration for the node pool specified in
	// desired_node_pool_id. If there is only one pool in the
	// cluster and desired_node_pool_id is not provided then
	// the change applies to that single node pool.
	DesiredNodePoolAutoscaling *NodePoolAutoscaling `protobuf:"bytes,9,opt,name=desired_node_pool_autoscaling,json=desiredNodePoolAutoscaling" json:"desired_node_pool_autoscaling,omitempty"`
	// The desired list of Google Compute Engine
	// [locations](/compute/docs/zones#available) in which the cluster's nodes
	// should be located. Changing the locations a cluster is in will result
	// in nodes being either created or removed from the cluster, depending on
	// whether locations are being added or removed.
	//
	// This list must always include the cluster's primary zone.
	DesiredLocations []string `protobuf:"bytes,10,rep,name=desired_locations,json=desiredLocations" json:"desired_locations,omitempty"`
	// The desired configuration options for master authorized networks feature.
	DesiredMasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `protobuf:"bytes,12,opt,name=desired_master_authorized_networks_config,json=desiredMasterAuthorizedNetworksConfig" json:"desired_master_authorized_networks_config,omitempty"`
	// The desired configuration options for the PodSecurityPolicy feature.
	DesiredPodSecurityPolicyConfig *PodSecurityPolicyConfig `protobuf:"bytes,14,opt,name=desired_pod_security_policy_config,json=desiredPodSecurityPolicyConfig" json:"desired_pod_security_policy_config,omitempty"`
	// The Kubernetes version to change the master to. The only valid value is the
	// latest supported version. Use "-" to have the server automatically select
	// the latest version.
	DesiredMasterVersion string `protobuf:"bytes,100,opt,name=desired_master_version,json=desiredMasterVersion" json:"desired_master_version,omitempty"`
}

func (m *ClusterUpdate) Reset()                    { *m = ClusterUpdate{} }
func (m *ClusterUpdate) String() string            { return proto.CompactTextString(m) }
func (*ClusterUpdate) ProtoMessage()               {}
func (*ClusterUpdate) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ClusterUpdate) GetDesiredNodeVersion() string {
	if m != nil {
		return m.DesiredNodeVersion
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredMonitoringService() string {
	if m != nil {
		return m.DesiredMonitoringService
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredAddonsConfig() *AddonsConfig {
	if m != nil {
		return m.DesiredAddonsConfig
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredNodePoolId() string {
	if m != nil {
		return m.DesiredNodePoolId
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredImageType() string {
	if m != nil {
		return m.DesiredImageType
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredNodePoolAutoscaling() *NodePoolAutoscaling {
	if m != nil {
		return m.DesiredNodePoolAutoscaling
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredLocations() []string {
	if m != nil {
		return m.DesiredLocations
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredMasterAuthorizedNetworksConfig() *MasterAuthorizedNetworksConfig {
	if m != nil {
		return m.DesiredMasterAuthorizedNetworksConfig
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredPodSecurityPolicyConfig() *PodSecurityPolicyConfig {
	if m != nil {
		return m.DesiredPodSecurityPolicyConfig
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredMasterVersion() string {
	if m != nil {
		return m.DesiredMasterVersion
	}
	return ""
}

// This operation resource represents operations that may have happened or are
// happening on the cluster. All fields are output only.
type Operation struct {
	// The server-assigned ID for the operation.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the operation
	// is taking place.
	// This field is deprecated, use location instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The operation type.
	OperationType Operation_Type `protobuf:"varint,3,opt,name=operation_type,json=operationType,enum=google.container.v1alpha1.Operation_Type" json:"operation_type,omitempty"`
	// The current status of the operation.
	Status Operation_Status `protobuf:"varint,4,opt,name=status,enum=google.container.v1alpha1.Operation_Status" json:"status,omitempty"`
	// Detailed operation progress, if available.
	Detail string `protobuf:"bytes,8,opt,name=detail" json:"detail,omitempty"`
	// If an error has occurred, a textual description of the error.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage" json:"status_message,omitempty"`
	// Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,6,opt,name=self_link,json=selfLink" json:"self_link,omitempty"`
	// Server-defined URL for the target of the operation.
	TargetLink string `protobuf:"bytes,7,opt,name=target_link,json=targetLink" json:"target_link,omitempty"`
	// [Output only] The name of the Google Compute Engine
	// [zone](/compute/docs/regions-zones/regions-zones#available) or
	// [region](/compute/docs/regions-zones/regions-zones#available) in which
	// the cluster resides.
	Location string `protobuf:"bytes,9,opt,name=location" json:"location,omitempty"`
	// [Output only] The time the operation started, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	StartTime string `protobuf:"bytes,10,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// [Output only] The time the operation completed, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	EndTime string `protobuf:"bytes,11,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
}

func (m *Operation) Reset()                    { *m = Operation{} }
func (m *Operation) String() string            { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()               {}
func (*Operation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *Operation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Operation) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *Operation) GetOperationType() Operation_Type {
	if m != nil {
		return m.OperationType
	}
	return Operation_TYPE_UNSPECIFIED
}

func (m *Operation) GetStatus() Operation_Status {
	if m != nil {
		return m.Status
	}
	return Operation_STATUS_UNSPECIFIED
}

func (m *Operation) GetDetail() string {
	if m != nil {
		return m.Detail
	}
	return ""
}

func (m *Operation) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Operation) GetSelfLink() string {
	if m != nil {
		return m.SelfLink
	}
	return ""
}

func (m *Operation) GetTargetLink() string {
	if m != nil {
		return m.TargetLink
	}
	return ""
}

func (m *Operation) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *Operation) GetStartTime() string {
	if m != nil {
		return m.StartTime
	}
	return ""
}

func (m *Operation) GetEndTime() string {
	if m != nil {
		return m.EndTime
	}
	return ""
}

// CreateClusterRequest creates a cluster.
type CreateClusterRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use parent instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use parent instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// A [cluster
	// resource](/container-engine/reference/rest/v1alpha1/projects.zones.clusters)
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster" json:"cluster,omitempty"`
	// The parent (project and location) where the cluster will be created.
	// Specified in the format 'projects/*/locations/*'.
	Parent string `protobuf:"bytes,5,opt,name=parent" json:"parent,omitempty"`
}

func (m *CreateClusterRequest) Reset()                    { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()               {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *CreateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CreateClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *CreateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

func (m *CreateClusterRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// GetClusterRequest gets the settings of a cluster.
type GetClusterRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to retrieve.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The name (project, location, cluster) of the cluster to retrieve.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,5,opt,name=name" json:"name,omitempty"`
}

func (m *GetClusterRequest) Reset()                    { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()               {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *GetClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *GetClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// UpdateClusterRequest updates the settings of a cluster.
type UpdateClusterRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to upgrade.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// A description of the update.
	Update *ClusterUpdate `protobuf:"bytes,4,opt,name=update" json:"update,omitempty"`
	// The name (project, location, cluster) of the cluster to update.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,5,opt,name=name" json:"name,omitempty"`
}

func (m *UpdateClusterRequest) Reset()                    { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()               {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *UpdateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UpdateClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *UpdateClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterRequest) GetUpdate() *ClusterUpdate {
	if m != nil {
		return m.Update
	}
	return nil
}

func (m *UpdateClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetNodePoolVersionRequest updates the version of a node pool.
type UpdateNodePoolRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to upgrade.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The name of the node pool to upgrade.
	// This field is deprecated, use name instead.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId" json:"node_pool_id,omitempty"`
	// The Kubernetes version to change the nodes to (typically an
	// upgrade). Use `-` to upgrade to the latest version supported by
	// the server.
	NodeVersion string `protobuf:"bytes,5,opt,name=node_version,json=nodeVersion" json:"node_version,omitempty"`
	// The desired image type for the node pool.
	ImageType string `protobuf:"bytes,6,opt,name=image_type,json=imageType" json:"image_type,omitempty"`
	// The name (project, location, cluster, node pool) of the node pool to update.
	// Specified in the format 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name string `protobuf:"bytes,8,opt,name=name" json:"name,omitempty"`
}

func (m *UpdateNodePoolRequest) Reset()                    { *m = UpdateNodePoolRequest{} }
func (m *UpdateNodePoolRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateNodePoolRequest) ProtoMessage()               {}
func (*UpdateNodePoolRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *UpdateNodePoolRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UpdateNodePoolRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *UpdateNodePoolRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateNodePoolRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *UpdateNodePoolRequest) GetNodeVersion() string {
	if m != nil {
		return m.NodeVersion
	}
	return ""
}

func (m *UpdateNodePoolRequest) GetImageType() string {
	if m != nil {
		return m.ImageType
	}
	return ""
}

func (m *UpdateNodePoolRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetNodePoolAutoscalingRequest sets the autoscaler settings of a node pool.
type SetNodePoolAutoscalingRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to upgrade.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The name of the node pool to upgrade.
	// This field is deprecated, use name instead.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId" json:"node_pool_id,omitempty"`
	// Autoscaling configuration for the node pool.
	Autoscaling *NodePoolAutoscaling `protobuf:"bytes,5,opt,name=autoscaling" json:"autoscaling,omitempty"`
	// The name (project, location, cluster, node pool) of the node pool to set
	// autoscaler settings. Specified in the format
	// 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name string `protobuf:"bytes,6,opt,name=name" json:"name,omitempty"`
}

func (m *SetNodePoolAutoscalingRequest) Reset()                    { *m = SetNodePoolAutoscalingRequest{} }
func (m *SetNodePoolAutoscalingRequest) String() string            { return proto.CompactTextString(m) }
func (*SetNodePoolAutoscalingRequest) ProtoMessage()               {}
func (*SetNodePoolAutoscalingRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *SetNodePoolAutoscalingRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetNodePoolAutoscalingRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetNodePoolAutoscalingRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetNodePoolAutoscalingRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *SetNodePoolAutoscalingRequest) GetAutoscaling() *NodePoolAutoscaling {
	if m != nil {
		return m.Autoscaling
	}
	return nil
}

func (m *SetNodePoolAutoscalingRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetLoggingServiceRequest sets the logging service of a cluster.
type SetLoggingServiceRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to upgrade.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The logging service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "logging.googleapis.com" - the Google Cloud Logging service
	// * "none" - no metrics will be exported from the cluster
	LoggingService string `protobuf:"bytes,4,opt,name=logging_service,json=loggingService" json:"logging_service,omitempty"`
	// The name (project, location, cluster) of the cluster to set logging.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,5,opt,name=name" json:"name,omitempty"`
}

func (m *SetLoggingServiceRequest) Reset()                    { *m = SetLoggingServiceRequest{} }
func (m *SetLoggingServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*SetLoggingServiceRequest) ProtoMessage()               {}
func (*SetLoggingServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *SetLoggingServiceRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetLoggingServiceRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetLoggingServiceRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetLoggingServiceRequest) GetLoggingService() string {
	if m != nil {
		return m.LoggingService
	}
	return ""
}

func (m *SetLoggingServiceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetMonitoringServiceRequest sets the monitoring service of a cluster.
type SetMonitoringServiceRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to upgrade.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "monitoring.googleapis.com" - the Google Cloud Monitoring service
	// * "none" - no metrics will be exported from the cluster
	MonitoringService string `protobuf:"bytes,4,opt,name=monitoring_service,json=monitoringService" json:"monitoring_service,omitempty"`
	// The name (project, location, cluster) of the cluster to set monitoring.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,6,opt,name=name" json:"name,omitempty"`
}

func (m *SetMonitoringServiceRequest) Reset()                    { *m = SetMonitoringServiceRequest{} }
func (m *SetMonitoringServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*SetMonitoringServiceRequest) ProtoMessage()               {}
func (*SetMonitoringServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *SetMonitoringServiceRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetMonitoringServiceRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetMonitoringServiceRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetMonitoringServiceRequest) GetMonitoringService() string {
	if m != nil {
		return m.MonitoringService
	}
	return ""
}

func (m *SetMonitoringServiceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetAddonsRequest sets the addons associated with the cluster.
type SetAddonsConfigRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to upgrade.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The desired configurations for the various addons available to run in the
	// cluster.
	AddonsConfig *AddonsConfig `protobuf:"bytes,4,opt,name=addons_config,json=addonsConfig" json:"addons_config,omitempty"`
	// The name (project, location, cluster) of the cluster to set addons.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,6,opt,name=name" json:"name,omitempty"`
}

func (m *SetAddonsConfigRequest) Reset()                    { *m = SetAddonsConfigRequest{} }
func (m *SetAddonsConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*SetAddonsConfigRequest) ProtoMessage()               {}
func (*SetAddonsConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *SetAddonsConfigRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetAddonsConfigRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetAddonsConfigRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetAddonsConfigRequest) GetAddonsConfig() *AddonsConfig {
	if m != nil {
		return m.AddonsConfig
	}
	return nil
}

func (m *SetAddonsConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetLocationsRequest sets the locations of the cluster.
type SetLocationsRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to upgrade.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The desired list of Google Compute Engine
	// [locations](/compute/docs/zones#available) in which the cluster's nodes
	// should be located. Changing the locations a cluster is in will result
	// in nodes being either created or removed from the cluster, depending on
	// whether locations are being added or removed.
	//
	// This list must always include the cluster's primary zone.
	Locations []string `protobuf:"bytes,4,rep,name=locations" json:"locations,omitempty"`
	// The name (project, location, cluster) of the cluster to set locations.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,6,opt,name=name" json:"name,omitempty"`
}

func (m *SetLocationsRequest) Reset()                    { *m = SetLocationsRequest{} }
func (m *SetLocationsRequest) String() string            { return proto.CompactTextString(m) }
func (*SetLocationsRequest) ProtoMessage()               {}
func (*SetLocationsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *SetLocationsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetLocationsRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetLocationsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetLocationsRequest) GetLocations() []string {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *SetLocationsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// UpdateMasterRequest updates the master of the cluster.
type UpdateMasterRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to upgrade.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The Kubernetes version to change the master to. The only valid value is the
	// latest supported version. Use "-" to have the server automatically select
	// the latest version.
	MasterVersion string `protobuf:"bytes,4,opt,name=master_version,json=masterVersion" json:"master_version,omitempty"`
	// The name (project, location, cluster) of the cluster to update.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,7,opt,name=name" json:"name,omitempty"`
}

func (m *UpdateMasterRequest) Reset()                    { *m = UpdateMasterRequest{} }
func (m *UpdateMasterRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateMasterRequest) ProtoMessage()               {}
func (*UpdateMasterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *UpdateMasterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UpdateMasterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *UpdateMasterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateMasterRequest) GetMasterVersion() string {
	if m != nil {
		return m.MasterVersion
	}
	return ""
}

func (m *UpdateMasterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetMasterAuthRequest updates the admin password of a cluster.
type SetMasterAuthRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to upgrade.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The exact form of action to be taken on the master auth.
	Action SetMasterAuthRequest_Action `protobuf:"varint,4,opt,name=action,enum=google.container.v1alpha1.SetMasterAuthRequest_Action" json:"action,omitempty"`
	// A description of the update.
	Update *MasterAuth `protobuf:"bytes,5,opt,name=update" json:"update,omitempty"`
	// The name (project, location, cluster) of the cluster to set auth.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,7,opt,name=name" json:"name,omitempty"`
}

func (m *SetMasterAuthRequest) Reset()                    { *m = SetMasterAuthRequest{} }
func (m *SetMasterAuthRequest) String() string            { return proto.CompactTextString(m) }
func (*SetMasterAuthRequest) ProtoMessage()               {}
func (*SetMasterAuthRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *SetMasterAuthRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetMasterAuthRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetMasterAuthRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetMasterAuthRequest) GetAction() SetMasterAuthRequest_Action {
	if m != nil {
		return m.Action
	}
	return SetMasterAuthRequest_UNKNOWN
}

func (m *SetMasterAuthRequest) GetUpdate() *MasterAuth {
	if m != nil {
		return m.Update
	}
	return nil
}

func (m *SetMasterAuthRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// DeleteClusterRequest deletes a cluster.
type DeleteClusterRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to delete.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The name (project, location, cluster) of the cluster to delete.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteClusterRequest) Reset()                    { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()               {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *DeleteClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeleteClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *DeleteClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListClustersRequest lists clusters.
type ListClustersRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use parent instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides, or "-" for all zones.
	// This field is deprecated, use parent instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The parent (project and location) where the clusters will be listed.
	// Specified in the format 'projects/*/locations/*'.
	// Location "-" matches all zones and all regions.
	Parent string `protobuf:"bytes,4,opt,name=parent" json:"parent,omitempty"`
}

func (m *ListClustersRequest) Reset()                    { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()               {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *ListClustersRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListClustersRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *ListClustersRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// ListClustersResponse is the result of ListClustersRequest.
type ListClustersResponse struct {
	// A list of clusters in the project in the specified zone, or
	// across all ones.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters" json:"clusters,omitempty"`
	// If any zones are listed here, the list of clusters returned
	// may be missing those zones.
	MissingZones []string `protobuf:"bytes,2,rep,name=missing_zones,json=missingZones" json:"missing_zones,omitempty"`
}

func (m *ListClustersResponse) Reset()                    { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()               {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetMissingZones() []string {
	if m != nil {
		return m.MissingZones
	}
	return nil
}

// GetOperationRequest gets a single operation.
type GetOperationRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The server-assigned `name` of the operation.
	// This field is deprecated, use name instead.
	OperationId string `protobuf:"bytes,3,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
	// The name (project, location, operation id) of the operation to get.
	// Specified in the format 'projects/*/locations/*/operations/*'.
	Name string `protobuf:"bytes,5,opt,name=name" json:"name,omitempty"`
}

func (m *GetOperationRequest) Reset()                    { *m = GetOperationRequest{} }
func (m *GetOperationRequest) String() string            { return proto.CompactTextString(m) }
func (*GetOperationRequest) ProtoMessage()               {}
func (*GetOperationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

func (m *GetOperationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetOperationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *GetOperationRequest) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *GetOperationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListOperationsRequest lists operations.
type ListOperationsRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use parent instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine [zone](/compute/docs/zones#available)
	// to return operations for, or `-` for all zones.
	// This field is deprecated, use parent instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The parent (project and location) where the operations will be listed.
	// Specified in the format 'projects/*/locations/*'.
	// Location "-" matches all zones and all regions.
	Parent string `protobuf:"bytes,4,opt,name=parent" json:"parent,omitempty"`
}

func (m *ListOperationsRequest) Reset()                    { *m = ListOperationsRequest{} }
func (m *ListOperationsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListOperationsRequest) ProtoMessage()               {}
func (*ListOperationsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *ListOperationsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListOperationsRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *ListOperationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// CancelOperationRequest cancels a single operation.
type CancelOperationRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the operation resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The server-assigned `name` of the operation.
	// This field is deprecated, use name instead.
	OperationId string `protobuf:"bytes,3,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
	// The name (project, location, operation id) of the operation to cancel.
	// Specified in the format 'projects/*/locations/*/operations/*'.
	Name string `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
}

func (m *CancelOperationRequest) Reset()                    { *m = CancelOperationRequest{} }
func (m *CancelOperationRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelOperationRequest) ProtoMessage()               {}
func (*CancelOperationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *CancelOperationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CancelOperationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *CancelOperationRequest) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *CancelOperationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListOperationsResponse is the result of ListOperationsRequest.
type ListOperationsResponse struct {
	// A list of operations in the project in the specified zone.
	Operations []*Operation `protobuf:"bytes,1,rep,name=operations" json:"operations,omitempty"`
	// If any zones are listed here, the list of operations returned
	// may be missing the operations from those zones.
	MissingZones []string `protobuf:"bytes,2,rep,name=missing_zones,json=missingZones" json:"missing_zones,omitempty"`
}

func (m *ListOperationsResponse) Reset()                    { *m = ListOperationsResponse{} }
func (m *ListOperationsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListOperationsResponse) ProtoMessage()               {}
func (*ListOperationsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *ListOperationsResponse) GetOperations() []*Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListOperationsResponse) GetMissingZones() []string {
	if m != nil {
		return m.MissingZones
	}
	return nil
}

// Gets the current Container Engine service configuration.
type GetServerConfigRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine [zone](/compute/docs/zones#available)
	// to return operations for.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name (project and location) of the server config to get
	// Specified in the format 'projects/*/locations/*'.
	Name string `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
}

func (m *GetServerConfigRequest) Reset()                    { *m = GetServerConfigRequest{} }
func (m *GetServerConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*GetServerConfigRequest) ProtoMessage()               {}
func (*GetServerConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *GetServerConfigRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetServerConfigRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *GetServerConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Container Engine service configuration.
type ServerConfig struct {
	// Version of Kubernetes the service deploys by default.
	DefaultClusterVersion string `protobuf:"bytes,1,opt,name=default_cluster_version,json=defaultClusterVersion" json:"default_cluster_version,omitempty"`
	// List of valid node upgrade target versions.
	ValidNodeVersions []string `protobuf:"bytes,3,rep,name=valid_node_versions,json=validNodeVersions" json:"valid_node_versions,omitempty"`
	// Default image type.
	DefaultImageType string `protobuf:"bytes,4,opt,name=default_image_type,json=defaultImageType" json:"default_image_type,omitempty"`
	// List of valid image types.
	ValidImageTypes []string `protobuf:"bytes,5,rep,name=valid_image_types,json=validImageTypes" json:"valid_image_types,omitempty"`
	// List of valid master versions.
	ValidMasterVersions []string `protobuf:"bytes,6,rep,name=valid_master_versions,json=validMasterVersions" json:"valid_master_versions,omitempty"`
}

func (m *ServerConfig) Reset()                    { *m = ServerConfig{} }
func (m *ServerConfig) String() string            { return proto.CompactTextString(m) }
func (*ServerConfig) ProtoMessage()               {}
func (*ServerConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *ServerConfig) GetDefaultClusterVersion() string {
	if m != nil {
		return m.DefaultClusterVersion
	}
	return ""
}

func (m *ServerConfig) GetValidNodeVersions() []string {
	if m != nil {
		return m.ValidNodeVersions
	}
	return nil
}

func (m *ServerConfig) GetDefaultImageType() string {
	if m != nil {
		return m.DefaultImageType
	}
	return ""
}

func (m *ServerConfig) GetValidImageTypes() []string {
	if m != nil {
		return m.ValidImageTypes
	}
	return nil
}

func (m *ServerConfig) GetValidMasterVersions() []string {
	if m != nil {
		return m.ValidMasterVersions
	}
	return nil
}

// CreateNodePoolRequest creates a node pool for a cluster.
type CreateNodePoolRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field is deprecated, use parent instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use parent instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster.
	// This field is deprecated, use parent instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The node pool to create.
	NodePool *NodePool `protobuf:"bytes,4,opt,name=node_pool,json=nodePool" json:"node_pool,omitempty"`
	// The parent (project, location, cluster id) where the node pool will be created.
	// Specified in the format 'projects/*/locations/*/clusters/*/nodePools/*'.
	Parent string `protobuf:"bytes,6,opt,name=parent" json:"parent,omitempty"`
}

func (m *CreateNodePoolRequest) Reset()                    { *m = CreateNodePoolRequest{} }
func (m *CreateNodePoolRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateNodePoolRequest) ProtoMessage()               {}
func (*CreateNodePoolRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *CreateNodePoolRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CreateNodePoolRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *CreateNodePoolRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateNodePoolRequest) GetNodePool() *NodePool {
	if m != nil {
		return m.NodePool
	}
	return nil
}

func (m *CreateNodePoolRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// DeleteNodePoolRequest deletes a node pool for a cluster.
type DeleteNodePoolRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The name of the node pool to delete.
	// This field is deprecated, use name instead.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId" json:"node_pool_id,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to delete.
	// Specified in the format 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name string `protobuf:"bytes,6,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteNodePoolRequest) Reset()                    { *m = DeleteNodePoolRequest{} }
func (m *DeleteNodePoolRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteNodePoolRequest) ProtoMessage()               {}
func (*DeleteNodePoolRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *DeleteNodePoolRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeleteNodePoolRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *DeleteNodePoolRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteNodePoolRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *DeleteNodePoolRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListNodePoolsRequest lists the node pool(s) for a cluster.
type ListNodePoolsRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field is deprecated, use parent instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use parent instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster.
	// This field is deprecated, use parent instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The parent (project, location, cluster id) where the node pools will be listed.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Parent string `protobuf:"bytes,5,opt,name=parent" json:"parent,omitempty"`
}

func (m *ListNodePoolsRequest) Reset()                    { *m = ListNodePoolsRequest{} }
func (m *ListNodePoolsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListNodePoolsRequest) ProtoMessage()               {}
func (*ListNodePoolsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *ListNodePoolsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListNodePoolsRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *ListNodePoolsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListNodePoolsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// GetNodePoolRequest retrieves a node pool for a cluster.
type GetNodePoolRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The name of the node pool.
	// This field is deprecated, use name instead.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId" json:"node_pool_id,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to get.
	// Specified in the format 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name string `protobuf:"bytes,6,opt,name=name" json:"name,omitempty"`
}

func (m *GetNodePoolRequest) Reset()                    { *m = GetNodePoolRequest{} }
func (m *GetNodePoolRequest) String() string            { return proto.CompactTextString(m) }
func (*GetNodePoolRequest) ProtoMessage()               {}
func (*GetNodePoolRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *GetNodePoolRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetNodePoolRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *GetNodePoolRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetNodePoolRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *GetNodePoolRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// NodePool contains the name and configuration for a cluster's node pool.
// Node pools are a set of nodes (i.e. VM's), with a common configuration and
// specification, under the control of the cluster master. They may have a set
// of Kubernetes labels applied to them, which may be used to reference them
// during pod scheduling. They may also be resized up or down, to accommodate
// the workload.
type NodePool struct {
	// The name of the node pool.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The node configuration of the pool.
	Config *NodeConfig `protobuf:"bytes,2,opt,name=config" json:"config,omitempty"`
	// The initial node count for the pool. You must ensure that your
	// Compute Engine <a href="/compute/docs/resource-quotas">resource quota</a>
	// is sufficient for this number of instances. You must also have available
	// firewall and routes quota.
	InitialNodeCount int32 `protobuf:"varint,3,opt,name=initial_node_count,json=initialNodeCount" json:"initial_node_count,omitempty"`
	// Autoscaler configuration for this NodePool. Autoscaler is enabled
	// only if a valid configuration is present.
	Autoscaling *NodePoolAutoscaling `protobuf:"bytes,4,opt,name=autoscaling" json:"autoscaling,omitempty"`
	// NodeManagement configuration for this NodePool.
	Management *NodeManagement `protobuf:"bytes,5,opt,name=management" json:"management,omitempty"`
	// [Output only] Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,100,opt,name=self_link,json=selfLink" json:"self_link,omitempty"`
	// [Output only] The version of the Kubernetes of this node.
	Version string `protobuf:"bytes,101,opt,name=version" json:"version,omitempty"`
	// [Output only] The resource URLs of [instance
	// groups](/compute/docs/instance-groups/) associated with this
	// node pool.
	InstanceGroupUrls []string `protobuf:"bytes,102,rep,name=instance_group_urls,json=instanceGroupUrls" json:"instance_group_urls,omitempty"`
	// [Output only] The status of the nodes in this pool instance.
	Status NodePool_Status `protobuf:"varint,103,opt,name=status,enum=google.container.v1alpha1.NodePool_Status" json:"status,omitempty"`
	// [Output only] Additional information about the current status of this
	// node pool instance, if available.
	StatusMessage string `protobuf:"bytes,104,opt,name=status_message,json=statusMessage" json:"status_message,omitempty"`
}

func (m *NodePool) Reset()                    { *m = NodePool{} }
func (m *NodePool) String() string            { return proto.CompactTextString(m) }
func (*NodePool) ProtoMessage()               {}
func (*NodePool) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *NodePool) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NodePool) GetConfig() *NodeConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *NodePool) GetInitialNodeCount() int32 {
	if m != nil {
		return m.InitialNodeCount
	}
	return 0
}

func (m *NodePool) GetAutoscaling() *NodePoolAutoscaling {
	if m != nil {
		return m.Autoscaling
	}
	return nil
}

func (m *NodePool) GetManagement() *NodeManagement {
	if m != nil {
		return m.Management
	}
	return nil
}

func (m *NodePool) GetSelfLink() string {
	if m != nil {
		return m.SelfLink
	}
	return ""
}

func (m *NodePool) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *NodePool) GetInstanceGroupUrls() []string {
	if m != nil {
		return m.InstanceGroupUrls
	}
	return nil
}

func (m *NodePool) GetStatus() NodePool_Status {
	if m != nil {
		return m.Status
	}
	return NodePool_STATUS_UNSPECIFIED
}

func (m *NodePool) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

// NodeManagement defines the set of node management services turned on for the
// node pool.
type NodeManagement struct {
	// Whether the nodes will be automatically upgraded.
	AutoUpgrade bool `protobuf:"varint,1,opt,name=auto_upgrade,json=autoUpgrade" json:"auto_upgrade,omitempty"`
	// Whether the nodes will be automatically repaired.
	AutoRepair bool `protobuf:"varint,2,opt,name=auto_repair,json=autoRepair" json:"auto_repair,omitempty"`
	// Specifies the Auto Upgrade knobs for the node pool.
	UpgradeOptions *AutoUpgradeOptions `protobuf:"bytes,10,opt,name=upgrade_options,json=upgradeOptions" json:"upgrade_options,omitempty"`
}

func (m *NodeManagement) Reset()                    { *m = NodeManagement{} }
func (m *NodeManagement) String() string            { return proto.CompactTextString(m) }
func (*NodeManagement) ProtoMessage()               {}
func (*NodeManagement) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

func (m *NodeManagement) GetAutoUpgrade() bool {
	if m != nil {
		return m.AutoUpgrade
	}
	return false
}

func (m *NodeManagement) GetAutoRepair() bool {
	if m != nil {
		return m.AutoRepair
	}
	return false
}

func (m *NodeManagement) GetUpgradeOptions() *AutoUpgradeOptions {
	if m != nil {
		return m.UpgradeOptions
	}
	return nil
}

// AutoUpgradeOptions defines the set of options for the user to control how
// the Auto Upgrades will proceed.
type AutoUpgradeOptions struct {
	// [Output only] This field is set when upgrades are about to commence
	// with the approximate start time for the upgrades, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	AutoUpgradeStartTime string `protobuf:"bytes,1,opt,name=auto_upgrade_start_time,json=autoUpgradeStartTime" json:"auto_upgrade_start_time,omitempty"`
	// [Output only] This field is set when upgrades are about to commence
	// with the description of the upgrade.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
}

func (m *AutoUpgradeOptions) Reset()                    { *m = AutoUpgradeOptions{} }
func (m *AutoUpgradeOptions) String() string            { return proto.CompactTextString(m) }
func (*AutoUpgradeOptions) ProtoMessage()               {}
func (*AutoUpgradeOptions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{42} }

func (m *AutoUpgradeOptions) GetAutoUpgradeStartTime() string {
	if m != nil {
		return m.AutoUpgradeStartTime
	}
	return ""
}

func (m *AutoUpgradeOptions) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// MaintenancePolicy defines the maintenance policy to be used for the cluster.
type MaintenancePolicy struct {
	// Specifies the maintenance window in which maintenance may be performed.
	Window *MaintenanceWindow `protobuf:"bytes,1,opt,name=window" json:"window,omitempty"`
}

func (m *MaintenancePolicy) Reset()                    { *m = MaintenancePolicy{} }
func (m *MaintenancePolicy) String() string            { return proto.CompactTextString(m) }
func (*MaintenancePolicy) ProtoMessage()               {}
func (*MaintenancePolicy) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{43} }

func (m *MaintenancePolicy) GetWindow() *MaintenanceWindow {
	if m != nil {
		return m.Window
	}
	return nil
}

// MaintenanceWindow defines the maintenance window to be used for the cluster.
type MaintenanceWindow struct {
	// Unimplemented, reserved for future use.
	// HourlyMaintenanceWindow hourly_maintenance_window = 1;
	//
	// Types that are valid to be assigned to Policy:
	//	*MaintenanceWindow_DailyMaintenanceWindow
	Policy isMaintenanceWindow_Policy `protobuf_oneof:"policy"`
}

func (m *MaintenanceWindow) Reset()                    { *m = MaintenanceWindow{} }
func (m *MaintenanceWindow) String() string            { return proto.CompactTextString(m) }
func (*MaintenanceWindow) ProtoMessage()               {}
func (*MaintenanceWindow) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{44} }

type isMaintenanceWindow_Policy interface {
	isMaintenanceWindow_Policy()
}

type MaintenanceWindow_DailyMaintenanceWindow struct {
	DailyMaintenanceWindow *DailyMaintenanceWindow `protobuf:"bytes,2,opt,name=daily_maintenance_window,json=dailyMaintenanceWindow,oneof"`
}

func (*MaintenanceWindow_DailyMaintenanceWindow) isMaintenanceWindow_Policy() {}

func (m *MaintenanceWindow) GetPolicy() isMaintenanceWindow_Policy {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (m *MaintenanceWindow) GetDailyMaintenanceWindow() *DailyMaintenanceWindow {
	if x, ok := m.GetPolicy().(*MaintenanceWindow_DailyMaintenanceWindow); ok {
		return x.DailyMaintenanceWindow
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*MaintenanceWindow) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _MaintenanceWindow_OneofMarshaler, _MaintenanceWindow_OneofUnmarshaler, _MaintenanceWindow_OneofSizer, []interface{}{
		(*MaintenanceWindow_DailyMaintenanceWindow)(nil),
	}
}

func _MaintenanceWindow_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*MaintenanceWindow)
	// policy
	switch x := m.Policy.(type) {
	case *MaintenanceWindow_DailyMaintenanceWindow:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DailyMaintenanceWindow); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("MaintenanceWindow.Policy has unexpected type %T", x)
	}
	return nil
}

func _MaintenanceWindow_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*MaintenanceWindow)
	switch tag {
	case 2: // policy.daily_maintenance_window
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DailyMaintenanceWindow)
		err := b.DecodeMessage(msg)
		m.Policy = &MaintenanceWindow_DailyMaintenanceWindow{msg}
		return true, err
	default:
		return false, nil
	}
}

func _MaintenanceWindow_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*MaintenanceWindow)
	// policy
	switch x := m.Policy.(type) {
	case *MaintenanceWindow_DailyMaintenanceWindow:
		s := proto.Size(x.DailyMaintenanceWindow)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Time window specified for daily maintenance operations.
type DailyMaintenanceWindow struct {
	// Time within the maintenance window to start the maintenance operations.
	// It must be in format "HH:MM”, where HH : [00-23] and MM : [00-59] GMT.
	StartTime string `protobuf:"bytes,2,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// [Output only] Duration of the time window, automatically chosen to be
	// smallest possible in the given scenario.
	Duration string `protobuf:"bytes,3,opt,name=duration" json:"duration,omitempty"`
}

func (m *DailyMaintenanceWindow) Reset()                    { *m = DailyMaintenanceWindow{} }
func (m *DailyMaintenanceWindow) String() string            { return proto.CompactTextString(m) }
func (*DailyMaintenanceWindow) ProtoMessage()               {}
func (*DailyMaintenanceWindow) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{45} }

func (m *DailyMaintenanceWindow) GetStartTime() string {
	if m != nil {
		return m.StartTime
	}
	return ""
}

func (m *DailyMaintenanceWindow) GetDuration() string {
	if m != nil {
		return m.Duration
	}
	return ""
}

// SetNodePoolManagementRequest sets the node management properties of a node
// pool.
type SetNodePoolManagementRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to update.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The name of the node pool to update.
	// This field is deprecated, use name instead.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId" json:"node_pool_id,omitempty"`
	// NodeManagement configuration for the node pool.
	Management *NodeManagement `protobuf:"bytes,5,opt,name=management" json:"management,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to set
	// management properties. Specified in the format
	// 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name string `protobuf:"bytes,7,opt,name=name" json:"name,omitempty"`
}

func (m *SetNodePoolManagementRequest) Reset()                    { *m = SetNodePoolManagementRequest{} }
func (m *SetNodePoolManagementRequest) String() string            { return proto.CompactTextString(m) }
func (*SetNodePoolManagementRequest) ProtoMessage()               {}
func (*SetNodePoolManagementRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{46} }

func (m *SetNodePoolManagementRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetNodePoolManagementRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetNodePoolManagementRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetNodePoolManagementRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *SetNodePoolManagementRequest) GetManagement() *NodeManagement {
	if m != nil {
		return m.Management
	}
	return nil
}

func (m *SetNodePoolManagementRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetNodePoolSizeRequest sets the size a node
// pool.
type SetNodePoolSizeRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to update.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The name of the node pool to update.
	// This field is deprecated, use name instead.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId" json:"node_pool_id,omitempty"`
	// The desired node count for the pool.
	NodeCount int32 `protobuf:"varint,5,opt,name=node_count,json=nodeCount" json:"node_count,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to set
	// size.
	// Specified in the format 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name string `protobuf:"bytes,7,opt,name=name" json:"name,omitempty"`
}

func (m *SetNodePoolSizeRequest) Reset()                    { *m = SetNodePoolSizeRequest{} }
func (m *SetNodePoolSizeRequest) String() string            { return proto.CompactTextString(m) }
func (*SetNodePoolSizeRequest) ProtoMessage()               {}
func (*SetNodePoolSizeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{47} }

func (m *SetNodePoolSizeRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetNodePoolSizeRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetNodePoolSizeRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetNodePoolSizeRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *SetNodePoolSizeRequest) GetNodeCount() int32 {
	if m != nil {
		return m.NodeCount
	}
	return 0
}

func (m *SetNodePoolSizeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// RollbackNodePoolUpgradeRequest rollbacks the previously Aborted or Failed
// NodePool upgrade. This will be an no-op if the last upgrade successfully
// completed.
type RollbackNodePoolUpgradeRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to rollback.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The name of the node pool to rollback.
	// This field is deprecated, use name instead.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId" json:"node_pool_id,omitempty"`
	// The name (project, location, cluster, node pool id) of the node poll to
	// rollback upgrade.
	// Specified in the format 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name string `protobuf:"bytes,6,opt,name=name" json:"name,omitempty"`
}

func (m *RollbackNodePoolUpgradeRequest) Reset()                    { *m = RollbackNodePoolUpgradeRequest{} }
func (m *RollbackNodePoolUpgradeRequest) String() string            { return proto.CompactTextString(m) }
func (*RollbackNodePoolUpgradeRequest) ProtoMessage()               {}
func (*RollbackNodePoolUpgradeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{48} }

func (m *RollbackNodePoolUpgradeRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RollbackNodePoolUpgradeRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *RollbackNodePoolUpgradeRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *RollbackNodePoolUpgradeRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *RollbackNodePoolUpgradeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListNodePoolsResponse is the result of ListNodePoolsRequest.
type ListNodePoolsResponse struct {
	// A list of node pools for a cluster.
	NodePools []*NodePool `protobuf:"bytes,1,rep,name=node_pools,json=nodePools" json:"node_pools,omitempty"`
}

func (m *ListNodePoolsResponse) Reset()                    { *m = ListNodePoolsResponse{} }
func (m *ListNodePoolsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListNodePoolsResponse) ProtoMessage()               {}
func (*ListNodePoolsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{49} }

func (m *ListNodePoolsResponse) GetNodePools() []*NodePool {
	if m != nil {
		return m.NodePools
	}
	return nil
}

// NodePoolAutoscaling contains information required by cluster autoscaler to
// adjust the size of the node pool to the current cluster usage.
type NodePoolAutoscaling struct {
	// Is autoscaling enabled for this node pool.
	Enabled bool `protobuf:"varint,1,opt,name=enabled" json:"enabled,omitempty"`
	// Minimum number of nodes in the NodePool. Must be >= 1 and <=
	// max_node_count.
	MinNodeCount int32 `protobuf:"varint,2,opt,name=min_node_count,json=minNodeCount" json:"min_node_count,omitempty"`
	// Maximum number of nodes in the NodePool. Must be >= min_node_count. There
	// has to enough quota to scale up the cluster.
	MaxNodeCount int32 `protobuf:"varint,3,opt,name=max_node_count,json=maxNodeCount" json:"max_node_count,omitempty"`
}

func (m *NodePoolAutoscaling) Reset()                    { *m = NodePoolAutoscaling{} }
func (m *NodePoolAutoscaling) String() string            { return proto.CompactTextString(m) }
func (*NodePoolAutoscaling) ProtoMessage()               {}
func (*NodePoolAutoscaling) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{50} }

func (m *NodePoolAutoscaling) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *NodePoolAutoscaling) GetMinNodeCount() int32 {
	if m != nil {
		return m.MinNodeCount
	}
	return 0
}

func (m *NodePoolAutoscaling) GetMaxNodeCount() int32 {
	if m != nil {
		return m.MaxNodeCount
	}
	return 0
}

// SetLabelsRequest sets the Google Cloud Platform labels on a Google Container
// Engine cluster, which will in turn set them for Google Compute Engine
// resources used by that cluster
type SetLabelsRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The labels to set for that cluster.
	ResourceLabels map[string]string `protobuf:"bytes,4,rep,name=resource_labels,json=resourceLabels" json:"resource_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The fingerprint of the previous set of labels for this resource,
	// used to detect conflicts. The fingerprint is initially generated by
	// Container Engine and changes after every request to modify or update
	// labels. You must always provide an up-to-date fingerprint hash when
	// updating or changing labels. Make a <code>get()</code> request to the
	// resource to get the latest fingerprint.
	LabelFingerprint string `protobuf:"bytes,5,opt,name=label_fingerprint,json=labelFingerprint" json:"label_fingerprint,omitempty"`
	// The name (project, location, cluster id) of the cluster to set labels.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,7,opt,name=name" json:"name,omitempty"`
}

func (m *SetLabelsRequest) Reset()                    { *m = SetLabelsRequest{} }
func (m *SetLabelsRequest) String() string            { return proto.CompactTextString(m) }
func (*SetLabelsRequest) ProtoMessage()               {}
func (*SetLabelsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{51} }

func (m *SetLabelsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetLabelsRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetLabelsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetLabelsRequest) GetResourceLabels() map[string]string {
	if m != nil {
		return m.ResourceLabels
	}
	return nil
}

func (m *SetLabelsRequest) GetLabelFingerprint() string {
	if m != nil {
		return m.LabelFingerprint
	}
	return ""
}

func (m *SetLabelsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetLegacyAbacRequest enables or disables the ABAC authorization mechanism for
// a cluster.
type SetLegacyAbacRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to update.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// Whether ABAC authorization will be enabled in the cluster.
	Enabled bool `protobuf:"varint,4,opt,name=enabled" json:"enabled,omitempty"`
	// The name (project, location, cluster id) of the cluster to set legacy abac.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,6,opt,name=name" json:"name,omitempty"`
}

func (m *SetLegacyAbacRequest) Reset()                    { *m = SetLegacyAbacRequest{} }
func (m *SetLegacyAbacRequest) String() string            { return proto.CompactTextString(m) }
func (*SetLegacyAbacRequest) ProtoMessage()               {}
func (*SetLegacyAbacRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{52} }

func (m *SetLegacyAbacRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetLegacyAbacRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetLegacyAbacRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetLegacyAbacRequest) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *SetLegacyAbacRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// StartIPRotationRequest creates a new IP for the cluster and then performs
// a node upgrade on each node pool to point to the new IP.
type StartIPRotationRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The name (project, location, cluster id) of the cluster to start IP rotation.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,6,opt,name=name" json:"name,omitempty"`
}

func (m *StartIPRotationRequest) Reset()                    { *m = StartIPRotationRequest{} }
func (m *StartIPRotationRequest) String() string            { return proto.CompactTextString(m) }
func (*StartIPRotationRequest) ProtoMessage()               {}
func (*StartIPRotationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{53} }

func (m *StartIPRotationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *StartIPRotationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *StartIPRotationRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *StartIPRotationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// CompleteIPRotationRequest moves the cluster master back into single-IP mode.
type CompleteIPRotationRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The name (project, location, cluster id) of the cluster to complete IP rotation.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,7,opt,name=name" json:"name,omitempty"`
}

func (m *CompleteIPRotationRequest) Reset()                    { *m = CompleteIPRotationRequest{} }
func (m *CompleteIPRotationRequest) String() string            { return proto.CompactTextString(m) }
func (*CompleteIPRotationRequest) ProtoMessage()               {}
func (*CompleteIPRotationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{54} }

func (m *CompleteIPRotationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CompleteIPRotationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *CompleteIPRotationRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CompleteIPRotationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// AcceleratorConfig represents a Hardware Accelerator request.
type AcceleratorConfig struct {
	// The number of the accelerator cards exposed to an instance.
	AcceleratorCount int64 `protobuf:"varint,1,opt,name=accelerator_count,json=acceleratorCount" json:"accelerator_count,omitempty"`
	// The accelerator type resource name. List of supported accelerators
	// [here](/compute/docs/gpus/#Introduction)
	AcceleratorType string `protobuf:"bytes,2,opt,name=accelerator_type,json=acceleratorType" json:"accelerator_type,omitempty"`
}

func (m *AcceleratorConfig) Reset()                    { *m = AcceleratorConfig{} }
func (m *AcceleratorConfig) String() string            { return proto.CompactTextString(m) }
func (*AcceleratorConfig) ProtoMessage()               {}
func (*AcceleratorConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{55} }

func (m *AcceleratorConfig) GetAcceleratorCount() int64 {
	if m != nil {
		return m.AcceleratorCount
	}
	return 0
}

func (m *AcceleratorConfig) GetAcceleratorType() string {
	if m != nil {
		return m.AcceleratorType
	}
	return ""
}

// SetNetworkPolicyRequest enables/disables network policy for a cluster.
type SetNetworkPolicyRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field is deprecated, use name instead.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use name instead.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster.
	// This field is deprecated, use name instead.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// Configuration options for the NetworkPolicy feature.
	NetworkPolicy *NetworkPolicy `protobuf:"bytes,4,opt,name=network_policy,json=networkPolicy" json:"network_policy,omitempty"`
	// The name (project, location, cluster id) of the cluster to set networking
	// policy.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,6,opt,name=name" json:"name,omitempty"`
}

func (m *SetNetworkPolicyRequest) Reset()                    { *m = SetNetworkPolicyRequest{} }
func (m *SetNetworkPolicyRequest) String() string            { return proto.CompactTextString(m) }
func (*SetNetworkPolicyRequest) ProtoMessage()               {}
func (*SetNetworkPolicyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{56} }

func (m *SetNetworkPolicyRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetNetworkPolicyRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetNetworkPolicyRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetNetworkPolicyRequest) GetNetworkPolicy() *NetworkPolicy {
	if m != nil {
		return m.NetworkPolicy
	}
	return nil
}

func (m *SetNetworkPolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetMaintenancePolicyRequest sets the maintenance policy for a cluster.
type SetMaintenancePolicyRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to update.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The maintenance policy to be set for the cluster. An empty field
	// clears the existing maintenance policy.
	MaintenancePolicy *MaintenancePolicy `protobuf:"bytes,4,opt,name=maintenance_policy,json=maintenancePolicy" json:"maintenance_policy,omitempty"`
	// The name (project, location, cluster id) of the cluster to set maintenance
	// policy.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,5,opt,name=name" json:"name,omitempty"`
}

func (m *SetMaintenancePolicyRequest) Reset()                    { *m = SetMaintenancePolicyRequest{} }
func (m *SetMaintenancePolicyRequest) String() string            { return proto.CompactTextString(m) }
func (*SetMaintenancePolicyRequest) ProtoMessage()               {}
func (*SetMaintenancePolicyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{57} }

func (m *SetMaintenancePolicyRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetMaintenancePolicyRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetMaintenancePolicyRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetMaintenancePolicyRequest) GetMaintenancePolicy() *MaintenancePolicy {
	if m != nil {
		return m.MaintenancePolicy
	}
	return nil
}

func (m *SetMaintenancePolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*NodeConfig)(nil), "google.container.v1alpha1.NodeConfig")
	proto.RegisterType((*NodeTaint)(nil), "google.container.v1alpha1.NodeTaint")
	proto.RegisterType((*MasterAuth)(nil), "google.container.v1alpha1.MasterAuth")
	proto.RegisterType((*ClientCertificateConfig)(nil), "google.container.v1alpha1.ClientCertificateConfig")
	proto.RegisterType((*AddonsConfig)(nil), "google.container.v1alpha1.AddonsConfig")
	proto.RegisterType((*HttpLoadBalancing)(nil), "google.container.v1alpha1.HttpLoadBalancing")
	proto.RegisterType((*HorizontalPodAutoscaling)(nil), "google.container.v1alpha1.HorizontalPodAutoscaling")
	proto.RegisterType((*KubernetesDashboard)(nil), "google.container.v1alpha1.KubernetesDashboard")
	proto.RegisterType((*NetworkPolicyConfig)(nil), "google.container.v1alpha1.NetworkPolicyConfig")
	proto.RegisterType((*MasterAuthorizedNetworksConfig)(nil), "google.container.v1alpha1.MasterAuthorizedNetworksConfig")
	proto.RegisterType((*MasterAuthorizedNetworksConfig_CidrBlock)(nil), "google.container.v1alpha1.MasterAuthorizedNetworksConfig.CidrBlock")
	proto.RegisterType((*NetworkPolicy)(nil), "google.container.v1alpha1.NetworkPolicy")
	proto.RegisterType((*IPAllocationPolicy)(nil), "google.container.v1alpha1.IPAllocationPolicy")
	proto.RegisterType((*PodSecurityPolicyConfig)(nil), "google.container.v1alpha1.PodSecurityPolicyConfig")
	proto.RegisterType((*Cluster)(nil), "google.container.v1alpha1.Cluster")
	proto.RegisterType((*ClusterUpdate)(nil), "google.container.v1alpha1.ClusterUpdate")
	proto.RegisterType((*Operation)(nil), "google.container.v1alpha1.Operation")
	proto.RegisterType((*CreateClusterRequest)(nil), "google.container.v1alpha1.CreateClusterRequest")
	proto.RegisterType((*GetClusterRequest)(nil), "google.container.v1alpha1.GetClusterRequest")
	proto.RegisterType((*UpdateClusterRequest)(nil), "google.container.v1alpha1.UpdateClusterRequest")
	proto.RegisterType((*UpdateNodePoolRequest)(nil), "google.container.v1alpha1.UpdateNodePoolRequest")
	proto.RegisterType((*SetNodePoolAutoscalingRequest)(nil), "google.container.v1alpha1.SetNodePoolAutoscalingRequest")
	proto.RegisterType((*SetLoggingServiceRequest)(nil), "google.container.v1alpha1.SetLoggingServiceRequest")
	proto.RegisterType((*SetMonitoringServiceRequest)(nil), "google.container.v1alpha1.SetMonitoringServiceRequest")
	proto.RegisterType((*SetAddonsConfigRequest)(nil), "google.container.v1alpha1.SetAddonsConfigRequest")
	proto.RegisterType((*SetLocationsRequest)(nil), "google.container.v1alpha1.SetLocationsRequest")
	proto.RegisterType((*UpdateMasterRequest)(nil), "google.container.v1alpha1.UpdateMasterRequest")
	proto.RegisterType((*SetMasterAuthRequest)(nil), "google.container.v1alpha1.SetMasterAuthRequest")
	proto.RegisterType((*DeleteClusterRequest)(nil), "google.container.v1alpha1.DeleteClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "google.container.v1alpha1.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "google.container.v1alpha1.ListClustersResponse")
	proto.RegisterType((*GetOperationRequest)(nil), "google.container.v1alpha1.GetOperationRequest")
	proto.RegisterType((*ListOperationsRequest)(nil), "google.container.v1alpha1.ListOperationsRequest")
	proto.RegisterType((*CancelOperationRequest)(nil), "google.container.v1alpha1.CancelOperationRequest")
	proto.RegisterType((*ListOperationsResponse)(nil), "google.container.v1alpha1.ListOperationsResponse")
	proto.RegisterType((*GetServerConfigRequest)(nil), "google.container.v1alpha1.GetServerConfigRequest")
	proto.RegisterType((*ServerConfig)(nil), "google.container.v1alpha1.ServerConfig")
	proto.RegisterType((*CreateNodePoolRequest)(nil), "google.container.v1alpha1.CreateNodePoolRequest")
	proto.RegisterType((*DeleteNodePoolRequest)(nil), "google.container.v1alpha1.DeleteNodePoolRequest")
	proto.RegisterType((*ListNodePoolsRequest)(nil), "google.container.v1alpha1.ListNodePoolsRequest")
	proto.RegisterType((*GetNodePoolRequest)(nil), "google.container.v1alpha1.GetNodePoolRequest")
	proto.RegisterType((*NodePool)(nil), "google.container.v1alpha1.NodePool")
	proto.RegisterType((*NodeManagement)(nil), "google.container.v1alpha1.NodeManagement")
	proto.RegisterType((*AutoUpgradeOptions)(nil), "google.container.v1alpha1.AutoUpgradeOptions")
	proto.RegisterType((*MaintenancePolicy)(nil), "google.container.v1alpha1.MaintenancePolicy")
	proto.RegisterType((*MaintenanceWindow)(nil), "google.container.v1alpha1.MaintenanceWindow")
	proto.RegisterType((*DailyMaintenanceWindow)(nil), "google.container.v1alpha1.DailyMaintenanceWindow")
	proto.RegisterType((*SetNodePoolManagementRequest)(nil), "google.container.v1alpha1.SetNodePoolManagementRequest")
	proto.RegisterType((*SetNodePoolSizeRequest)(nil), "google.container.v1alpha1.SetNodePoolSizeRequest")
	proto.RegisterType((*RollbackNodePoolUpgradeRequest)(nil), "google.container.v1alpha1.RollbackNodePoolUpgradeRequest")
	proto.RegisterType((*ListNodePoolsResponse)(nil), "google.container.v1alpha1.ListNodePoolsResponse")
	proto.RegisterType((*NodePoolAutoscaling)(nil), "google.container.v1alpha1.NodePoolAutoscaling")
	proto.RegisterType((*SetLabelsRequest)(nil), "google.container.v1alpha1.SetLabelsRequest")
	proto.RegisterType((*SetLegacyAbacRequest)(nil), "google.container.v1alpha1.SetLegacyAbacRequest")
	proto.RegisterType((*StartIPRotationRequest)(nil), "google.container.v1alpha1.StartIPRotationRequest")
	proto.RegisterType((*CompleteIPRotationRequest)(nil), "google.container.v1alpha1.CompleteIPRotationRequest")
	proto.RegisterType((*AcceleratorConfig)(nil), "google.container.v1alpha1.AcceleratorConfig")
	proto.RegisterType((*SetNetworkPolicyRequest)(nil), "google.container.v1alpha1.SetNetworkPolicyRequest")
	proto.RegisterType((*SetMaintenancePolicyRequest)(nil), "google.container.v1alpha1.SetMaintenancePolicyRequest")
	proto.RegisterEnum("google.container.v1alpha1.NodeTaint_Effect", NodeTaint_Effect_name, NodeTaint_Effect_value)
	proto.RegisterEnum("google.container.v1alpha1.NetworkPolicy_Provider", NetworkPolicy_Provider_name, NetworkPolicy_Provider_value)
	proto.RegisterEnum("google.container.v1alpha1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("google.container.v1alpha1.Operation_Status", Operation_Status_name, Operation_Status_value)
	proto.RegisterEnum("google.container.v1alpha1.Operation_Type", Operation_Type_name, Operation_Type_value)
	proto.RegisterEnum("google.container.v1alpha1.SetMasterAuthRequest_Action", SetMasterAuthRequest_Action_name, SetMasterAuthRequest_Action_value)
	proto.RegisterEnum("google.container.v1alpha1.NodePool_Status", NodePool_Status_name, NodePool_Status_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ClusterManager service

type ClusterManagerClient interface {
	// Lists all clusters owned by a project in either the specified zone or all
	// zones.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets the details of a specific cluster.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Creates a cluster, consisting of the specified number and type of Google
	// Compute Engine instances.
	//
	// By default, the cluster is created in the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// One firewall is added for the cluster. After cluster creation,
	// the cluster creates routes for each node to allow the containers
	// on that node to communicate with all other instances in the
	// cluster.
	//
	// Finally, an entry is added to the project's global metadata indicating
	// which CIDR range is being used by the cluster.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the settings of a specific cluster.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the version and/or iamge type of a specific node pool.
	UpdateNodePool(ctx context.Context, in *UpdateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the autoscaling settings of a specific node pool.
	SetNodePoolAutoscaling(ctx context.Context, in *SetNodePoolAutoscalingRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the logging service of a specific cluster.
	SetLoggingService(ctx context.Context, in *SetLoggingServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the monitoring service of a specific cluster.
	SetMonitoringService(ctx context.Context, in *SetMonitoringServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the addons of a specific cluster.
	SetAddonsConfig(ctx context.Context, in *SetAddonsConfigRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the locations of a specific cluster.
	SetLocations(ctx context.Context, in *SetLocationsRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the master of a specific cluster.
	UpdateMaster(ctx context.Context, in *UpdateMasterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Used to set master auth materials. Currently supports :-
	// Changing the admin password of a specific cluster.
	// This can be either via password generation or explicitly set.
	// Modify basic_auth.csv and reset the K8S API server.
	SetMasterAuth(ctx context.Context, in *SetMasterAuthRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the cluster, including the Kubernetes endpoint and all worker
	// nodes.
	//
	// Firewalls and routes that were configured during cluster creation
	// are also deleted.
	//
	// Other Google Compute Engine resources that might be in use by the cluster
	// (e.g. load balancer resources) will not be deleted if they weren't present
	// at the initial create time.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists all operations in a project in a specific zone or all zones.
	ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error)
	// Gets the specified operation.
	GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Cancels the specified operation.
	CancelOperation(ctx context.Context, in *CancelOperationRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Returns configuration info about the Container Engine service.
	GetServerConfig(ctx context.Context, in *GetServerConfigRequest, opts ...grpc.CallOption) (*ServerConfig, error)
	// Lists the node pools for a cluster.
	ListNodePools(ctx context.Context, in *ListNodePoolsRequest, opts ...grpc.CallOption) (*ListNodePoolsResponse, error)
	// Retrieves the node pool requested.
	GetNodePool(ctx context.Context, in *GetNodePoolRequest, opts ...grpc.CallOption) (*NodePool, error)
	// Creates a node pool for a cluster.
	CreateNodePool(ctx context.Context, in *CreateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes a node pool from a cluster.
	DeleteNodePool(ctx context.Context, in *DeleteNodePoolRequest, opts ...grpc.CallOption) (*Operation, error)
	// Roll back the previously Aborted or Failed NodePool upgrade.
	// This will be an no-op if the last upgrade successfully completed.
	RollbackNodePoolUpgrade(ctx context.Context, in *RollbackNodePoolUpgradeRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the NodeManagement options for a node pool.
	SetNodePoolManagement(ctx context.Context, in *SetNodePoolManagementRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets labels on a cluster.
	SetLabels(ctx context.Context, in *SetLabelsRequest, opts ...grpc.CallOption) (*Operation, error)
	// Enables or disables the ABAC authorization mechanism on a cluster.
	SetLegacyAbac(ctx context.Context, in *SetLegacyAbacRequest, opts ...grpc.CallOption) (*Operation, error)
	// Start master IP rotation.
	StartIPRotation(ctx context.Context, in *StartIPRotationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Completes master IP rotation.
	CompleteIPRotation(ctx context.Context, in *CompleteIPRotationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the size of a specific node pool.
	SetNodePoolSize(ctx context.Context, in *SetNodePoolSizeRequest, opts ...grpc.CallOption) (*Operation, error)
	// Enables/Disables Network Policy for a cluster.
	SetNetworkPolicy(ctx context.Context, in *SetNetworkPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the maintenance policy for a cluster.
	SetMaintenancePolicy(ctx context.Context, in *SetMaintenancePolicyRequest, opts ...grpc.CallOption) (*Operation, error)
}

type clusterManagerClient struct {
	cc *grpc.ClientConn
}

func NewClusterManagerClient(cc *grpc.ClientConn) ClusterManagerClient {
	return &clusterManagerClient{cc}
}

func (c *clusterManagerClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/ListClusters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/GetCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/CreateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/UpdateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) UpdateNodePool(ctx context.Context, in *UpdateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/UpdateNodePool", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNodePoolAutoscaling(ctx context.Context, in *SetNodePoolAutoscalingRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/SetNodePoolAutoscaling", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLoggingService(ctx context.Context, in *SetLoggingServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/SetLoggingService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetMonitoringService(ctx context.Context, in *SetMonitoringServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/SetMonitoringService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetAddonsConfig(ctx context.Context, in *SetAddonsConfigRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/SetAddonsConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLocations(ctx context.Context, in *SetLocationsRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/SetLocations", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) UpdateMaster(ctx context.Context, in *UpdateMasterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/UpdateMaster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetMasterAuth(ctx context.Context, in *SetMasterAuthRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/SetMasterAuth", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/DeleteCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error) {
	out := new(ListOperationsResponse)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/ListOperations", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/GetOperation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CancelOperation(ctx context.Context, in *CancelOperationRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/CancelOperation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetServerConfig(ctx context.Context, in *GetServerConfigRequest, opts ...grpc.CallOption) (*ServerConfig, error) {
	out := new(ServerConfig)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/GetServerConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) ListNodePools(ctx context.Context, in *ListNodePoolsRequest, opts ...grpc.CallOption) (*ListNodePoolsResponse, error) {
	out := new(ListNodePoolsResponse)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/ListNodePools", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetNodePool(ctx context.Context, in *GetNodePoolRequest, opts ...grpc.CallOption) (*NodePool, error) {
	out := new(NodePool)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/GetNodePool", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CreateNodePool(ctx context.Context, in *CreateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/CreateNodePool", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) DeleteNodePool(ctx context.Context, in *DeleteNodePoolRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/DeleteNodePool", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) RollbackNodePoolUpgrade(ctx context.Context, in *RollbackNodePoolUpgradeRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/RollbackNodePoolUpgrade", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNodePoolManagement(ctx context.Context, in *SetNodePoolManagementRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/SetNodePoolManagement", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLabels(ctx context.Context, in *SetLabelsRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/SetLabels", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLegacyAbac(ctx context.Context, in *SetLegacyAbacRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/SetLegacyAbac", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) StartIPRotation(ctx context.Context, in *StartIPRotationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/StartIPRotation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CompleteIPRotation(ctx context.Context, in *CompleteIPRotationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/CompleteIPRotation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNodePoolSize(ctx context.Context, in *SetNodePoolSizeRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/SetNodePoolSize", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNetworkPolicy(ctx context.Context, in *SetNetworkPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/SetNetworkPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetMaintenancePolicy(ctx context.Context, in *SetMaintenancePolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1alpha1.ClusterManager/SetMaintenancePolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ClusterManager service

type ClusterManagerServer interface {
	// Lists all clusters owned by a project in either the specified zone or all
	// zones.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets the details of a specific cluster.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Creates a cluster, consisting of the specified number and type of Google
	// Compute Engine instances.
	//
	// By default, the cluster is created in the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// One firewall is added for the cluster. After cluster creation,
	// the cluster creates routes for each node to allow the containers
	// on that node to communicate with all other instances in the
	// cluster.
	//
	// Finally, an entry is added to the project's global metadata indicating
	// which CIDR range is being used by the cluster.
	CreateCluster(context.Context, *CreateClusterRequest) (*Operation, error)
	// Updates the settings of a specific cluster.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*Operation, error)
	// Updates the version and/or iamge type of a specific node pool.
	UpdateNodePool(context.Context, *UpdateNodePoolRequest) (*Operation, error)
	// Sets the autoscaling settings of a specific node pool.
	SetNodePoolAutoscaling(context.Context, *SetNodePoolAutoscalingRequest) (*Operation, error)
	// Sets the logging service of a specific cluster.
	SetLoggingService(context.Context, *SetLoggingServiceRequest) (*Operation, error)
	// Sets the monitoring service of a specific cluster.
	SetMonitoringService(context.Context, *SetMonitoringServiceRequest) (*Operation, error)
	// Sets the addons of a specific cluster.
	SetAddonsConfig(context.Context, *SetAddonsConfigRequest) (*Operation, error)
	// Sets the locations of a specific cluster.
	SetLocations(context.Context, *SetLocationsRequest) (*Operation, error)
	// Updates the master of a specific cluster.
	UpdateMaster(context.Context, *UpdateMasterRequest) (*Operation, error)
	// Used to set master auth materials. Currently supports :-
	// Changing the admin password of a specific cluster.
	// This can be either via password generation or explicitly set.
	// Modify basic_auth.csv and reset the K8S API server.
	SetMasterAuth(context.Context, *SetMasterAuthRequest) (*Operation, error)
	// Deletes the cluster, including the Kubernetes endpoint and all worker
	// nodes.
	//
	// Firewalls and routes that were configured during cluster creation
	// are also deleted.
	//
	// Other Google Compute Engine resources that might be in use by the cluster
	// (e.g. load balancer resources) will not be deleted if they weren't present
	// at the initial create time.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*Operation, error)
	// Lists all operations in a project in a specific zone or all zones.
	ListOperations(context.Context, *ListOperationsRequest) (*ListOperationsResponse, error)
	// Gets the specified operation.
	GetOperation(context.Context, *GetOperationRequest) (*Operation, error)
	// Cancels the specified operation.
	CancelOperation(context.Context, *CancelOperationRequest) (*google_protobuf1.Empty, error)
	// Returns configuration info about the Container Engine service.
	GetServerConfig(context.Context, *GetServerConfigRequest) (*ServerConfig, error)
	// Lists the node pools for a cluster.
	ListNodePools(context.Context, *ListNodePoolsRequest) (*ListNodePoolsResponse, error)
	// Retrieves the node pool requested.
	GetNodePool(context.Context, *GetNodePoolRequest) (*NodePool, error)
	// Creates a node pool for a cluster.
	CreateNodePool(context.Context, *CreateNodePoolRequest) (*Operation, error)
	// Deletes a node pool from a cluster.
	DeleteNodePool(context.Context, *DeleteNodePoolRequest) (*Operation, error)
	// Roll back the previously Aborted or Failed NodePool upgrade.
	// This will be an no-op if the last upgrade successfully completed.
	RollbackNodePoolUpgrade(context.Context, *RollbackNodePoolUpgradeRequest) (*Operation, error)
	// Sets the NodeManagement options for a node pool.
	SetNodePoolManagement(context.Context, *SetNodePoolManagementRequest) (*Operation, error)
	// Sets labels on a cluster.
	SetLabels(context.Context, *SetLabelsRequest) (*Operation, error)
	// Enables or disables the ABAC authorization mechanism on a cluster.
	SetLegacyAbac(context.Context, *SetLegacyAbacRequest) (*Operation, error)
	// Start master IP rotation.
	StartIPRotation(context.Context, *StartIPRotationRequest) (*Operation, error)
	// Completes master IP rotation.
	CompleteIPRotation(context.Context, *CompleteIPRotationRequest) (*Operation, error)
	// Sets the size of a specific node pool.
	SetNodePoolSize(context.Context, *SetNodePoolSizeRequest) (*Operation, error)
	// Enables/Disables Network Policy for a cluster.
	SetNetworkPolicy(context.Context, *SetNetworkPolicyRequest) (*Operation, error)
	// Sets the maintenance policy for a cluster.
	SetMaintenancePolicy(context.Context, *SetMaintenancePolicyRequest) (*Operation, error)
}

func RegisterClusterManagerServer(s *grpc.Server, srv ClusterManagerServer) {
	s.RegisterService(&_ClusterManager_serviceDesc, srv)
}

func _ClusterManager_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_UpdateNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).UpdateNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/UpdateNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).UpdateNodePool(ctx, req.(*UpdateNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNodePoolAutoscaling_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodePoolAutoscalingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNodePoolAutoscaling(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/SetNodePoolAutoscaling",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNodePoolAutoscaling(ctx, req.(*SetNodePoolAutoscalingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLoggingService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLoggingServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLoggingService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/SetLoggingService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLoggingService(ctx, req.(*SetLoggingServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetMonitoringService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMonitoringServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetMonitoringService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/SetMonitoringService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetMonitoringService(ctx, req.(*SetMonitoringServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetAddonsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetAddonsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetAddonsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/SetAddonsConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetAddonsConfig(ctx, req.(*SetAddonsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/SetLocations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLocations(ctx, req.(*SetLocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_UpdateMaster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMasterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).UpdateMaster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/UpdateMaster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).UpdateMaster(ctx, req.(*UpdateMasterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetMasterAuth_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMasterAuthRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetMasterAuth(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/SetMasterAuth",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetMasterAuth(ctx, req.(*SetMasterAuthRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListOperations(ctx, req.(*ListOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/GetOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetOperation(ctx, req.(*GetOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CancelOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CancelOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/CancelOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CancelOperation(ctx, req.(*CancelOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetServerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetServerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/GetServerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetServerConfig(ctx, req.(*GetServerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_ListNodePools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodePoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListNodePools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/ListNodePools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListNodePools(ctx, req.(*ListNodePoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/GetNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetNodePool(ctx, req.(*GetNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CreateNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CreateNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/CreateNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CreateNodePool(ctx, req.(*CreateNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_DeleteNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).DeleteNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/DeleteNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).DeleteNodePool(ctx, req.(*DeleteNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_RollbackNodePoolUpgrade_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackNodePoolUpgradeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).RollbackNodePoolUpgrade(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/RollbackNodePoolUpgrade",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).RollbackNodePoolUpgrade(ctx, req.(*RollbackNodePoolUpgradeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNodePoolManagement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodePoolManagementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNodePoolManagement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/SetNodePoolManagement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNodePoolManagement(ctx, req.(*SetNodePoolManagementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/SetLabels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLabels(ctx, req.(*SetLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLegacyAbac_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLegacyAbacRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLegacyAbac(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/SetLegacyAbac",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLegacyAbac(ctx, req.(*SetLegacyAbacRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_StartIPRotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartIPRotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).StartIPRotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/StartIPRotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).StartIPRotation(ctx, req.(*StartIPRotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CompleteIPRotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteIPRotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CompleteIPRotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/CompleteIPRotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CompleteIPRotation(ctx, req.(*CompleteIPRotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNodePoolSize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodePoolSizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNodePoolSize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/SetNodePoolSize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNodePoolSize(ctx, req.(*SetNodePoolSizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/SetNetworkPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNetworkPolicy(ctx, req.(*SetNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetMaintenancePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMaintenancePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetMaintenancePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1alpha1.ClusterManager/SetMaintenancePolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetMaintenancePolicy(ctx, req.(*SetMaintenancePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.container.v1alpha1.ClusterManager",
	HandlerType: (*ClusterManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListClusters",
			Handler:    _ClusterManager_ListClusters_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _ClusterManager_GetCluster_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _ClusterManager_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _ClusterManager_UpdateCluster_Handler,
		},
		{
			MethodName: "UpdateNodePool",
			Handler:    _ClusterManager_UpdateNodePool_Handler,
		},
		{
			MethodName: "SetNodePoolAutoscaling",
			Handler:    _ClusterManager_SetNodePoolAutoscaling_Handler,
		},
		{
			MethodName: "SetLoggingService",
			Handler:    _ClusterManager_SetLoggingService_Handler,
		},
		{
			MethodName: "SetMonitoringService",
			Handler:    _ClusterManager_SetMonitoringService_Handler,
		},
		{
			MethodName: "SetAddonsConfig",
			Handler:    _ClusterManager_SetAddonsConfig_Handler,
		},
		{
			MethodName: "SetLocations",
			Handler:    _ClusterManager_SetLocations_Handler,
		},
		{
			MethodName: "UpdateMaster",
			Handler:    _ClusterManager_UpdateMaster_Handler,
		},
		{
			MethodName: "SetMasterAuth",
			Handler:    _ClusterManager_SetMasterAuth_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _ClusterManager_DeleteCluster_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ClusterManager_ListOperations_Handler,
		},
		{
			MethodName: "GetOperation",
			Handler:    _ClusterManager_GetOperation_Handler,
		},
		{
			MethodName: "CancelOperation",
			Handler:    _ClusterManager_CancelOperation_Handler,
		},
		{
			MethodName: "GetServerConfig",
			Handler:    _ClusterManager_GetServerConfig_Handler,
		},
		{
			MethodName: "ListNodePools",
			Handler:    _ClusterManager_ListNodePools_Handler,
		},
		{
			MethodName: "GetNodePool",
			Handler:    _ClusterManager_GetNodePool_Handler,
		},
		{
			MethodName: "CreateNodePool",
			Handler:    _ClusterManager_CreateNodePool_Handler,
		},
		{
			MethodName: "DeleteNodePool",
			Handler:    _ClusterManager_DeleteNodePool_Handler,
		},
		{
			MethodName: "RollbackNodePoolUpgrade",
			Handler:    _ClusterManager_RollbackNodePoolUpgrade_Handler,
		},
		{
			MethodName: "SetNodePoolManagement",
			Handler:    _ClusterManager_SetNodePoolManagement_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _ClusterManager_SetLabels_Handler,
		},
		{
			MethodName: "SetLegacyAbac",
			Handler:    _ClusterManager_SetLegacyAbac_Handler,
		},
		{
			MethodName: "StartIPRotation",
			Handler:    _ClusterManager_StartIPRotation_Handler,
		},
		{
			MethodName: "CompleteIPRotation",
			Handler:    _ClusterManager_CompleteIPRotation_Handler,
		},
		{
			MethodName: "SetNodePoolSize",
			Handler:    _ClusterManager_SetNodePoolSize_Handler,
		},
		{
			MethodName: "SetNetworkPolicy",
			Handler:    _ClusterManager_SetNetworkPolicy_Handler,
		},
		{
			MethodName: "SetMaintenancePolicy",
			Handler:    _ClusterManager_SetMaintenancePolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/container/v1alpha1/cluster_service.proto",
}

func init() { proto.RegisterFile("google/container/v1alpha1/cluster_service.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 4748 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5c, 0x5d, 0x6c, 0x23, 0xd7,
	0x75, 0xce, 0x48, 0x14, 0x25, 0x1e, 0x52, 0x14, 0x75, 0xf5, 0xc7, 0xa5, 0xbd, 0xf6, 0x7a, 0x62,
	0xd7, 0x6b, 0x6d, 0x2c, 0x79, 0xd7, 0x1b, 0xdb, 0xf1, 0x3f, 0x45, 0xcd, 0x6a, 0x99, 0x95, 0x48,
	0x66, 0x28, 0x79, 0x63, 0xbb, 0xc0, 0x74, 0xc4, 0xb9, 0xa2, 0x26, 0x22, 0x67, 0xc6, 0x33, 0xc3,
	0xb5, 0xb5, 0xae, 0xd3, 0x26, 0x75, 0xdf, 0xfa, 0x16, 0xa0, 0x40, 0x8b, 0x02, 0x01, 0x8c, 0xfe,
	0xa5, 0x29, 0xd0, 0xa2, 0x45, 0x81, 0xb4, 0xe8, 0x0f, 0xda, 0xbe, 0xf4, 0xa1, 0x68, 0x8b, 0xe4,
	0xb9, 0x40, 0x0b, 0xf4, 0xa1, 0x6f, 0x45, 0x1e, 0xfb, 0xd0, 0x22, 0xb8, 0x3f, 0x33, 0xbc, 0x43,
	0x0e, 0x87, 0x94, 0x14, 0xad, 0xfd, 0xa6, 0x39, 0xf7, 0x9e, 0x7b, 0xbf, 0x73, 0xe6, 0xdc, 0x73,
	0xce, 0x3d, 0x67, 0x28, 0xd8, 0x6c, 0xdb, 0x76, 0xbb, 0x83, 0x37, 0x5b, 0xb6, 0xe5, 0xeb, 0xa6,
	0x85, 0xdd, 0xcd, 0x07, 0x37, 0xf5, 0x8e, 0x73, 0xac, 0xdf, 0xdc, 0x6c, 0x75, 0x7a, 0x9e, 0x8f,
	0x5d, 0xcd, 0xc3, 0xee, 0x03, 0xb3, 0x85, 0x37, 0x1c, 0xd7, 0xf6, 0x6d, 0x74, 0x85, 0x31, 0x6c,
	0x84, 0x0c, 0x1b, 0x01, 0x43, 0xe9, 0x71, 0xbe, 0x96, 0xee, 0x98, 0x9b, 0xba, 0x65, 0xd9, 0xbe,
	0xee, 0x9b, 0xb6, 0xe5, 0x31, 0xc6, 0xd2, 0x63, 0x7c, 0x94, 0x3e, 0x1d, 0xf6, 0x8e, 0x36, 0x71,
	0xd7, 0xf1, 0x4f, 0xd9, 0xa0, 0xfc, 0xdf, 0x33, 0x00, 0x35, 0xdb, 0xc0, 0x15, 0xdb, 0x3a, 0x32,
	0xdb, 0xe8, 0x29, 0xc8, 0x75, 0xf5, 0xd6, 0xb1, 0x69, 0x61, 0xcd, 0x3f, 0x75, 0x70, 0x51, 0xba,
	0x26, 0x5d, 0xcf, 0xa8, 0x59, 0x4e, 0xdb, 0x3f, 0x75, 0x30, 0xba, 0x06, 0x39, 0xc3, 0xf4, 0x4e,
	0x34, 0xcf, 0x7c, 0x88, 0xb5, 0xf6, 0x61, 0x71, 0xea, 0x9a, 0x74, 0x7d, 0x46, 0x05, 0x42, 0x6b,
	0x9a, 0x0f, 0xf1, 0xce, 0x21, 0x59, 0xc4, 0xd6, 0x7b, 0xfe, 0xb1, 0xe6, 0xb5, 0x6c, 0x07, 0x7b,
	0xc5, 0xe9, 0x6b, 0xd3, 0x64, 0x11, 0x4a, 0x6b, 0x52, 0x12, 0x7a, 0x16, 0x16, 0xb8, 0x74, 0x9a,
	0xde, 0x6a, 0xd9, 0x3d, 0xcb, 0x2f, 0x66, 0xe8, 0x56, 0x79, 0x4e, 0x2e, 0x33, 0x2a, 0xaa, 0xc3,
	0x5c, 0x17, 0xfb, 0xba, 0xa1, 0xfb, 0x7a, 0x31, 0x75, 0x6d, 0xfa, 0x7a, 0xf6, 0xd6, 0x8b, 0x1b,
	0x23, 0x15, 0xb1, 0xd1, 0x97, 0x64, 0x63, 0x8f, 0x73, 0x29, 0x96, 0xef, 0x9e, 0xaa, 0xe1, 0x22,
	0xe8, 0x2a, 0x80, 0xd9, 0xd5, 0xdb, 0x5c, 0xbe, 0x19, 0xba, 0x69, 0x86, 0x52, 0xa8, 0x74, 0x55,
	0x48, 0x77, 0xf4, 0x43, 0xdc, 0xf1, 0x8a, 0x69, 0xba, 0xdb, 0xcd, 0xc9, 0x76, 0xdb, 0xa5, 0x3c,
	0x6c, 0x2f, 0xbe, 0x00, 0xfa, 0x05, 0x58, 0xe8, 0xd8, 0x2d, 0xbd, 0xa3, 0x79, 0x9e, 0xa1, 0x31,
	0x19, 0x67, 0xa9, 0xae, 0xe6, 0x29, 0xb9, 0xe9, 0x19, 0x15, 0x2a, 0x22, 0x82, 0x94, 0xaf, 0xb7,
	0xbd, 0xe2, 0x1c, 0x55, 0x13, 0xfd, 0x1b, 0x5d, 0x83, 0xac, 0xe3, 0x62, 0xf2, 0xa2, 0xcc, 0xc3,
	0x0e, 0x2e, 0xc2, 0x35, 0xe9, 0xfa, 0x9c, 0x2a, 0x92, 0x50, 0x03, 0x72, 0x7a, 0xab, 0x85, 0x3b,
	0xd8, 0xd5, 0x7d, 0xdb, 0xf5, 0x8a, 0x59, 0x0a, 0xf7, 0x2b, 0x09, 0x70, 0xcb, 0xfd, 0xe9, 0x0c,
	0xb5, 0x1a, 0x59, 0x01, 0x5d, 0x87, 0x42, 0xd7, 0xb4, 0xb4, 0x96, 0xd3, 0xd3, 0x9c, 0x8e, 0xee,
	0x1f, 0xd9, 0x6e, 0xb7, 0x38, 0xcf, 0x5e, 0x4a, 0xd7, 0xb4, 0x2a, 0x4e, 0xaf, 0xc1, 0xa9, 0xe8,
	0x75, 0x48, 0x93, 0xc5, 0x7d, 0xaf, 0xb8, 0x40, 0x77, 0x7d, 0x7a, 0x8c, 0x92, 0xf6, 0xc9, 0x64,
	0x95, 0xf3, 0x94, 0x5e, 0x83, 0xf9, 0xc8, 0xcb, 0x41, 0x05, 0x98, 0x3e, 0xc1, 0xa7, 0xdc, 0xd6,
	0xc8, 0x9f, 0x68, 0x19, 0x66, 0x1e, 0xe8, 0x9d, 0x1e, 0xa6, 0xc6, 0x95, 0x51, 0xd9, 0xc3, 0xab,
	0x53, 0xaf, 0x48, 0xa5, 0xaf, 0x41, 0x56, 0xd0, 0xf5, 0x59, 0x58, 0xe5, 0x9f, 0x48, 0x90, 0x09,
	0xd1, 0x4c, 0xca, 0x89, 0x2a, 0x90, 0xc6, 0x47, 0x47, 0xb8, 0xe5, 0x17, 0xa7, 0xaf, 0x49, 0xd7,
	0xf3, 0xb7, 0x6e, 0x4c, 0x22, 0xeb, 0x86, 0x42, 0x59, 0x54, 0xce, 0x2a, 0xbf, 0x0b, 0x69, 0x46,
	0x41, 0xab, 0x80, 0x94, 0x3b, 0x77, 0x94, 0xca, 0xbe, 0x76, 0x50, 0x6b, 0x36, 0x94, 0x4a, 0xf5,
	0x4e, 0x55, 0xd9, 0x2e, 0x7c, 0x09, 0x2d, 0x40, 0xb6, 0x56, 0xd7, 0x9a, 0x95, 0xbb, 0xca, 0xf6,
	0xc1, 0xae, 0x52, 0x90, 0xc8, 0xc4, 0x86, 0xaa, 0xdc, 0x51, 0x54, 0x4d, 0xa4, 0x4f, 0xa1, 0x3c,
	0x40, 0xad, 0xae, 0x29, 0xdf, 0x54, 0x2a, 0x07, 0xfb, 0x4a, 0x61, 0x5a, 0xfe, 0xd1, 0x14, 0xc0,
	0x9e, 0x4e, 0xfc, 0x45, 0xb9, 0xe7, 0x1f, 0xa3, 0x12, 0xcc, 0xf5, 0x3c, 0xec, 0x5a, 0x7a, 0x37,
	0x38, 0xbc, 0xe1, 0x33, 0x19, 0x73, 0x74, 0xcf, 0xfb, 0xd0, 0x76, 0x0d, 0x2e, 0x63, 0xf8, 0x8c,
	0x2c, 0xb8, 0xd2, 0xea, 0x98, 0xd8, 0xf2, 0xb5, 0x16, 0x76, 0x7d, 0xf3, 0xc8, 0x6c, 0xe9, 0x3e,
	0xd6, 0x5a, 0xd4, 0x4e, 0xa8, 0xe4, 0xd9, 0x5b, 0xb7, 0x12, 0x24, 0xaf, 0x50, 0xde, 0x4a, 0x9f,
	0x95, 0x5b, 0xd8, 0x5a, 0x2b, 0x7e, 0x00, 0xdd, 0x86, 0xd5, 0xc0, 0xcd, 0xb5, 0x74, 0x71, 0xcf,
	0xa2, 0x41, 0x91, 0x2d, 0xf3, 0xd1, 0x8a, 0x2e, 0xf0, 0xa2, 0xe7, 0x01, 0x0d, 0xa3, 0x2c, 0x62,
	0xca, 0xb1, 0x38, 0xb4, 0x15, 0x39, 0xeb, 0x7c, 0x3a, 0x79, 0xd5, 0x47, 0xec, 0xac, 0x33, 0xca,
	0x3d, 0x7c, 0x2a, 0x37, 0x61, 0x6d, 0x04, 0x6e, 0xf4, 0x0a, 0x14, 0x4d, 0xcf, 0xeb, 0x61, 0x2d,
	0x66, 0x3b, 0x89, 0x1e, 0xc6, 0x55, 0x3a, 0x3e, 0xc4, 0x2f, 0xff, 0xfe, 0x34, 0xe4, 0xca, 0x86,
	0x61, 0x5b, 0x1e, 0x5f, 0xea, 0x17, 0x61, 0xe9, 0xd8, 0xf7, 0x1d, 0xad, 0x63, 0xeb, 0x86, 0x76,
	0xa8, 0x77, 0x74, 0xab, 0x65, 0x5a, 0x6d, 0xba, 0x4a, 0xf2, 0x79, 0xbd, 0xeb, 0xfb, 0xce, 0xae,
	0xad, 0x1b, 0x5b, 0x01, 0x8f, 0xba, 0x78, 0x3c, 0x48, 0x42, 0x1f, 0x40, 0xe9, 0xd8, 0x76, 0xcd,
	0x87, 0x84, 0xbd, 0xa3, 0x39, 0xb6, 0xa1, 0xe9, 0x3d, 0xdf, 0xf6, 0x5a, 0x7a, 0x87, 0x6c, 0x32,
	0x45, 0x37, 0x49, 0xf2, 0x98, 0x77, 0x43, 0xe6, 0x86, 0x6d, 0x94, 0xfb, 0xac, 0x6a, 0xf1, 0x78,
	0xc4, 0x08, 0xd2, 0x61, 0xf9, 0xa4, 0x77, 0x88, 0x5d, 0x0b, 0xfb, 0xd8, 0xd3, 0x0c, 0xdd, 0x3b,
	0x3e, 0xb4, 0x75, 0xd7, 0xe0, 0x56, 0xb2, 0x91, 0xb0, 0xd9, 0xbd, 0x90, 0x6d, 0x3b, 0xe0, 0x52,
	0x97, 0x4e, 0x86, 0x89, 0xe8, 0x10, 0x56, 0x2c, 0xec, 0x7f, 0x68, 0xbb, 0x27, 0x9a, 0x63, 0x77,
	0xcc, 0xd6, 0x69, 0x60, 0x89, 0xa9, 0xb1, 0x7b, 0xd4, 0x18, 0x5f, 0x83, 0xb2, 0x71, 0x2b, 0x5c,
	0xb2, 0x86, 0x89, 0xf2, 0x26, 0x2c, 0x0e, 0x69, 0x98, 0x1c, 0x11, 0xc3, 0xf4, 0xf4, 0xc3, 0x0e,
	0x36, 0xf8, 0x7b, 0x0e, 0x9f, 0xe5, 0x97, 0xa0, 0x38, 0x4a, 0x5b, 0x89, 0x7c, 0x37, 0x61, 0x29,
	0x46, 0xf0, 0x71, 0x2c, 0x31, 0x72, 0x24, 0xb2, 0xfc, 0x8f, 0x04, 0x4f, 0xf4, 0xfd, 0x00, 0xc1,
	0x89, 0x0d, 0xbe, 0x46, 0x60, 0x89, 0x45, 0x98, 0xc5, 0x96, 0xc8, 0x1d, 0x3c, 0x22, 0x03, 0xb2,
	0x2d, 0xd3, 0x70, 0xb5, 0xc3, 0x8e, 0xdd, 0x3a, 0xf1, 0x8a, 0x53, 0xd4, 0xab, 0x57, 0x12, 0xb4,
	0x9c, 0xbc, 0xd3, 0x46, 0xc5, 0x34, 0xdc, 0x2d, 0xb2, 0x96, 0x0a, 0xad, 0xe0, 0x4f, 0xaf, 0xb4,
	0x07, 0x99, 0x70, 0x80, 0x24, 0x09, 0x86, 0xe9, 0x39, 0x1d, 0xfd, 0x54, 0x13, 0x9c, 0x55, 0x96,
	0xd3, 0x6a, 0xc4, 0x5f, 0x91, 0xe3, 0x1b, 0xa2, 0xe2, 0x1e, 0x2b, 0x13, 0xae, 0x27, 0xff, 0x91,
	0x04, 0xf3, 0x11, 0x2d, 0xa1, 0x3d, 0x98, 0x73, 0x5c, 0xfb, 0x81, 0x69, 0x60, 0x97, 0xae, 0x97,
	0x4f, 0x0e, 0xdf, 0x22, 0xef, 0x46, 0x83, 0x33, 0xaa, 0xe1, 0x12, 0xa2, 0xbe, 0xa6, 0x22, 0xfa,
	0x92, 0x5f, 0x80, 0xb9, 0x46, 0x7f, 0xd6, 0x72, 0x43, 0xad, 0xbf, 0x53, 0xdd, 0x56, 0xd4, 0x01,
	0x9f, 0x0e, 0x90, 0xae, 0x94, 0x77, 0xab, 0x95, 0x7a, 0x41, 0x92, 0xff, 0x22, 0x05, 0xa8, 0xda,
	0x28, 0x77, 0x48, 0xe8, 0x27, 0xc9, 0x19, 0x47, 0xfc, 0x34, 0xe4, 0x7b, 0x1e, 0xd6, 0x4c, 0x47,
	0xd3, 0x3b, 0xa6, 0xee, 0x61, 0x8f, 0xbf, 0x99, 0x5c, 0xcf, 0xc3, 0x55, 0xa7, 0xcc, 0x68, 0xe8,
	0x06, 0x2c, 0xb6, 0x5c, 0x4c, 0x1c, 0xb2, 0xd7, 0x3b, 0xe4, 0xb6, 0xcc, 0x21, 0x15, 0xd8, 0x40,
	0x33, 0xa4, 0xd3, 0xd4, 0x2a, 0x7c, 0x62, 0xba, 0x9d, 0xe6, 0xa9, 0x55, 0x48, 0xa6, 0xea, 0x5d,
	0x87, 0xc5, 0xc0, 0x05, 0x9b, 0xce, 0x83, 0xdb, 0x1a, 0xd1, 0x2c, 0x3d, 0x60, 0x19, 0x75, 0x81,
	0x0f, 0x54, 0x9d, 0x07, 0xb7, 0xc9, 0x2b, 0x23, 0x38, 0x2d, 0xdb, 0xc0, 0xc2, 0x44, 0x96, 0x39,
	0xe5, 0x08, 0x35, 0x9c, 0xf5, 0x15, 0x40, 0x3c, 0x7d, 0xf3, 0x84, 0x99, 0x69, 0x3a, 0xb3, 0x10,
	0x8c, 0x84, 0xb3, 0xdf, 0x82, 0xc7, 0xfb, 0x99, 0x6e, 0xcb, 0xb6, 0x0c, 0xdd, 0x3d, 0xd5, 0x5c,
	0xdd, 0x6a, 0x63, 0x86, 0x7a, 0x96, 0xf2, 0x5d, 0xe1, 0x73, 0x9a, 0xc1, 0x14, 0x95, 0xcc, 0xa0,
	0x02, 0x94, 0xe1, 0x6a, 0xb8, 0x5d, 0xec, 0x0a, 0x73, 0x74, 0x85, 0x52, 0x30, 0x29, 0x66, 0x89,
	0xaf, 0xc2, 0xda, 0x90, 0x0e, 0xb8, 0xbd, 0x65, 0x22, 0x71, 0x28, 0x40, 0xcd, 0x8c, 0x77, 0x13,
	0x96, 0xa3, 0xea, 0xe0, 0x3c, 0xc0, 0x22, 0x91, 0xa8, 0x14, 0xc6, 0xf0, 0x32, 0x14, 0x87, 0x35,
	0xc3, 0x99, 0xb2, 0x94, 0x69, 0x65, 0x50, 0x3f, 0xcc, 0xc8, 0x5f, 0x84, 0xb5, 0x86, 0x6d, 0x34,
	0x71, 0xab, 0xe7, 0x9a, 0xfe, 0x69, 0xc4, 0x1b, 0x8c, 0x3c, 0xce, 0xf2, 0xaf, 0x2f, 0xc0, 0x6c,
	0x85, 0xe1, 0x26, 0xd9, 0xa5, 0x70, 0xbe, 0xe8, 0xdf, 0x24, 0xbb, 0x34, 0xb0, 0xd7, 0x72, 0x4d,
	0x87, 0x98, 0x22, 0x3f, 0x59, 0x22, 0x89, 0xbc, 0x49, 0xd3, 0x32, 0x7d, 0x53, 0xef, 0x68, 0x54,
	0x50, 0x96, 0xbe, 0x4e, 0xd3, 0xf4, 0xb5, 0xc0, 0x47, 0x58, 0xfa, 0x4b, 0x32, 0xd8, 0x3b, 0x90,
	0xe5, 0xb3, 0x04, 0x27, 0xfd, 0xcc, 0x44, 0x99, 0xb3, 0x0a, 0x56, 0xff, 0xf6, 0x71, 0x07, 0xb2,
	0x5d, 0xea, 0x58, 0x48, 0x10, 0x3b, 0xa6, 0x26, 0x96, 0xbc, 0x4e, 0xdf, 0x0d, 0xa9, 0xd0, 0xed,
	0x27, 0x41, 0xcf, 0x92, 0xcc, 0xbb, 0xdd, 0x36, 0xad, 0x76, 0x70, 0x87, 0xe2, 0x46, 0x98, 0xe7,
	0xe4, 0x26, 0xa3, 0x92, 0x7c, 0xa2, 0x6b, 0x5b, 0xa6, 0x6f, 0xbb, 0xe2, 0x5c, 0x66, 0x78, 0x8b,
	0xfd, 0x91, 0x60, 0x7a, 0x11, 0x66, 0x83, 0xd3, 0xc7, 0x4c, 0x2b, 0x78, 0x8c, 0x3f, 0x4b, 0x99,
	0xf8, 0xb3, 0xb4, 0x0b, 0xf3, 0x3a, 0x4d, 0x10, 0x02, 0x7d, 0x01, 0x95, 0xf3, 0xd9, 0xa4, 0xd4,
	0x5d, 0x48, 0x28, 0xd4, 0x9c, 0x2e, 0xa6, 0x17, 0x4f, 0x00, 0x08, 0x4e, 0x81, 0xd9, 0x92, 0x40,
	0x41, 0x5b, 0x40, 0x35, 0xac, 0x39, 0xb6, 0xdd, 0xf1, 0x8a, 0x39, 0xea, 0xd9, 0xbf, 0x3c, 0xe6,
	0xd5, 0x34, 0x6c, 0xbb, 0xa3, 0x66, 0x2c, 0xfe, 0x97, 0x87, 0x1e, 0x87, 0x4c, 0xe0, 0xb7, 0xbc,
	0xe2, 0x3c, 0xbd, 0xa6, 0xf4, 0x09, 0xe8, 0x25, 0x58, 0x63, 0x86, 0xa7, 0x09, 0x69, 0x01, 0x5d,
	0xad, 0x98, 0xa7, 0x76, 0xb9, 0xc2, 0x86, 0xfb, 0x41, 0xb0, 0x4c, 0x06, 0x51, 0x1d, 0xf2, 0xd1,
	0x20, 0x5f, 0x5c, 0xa2, 0x8a, 0xb8, 0x3e, 0xa9, 0xcf, 0x56, 0xe7, 0x23, 0x71, 0x1d, 0x69, 0xb0,
	0x4c, 0x1d, 0x69, 0x00, 0x2d, 0x58, 0x76, 0x99, 0x2e, 0xfb, 0x7c, 0xc2, 0xb2, 0xc3, 0x9e, 0x59,
	0x45, 0xa6, 0x33, 0xe4, 0xad, 0x3f, 0x95, 0xe0, 0x29, 0xc1, 0x40, 0x59, 0xe8, 0xd3, 0x38, 0x88,
	0xf0, 0x75, 0xae, 0xd2, 0xed, 0xbe, 0x76, 0xee, 0xe8, 0xa9, 0x3e, 0xd1, 0x4d, 0x8e, 0xe3, 0xef,
	0x03, 0xea, 0x92, 0x5b, 0x06, 0xb6, 0x74, 0xab, 0x85, 0x03, 0x29, 0xd7, 0xc6, 0x26, 0x94, 0x7b,
	0x7d, 0x26, 0x2e, 0xe4, 0x62, 0x77, 0x90, 0x84, 0x6c, 0x28, 0x91, 0x2c, 0xd2, 0xe3, 0x1e, 0x67,
	0x20, 0xff, 0xba, 0x32, 0xf6, 0x26, 0x30, 0xc2, 0x5b, 0xa9, 0x6b, 0xce, 0x08, 0x37, 0xf6, 0x18,
	0x64, 0x3c, 0xdc, 0x39, 0xd2, 0x3a, 0xa6, 0x75, 0xc2, 0x93, 0xff, 0x39, 0x42, 0xd8, 0x35, 0xad,
	0x13, 0xe2, 0xbd, 0x1e, 0xda, 0x56, 0x90, 0xe2, 0xd3, 0xbf, 0x49, 0x16, 0x84, 0x2d, 0xc3, 0xb1,
	0x4d, 0xcb, 0xe7, 0x39, 0x7d, 0xf8, 0x4c, 0x6c, 0x31, 0xf0, 0x5b, 0xc1, 0x79, 0x7c, 0x80, 0x5d,
	0x8f, 0x78, 0xb9, 0x36, 0x73, 0xb3, 0x7c, 0x98, 0xbb, 0xc7, 0x77, 0xd8, 0x20, 0xbd, 0x8e, 0xf4,
	0x5c, 0x97, 0xa4, 0xfa, 0xfc, 0x05, 0x07, 0x6c, 0xc7, 0x3c, 0x0c, 0xb0, 0x51, 0xf6, 0xe6, 0x02,
	0xae, 0x17, 0x20, 0xa0, 0x33, 0x2f, 0x19, 0xf0, 0x98, 0x94, 0x07, 0xf1, 0x31, 0x72, 0xa2, 0x02,
	0x8e, 0x27, 0x21, 0xcb, 0x23, 0xb9, 0x6f, 0x76, 0x71, 0xf1, 0x5b, 0xec, 0xb8, 0x32, 0xd2, 0xbe,
	0x49, 0x63, 0x5a, 0xda, 0xf3, 0x75, 0xbf, 0xe7, 0x15, 0x4f, 0x68, 0x02, 0xf3, 0x5c, 0xe2, 0xa5,
	0x8b, 0xca, 0xb0, 0xd1, 0xa4, 0x0c, 0x2a, 0x67, 0x44, 0xcf, 0x40, 0x9e, 0xfd, 0xa5, 0x75, 0xb1,
	0xe7, 0xe9, 0x6d, 0x5c, 0xec, 0xd0, 0x6d, 0xe6, 0x19, 0x75, 0x8f, 0x11, 0xd1, 0xf3, 0xb0, 0x34,
	0x10, 0xc3, 0x3c, 0xf3, 0x21, 0x2e, 0x76, 0x99, 0x8f, 0x17, 0x43, 0x58, 0xd3, 0x7c, 0x88, 0x47,
	0xc4, 0x76, 0x6b, 0x44, 0x6c, 0xdf, 0x80, 0x25, 0xd3, 0xf2, 0x7c, 0x6a, 0x9f, 0x6d, 0xd7, 0xee,
	0x39, 0x5a, 0xcf, 0xed, 0x78, 0x45, 0x9b, 0xfa, 0x8e, 0xc5, 0x60, 0x68, 0x87, 0x8c, 0x1c, 0xb8,
	0x1d, 0x8f, 0xac, 0x1e, 0xd1, 0x24, 0x8b, 0x37, 0x0e, 0xc3, 0x22, 0xe8, 0x91, 0xc5, 0x9b, 0x27,
	0x21, 0x8b, 0x3f, 0x72, 0x4c, 0x97, 0x6b, 0xf1, 0x03, 0xa6, 0x45, 0x46, 0xa2, 0x5a, 0x2c, 0xc1,
	0x5c, 0x70, 0x74, 0x8b, 0x2e, 0x33, 0x91, 0xe0, 0x59, 0x36, 0x21, 0xcd, 0x14, 0x46, 0xae, 0xd8,
	0xcd, 0xfd, 0xf2, 0xfe, 0x41, 0x73, 0x20, 0x6f, 0x2b, 0x40, 0x8e, 0x66, 0x74, 0xcd, 0x6a, 0xbd,
	0x56, 0xad, 0xed, 0x14, 0x24, 0x94, 0x85, 0x59, 0xf5, 0xa0, 0x46, 0x1f, 0xa6, 0xc8, 0x55, 0x5d,
	0x55, 0x2a, 0xf5, 0x5a, 0xa5, 0xba, 0x4b, 0x08, 0xd3, 0x28, 0x07, 0x73, 0xcd, 0xfd, 0x7a, 0xa3,
	0x41, 0x9e, 0x52, 0x28, 0x03, 0x33, 0x8a, 0xaa, 0xd6, 0xd5, 0xc2, 0x8c, 0xfc, 0x07, 0x69, 0x98,
	0xe7, 0x2f, 0xe9, 0xc0, 0x31, 0xc8, 0x8d, 0xf4, 0x05, 0x58, 0x36, 0xb0, 0x67, 0xba, 0xc4, 0x6d,
	0x88, 0x16, 0xc3, 0xd2, 0x2e, 0xc4, 0xc7, 0x44, 0x8b, 0x79, 0x1d, 0x4a, 0x01, 0x47, 0x4c, 0xa8,
	0x62, 0x59, 0x58, 0x91, 0xcf, 0xd8, 0x1b, 0x8a, 0x58, 0xef, 0xc3, 0x4a, 0xc0, 0x1d, 0x8d, 0x39,
	0xe9, 0xb3, 0xc5, 0x9c, 0x25, 0xbe, 0x4a, 0xe4, 0x66, 0xbb, 0x39, 0x20, 0x0c, 0x09, 0x31, 0x9a,
	0x69, 0x04, 0xf1, 0x53, 0x10, 0x86, 0x84, 0x91, 0xaa, 0x41, 0xde, 0x72, 0xc0, 0x20, 0xd4, 0xe0,
	0x58, 0x28, 0x2d, 0xf0, 0x91, 0x6a, 0x58, 0x8a, 0xfb, 0x00, 0xae, 0x0e, 0x2f, 0x2f, 0xde, 0x6e,
	0x33, 0xe3, 0x2f, 0x83, 0x7c, 0x6f, 0xf1, 0x62, 0x5b, 0x1a, 0xc0, 0x25, 0x5e, 0xe3, 0x6e, 0x40,
	0x80, 0x5a, 0xeb, 0x07, 0x3c, 0xa0, 0x46, 0x1b, 0xe0, 0xdb, 0x0d, 0xe3, 0xde, 0xf7, 0x24, 0x78,
	0x2e, 0x7c, 0x35, 0x63, 0xa3, 0x42, 0xee, 0xa2, 0x51, 0xe1, 0x99, 0xe0, 0x25, 0x27, 0x07, 0x87,
	0x6f, 0x83, 0x1c, 0x80, 0x4a, 0xf0, 0xe3, 0xf9, 0x73, 0xfb, 0xf1, 0x27, 0xf8, 0xea, 0xa3, 0xb2,
	0xd2, 0xdb, 0xb0, 0x3a, 0xa0, 0x94, 0xc0, 0xc6, 0x79, 0x61, 0x27, 0x22, 0x06, 0xb7, 0x72, 0xf9,
	0xa7, 0x69, 0xc8, 0xd4, 0x1d, 0xec, 0x52, 0xd5, 0xc6, 0xe6, 0xac, 0x41, 0x24, 0x98, 0x12, 0x22,
	0x41, 0x03, 0xf2, 0x76, 0xc0, 0xc4, 0x6c, 0x69, 0x7a, 0xac, 0xd3, 0x0c, 0x77, 0xd9, 0x20, 0x46,
	0xa6, 0xce, 0x87, 0x0b, 0x50, 0x9b, 0xab, 0x84, 0xee, 0x37, 0x35, 0xb6, 0xda, 0xd7, 0x5f, 0x69,
	0xc0, 0x01, 0xaf, 0x42, 0xda, 0xc0, 0xbe, 0x6e, 0x76, 0xb8, 0x69, 0xf3, 0xa7, 0x18, 0xc7, 0x3c,
	0x13, 0xe7, 0x98, 0x23, 0x01, 0x31, 0x3d, 0x10, 0x10, 0x9f, 0x84, 0xac, 0xaf, 0xbb, 0x6d, 0xec,
	0xb3, 0x61, 0x76, 0xd4, 0x80, 0x91, 0xe8, 0x04, 0xd1, 0xf5, 0x65, 0xa2, 0xae, 0x8f, 0x5c, 0xa8,
	0x3d, 0x5f, 0x77, 0x7d, 0xe6, 0x36, 0xd9, 0x65, 0x25, 0x43, 0x29, 0xd4, 0x6b, 0x5e, 0xa1, 0x81,
	0x95, 0x0d, 0xb2, 0x44, 0x72, 0x16, 0x5b, 0x06, 0x19, 0x92, 0xd5, 0xb1, 0x4e, 0x33, 0x0b, 0xb3,
	0x0d, 0xa5, 0xb6, 0x1d, 0xe3, 0x2f, 0xe7, 0x20, 0xb5, 0x5d, 0xaf, 0x29, 0xcc, 0x51, 0x96, 0xb7,
	0xea, 0xea, 0x3e, 0x75, 0x94, 0xf2, 0xff, 0x4d, 0x41, 0x8a, 0x2a, 0x7d, 0x19, 0x0a, 0xfb, 0xef,
	0x36, 0x94, 0x81, 0x05, 0x11, 0xe4, 0x2b, 0xaa, 0x52, 0xde, 0x57, 0xb4, 0xca, 0xee, 0x41, 0x73,
	0x5f, 0x51, 0x0b, 0x12, 0xa1, 0x6d, 0x2b, 0xbb, 0x8a, 0x40, 0x9b, 0x22, 0xb4, 0x83, 0xc6, 0x8e,
	0x5a, 0xde, 0x56, 0xb4, 0xbd, 0x32, 0xa5, 0x4d, 0xa3, 0x45, 0x98, 0x0f, 0x68, 0xb5, 0xfa, 0xb6,
	0xd2, 0x2c, 0xa4, 0xc8, 0x34, 0x55, 0x69, 0x94, 0xab, 0x6a, 0xc8, 0x3a, 0xc3, 0x58, 0xb7, 0xc5,
	0x2d, 0xd2, 0x04, 0x0c, 0xdf, 0x96, 0x70, 0x6a, 0x8d, 0x7a, 0x7d, 0xb7, 0x30, 0x4b, 0xa8, 0x7c,
	0xe3, 0x3e, 0x75, 0x0e, 0x3d, 0x0e, 0xc5, 0xa6, 0xb2, 0xdf, 0x27, 0x69, 0x7b, 0xe5, 0x5a, 0x79,
	0x47, 0xd9, 0x53, 0x6a, 0xfb, 0x85, 0x0c, 0x5a, 0x81, 0xc5, 0xf2, 0xc1, 0x7e, 0x5d, 0xe3, 0xdb,
	0x32, 0x20, 0x40, 0x14, 0x48, 0xc9, 0x51, 0x80, 0x59, 0x94, 0x07, 0x20, 0x8b, 0xed, 0x96, 0xb7,
	0x94, 0xdd, 0x66, 0x21, 0x87, 0x96, 0x60, 0x81, 0x3c, 0x33, 0x99, 0xb4, 0xf2, 0xc1, 0xfe, 0xdd,
	0xc2, 0x3c, 0xd5, 0x7e, 0x64, 0xc7, 0x66, 0xf5, 0x3d, 0xa5, 0x90, 0x0f, 0xe9, 0xca, 0xfe, 0xfd,
	0xba, 0x7a, 0x4f, 0x6b, 0xd4, 0x77, 0xab, 0x95, 0x77, 0x0b, 0x0b, 0xa8, 0x04, 0xab, 0x6c, 0x91,
	0x6a, 0x6d, 0x5f, 0xa9, 0x95, 0x6b, 0x15, 0x25, 0x18, 0x2b, 0xc8, 0xdf, 0x97, 0x60, 0xb9, 0x42,
	0x33, 0x0f, 0x1e, 0xa3, 0x54, 0xfc, 0x41, 0x0f, 0x7b, 0x3e, 0x31, 0x13, 0xc7, 0xb5, 0xbf, 0x85,
	0x5b, 0x3e, 0xf1, 0xe6, 0xec, 0x10, 0x66, 0x38, 0xa5, 0x6a, 0xc4, 0x9e, 0xc4, 0xd7, 0x61, 0x96,
	0xe7, 0x5b, 0xbc, 0x0c, 0x28, 0x8f, 0xcf, 0x5b, 0xd4, 0x80, 0x85, 0x1c, 0x18, 0x47, 0x27, 0x21,
	0x9e, 0x1f, 0x08, 0xfe, 0x24, 0x9f, 0xc2, 0xe2, 0x0e, 0xf6, 0x2f, 0x8e, 0x8e, 0xd6, 0x81, 0xf9,
	0xed, 0xcc, 0xe0, 0xd5, 0x90, 0x4c, 0x70, 0x2d, 0x33, 0x42, 0x77, 0x33, 0xd3, 0x77, 0x37, 0xf2,
	0xdf, 0x4a, 0xb0, 0xcc, 0x62, 0xf6, 0xa5, 0x6f, 0xff, 0x36, 0xa4, 0x7b, 0x74, 0x27, 0x7e, 0x71,
	0xbe, 0x3e, 0x5e, 0x75, 0x0c, 0x99, 0xca, 0xf9, 0x62, 0x05, 0xf8, 0x4f, 0x09, 0x56, 0xd8, 0xb4,
	0xf0, 0x46, 0x77, 0x69, 0x12, 0x5c, 0x83, 0x5c, 0x24, 0x01, 0x60, 0xd9, 0x0c, 0x58, 0xfd, 0xc8,
	0xff, 0x14, 0x9f, 0x11, 0xc4, 0x02, 0x86, 0x94, 0x56, 0x0d, 0x82, 0x44, 0x27, 0xda, 0x98, 0x4b,
	0x0f, 0x36, 0xe6, 0x02, 0x19, 0xe7, 0x04, 0x19, 0xff, 0x57, 0x82, 0xab, 0x4d, 0xec, 0xc7, 0x45,
	0xf9, 0xcf, 0x51, 0xd6, 0x06, 0x64, 0xc5, 0x2c, 0x65, 0xe6, 0x5c, 0x59, 0x8a, 0xb8, 0x44, 0x28,
	0x7b, 0x5a, 0x90, 0xfd, 0x07, 0x12, 0x14, 0x9b, 0xd8, 0xdf, 0x8d, 0x14, 0x34, 0x2e, 0x4f, 0xec,
	0x98, 0x92, 0x4a, 0x2a, 0xb6, 0xa4, 0x12, 0x67, 0x8b, 0x7f, 0x26, 0xc1, 0x63, 0x4d, 0xec, 0x0f,
	0xa5, 0xa7, 0x97, 0x07, 0x37, 0xbe, 0xb0, 0x93, 0x1a, 0x55, 0xd8, 0x89, 0x53, 0xf0, 0x3f, 0x4b,
	0xb0, 0xda, 0xc4, 0x7e, 0x24, 0x0d, 0xbe, 0x34, 0xbc, 0x43, 0x35, 0xa1, 0xd4, 0x45, 0x6a, 0x42,
	0x71, 0xe2, 0xfc, 0x96, 0x04, 0x4b, 0xd4, 0x5e, 0x78, 0xfa, 0x7a, 0x79, 0xb2, 0x44, 0xaa, 0x45,
	0xa9, 0xc1, 0x6a, 0x51, 0x1c, 0xb6, 0xcf, 0x24, 0x58, 0x62, 0xbe, 0x8a, 0x65, 0x85, 0x97, 0x87,
	0xed, 0x19, 0xc8, 0x0f, 0x64, 0xa5, 0xcc, 0x26, 0xe6, 0xbb, 0x91, 0x8b, 0x7d, 0x00, 0x72, 0x56,
	0x00, 0xf9, 0xef, 0x53, 0xb0, 0x4c, 0x8c, 0xb8, 0x5f, 0x72, 0xbc, 0x34, 0x94, 0x35, 0x48, 0xeb,
	0x2d, 0x3f, 0x40, 0x97, 0xbf, 0xf5, 0x52, 0x82, 0x19, 0xc4, 0x41, 0xda, 0x28, 0x53, 0x6e, 0x95,
	0xaf, 0x82, 0xde, 0x08, 0x23, 0xcc, 0x99, 0x4a, 0xaa, 0x83, 0xe1, 0x45, 0xd4, 0x46, 0x03, 0xd2,
	0x6c, 0x13, 0x92, 0xeb, 0x1d, 0xd4, 0xee, 0xd5, 0xea, 0xf7, 0x6b, 0xec, 0xea, 0x4c, 0xf2, 0x8d,
	0x46, 0xb9, 0xd9, 0xbc, 0x5f, 0x57, 0xb7, 0x0b, 0x12, 0xc9, 0x82, 0x76, 0x94, 0x9a, 0xa2, 0x92,
	0x8c, 0x2a, 0x24, 0x4f, 0x05, 0x13, 0x0f, 0x9a, 0x8a, 0x5a, 0x2b, 0xef, 0x29, 0x85, 0x69, 0xf9,
	0x97, 0x61, 0x79, 0x1b, 0x77, 0xf0, 0x23, 0x08, 0xb8, 0x81, 0x3c, 0x29, 0x41, 0x9e, 0x5f, 0x82,
	0xa5, 0x5d, 0xd3, 0x0b, 0x72, 0x8d, 0x8b, 0x9c, 0x8e, 0x7e, 0x32, 0x93, 0x8a, 0x24, 0x33, 0x1f,
	0xc3, 0x72, 0x74, 0x07, 0xcf, 0xb1, 0x2d, 0x0f, 0xa3, 0x37, 0x61, 0x8e, 0x43, 0xf3, 0x8a, 0x12,
	0x2d, 0xcf, 0x4e, 0x92, 0x3b, 0x85, 0x3c, 0xe8, 0xcb, 0x30, 0xdf, 0x35, 0x3d, 0x8f, 0xf8, 0x39,
	0xb2, 0x3f, 0xeb, 0xde, 0x65, 0xd4, 0x1c, 0x27, 0xbe, 0x47, 0x68, 0xf2, 0xaf, 0xc0, 0xd2, 0x0e,
	0xf6, 0xc3, 0x1b, 0xcb, 0x05, 0xc4, 0x7b, 0x0a, 0x72, 0xfd, 0x3b, 0x57, 0xa8, 0xdd, 0x6c, 0x48,
	0x1b, 0x91, 0x4f, 0x1d, 0xc2, 0x0a, 0x91, 0x3e, 0x44, 0x70, 0x19, 0x1a, 0xfe, 0xae, 0x04, 0xab,
	0x15, 0xdd, 0x6a, 0xe1, 0xce, 0x23, 0x16, 0x54, 0x34, 0xa4, 0x5f, 0x93, 0x60, 0x75, 0x50, 0x52,
	0xfe, 0xa6, 0xb7, 0x01, 0x42, 0xee, 0xe0, 0x5d, 0x3f, 0x3d, 0xc9, 0x05, 0x53, 0x15, 0xf8, 0x26,
	0x7b, 0xdf, 0x1a, 0xac, 0xee, 0x60, 0x9f, 0x84, 0x37, 0xec, 0x5e, 0x38, 0x76, 0xc5, 0x89, 0xf9,
	0xe9, 0x14, 0xe4, 0xc4, 0xe5, 0xd1, 0x4b, 0xb0, 0x66, 0xe0, 0x23, 0xbd, 0xd7, 0xf1, 0x87, 0x2a,
	0xaf, 0x6c, 0x93, 0x15, 0x3e, 0x3c, 0x50, 0x79, 0xdd, 0x80, 0xa5, 0x07, 0x7a, 0xc7, 0x8c, 0xd6,
	0xc3, 0x82, 0x6f, 0xc6, 0x16, 0xe9, 0x90, 0x50, 0x0e, 0xf3, 0x58, 0x0d, 0x89, 0xed, 0x23, 0xa4,
	0x8b, 0xa9, 0xa0, 0x86, 0x44, 0x47, 0xfa, 0x35, 0xa4, 0x75, 0x60, 0x4b, 0x08, 0x73, 0xbd, 0xe2,
	0x0c, 0x5d, 0x7b, 0x81, 0x0e, 0x84, 0x53, 0x3d, 0x74, 0x0b, 0x56, 0xd8, 0xdc, 0x68, 0x84, 0x60,
	0x5f, 0x82, 0x65, 0x54, 0x06, 0x33, 0x52, 0xb6, 0xf0, 0xe4, 0x7f, 0x94, 0x60, 0x85, 0xdd, 0xa1,
	0x2e, 0x3f, 0xcb, 0x7e, 0x1b, 0x32, 0x61, 0xe6, 0xc9, 0xf3, 0x83, 0x89, 0x1a, 0x39, 0x73, 0x41,
	0x6e, 0x2a, 0x1c, 0x9c, 0x74, 0xe4, 0xe0, 0x7c, 0x5f, 0x82, 0x15, 0xe6, 0x7b, 0xbf, 0x08, 0x77,
	0x85, 0xb8, 0x0c, 0xe1, 0x57, 0x25, 0xe6, 0x3d, 0x03, 0x7c, 0x97, 0x98, 0xbe, 0x8c, 0xba, 0x8c,
	0xfe, 0x8e, 0x04, 0x68, 0xa7, 0x7f, 0xd9, 0xf8, 0xa2, 0x69, 0xe8, 0xff, 0x53, 0x30, 0x17, 0x60,
	0x8b, 0x2d, 0xa0, 0xbd, 0x01, 0x69, 0x9e, 0x5b, 0x4e, 0x9d, 0xa5, 0x3f, 0xcb, 0x99, 0xce, 0xd8,
	0x11, 0x1e, 0xb8, 0x03, 0xa5, 0x2e, 0x7e, 0x07, 0xaa, 0x02, 0x74, 0x75, 0x4b, 0x6f, 0xe3, 0x6e,
	0xf0, 0x6a, 0xb2, 0x89, 0x75, 0x3e, 0xb2, 0xe0, 0x5e, 0xc8, 0xa0, 0x0a, 0xcc, 0xc9, 0x1d, 0xa7,
	0x22, 0xcc, 0x06, 0x7e, 0x8b, 0x35, 0x9d, 0x82, 0xc7, 0x51, 0x3d, 0x8d, 0xa3, 0x51, 0x3d, 0x8d,
	0xad, 0xb0, 0x96, 0xd8, 0xa6, 0x59, 0xdc, 0xfa, 0x04, 0xe2, 0x8f, 0xef, 0xe5, 0x1c, 0xc7, 0x94,
	0x0c, 0xe5, 0xef, 0x48, 0x17, 0x6d, 0x6a, 0xac, 0x02, 0xe2, 0x0f, 0xda, 0xfd, 0xea, 0xfe, 0x5d,
	0x8d, 0xb5, 0x30, 0xa6, 0x07, 0x9b, 0x1d, 0xa9, 0x48, 0xb3, 0x63, 0xa6, 0xdf, 0xec, 0x48, 0xcb,
	0x7f, 0x2c, 0x41, 0x3e, 0xaa, 0x74, 0x12, 0x42, 0xc9, 0x2b, 0xd4, 0x7a, 0x4e, 0xdb, 0xd5, 0x8d,
	0xe0, 0xcb, 0x39, 0xfa, 0x5a, 0x0f, 0x18, 0x09, 0x3d, 0xc9, 0x0c, 0x45, 0x73, 0xb1, 0xa3, 0x9b,
	0x2e, 0xff, 0xa8, 0x05, 0x08, 0x49, 0xa5, 0x14, 0xf4, 0x0e, 0x2c, 0x70, 0x76, 0xcd, 0x76, 0x82,
	0x82, 0xfc, 0xb8, 0x7e, 0x6e, 0xb9, 0xbf, 0x43, 0x9d, 0x31, 0xa9, 0xf9, 0x5e, 0xe4, 0x59, 0xee,
	0x02, 0x1a, 0x9e, 0x85, 0xbe, 0x0a, 0x6b, 0x22, 0x62, 0x4d, 0x28, 0x97, 0xb2, 0xb3, 0xb4, 0x2c,
	0x80, 0x6f, 0x86, 0x95, 0xd3, 0xb1, 0x1f, 0x54, 0xc8, 0xef, 0xc2, 0xe2, 0x50, 0xfb, 0x15, 0x6d,
	0x43, 0xfa, 0x43, 0xd3, 0x32, 0xec, 0x0f, 0x27, 0xf8, 0x1a, 0x50, 0xe0, 0xbe, 0x4f, 0x79, 0x54,
	0xce, 0x2b, 0xff, 0x86, 0x14, 0x59, 0x9b, 0x8d, 0xa2, 0x2e, 0x14, 0x0d, 0xdd, 0xec, 0x9c, 0x6a,
	0x62, 0xab, 0x98, 0xef, 0xc6, 0x1c, 0x40, 0xd2, 0xb7, 0x51, 0xdb, 0x84, 0x75, 0x68, 0xd1, 0xbb,
	0x5f, 0x52, 0x57, 0x8d, 0xd8, 0x91, 0xad, 0x39, 0x48, 0xb3, 0x0e, 0x83, 0xdc, 0x84, 0xd5, 0x78,
	0xee, 0x81, 0xf2, 0xf3, 0xd4, 0x60, 0xf9, 0xb9, 0x04, 0x73, 0x46, 0x8f, 0x65, 0x39, 0xdc, 0x29,
	0x86, 0xcf, 0xf2, 0x4f, 0x25, 0x78, 0x5c, 0xa8, 0xf4, 0x08, 0x07, 0xfb, 0x73, 0x74, 0xc3, 0x3f,
	0x47, 0x97, 0x14, 0x77, 0xc5, 0xfa, 0x3b, 0x56, 0x80, 0x08, 0x64, 0x6e, 0x9a, 0x0f, 0xf1, 0xe7,
	0x29, 0xed, 0x55, 0xfe, 0x21, 0x09, 0x73, 0xfc, 0x33, 0xd4, 0xf1, 0x67, 0xac, 0xd0, 0xe3, 0xc7,
	0x49, 0xf0, 0x87, 0x12, 0x3c, 0xa1, 0xda, 0x9d, 0xce, 0xa1, 0xde, 0x3a, 0x09, 0xc4, 0xe0, 0x67,
	0xe7, 0x8b, 0x16, 0x3e, 0xdf, 0x67, 0xf7, 0x13, 0x21, 0xbf, 0xe0, 0x49, 0x7b, 0xf4, 0xfb, 0x19,
	0xe9, 0x3c, 0xdf, 0xcf, 0xc8, 0x1f, 0xc3, 0x52, 0x5c, 0xb7, 0x71, 0xf4, 0xf7, 0x98, 0x4f, 0x43,
	0xbe, 0x6b, 0x5a, 0x62, 0xa0, 0x65, 0xbf, 0xb2, 0xc8, 0x75, 0x4d, 0xab, 0x1f, 0x64, 0xc9, 0x2c,
	0xfd, 0xa3, 0xe1, 0x70, 0x9c, 0xeb, 0xea, 0x1f, 0x85, 0xb3, 0xe4, 0x1f, 0x4f, 0x41, 0xa1, 0x89,
	0x7d, 0xf6, 0xd5, 0xfc, 0xe5, 0xa9, 0xfd, 0x18, 0x16, 0x5c, 0xec, 0xd9, 0x3d, 0xb7, 0x85, 0x35,
	0xfe, 0x0b, 0x0a, 0xf6, 0x7b, 0x8d, 0xb7, 0x92, 0x8b, 0x17, 0x11, 0x5c, 0x1b, 0x2a, 0x5f, 0x42,
	0xfc, 0x3d, 0x45, 0xde, 0x8d, 0x10, 0xd1, 0x0d, 0x58, 0xa4, 0x1b, 0x68, 0x47, 0xa6, 0xd5, 0xc6,
	0xae, 0xe3, 0x9a, 0x61, 0xae, 0x56, 0xa0, 0x03, 0x77, 0xfa, 0xf4, 0x38, 0xb3, 0x2c, 0x95, 0x61,
	0x29, 0x66, 0x9f, 0x33, 0xfd, 0x96, 0xe0, 0x37, 0x25, 0x5a, 0x0c, 0xda, 0xc5, 0x6d, 0xbd, 0x75,
	0x5a, 0x3e, 0xd4, 0x5b, 0x97, 0xa7, 0x58, 0xc1, 0x4a, 0x52, 0x51, 0x2b, 0x89, 0xb3, 0xe3, 0x6f,
	0xc3, 0x2a, 0x0d, 0x4b, 0xd5, 0x86, 0xca, 0x7f, 0x06, 0x74, 0xf9, 0x75, 0x14, 0x71, 0xff, 0xef,
	0x48, 0x70, 0xa5, 0x62, 0x77, 0x1d, 0x72, 0x99, 0x78, 0x94, 0x18, 0x44, 0xb7, 0x73, 0x02, 0x8b,
	0x43, 0xbf, 0x75, 0x21, 0x56, 0x23, 0xfc, 0xda, 0x85, 0x9f, 0x17, 0x82, 0x60, 0x5a, 0x2d, 0xe8,
	0xe2, 0x6c, 0x72, 0xb2, 0x9e, 0x03, 0x91, 0xc6, 0xae, 0x98, 0x0c, 0xd4, 0x82, 0x40, 0x27, 0xd7,
	0x46, 0xf9, 0xdf, 0x24, 0x58, 0x23, 0x5e, 0x3a, 0xf2, 0x61, 0xda, 0xa5, 0x89, 0x3b, 0xfc, 0xcd,
	0x5c, 0xea, 0x62, 0xdf, 0xcc, 0xc5, 0xbd, 0xc3, 0xff, 0xe0, 0xe5, 0xfa, 0xa1, 0xcf, 0xc5, 0x2e,
	0x4d, 0xac, 0xf8, 0x2f, 0xda, 0x52, 0x3f, 0x9f, 0x2f, 0xda, 0x62, 0xca, 0x51, 0xb7, 0x3e, 0xbd,
	0x01, 0x79, 0x5e, 0x88, 0x60, 0x11, 0xd9, 0x45, 0x3f, 0x94, 0x20, 0x27, 0x16, 0xe8, 0x50, 0xd2,
	0x75, 0x25, 0xa6, 0x56, 0x58, 0xda, 0x9c, 0x78, 0x3e, 0x0b, 0x2d, 0xf2, 0xab, 0xdf, 0xfd, 0xc9,
	0x7f, 0x7d, 0x6f, 0xea, 0x36, 0xba, 0xd5, 0xff, 0xe9, 0xdf, 0xc7, 0xec, 0xb2, 0xf9, 0x06, 0xd7,
	0xa6, 0xb7, 0xb9, 0xbe, 0x19, 0x96, 0xce, 0x37, 0xd7, 0x3f, 0xd9, 0x0c, 0xab, 0x7e, 0xbf, 0x2d,
	0x01, 0xf4, 0x7b, 0xa3, 0x28, 0x49, 0x49, 0x43, 0x2d, 0xd4, 0xd2, 0x04, 0x05, 0xc6, 0x58, 0x70,
	0x44, 0x75, 0x23, 0xa0, 0x85, 0xc8, 0x36, 0xd7, 0x3f, 0x41, 0xbf, 0x27, 0xc1, 0x7c, 0xa4, 0xb3,
	0x8c, 0x92, 0x74, 0x13, 0xd7, 0x83, 0x2e, 0x4d, 0x54, 0x17, 0x93, 0xdf, 0xa0, 0x20, 0x5f, 0x96,
	0xcf, 0xa1, 0xc1, 0x57, 0xa5, 0x75, 0x8a, 0x33, 0xd2, 0xe4, 0x4d, 0xc4, 0x19, 0xd7, 0x0e, 0x3e,
	0x1b, 0xce, 0xd2, 0x39, 0x94, 0x49, 0x70, 0xfe, 0xb9, 0x04, 0xf9, 0x68, 0x2f, 0x17, 0xbd, 0x30,
	0x16, 0xe8, 0x40, 0xa1, 0x62, 0x42, 0xa4, 0x55, 0x8a, 0xb4, 0x52, 0x7a, 0xf3, 0xcc, 0x48, 0x37,
	0xc3, 0x7c, 0x87, 0xa3, 0xfe, 0x71, 0x34, 0x7f, 0x15, 0x33, 0x9f, 0x57, 0x92, 0x73, 0x82, 0xd1,
	0x0d, 0xdd, 0x09, 0xa5, 0xf8, 0x26, 0x95, 0x42, 0x95, 0xf7, 0x2e, 0x28, 0x85, 0x87, 0x7d, 0x01,
	0x03, 0x11, 0xea, 0x47, 0x12, 0x2c, 0x0e, 0xb5, 0x5d, 0xd1, 0x8b, 0x63, 0x72, 0x9c, 0xb8, 0x26,
	0xed, 0x84, 0xa2, 0xdc, 0xa5, 0xa2, 0x6c, 0xc9, 0x6f, 0x9c, 0xc3, 0x74, 0xbc, 0x70, 0x6b, 0x02,
	0xfd, 0xef, 0x59, 0xce, 0x32, 0xfc, 0x91, 0xe0, 0xb8, 0xf6, 0xd2, 0x88, 0xb6, 0xed, 0x84, 0x02,
	0xdc, 0xa3, 0x02, 0x28, 0xf2, 0xdb, 0xe7, 0x13, 0xa0, 0xbf, 0x3b, 0x3f, 0x09, 0x0b, 0x03, 0x4d,
	0x59, 0x74, 0x33, 0x19, 0x7e, 0x4c, 0x03, 0x77, 0x42, 0xe4, 0x3b, 0x14, 0x79, 0x59, 0x7e, 0xfd,
	0x7c, 0xc8, 0xd9, 0xc6, 0x04, 0xf5, 0x9f, 0x4a, 0x90, 0x13, 0x7b, 0xaf, 0x89, 0xa1, 0x25, 0xa6,
	0x49, 0x3b, 0x21, 0xde, 0xaf, 0x53, 0xbc, 0xdb, 0xf2, 0x5b, 0xe7, 0x35, 0x15, 0x3e, 0x14, 0x40,
	0x16, 0x5b, 0xb2, 0x89, 0x90, 0x63, 0x7a, 0xb7, 0x8f, 0x00, 0x72, 0x4f, 0xd8, 0x95, 0xdb, 0xc6,
	0x7c, 0xa4, 0x1b, 0x9a, 0xe8, 0xcd, 0xe3, 0xfa, 0xa6, 0x8f, 0xc8, 0xa2, 0xc3, 0x6d, 0x09, 0xea,
	0xcf, 0x24, 0x98, 0x8f, 0xf4, 0x3d, 0x13, 0x51, 0xc7, 0x75, 0x48, 0x27, 0x44, 0xcd, 0x03, 0xfa,
	0xfa, 0x79, 0x02, 0x3a, 0x09, 0x40, 0xd1, 0xa6, 0x56, 0x62, 0x00, 0x8a, 0xed, 0xf4, 0x95, 0x6e,
	0x9e, 0x81, 0x83, 0x67, 0x48, 0xaf, 0x53, 0xcc, 0x2f, 0xa1, 0xdb, 0x93, 0xc7, 0x77, 0xa1, 0x53,
	0xf6, 0x99, 0x04, 0x39, 0xb1, 0xeb, 0x99, 0x68, 0xc3, 0x31, 0xed, 0xd1, 0x09, 0x15, 0x1b, 0x07,
	0x32, 0x49, 0xb1, 0x7d, 0x84, 0x44, 0xb5, 0xbf, 0x2b, 0xc1, 0xc2, 0x40, 0xd3, 0x32, 0xd1, 0xa3,
	0xc5, 0x37, 0x38, 0x4b, 0xab, 0x01, 0x4b, 0xf0, 0x5f, 0x1e, 0x36, 0x94, 0xae, 0xe3, 0x9f, 0xca,
	0x77, 0x28, 0xb8, 0xb7, 0xe5, 0xd7, 0xce, 0x03, 0xee, 0xd5, 0x16, 0xdd, 0x8c, 0x98, 0xe9, 0x0f,
	0x25, 0x58, 0x18, 0xe8, 0x28, 0x26, 0xc2, 0x8c, 0xef, 0x3e, 0x96, 0x9e, 0x4d, 0x3c, 0x91, 0xfd,
	0xf9, 0x67, 0x55, 0xea, 0x27, 0x9b, 0x9e, 0x88, 0xec, 0xaf, 0x24, 0x98, 0x8f, 0x94, 0x73, 0xd0,
	0xb8, 0xe4, 0x7c, 0xb0, 0xb1, 0x54, 0x7a, 0x61, 0x72, 0x06, 0x6e, 0xac, 0x5c, 0xd5, 0xe8, 0xcd,
	0x49, 0x8d, 0x55, 0x3c, 0x62, 0xfd, 0xbc, 0x03, 0xfd, 0x40, 0x82, 0xac, 0xd0, 0x68, 0x42, 0xcf,
	0x27, 0xab, 0x79, 0x30, 0xcf, 0x9b, 0xa4, 0x38, 0x15, 0x8b, 0xf5, 0x1c, 0x09, 0x12, 0x75, 0x0c,
	0xd1, 0xfe, 0x67, 0xa2, 0x63, 0x88, 0x6d, 0x95, 0x9e, 0x2d, 0x33, 0x95, 0x2f, 0xa8, 0x5e, 0x1e,
	0xdc, 0xf2, 0xd1, 0x7e, 0x67, 0x22, 0xea, 0xd8, 0xd6, 0xe8, 0x84, 0xa8, 0xb9, 0xa2, 0xd7, 0x2f,
	0xaa, 0xe8, 0x7f, 0x91, 0x60, 0x6d, 0x44, 0x29, 0x15, 0x25, 0xfd, 0xa8, 0x20, 0xb9, 0xfc, 0x3a,
	0xa1, 0x10, 0x2a, 0x15, 0x62, 0x57, 0xde, 0xb9, 0x60, 0x3a, 0xed, 0x72, 0x30, 0xe4, 0x1d, 0xfc,
	0xab, 0x04, 0x2b, 0xb1, 0x15, 0x7d, 0xf4, 0xf2, 0x64, 0x97, 0x83, 0xa1, 0x1e, 0xc0, 0x84, 0xc2,
	0xdc, 0xa7, 0xc2, 0x7c, 0x43, 0xde, 0xbd, 0xf8, 0xdd, 0xa0, 0x0f, 0x81, 0x48, 0xf4, 0x27, 0x12,
	0x64, 0xc2, 0x82, 0x26, 0xba, 0x71, 0x86, 0xb2, 0xe7, 0x84, 0xc8, 0xeb, 0x14, 0x79, 0x55, 0xde,
	0x3e, 0x5f, 0xde, 0x11, 0xad, 0x79, 0x0a, 0x19, 0x53, 0xbf, 0x8a, 0x39, 0x2e, 0x63, 0x1a, 0xaa,
	0x77, 0x3e, 0x9a, 0x8c, 0xa9, 0xbf, 0x2d, 0x41, 0xfd, 0x97, 0xe4, 0x0e, 0x10, 0xad, 0x71, 0x26,
	0xdf, 0x01, 0x62, 0xeb, 0xa1, 0x13, 0x22, 0xdf, 0xa3, 0xc8, 0x77, 0xe4, 0xad, 0xf3, 0x20, 0xa7,
	0x1b, 0x3b, 0xc1, 0xc6, 0x04, 0xfb, 0x3f, 0x48, 0x80, 0x86, 0xcb, 0xa3, 0xe8, 0x76, 0x92, 0xcf,
	0x1c, 0x55, 0x4d, 0x9d, 0x50, 0x82, 0x06, 0x95, 0xe0, 0xeb, 0xb2, 0x72, 0x0e, 0x09, 0x5a, 0xc1,
	0xde, 0x11, 0x21, 0xfe, 0x86, 0x5d, 0xc2, 0xc4, 0xc6, 0xd4, 0xb8, 0x4b, 0x58, 0x4c, 0x13, 0x6b,
	0x42, 0xf8, 0xdf, 0xa0, 0xf0, 0xef, 0xc9, 0x77, 0x2e, 0x7e, 0x5c, 0xc9, 0xe6, 0x04, 0xff, 0x5f,
	0x4b, 0xb4, 0x23, 0x12, 0xfd, 0xdf, 0x11, 0xb7, 0xc6, 0x08, 0x10, 0x53, 0xdf, 0x9d, 0x50, 0x82,
	0x1a, 0x95, 0xe0, 0xae, 0x5c, 0x39, 0x9f, 0xf1, 0x47, 0x76, 0x26, 0xf0, 0xff, 0x89, 0xdf, 0xe3,
	0x87, 0x0a, 0x9d, 0x63, 0x3f, 0x13, 0x8d, 0xaf, 0xe7, 0x5e, 0x7a, 0x10, 0xe0, 0xbe, 0x72, 0x60,
	0xf7, 0x57, 0xa5, 0xf5, 0xad, 0x87, 0x70, 0xb5, 0x65, 0x77, 0x47, 0x6f, 0xbf, 0xb5, 0x54, 0x09,
	0xfe, 0xfb, 0x03, 0xad, 0x3c, 0x34, 0x48, 0x72, 0xdb, 0x90, 0xde, 0xdb, 0xe2, 0x1c, 0x6d, 0xbb,
	0xa3, 0x5b, 0xed, 0x0d, 0xdb, 0x6d, 0x6f, 0xb6, 0xb1, 0x45, 0x53, 0x5f, 0xfe, 0x7f, 0xd5, 0x74,
	0xc7, 0xf4, 0x62, 0xfe, 0xb7, 0xda, 0x6b, 0x21, 0xe9, 0x30, 0x4d, 0xa7, 0xbf, 0xf8, 0xb3, 0x00,
	0x00, 0x00, 0xff, 0xff, 0x2e, 0xaf, 0xec, 0xb5, 0x89, 0x4d, 0x00, 0x00,
}
