// Code generated by go-swagger; DO NOT EDIT.

package triggers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDeleteTriggerParams creates a new DeleteTriggerParams object
// with the default values initialized.
func NewDeleteTriggerParams() *DeleteTriggerParams {
	var ()
	return &DeleteTriggerParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteTriggerParamsWithTimeout creates a new DeleteTriggerParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewDeleteTriggerParamsWithTimeout(timeout time.Duration) *DeleteTriggerParams {
	var ()
	return &DeleteTriggerParams{

		timeout: timeout,
	}
}

// NewDeleteTriggerParamsWithContext creates a new DeleteTriggerParams object
// with the default values initialized, and the ability to set a context for a request
func NewDeleteTriggerParamsWithContext(ctx context.Context) *DeleteTriggerParams {
	var ()
	return &DeleteTriggerParams{

		Context: ctx,
	}
}

// NewDeleteTriggerParamsWithHTTPClient creates a new DeleteTriggerParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewDeleteTriggerParamsWithHTTPClient(client *http.Client) *DeleteTriggerParams {
	var ()
	return &DeleteTriggerParams{
		HTTPClient: client,
	}
}

/*DeleteTriggerParams contains all the parameters to send to the API endpoint
for the delete trigger operation typically these are written to a http.Request
*/
type DeleteTriggerParams struct {

	/*TriggerID
	  Opaque, unique Trigger ID.

	*/
	TriggerID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the delete trigger params
func (o *DeleteTriggerParams) WithTimeout(timeout time.Duration) *DeleteTriggerParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete trigger params
func (o *DeleteTriggerParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete trigger params
func (o *DeleteTriggerParams) WithContext(ctx context.Context) *DeleteTriggerParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete trigger params
func (o *DeleteTriggerParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete trigger params
func (o *DeleteTriggerParams) WithHTTPClient(client *http.Client) *DeleteTriggerParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete trigger params
func (o *DeleteTriggerParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithTriggerID adds the triggerID to the delete trigger params
func (o *DeleteTriggerParams) WithTriggerID(triggerID string) *DeleteTriggerParams {
	o.SetTriggerID(triggerID)
	return o
}

// SetTriggerID adds the triggerId to the delete trigger params
func (o *DeleteTriggerParams) SetTriggerID(triggerID string) {
	o.TriggerID = triggerID
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteTriggerParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param triggerID
	if err := r.SetPathParam("triggerID", o.TriggerID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
