// Code generated by go-swagger; DO NOT EDIT.

package fns

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new fns API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for fns API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientService is the interface for Client methods
type ClientService interface {
	CreateFn(params *CreateFnParams) (*CreateFnOK, error)

	DeleteFn(params *DeleteFnParams) (*DeleteFnNoContent, error)

	GetFn(params *GetFnParams) (*GetFnOK, error)

	ListFns(params *ListFnsParams) (*ListFnsOK, error)

	UpdateFn(params *UpdateFnParams) (*UpdateFnOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
  CreateFn creates a new function

  Creates a new Function, returning the complete entity.
*/
func (a *Client) CreateFn(params *CreateFnParams) (*CreateFnOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateFnParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "CreateFn",
		Method:             "POST",
		PathPattern:        "/fns",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateFnReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateFnOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateFnDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
  DeleteFn deletes a function

  Delete the specified Function.
*/
func (a *Client) DeleteFn(params *DeleteFnParams) (*DeleteFnNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteFnParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DeleteFn",
		Method:             "DELETE",
		PathPattern:        "/fns/{fnID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteFnReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteFnNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteFnDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
  GetFn gets definition of a function

  Gets the definition for the Function with the specified ID.
*/
func (a *Client) GetFn(params *GetFnParams) (*GetFnOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetFnParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetFn",
		Method:             "GET",
		PathPattern:        "/fns/{fnID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetFnReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetFnOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetFnDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
  ListFns gets a list of functions within an application

  Get a filtered list of Functions for an Application, in alphabetical order.
*/
func (a *Client) ListFns(params *ListFnsParams) (*ListFnsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListFnsParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListFns",
		Method:             "GET",
		PathPattern:        "/fns",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListFnsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListFnsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListFnsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
  UpdateFn updates a function

  Updates a Function via merging the provided values.
*/
func (a *Client) UpdateFn(params *UpdateFnParams) (*UpdateFnOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateFnParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "UpdateFn",
		Method:             "PUT",
		PathPattern:        "/fns/{fnID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateFnReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateFnOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateFnDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
