// Code generated by go-swagger; DO NOT EDIT.

package apps

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListAppsParams creates a new ListAppsParams object
// with the default values initialized.
func NewListAppsParams() *ListAppsParams {
	var ()
	return &ListAppsParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewListAppsParamsWithTimeout creates a new ListAppsParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewListAppsParamsWithTimeout(timeout time.Duration) *ListAppsParams {
	var ()
	return &ListAppsParams{

		timeout: timeout,
	}
}

// NewListAppsParamsWithContext creates a new ListAppsParams object
// with the default values initialized, and the ability to set a context for a request
func NewListAppsParamsWithContext(ctx context.Context) *ListAppsParams {
	var ()
	return &ListAppsParams{

		Context: ctx,
	}
}

// NewListAppsParamsWithHTTPClient creates a new ListAppsParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewListAppsParamsWithHTTPClient(client *http.Client) *ListAppsParams {
	var ()
	return &ListAppsParams{
		HTTPClient: client,
	}
}

/*ListAppsParams contains all the parameters to send to the API endpoint
for the list apps operation typically these are written to a http.Request
*/
type ListAppsParams struct {

	/*Cursor
	  Cursor from previous response.next_cursor to begin results after, if any.

	*/
	Cursor *string
	/*Name
	  The Application name to filter by.

	*/
	Name *string
	/*PerPage
	  Number of results to return, defaults to 30. Max of 100.

	*/
	PerPage *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the list apps params
func (o *ListAppsParams) WithTimeout(timeout time.Duration) *ListAppsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list apps params
func (o *ListAppsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list apps params
func (o *ListAppsParams) WithContext(ctx context.Context) *ListAppsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list apps params
func (o *ListAppsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list apps params
func (o *ListAppsParams) WithHTTPClient(client *http.Client) *ListAppsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list apps params
func (o *ListAppsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCursor adds the cursor to the list apps params
func (o *ListAppsParams) WithCursor(cursor *string) *ListAppsParams {
	o.SetCursor(cursor)
	return o
}

// SetCursor adds the cursor to the list apps params
func (o *ListAppsParams) SetCursor(cursor *string) {
	o.Cursor = cursor
}

// WithName adds the name to the list apps params
func (o *ListAppsParams) WithName(name *string) *ListAppsParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the list apps params
func (o *ListAppsParams) SetName(name *string) {
	o.Name = name
}

// WithPerPage adds the perPage to the list apps params
func (o *ListAppsParams) WithPerPage(perPage *int64) *ListAppsParams {
	o.SetPerPage(perPage)
	return o
}

// SetPerPage adds the perPage to the list apps params
func (o *ListAppsParams) SetPerPage(perPage *int64) {
	o.PerPage = perPage
}

// WriteToRequest writes these params to a swagger request
func (o *ListAppsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Cursor != nil {

		// query param cursor
		var qrCursor string
		if o.Cursor != nil {
			qrCursor = *o.Cursor
		}
		qCursor := qrCursor
		if qCursor != "" {
			if err := r.SetQueryParam("cursor", qCursor); err != nil {
				return err
			}
		}

	}

	if o.Name != nil {

		// query param name
		var qrName string
		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {
			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}

	}

	if o.PerPage != nil {

		// query param per_page
		var qrPerPage int64
		if o.PerPage != nil {
			qrPerPage = *o.PerPage
		}
		qPerPage := swag.FormatInt64(qrPerPage)
		if qPerPage != "" {
			if err := r.SetQueryParam("per_page", qPerPage); err != nil {
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
