---
title: "Verifying Releases"
---

fabio releases can be verified by comparing the SHA256 checksum
and by verifying the checksums with a GPG key.

You can verify the SHA256 checksums with the GPG key below.
You can also download it from most key servers using the ID

For fabio release 5.14 and newer:

[`76462AB9B0C185ABC66FD98F59861FC4870361CA`](https://keyserver.ubuntu.com/pks/lookup?search=76462AB9B0C185ABC66FD98F59861FC4870361CA&fingerprint=on&op=index)

    -----BEGIN PGP PUBLIC KEY BLOCK-----

    mQINBF40mfQBEADHOlocoiOY66SLZtzJjCNKFeerYH2zHNU3sLK+sHp/76MUrPV4
    uDG3T6a6QK0HUKLy/hxKh/wftNCOaSYTwNVbYJ1EYBnBEgxuKNM8K5xOCKjwWrXF
    J80xoXBJXXmJvOFHEoWjUnDAMVUJyf3bt0sT0vOA5OTdbd2LhimDOpeIiO/umZKp
    0ZsDcjUPUuIenqnKyk4UwAfXdWxrj2g5/But1n3nasvgtEtQg9CaSloh6Zgzcy+3
    I+jpCn2FLOay+THABkM+XmjSYudkIFlqsZwkB2GxwTaRXENt8QUK7i4GWVCcPN6x
    gYgIz9uLZQXkkxGZvasC5fUm/W6F0pyz1wUbbizhDuBhoez3XdJdhW8nWCT6rg5M
    ejgkSVoG/fqoG9SoFXeTlQjZJSc8+0pTgWsqnuwmM+eFllvORSKS7uwBNg7jvFPv
    4yLGCR5bGxTX7VM4XPkLR2pUF/nHmSohiGOWpqw+PRVwOWBBMi+r4c4SckR4MMOB
    NK+KJTQnildsnqw/mvf98Op4GrAtD4MQDFRKD2TSIq60qFTe6MF77P50Z33r6x5x
    CPN7XYTzZKPPiHf5uWtyOvH3V+vxHX2N0zAsRADXW+Jsly/Wwt0k8Km3beaF/Jvw
    AFQwneh50L5Pv+Tb+8b6xS8gvIeGPgs4lcxRDxFEcFKN58OjtDelN212cQARAQAB
    tCVhZG1pbkBmYWJpb2xiLm5ldCA8YWRtaW5AZmFiaW9sYi5uZXQ+iQJUBBMBCgA+
    FiEEdkYqubDBhavGb9mPWYYfxIcDYcoFAl40mfQCGwMFCQk/xgAFCwkIBwMFFQoJ
    CAsFFgIDAQACHgECF4AACgkQWYYfxIcDYcqCgQ/8CfH2EBmBlHB7jlI4nFu17fqV
    WTXxhuo2UcTCQ3G8at32V27FZTFq64rtY7/QmY3HyHhdn77NXzIlLDsaD07IEBpw
    GFf05V1vVm/Y+DB/3vmHr+bEP5bB4RZqYz+U1cSGTEg2S3sOuz416gJdoCFN8Lin
    1fHRuGfZTJ2j2oQhUsYbt+GBpPm7xtpqK4yfCd4gT2vhDzbDG9QSLMrrLh/aA6Ya
    IcZZCsXpnRPhfvPrp0LuIY9Lml+EaMfNxsoXYl2W5c+BpXG93ThSLKPc8XM/7e4A
    CkRWNLKihVZNDmGCIy2FIFIV9YlEIhAAtZPhsUE3rnrIUgHETPYwDvAJB4pbJrLe
    bwnRuWZlYNsPZp8W4RxbQVcHpsg+sWoyAkykWxs9FbxgXEGd0+wP5tumFquyfijg
    eQLnsFU7KlQA+5Rh6ulrvzMNHFBYLoPa+U1soR6Jg0hCPhkzc+6tzTrmUCg7H7+i
    49szuN2KZr6k5GR+f2p9mOlnHmjJSJVULtnBQJMfTEnqzszvw9OgO1j72x7hTVRO
    UQSV6NXr0GFr293iTJS1x2/zFETCZelxVwbyp0t/psDz8nv6aXMcSjzcoWgmRRcP
    zpfNidLLp3Ym9XKtz7kvPI/PRTsHoO+qw6H6Kw8jMxxIv5hApCI/YOt5GFBlXmZq
    hBckyt1rS0kW5zQsStS5Ag0EXjSZ9AEQAMrim1LXqnqdMJlc6sj++TZgoLeYmtSI
    4n/J1AGk9/BIumJKgCL5TPvUhz7HUWjhOqhtH/1/EyxPTI25Up7QcQKb0TYG/6Gn
    3mIeBsvTdPZWmwq0e7aCrTSU8bYNnuMKAFxlPPG/lu7v1QQkaPgbEMOZI7cDA7V8
    TLs/uQcAjGPdu2f2mJ/m+kgjeOwud+43CF4aI2/eVd39DqjjDrRImUc3OXypE4vW
    PRq2ooSnS7VE0yU3QBubdPB8Y7x7R5bDE9fgLjZ9t//bSLgZfVzZoc7TvycH9opk
    zr1LD4XEdZYFWc1h7++ci+f75/QQppPto3ItK61oUnpyO5J0Bl/Ay7086xU8b5Be
    mPFDVMUE8SW2a+baaDKwbYUvImSI2CwNkCuYieGuAueMkY+Coe7AdaDhtuzINkby
    e9ALGGbpRi/ByURQoW9akQt+ap7I8/bdp+IFYWT8K1HFogd5y0+TYaatpnT9jJYM
    64GtnDhyD2ncyLNM1a7YOn4e+WWiK8datzn962VsaSXjAPKvVROkgLoedDU9oiDm
    ITDZgcsyY6ATgYmzlN2Qm8ubig1adZdGWsWzv0d9Qj8AEzsPqRVrQ6Ofc/sNi5Y3
    ELSOpWUOetbKEBFYe3oA2Bu6LOqd3lcKittWke3RMkehKFqxFdmBwjcrCtIjLicv
    IemWK6rAAYmJABEBAAGJAjwEGAEKACYWIQR2Riq5sMGFq8Zv2Y9Zhh/EhwNhygUC
    XjSZ9AIbDAUJCT/GAAAKCRBZhh/EhwNhyrzoEACe9SVpr6TaFvIcfcvj9d4FOmiK
    Tgm64SEnYDDs6JhzD3p38Ut80d6y2vg9WUMUA3dhftbAyr/rqkZghiV3UhWJGPJm
    AGWVG3p5TpSPCloFUlHHMWXCJm4UAoo75ud15PYD8CtUfOYc68A7a+9f+1dC5gRy
    rVjBltWshsai+CjksRlg64wGMvJL7ghcsGoxFOzU/khGvo5JZ3OzObscYLxBKPnY
    sUPerHnKB63CYxNfkd2aziapE7zXqoN1ZAFKwsBp38CiuBIT+8bb6+vAy9azfW/J
    mGqjn4vfBUpdTsPbRRRI3CAoUN8R5QqVCCzV6hcv2p921ZWNpO0QxaHJYq0W3mwH
    ls5eJOWJwx3qZ8ZB84fnuUb1YhzNjOSJDjgE8ZJ1iHf+ZTpqNRNbsyshfPcI5FYR
    /PKPXTGNTeTFAXiQ/UjxFK/UEVWs3mDfqtyvC+Z5s7jCGabPwoOvWeHGMHUWWZRv
    NU+TL+pUMWY29wKsDsk7zriokCDApNnJJb52/tIzk/XHMLPBjGSoYinKYMALYbAp
    6UvSeJ6cJ/+5vwXJadMyiYrsPPQiuVCUfVg6KcX6B/+2MaKoyY3s8DaZ1vFdtZcg
    1tjLI383GOEuDGfUDOgrlTikgpxbT2q4Zq80aQhPD8mMlpqdTO4UWfvwwx0FPH04
    5xVKlvTztaHhtaWHkg==
    =b3Un
    -----END PGP PUBLIC KEY BLOCK-----


For release 5.13 and older:

[`D8B19A29317E92E470D7CD67021E03CADDA53977`](http://pgp.key-server.io/search/0xD8B19A29317E92E470D7CD67021E03CADDA53977)


	-----BEGIN PGP PUBLIC KEY BLOCK-----
	Version: GnuPG v2

	mQENBFHXufMBCADO35ztkc+e22Oyfxa7npmqljgZs4O3qFB3YBY0AiFqZ+YDwc1P
	2sb9r76M6J9sMiijFHZ4NZkHm1NOPgiEK13fLc/cDlrDMbbv7yqrBlYZuaQxPvCw
	Bv+zAyVyNqy79sbQpXId7bokAMthrAf69x9F1/HaBmqspi6/8JWcQmNcGVqaABRk
	eQSB/Oq8DYBawroMRUGNtyTMKJ5FAbsYeDH7kiOlBtJxaxdhzlMX/4W6PUVXCOF+
	44CKVWl7eIwXkdbkAVOy2AgqG6b+X9svbjNvV0GFErozHwCjIxSKT2m/jTkey4oq
	st9eBuNClEKtduxjCzkbhLX+Xvqg9vPNCY1NABEBAAG0K0ZyYW5rIFNjaHJvZWRl
	ciA8ZnJhbmsuc2Nocm9lZGVyQGdtYWlsLmNvbT6JAT4EEwECACgCGy8GCwkIBwMC
	BhUIAgkKCwQWAgMBAh4BAheABQJX1Z3mBQkJwErzAAoJEAIeA8rdpTl3MucIAIqx
	0qPeNCiT0EnJfMNaI0ttx/+Y+hF/35XqXbuhAXDPUSwqyNAt+6qdKwnc7J4ZVZx6
	rdH0jUoNbXoN/y/QUsmtktiQqmnyFaAT3CUphg5ZcB6g+/RUPJ0uyXY+UgB7LhLd
	tyYyxJamfhpf0O+IEVQ+MqTvI6glCoN0s7LGGJR+/E5xbrJv8VdGrHFSPe6i4nU9
	axz38MzEkHPDYUcd+6QaYN82tiuL+ipkHudOOs4aO02x18g6cg7BBZFKrAPLP7SX
	TTG94mRhf9OEeKc/gTrHqQ+ZBrwyDZKS13LHoHYLkRVIyWDl3t3SU/U+TGsroR4a
	dGQoe4tJPzZ3X5hAlK20JkZyYW5rIFNjaHJvZWRlciA8ZnJzY2hyb2VkZXJAZWJh
	eS5jb20+iQE+BBMBAgAoAhsvBgsJCAcDAgYVCAIJCgsEFgIDAQIeAQIXgAUCV9Wd
	5gUJCcBK8wAKCRACHgPK3aU5d5hFCACe+JXpMRfqsfvc8rc4euxg0GSQGI8XfBx+
	qziCO37cPTtAxyQGg5Z/ZXe6xv1kDP73mUkpZ9DLBlbCdYtC/l1LG+cYV8f/sa9K
	FTn924j86R5ABqwgyo2ACE5iDFOA52ud2ZqVrjjOfqzShQZGanM+X+9A+5NHO7ZD
	RG2LqR+b9VG8bKIhbCddu6q0/CB722PSqCVo4tAZ4W6oiA2D6QB/GfMUswSntN7e
	nhyjEWM6701Kk5hcTrsAIEMPRLwz+NwEb63cJ5XNsIl6vIsBkGtuxTSz/2/ecwlp
	hh4XWLTG+I+AkEo4mUUCMdieRf+IGjXXnogmJyfGtE2BTraO+v48tC1GcmFuayBT
	Y2hyb2VkZXIgPGZyYW5rLnNjaHJvZWRlckBnby1sZWZ0LmNvbT6JAT4EEwECACgC
	Gy8GCwkIBwMCBhUIAgkKCwQWAgMBAh4BAheABQJX1Z3mBQkJwErzAAoJEAIeA8rd
	pTl3qqkH/2Jmm44cZNDAmleoOq/gOBdDUE1Ot8wiNOnaa08Eem9DyRJ312TDXUTu
	gyCyNFfimln4G+XYRqw6r1Vxxtv7VMZmAaVd2q6aAC+SEbAYo32mNU5cVF1FTu04
	VTUlkV5jkG1mHBOVs3yxkxd+YPZQsXD3GaaFhd6/NCpqrAxzkGcEZvoHWz8vGTlf
	RxX5qnQeLg8VxttjSuXpfHbYptAwYmX+nDC6lL9IriJhRFtH3dVed2iHIiYtxlF6
	7enUv6PndL1GHHXNzl5CFtJaG2Tr8NgdCTycymLAonXvm8j4zE1jRihnZ4TS+6Zk
	UYS6G01WlBeHLEvCCxt8vpzKQFgg0kS5AQ0EUde58wEIAMgdQBVvrzrIJmN6i5B0
	6Ey7bUBUijqiAQ5ful+aKANEePdshgapphfJstRAz+ppjZsBwN2XKFtVbY5znzDZ
	dukvqB8A9KXOt0a4TT/q9JPE2ivlhp2ldhAr8LUcBNSLNTKKR5HwOSrMVxTaP6Pq
	ZwbeW6NuDsPCLk0YpkcT13YrDK29IObZMr6g7UkZ3UD0w99OveQdimMvslIwd/sp
	wP9oRefqZ1vhyllOA0SFmSlzTk7iSLrBzoGAXALhGpUdxN1LsCIvDZGydm7YtOGX
	GOu+VTA6odHOB5urEEGn+dMPlF1qEcqirvYFmnamcnjrhn2nbxLn8jz2MRlNTGPt
	88sAEQEAAYkCRAQYAQoADwIbLgUCV9WeGQUJCcBLJgEpwF0gBBkBCgAGBQJR17nz
	AAoJEE1lxursh97NIVsH/i1edqJvxH2naj49hMp3m8OSUj0cOkTA1rebeF33YFLn
	XqHUdL1DelFQIZ8zXcS5E5iB7OceqxNjoJaGU0k4yXg4IU52xtHcwM2FqxtRNMds
	4yb+Hpopm2oLl9lsnA/Rm9pqNGoVN6Hc/mbueYpVxB1jKFqH1mX3+G/h5Z6YzPXg
	jf6F8SLgM1kfJA7zb77Gghe5+xtYNGqoqRFne3YqHApXYfTbOFxr+5+32v2m7ib/
	OI4p5Zq/y/F5+QLn+phGsWeYrmGCalyTzxCZvDgtgDsucqF55G8EIxiPQ/IQrs+y
	/VuL+nvIZjKJO8X8r0AXNk7HA/KTxTUkRYArAwLj+skJEAIeA8rdpTl3nnYH/1z6
	tNBVVDRl/jU9m0yj4PpNMZUjd+t0jH3WzMrqKbN7/Io8kFCLJdmg4+97tXjVtRbR
	CWw7K43cOpQchXh3t+cwtcfdJd6TOqJCO21laQL0CBIZlNS9lQ7c4J9eew3MKe4Y
	D22kOes/SXAIONU/KNP+aLXy8iMvXcxKe3vsZj4g4Huk4+mXkoFIrVit/tm7PIqm
	VZd8lFRK841qZdL+vc/JQR8b8o3CtTbBJ4KO/sylw0M0EHsIQv2TL//NABiCuob/
	gjpASGi/ZqGVKl/twu9ZaL3Z07uOGOlAlvU5VVlA/1gf39BoUA1ZL5loPNlERPIF
	oqPZ3VIfhRjqQbvOnDU=
	=OeUJ
	-----END PGP PUBLIC KEY BLOCK-----

## Checksum Verification

If you would like to verify the checksum of a fabio download,
please note that only the `sha256` file is signed by the GPG key
below. The binaries themselves are not signed, but rather hashed.
To verify the integrity of a particular binary:

Download the binary, `sha256`, and `sha256.sig` files
Verify the `sha256` file is properly signed
Verify the `sha256` in the file matches the binary

For example:

```
# This is the public key from above - one-time step.
gpg --import fabiolb.asc

# Download the binary and signature files.
curl -OsL https://github.com/fabiolb/fabio/releases/download/v1.5.14/fabio-1.5.14-go1.15-linux_amd64
curl -OsL https://github.com/fabiolb/fabio/releases/download/v1.5.14/fabio-1.5.14-go1.15.sha256
curl -OsL https://github.com/fabiolb/fabio/releases/download/v1.5.14/fabio-1.5.14-go1.15.sha256.sig

# Verify the signature file is untampered.
gpg --verify fabio-1.5.14-go1.15.sha256.sig fabio-1.5.14-go1.15.sha256
# Verify the SHASUM matches the binary.
grep linux_amd64 fabio-1.5.14-go1.15.sha256 | shasum -a 256 -c -
```

## Note

Parts of this text have been taken from the [HashiCorp Security Page](https://www.hashicorp.com/security.html)
which describes the procedure which is also used for fabio.
