package ui

import (
	"html/template"
	"net/http"
)

type ManualHandler struct {
	BasePath string
	Color    string
	Title    string
	Version  string
	Commands string
}

func (h *ManualHandler) ServeHTTP(w http.ResponseWriter, r *http.Request) {
	path := r.RequestURI[len(h.BasePath):]
	data := struct {
		*ManualHandler
		Path    string
		APIPath string
	}{
		ManualHandler: h,
		Path:          path,
		APIPath:       "/api/manual" + path,
	}
	tmplManual.ExecuteTemplate(w, "manual", data)
}

var funcs = template.FuncMap{
	"noescape": func(str string) template.HTML {
		return template.HTML(str)
	},
}

var tmplManual = template.Must(template.New("manual").Funcs(funcs).Parse( // language=HTML
	`<!doctype html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<title>fabio{{if .Title}} - {{.Title}}{{end}}</title>
	<script type="text/javascript" src="/assets/code.jquery.com/jquery-3.6.0.min.js"></script>
	<link href="/assets/fonts/material-icons.css" rel="stylesheet">
	<link rel="stylesheet" href="/assets/cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/css/materialize.min.css">
	<script src="/assets/cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/js/materialize.min.js"></script>
	<meta name="viewport" content="width=device-width, initial-scale=1.0"/>

	<style type="text/css">
		.footer { padding-top: 10px; }
		.logo { height: 32px; margin: 0 auto; display: block; }
	</style>
</head>
<body>

<ul id="overrides" class="dropdown-content"></ul>

<nav class="top-nav {{.Color}}">

	<div class="container">
		<div class="nav-wrapper">
			<a href="/" class="brand-logo"><img alt="Fabio Logo" style="margin: 15px 0" class="logo" src="/assets/logo.bw.svg"> {{if .Title}} - {{.Title}}{{end}}</a>
			<ul id="nav-mobile" class="right hide-on-med-and-down">
				<li><a href="/routes">Routes</a></li>
				<li><a class="dropdown-trigger dropdown-button" href="#" data-target="overrides">Overrides<i class="material-icons right">arrow_drop_down</i></a></li>
				<li><a href="https://github.com/fabiolb/fabio/blob/master/CHANGELOG.md">{{.Version}}</a></li>
				<li><a href="https://github.com/fabiolb/fabio">Github</a></li>
				<li><a href="https://fabiolb.net">Fabiolb.net</a></li>
			</ul>
		</div>
	</div>

</nav>

<div class="container">

	<div class="section">
		<h5>Manual Routes{{if .Path}} for "{{.Path}}"{{end}}</h5>

		<div class="row">
			<form class="col s12">
				<input type="hidden" name="version">
				<div class="row">
					<div class="input-field col s12">
						<textarea id="textarea1" class="materialize-textarea"></textarea>
						<label for="textarea1"></label>
					</div>
				</div>
			</form>
			<button class="btn waves-effect waves-light" name="save">Save</button>
			<button class="btn waves-effect waves-light" name="help">Help</button>
		</div>

		<div class="row">
			<pre class="help hide">{{.Commands}}</pre>
		</div>
	</div>

</div>

<script>
$(function(){
	$('.dropdown-trigger').dropdown();
	let params={};window.location.search.replace(/[?&]+([^=&]+)=([^&]*)/gi,function(str,key,value){params[key] = value;});

	$.get({{.APIPath}}, function(data) {
		const $ta1 = $("#textarea1");
		$("input[name=version]").val(data.version);
		$("textarea>label").val("Version " + data.version);
		$ta1.val(data.value);
		M.textareaAutoResize($('#textarea1'));
	});

	$.get('/api/paths', function(data) {
		const d = $("#overrides");
		$.each(data, function(idx, val) {
			let path = val;
			if (val == "") {
				val = "default";
			}
			d.append(
				$('<li />').append(
					$('<a />').attr('href', '/manual'+path).text(val)
				)
			);
		});
	});

	$("button[name=help]").click(function() {
		$("pre.help").toggleClass("hide");
	});

	$("button[name=save]").click(function() {
		const data = {
			value   : $("#textarea1").val(),
			version : $("input[name=version]").val()
		}
		$.ajax({{.APIPath}}, {
			type: 'PUT',
			data: JSON.stringify(data),
			contentType: 'application/json',
			statusCode: {
				400: function(jqXHR, textStatus, err) { alert(err); },
				409: function(jqXHR, textStatus, err) { alert(err); },
				500: function(jqXHR, textStatus, err) { alert(err); }
			},
			success: function() {
				window.location.reload();
			}
		});
	});
})
</script>

</body>
</html>
`))
