---
title: "Config Language"
weight: 550
---

The routing table is configured with commands in the language specified below.
Rules are automatically generated by the configured backend. Additional rules
can be stored in the Consul KV store configured by
[`registry.consul.kvpath`](/ref/registry.consul.kvpath/) which by default is
`/fabio/config`. 

As of fabio 1.5.7 the path is interpreted as a prefix and the values of all sub
keys are appended in alphabetical order. When the
[`log.routes.format`](/ref/log.routes.format/) is set to `all` then the routing
table contains comments on the source of the fragment.

### Comments

Blank lines and lines starting with `#` or `//` are ignored.

### `route add`

Add a route for a service `svc` for the `src` (e.g. `/path` or `:port`) to a `dst` (e.g. `URL` or `host:port`).

`route add <svc> <src> <dst>[ weight <w>][ tags "<t1>,<t2>,..."][ opts "k1=v1 k2=v2 ..."]`

Option                                     | Description
------------------------------------------ | -----------
`allow=ip:10.0.0.0/8,ip:fe80::/10`         | Restrict access to source addresses within the `10.0.0.0/8` or `fe80::/10` CIDR mask.  All other requests will be denied.
`deny=ip:10.0.0.0/8,ip:fe80::1234`         | Deny requests that source from the `10.0.0.0/8` CIDR mask or `fe80::1234`.  All other requests will be allowed.
`strip=/path`                              | Forward `/path/to/file` as `/to/file`
`prepend=/prefix`                          | Forward `/path/to/file` as `/prefix/path/to/file`
`proto=tcp`                                | Upstream service is TCP, `dst` must be `:port`
`pxyproto=true`                            | Enables PROXY protocol on outbount TCP connection
`proto=https`                              | Upstream service is HTTPS
`tlsskipverify=true`                       | Disable TLS cert validation for HTTPS upstream
`host=name`                                | Set the `Host` header to `name`. If `name == 'dst'` then the `Host` header will be set to the registered upstream host name
`register=name`                            | Register fabio as new service `name`. Useful for registering hostnames for host specific routes.
`auth=name`                                | Specify an auth scheme to use (must be registered with the fabio server using `proxy.auth`)

##### Example

```
# route traffic for product-svc to 1.2.3.4:8000 and :9000
route add product-svc /product http://1.2.3.4:8000
route add product-svc /product http://1.2.3.4:9000
```

### `route del`

Remove one or more routes which match the given criteria.

```
route del <svc>[ <src>[ <dst>]]
route del <svc> tags "<t1>,<t2>,..."
route del tags "<t1>,<t2>,..."
```

##### Example

```
# remove all routes for 'product-svc'
route del product-svc

# remove all routes for 'product-svc' and /path
route del product-svc /path

# remove single route
route del product-svc /path http://1.2.3.4:8000

# remove all routes for 'product-svc' matching a tag
route del product-svc tags "green"

# remove all routes matching a tag
route del tags "yesterday"
```

### `route weight`

Directs a certain amount of traffic to instances matching certain criteria.

The weight `w` is expressed as follows:

 * `w` is a float > 0 describing a percentage, e.g. 0.5 == 50%
 * `w <= 0`: means no fixed weighting. Traffic is evenly distributed
 * `w > 0`: route will receive n% of traffic. If sum(w) > 1 then w is normalized.
 * `sum(w) >= 1`: only matching services will receive traffic

Note that the total sum of traffic sent to all matching routes is `w`%.

The order of commands matters but routes are always ordered from most to least
specific by prefix length.

```
route weight <svc> <src> weight <w> tags "<t1>,<t2>,..."
route weight <src> weight <w> tags "<t1>,<t2>,..."
route weight <svc> <src> weight <w>
route weight service host/path weight w tags "tag1,tag2"
```

##### Example

```
# Route 5% of the traffic to product-svc:/path with tags "green"
route weight product-svc /path weight .05 tags "green"

# Route 5% of the traffic to '/path' to the Go implementation.
# Route the rest (95%) to the other implementation
route weight /path weight .05 tags "lang=go"

# Route 5% of the traffice to '/path' on the product-svc-go
route weight product-svc-go /path weight .05
```

### Routing rules

The routing table contains first all routes with a host sorted by prefix
length in descending order and then all routes without a host again sorted by
prefix length in descending order.

For each incoming request the routing table is searched top to bottom for a
matching route. A route matches if either `host/path` or - if there was no
match - just `/path` matches.

The matching route determines the target URL depending on the configured
strategy. `rnd` and `rr` are available with `rnd` being the default.

##### Example

The auto-generated routing table is

```
route add service-a www.mp.dev/accounts/ http://host-a:11050/ tags "a,b"
route add service-a www.kjca.dev/accounts/ http://host-a:11050/ tags "a,b"
route add service-a www.dba.dev/accounts/ http://host-a:11050/ tags "a,b"
route add service-b www.mp.dev/auth/ http://host-b:11080/ tags "a,b"
route add service-b www.kjca.dev/auth/ http://host-b:11080/ tags "a,b"
route add service-b www.dba.dev/auth/ http://host-b:11080/ tags "a,b"
```

The manual configuration under `/fabio/config` is

```
route del service-b www.dba.dev/auth/
route add service-c www.somedomain.com/ http://host-z:12345/
```

The complete routing table then is

```
route add service-a www.mp.dev/accounts/ http://host-a:11050/ tags "a,b"
route add service-a www.kjca.dev/accounts/ http://host-a:11050/ tags "a,b"
route add service-a www.dba.dev/accounts/ http://host-a:11050/ tags "a,b"
route add service-b www.mp.dev/auth/ http://host-b:11080/ tags "a,b"
route add service-b www.kjca.dev/auth/ http://host-b:11080/ tags "a,b"
route add service-c www.somedomain.com/ http://host-z:12345/
```
