# Configuration
## Configuration sources

Settings can be specified in three ways (in order of precedence): 

1. Command line arguments.
1. Environment variables starting with **`DKRON_`**
1. **`dkron.yml`** config file

:::caution
Dkron sends anonymous usage data to a server with the purpose of elaborating usage statistics, if you want to disable statistics collection, you can disable it in the dkron config file or in the command line using `--disable-usage-stats` parameter
:::

## Config file location

Config file will be loaded from the following paths:

- `/etc/dkron`
- `$HOME/.dkron`
- `./config`

### Config file example

```yaml
# Dkron example configuration file
# server: false
# bootstrap-expect: 3
# data-dir: dkron.data
# log-level: debug
# tags:
#   dc: east
# encrypt: a-valid-key-generated-with-dkron-keygen
# retry-join:
#   - 10.0.0.1
#   - 10.0.0.2
#   - 10.0.0.3
# raft-multiplier: 1
# webhook-url: https://hooks.slack.com/services/XXXXXX/XXXXXXX/XXXXXXXXXXXXXXXXXXXX
# webhook-payload: "payload={\"text\": \"{{.Report}}\", \"channel\": \"#foo\"}"
# webhook-headers: Content-Type:application/x-www-form-urlencoded
# mail-host: email-smtp.eu-west-1.amazonaws.com
# mail-port: 25
# mail-username": mailuser
# mail-password": mailpassword
# mail-from": cron@example.com
# mail-subject_prefix: [Dkron]
# mail-payload: "Job {{.JobName}} finished with status {{.Success}} on node {{.NodeName}}\n\nOutput:\n{{.Output}}"
```

## Important Configuration Parameters

Here's a detailed explanation of the key configuration parameters:

### Core Configuration

| Parameter | Description |
|-----------|-------------|
| `server` | When set to `true`, the agent runs in server mode and participates in leader election. Default: `false` |
| `bootstrap-expect` | Number of expected servers in the cluster. When this many servers are available, Dkron will bootstrap the cluster and start a leader election. This helps automate cluster formation. |
| `data-dir` | Directory for storing server-specific data including the replicated log. Default: `dkron.data` |
| `log-level` | Log verbosity level: `debug`, `info`, `warn`, `error`, `fatal`, `panic`. Default: `info` |

### Networking and Cluster Formation

| Parameter | Description |
|-----------|-------------|
| `bind-addr` | Address to bind for network services. Uses go-sockaddr template format. Default: `{{ GetPrivateIP }}:8946` |
| `http-addr` | Address to bind the UI web server to. Format: `:8080` |
| `advertise-addr` | Address advertised to other nodes. Uses the bind address by default. |
| `advertise-rpc-port` | RPC port advertised to clients. Uses `rpc-port` by default. |
| `rpc-port` | Port used for RPC communication with clients. Default: `6868` |
| `join` | Initial agent to join with. Can be specified multiple times. |
| `retry-join` | Address of agent to join with retries. Can be specified multiple times. |
| `retry-interval` | Time to wait between join attempts. Default: `30s` |
| `retry-max` | Maximum number of join attempts. `0` means retry indefinitely. |
| `encrypt` | Key for encrypting network traffic. Must be a base64-encoded 16-byte key generated by `dkron keygen` |

### Node Configuration

| Parameter | Description |
|-----------|-------------|
| `node-name` | Name of this node. Must be unique in the cluster. Default: system hostname |
| `datacenter` | Data center of the local agent. All members of a datacenter should share a LAN connection. Default: `dc1` |
| `region` | Region the agent belongs to. A region typically maps to a geographic region. Default: `global` |
| `tag` | Attach key/value tag pairs to the node. Format: `key=value`. Can be specified multiple times. |

### Performance and Scaling

| Parameter | Description |
|-----------|-------------|
| `raft-multiplier` | Integer multiplier for Raft timing parameters. Lower values increase sensitivity to failures but require more resources. 1 is high-performance, 10 is max. Default: `1` |
| `profile` | Controls timing profiles. Options: `lan`, `wan`, etc. Default: `lan` |
| `serf-reconnect-timeout` | Time to attempt reconnection to failed nodes before removing them. Default: `24h` |

### Notification Configuration

| Parameter | Description |
|-----------|-------------|
| `webhook-endpoint` | Endpoint URL to call for webhook notifications. |
| `webhook-payload` | Body of the POST request to send when calling the webhook. |
| `webhook-headers` | Headers to use when calling the webhook URL. Can be specified multiple times. |
| `mail-host` | Mail server hostname for sending notifications. |
| `mail-port` | Mail server port. |
| `mail-username` | Username for mail server authentication. |
| `mail-password` | Password for mail server authentication. |
| `mail-from` | From email address to use in notifications. |
| `mail-subject-prefix` | Prefix for the email subject line. Default: `[Dkron]` |
| `mail-payload` | Custom Go template for the email body. If not set, defaults to the execution output. Available template variables: `{{.Report}}`, `{{.JobName}}`, `{{.ReportingNode}}`, `{{.StartTime}}`, `{{.FinishedAt}}`, `{{.Success}}`, `{{.NodeName}}`, `{{.Output}}` |

### Metrics Configuration

| Parameter | Description |
|-----------|-------------|
| `statsd-addr` | Address of a statsd server for metrics collection. |
| `dog-statsd-addr` | Address of a DataDog statsd agent. |
| `dog-statsd-tags` | Tags to include with DataDog metrics. Format: `key:value` |
| `enable-prometheus` | When `true`, enables serving Prometheus metrics at the `/metrics` endpoint. |

## Environment Variables

All configuration options can also be specified as environment variables by:

1. Converting to uppercase
2. Replacing dashes with underscores
3. Prefixing with `DKRON_`

Example: `server: true` becomes `DKRON_SERVER=true`

### SEE ALSO

* [dkron agent](/docs/cli/dkron_agent/)	 - Start a dkron agent
* [dkron doc](/docs/cli/dkron_doc/)	 - Generate Markdown documentation for the Dkron CLI.
* [dkron keygen](/docs/cli/dkron_keygen/)	 - Generates a new encryption key
* [dkron version](/docs/cli/dkron_version/)	 - Show version
