// Package client provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen/v2 version v2.1.0 DO NOT EDIT.
package client

import (
	"bytes"
	"compress/gzip"
	"context"
	"encoding/base64"
	"encoding/json"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"path"
	"strings"

	"github.com/distribworks/dkron/v4/types"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
	"github.com/oapi-codegen/runtime"
	openapi_types "github.com/oapi-codegen/runtime/types"
)

const (
	TokenAuthScopes = "TokenAuth.Scopes"
)

// Execution An execution represents a timed job run.
type Execution = types.Execution

// Job A Job represents a scheduled task to execute.
type Job = types.Job

// Member A member represents a cluster member node.
type Member = types.Member

// Policy defines model for policy.
type Policy = types.Policy

// Processors Processor plugins used to process executions results of this job
type Processors map[string]map[string]string

// Restore Each job restore result.
type Restore = string

// RestoreBody defines model for restore_body.
type RestoreBody struct {
	// File Json file that needs to be restored.
	File openapi_types.File `json:"file"`
}

// Status Status represents details about the node.
type Status struct {
	// Agent Node basic details
	Agent *map[string]map[string]interface{} `json:"agent,omitempty"`

	// Serf Serf status
	Serf *map[string]map[string]interface{} `json:"serf,omitempty"`

	// Tags Tags asociated with this node
	Tags *map[string]string `json:"tags,omitempty"`
}

// GetJobsParams defines parameters for GetJobs.
type GetJobsParams struct {
	// Metadata Filter jobs by metadata
	Metadata *[]string `form:"metadata,omitempty" json:"metadata,omitempty"`

	// Sort Sorting field
	Sort *string `form:"_sort,omitempty" json:"_sort,omitempty"`

	// Order Sort order (ASC/DESC)
	Order *string `form:"_order,omitempty" json:"_order,omitempty"`

	// Q Filter query text
	Q *string `form:"q,omitempty" json:"q,omitempty"`

	// Start Start index
	Start *int `form:"_start,omitempty" json:"_start,omitempty"`

	// End End index
	End *int `form:"_end,omitempty" json:"_end,omitempty"`
}

// CreateOrUpdateJobPatchParams defines parameters for CreateOrUpdateJobPatch.
type CreateOrUpdateJobPatchParams struct {
	// Runoncreate If present, regardless of any value, causes the job to be run immediately after being succesfully created or updated.
	Runoncreate *bool `form:"runoncreate,omitempty" json:"runoncreate,omitempty"`
}

// CreateOrUpdateJobParams defines parameters for CreateOrUpdateJob.
type CreateOrUpdateJobParams struct {
	// Runoncreate If present, regardless of any value, causes the job to be run immediately after being succesfully created or updated.
	Runoncreate *bool `form:"runoncreate,omitempty" json:"runoncreate,omitempty"`
}

// CreateOrUpdateJobPatchJSONRequestBody defines body for CreateOrUpdateJobPatch for application/json ContentType.
type CreateOrUpdateJobPatchJSONRequestBody = Job

// CreateOrUpdateJobJSONRequestBody defines body for CreateOrUpdateJob for application/json ContentType.
type CreateOrUpdateJobJSONRequestBody = Job

// RestoreMultipartRequestBody defines body for Restore for multipart/form-data ContentType.
type RestoreMultipartRequestBody = RestoreBody

// RequestEditorFn  is the function signature for the RequestEditor callback function
type RequestEditorFn func(ctx context.Context, req *http.Request) error

// Doer performs HTTP requests.
//
// The standard http.Client implements this interface.
type HttpRequestDoer interface {
	Do(req *http.Request) (*http.Response, error)
}

// Client which conforms to the OpenAPI3 specification for this service.
type Client struct {
	// The endpoint of the server conforming to this interface, with scheme,
	// https://api.deepmap.com for example. This can contain a path relative
	// to the server, such as https://api.deepmap.com/dev-test, and all the
	// paths in the swagger spec will be appended to the server.
	Server string

	// Doer for performing requests, typically a *http.Client with any
	// customized settings, such as certificate chains.
	Client HttpRequestDoer

	// A list of callbacks for modifying requests which are generated before sending over
	// the network.
	RequestEditors []RequestEditorFn
}

// ClientOption allows setting custom parameters during construction
type ClientOption func(*Client) error

// Creates a new Client, with reasonable defaults
func NewClient(server string, opts ...ClientOption) (*Client, error) {
	// create a client with sane default values
	client := Client{
		Server: server,
	}
	// mutate client and add all optional params
	for _, o := range opts {
		if err := o(&client); err != nil {
			return nil, err
		}
	}
	// ensure the server URL always has a trailing slash
	if !strings.HasSuffix(client.Server, "/") {
		client.Server += "/"
	}
	// create httpClient, if not already present
	if client.Client == nil {
		client.Client = &http.Client{}
	}
	return &client, nil
}

// WithHTTPClient allows overriding the default Doer, which is
// automatically created using http.Client. This is useful for tests.
func WithHTTPClient(doer HttpRequestDoer) ClientOption {
	return func(c *Client) error {
		c.Client = doer
		return nil
	}
}

// WithRequestEditorFn allows setting up a callback function, which will be
// called right before sending the request. This can be used to mutate the request.
func WithRequestEditorFn(fn RequestEditorFn) ClientOption {
	return func(c *Client) error {
		c.RequestEditors = append(c.RequestEditors, fn)
		return nil
	}
}

// The interface specification for the client above.
type ClientInterface interface {
	// Status request
	Status(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeletePolicy request
	DeletePolicy(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ShowPolicyByName request
	ShowPolicyByName(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpsertPolicy request
	UpsertPolicy(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Busy request
	Busy(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetIsLeader request
	GetIsLeader(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetJobs request
	GetJobs(ctx context.Context, params *GetJobsParams, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateOrUpdateJobPatchWithBody request with any body
	CreateOrUpdateJobPatchWithBody(ctx context.Context, params *CreateOrUpdateJobPatchParams, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateOrUpdateJobPatch(ctx context.Context, params *CreateOrUpdateJobPatchParams, body CreateOrUpdateJobPatchJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateOrUpdateJobWithBody request with any body
	CreateOrUpdateJobWithBody(ctx context.Context, params *CreateOrUpdateJobParams, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateOrUpdateJob(ctx context.Context, params *CreateOrUpdateJobParams, body CreateOrUpdateJobJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteJob request
	DeleteJob(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ShowJobByName request
	ShowJobByName(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RunJob request
	RunJob(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListExecutionsByJob request
	ListExecutionsByJob(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ShowExecutionByID request
	ShowExecutionByID(ctx context.Context, jobName string, execution string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ToggleJob request
	ToggleJob(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetLeader request
	GetLeader(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// Leave request
	Leave(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetMember request
	GetMember(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RestoreWithBody request with any body
	RestoreWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)
}

func (c *Client) Status(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewStatusRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeletePolicy(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeletePolicyRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ShowPolicyByName(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewShowPolicyByNameRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpsertPolicy(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpsertPolicyRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Busy(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewBusyRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetIsLeader(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetIsLeaderRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetJobs(ctx context.Context, params *GetJobsParams, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetJobsRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateOrUpdateJobPatchWithBody(ctx context.Context, params *CreateOrUpdateJobPatchParams, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateOrUpdateJobPatchRequestWithBody(c.Server, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateOrUpdateJobPatch(ctx context.Context, params *CreateOrUpdateJobPatchParams, body CreateOrUpdateJobPatchJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateOrUpdateJobPatchRequest(c.Server, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateOrUpdateJobWithBody(ctx context.Context, params *CreateOrUpdateJobParams, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateOrUpdateJobRequestWithBody(c.Server, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateOrUpdateJob(ctx context.Context, params *CreateOrUpdateJobParams, body CreateOrUpdateJobJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateOrUpdateJobRequest(c.Server, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteJob(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteJobRequest(c.Server, jobName)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ShowJobByName(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewShowJobByNameRequest(c.Server, jobName)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RunJob(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRunJobRequest(c.Server, jobName)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListExecutionsByJob(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListExecutionsByJobRequest(c.Server, jobName)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ShowExecutionByID(ctx context.Context, jobName string, execution string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewShowExecutionByIDRequest(c.Server, jobName, execution)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ToggleJob(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewToggleJobRequest(c.Server, jobName)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetLeader(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetLeaderRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Leave(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewLeaveRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetMember(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetMemberRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RestoreWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRestoreRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

// NewStatusRequest generates requests for Status
func NewStatusRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewDeletePolicyRequest generates requests for DeletePolicy
func NewDeletePolicyRequest(server string, name string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/acl/policies/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewShowPolicyByNameRequest generates requests for ShowPolicyByName
func NewShowPolicyByNameRequest(server string, name string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/acl/policies/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpsertPolicyRequest generates requests for UpsertPolicy
func NewUpsertPolicyRequest(server string, name string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/acl/policies/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewBusyRequest generates requests for Busy
func NewBusyRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/busy")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetIsLeaderRequest generates requests for GetIsLeader
func NewGetIsLeaderRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/isleader")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetJobsRequest generates requests for GetJobs
func NewGetJobsRequest(server string, params *GetJobsParams) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/jobs")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	if params != nil {
		queryValues := queryURL.Query()

		if params.Metadata != nil {

			if queryFrag, err := runtime.StyleParamWithLocation("form", true, "metadata", runtime.ParamLocationQuery, *params.Metadata); err != nil {
				return nil, err
			} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
				return nil, err
			} else {
				for k, v := range parsed {
					for _, v2 := range v {
						queryValues.Add(k, v2)
					}
				}
			}

		}

		if params.Sort != nil {

			if queryFrag, err := runtime.StyleParamWithLocation("form", true, "_sort", runtime.ParamLocationQuery, *params.Sort); err != nil {
				return nil, err
			} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
				return nil, err
			} else {
				for k, v := range parsed {
					for _, v2 := range v {
						queryValues.Add(k, v2)
					}
				}
			}

		}

		if params.Order != nil {

			if queryFrag, err := runtime.StyleParamWithLocation("form", true, "_order", runtime.ParamLocationQuery, *params.Order); err != nil {
				return nil, err
			} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
				return nil, err
			} else {
				for k, v := range parsed {
					for _, v2 := range v {
						queryValues.Add(k, v2)
					}
				}
			}

		}

		if params.Q != nil {

			if queryFrag, err := runtime.StyleParamWithLocation("form", true, "q", runtime.ParamLocationQuery, *params.Q); err != nil {
				return nil, err
			} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
				return nil, err
			} else {
				for k, v := range parsed {
					for _, v2 := range v {
						queryValues.Add(k, v2)
					}
				}
			}

		}

		if params.Start != nil {

			if queryFrag, err := runtime.StyleParamWithLocation("form", true, "_start", runtime.ParamLocationQuery, *params.Start); err != nil {
				return nil, err
			} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
				return nil, err
			} else {
				for k, v := range parsed {
					for _, v2 := range v {
						queryValues.Add(k, v2)
					}
				}
			}

		}

		if params.End != nil {

			if queryFrag, err := runtime.StyleParamWithLocation("form", true, "_end", runtime.ParamLocationQuery, *params.End); err != nil {
				return nil, err
			} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
				return nil, err
			} else {
				for k, v := range parsed {
					for _, v2 := range v {
						queryValues.Add(k, v2)
					}
				}
			}

		}

		queryURL.RawQuery = queryValues.Encode()
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateOrUpdateJobPatchRequest calls the generic CreateOrUpdateJobPatch builder with application/json body
func NewCreateOrUpdateJobPatchRequest(server string, params *CreateOrUpdateJobPatchParams, body CreateOrUpdateJobPatchJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateOrUpdateJobPatchRequestWithBody(server, params, "application/json", bodyReader)
}

// NewCreateOrUpdateJobPatchRequestWithBody generates requests for CreateOrUpdateJobPatch with any type of body
func NewCreateOrUpdateJobPatchRequestWithBody(server string, params *CreateOrUpdateJobPatchParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/jobs")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	if params != nil {
		queryValues := queryURL.Query()

		if params.Runoncreate != nil {

			if queryFrag, err := runtime.StyleParamWithLocation("form", true, "runoncreate", runtime.ParamLocationQuery, *params.Runoncreate); err != nil {
				return nil, err
			} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
				return nil, err
			} else {
				for k, v := range parsed {
					for _, v2 := range v {
						queryValues.Add(k, v2)
					}
				}
			}

		}

		queryURL.RawQuery = queryValues.Encode()
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewCreateOrUpdateJobRequest calls the generic CreateOrUpdateJob builder with application/json body
func NewCreateOrUpdateJobRequest(server string, params *CreateOrUpdateJobParams, body CreateOrUpdateJobJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateOrUpdateJobRequestWithBody(server, params, "application/json", bodyReader)
}

// NewCreateOrUpdateJobRequestWithBody generates requests for CreateOrUpdateJob with any type of body
func NewCreateOrUpdateJobRequestWithBody(server string, params *CreateOrUpdateJobParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/jobs")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	if params != nil {
		queryValues := queryURL.Query()

		if params.Runoncreate != nil {

			if queryFrag, err := runtime.StyleParamWithLocation("form", true, "runoncreate", runtime.ParamLocationQuery, *params.Runoncreate); err != nil {
				return nil, err
			} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
				return nil, err
			} else {
				for k, v := range parsed {
					for _, v2 := range v {
						queryValues.Add(k, v2)
					}
				}
			}

		}

		queryURL.RawQuery = queryValues.Encode()
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteJobRequest generates requests for DeleteJob
func NewDeleteJobRequest(server string, jobName string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "job_name", runtime.ParamLocationPath, jobName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/jobs/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewShowJobByNameRequest generates requests for ShowJobByName
func NewShowJobByNameRequest(server string, jobName string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "job_name", runtime.ParamLocationPath, jobName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/jobs/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRunJobRequest generates requests for RunJob
func NewRunJobRequest(server string, jobName string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "job_name", runtime.ParamLocationPath, jobName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/jobs/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListExecutionsByJobRequest generates requests for ListExecutionsByJob
func NewListExecutionsByJobRequest(server string, jobName string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "job_name", runtime.ParamLocationPath, jobName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/jobs/%s/executions", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewShowExecutionByIDRequest generates requests for ShowExecutionByID
func NewShowExecutionByIDRequest(server string, jobName string, execution string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "job_name", runtime.ParamLocationPath, jobName)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "execution", runtime.ParamLocationPath, execution)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/jobs/%s/executions/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewToggleJobRequest generates requests for ToggleJob
func NewToggleJobRequest(server string, jobName string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "job_name", runtime.ParamLocationPath, jobName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/jobs/%s/toggle", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetLeaderRequest generates requests for GetLeader
func NewGetLeaderRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/leader")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewLeaveRequest generates requests for Leave
func NewLeaveRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/leave")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetMemberRequest generates requests for GetMember
func NewGetMemberRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/members")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRestoreRequestWithBody generates requests for Restore with any type of body
func NewRestoreRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/restore")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

func (c *Client) applyEditors(ctx context.Context, req *http.Request, additionalEditors []RequestEditorFn) error {
	for _, r := range c.RequestEditors {
		if err := r(ctx, req); err != nil {
			return err
		}
	}
	for _, r := range additionalEditors {
		if err := r(ctx, req); err != nil {
			return err
		}
	}
	return nil
}

// ClientWithResponses builds on ClientInterface to offer response payloads
type ClientWithResponses struct {
	ClientInterface
}

// NewClientWithResponses creates a new ClientWithResponses, which wraps
// Client with return type handling
func NewClientWithResponses(server string, opts ...ClientOption) (*ClientWithResponses, error) {
	client, err := NewClient(server, opts...)
	if err != nil {
		return nil, err
	}
	return &ClientWithResponses{client}, nil
}

// WithBaseURL overrides the baseURL.
func WithBaseURL(baseURL string) ClientOption {
	return func(c *Client) error {
		newBaseURL, err := url.Parse(baseURL)
		if err != nil {
			return err
		}
		c.Server = newBaseURL.String()
		return nil
	}
}

// ClientWithResponsesInterface is the interface specification for the client with responses above.
type ClientWithResponsesInterface interface {
	// StatusWithResponse request
	StatusWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*StatusResponse, error)

	// DeletePolicyWithResponse request
	DeletePolicyWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeletePolicyResponse, error)

	// ShowPolicyByNameWithResponse request
	ShowPolicyByNameWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*ShowPolicyByNameResponse, error)

	// UpsertPolicyWithResponse request
	UpsertPolicyWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*UpsertPolicyResponse, error)

	// BusyWithResponse request
	BusyWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*BusyResponse, error)

	// GetIsLeaderWithResponse request
	GetIsLeaderWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetIsLeaderResponse, error)

	// GetJobsWithResponse request
	GetJobsWithResponse(ctx context.Context, params *GetJobsParams, reqEditors ...RequestEditorFn) (*GetJobsResponse, error)

	// CreateOrUpdateJobPatchWithBodyWithResponse request with any body
	CreateOrUpdateJobPatchWithBodyWithResponse(ctx context.Context, params *CreateOrUpdateJobPatchParams, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateOrUpdateJobPatchResponse, error)

	CreateOrUpdateJobPatchWithResponse(ctx context.Context, params *CreateOrUpdateJobPatchParams, body CreateOrUpdateJobPatchJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateOrUpdateJobPatchResponse, error)

	// CreateOrUpdateJobWithBodyWithResponse request with any body
	CreateOrUpdateJobWithBodyWithResponse(ctx context.Context, params *CreateOrUpdateJobParams, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateOrUpdateJobResponse, error)

	CreateOrUpdateJobWithResponse(ctx context.Context, params *CreateOrUpdateJobParams, body CreateOrUpdateJobJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateOrUpdateJobResponse, error)

	// DeleteJobWithResponse request
	DeleteJobWithResponse(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*DeleteJobResponse, error)

	// ShowJobByNameWithResponse request
	ShowJobByNameWithResponse(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*ShowJobByNameResponse, error)

	// RunJobWithResponse request
	RunJobWithResponse(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*RunJobResponse, error)

	// ListExecutionsByJobWithResponse request
	ListExecutionsByJobWithResponse(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*ListExecutionsByJobResponse, error)

	// ShowExecutionByIDWithResponse request
	ShowExecutionByIDWithResponse(ctx context.Context, jobName string, execution string, reqEditors ...RequestEditorFn) (*ShowExecutionByIDResponse, error)

	// ToggleJobWithResponse request
	ToggleJobWithResponse(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*ToggleJobResponse, error)

	// GetLeaderWithResponse request
	GetLeaderWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetLeaderResponse, error)

	// LeaveWithResponse request
	LeaveWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*LeaveResponse, error)

	// GetMemberWithResponse request
	GetMemberWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetMemberResponse, error)

	// RestoreWithBodyWithResponse request with any body
	RestoreWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*RestoreResponse, error)
}

type StatusResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Status
}

// Status returns HTTPResponse.Status
func (r StatusResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r StatusResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeletePolicyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Policy
}

// Status returns HTTPResponse.Status
func (r DeletePolicyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeletePolicyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ShowPolicyByNameResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Policy
}

// Status returns HTTPResponse.Status
func (r ShowPolicyByNameResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ShowPolicyByNameResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpsertPolicyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON202      *Policy
}

// Status returns HTTPResponse.Status
func (r UpsertPolicyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpsertPolicyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type BusyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *[]Execution
}

// Status returns HTTPResponse.Status
func (r BusyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r BusyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetIsLeaderResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r GetIsLeaderResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetIsLeaderResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetJobsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *[]Job
}

// Status returns HTTPResponse.Status
func (r GetJobsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetJobsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateOrUpdateJobPatchResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Job
}

// Status returns HTTPResponse.Status
func (r CreateOrUpdateJobPatchResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateOrUpdateJobPatchResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateOrUpdateJobResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Job
}

// Status returns HTTPResponse.Status
func (r CreateOrUpdateJobResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateOrUpdateJobResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteJobResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Job
}

// Status returns HTTPResponse.Status
func (r DeleteJobResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteJobResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ShowJobByNameResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Job
}

// Status returns HTTPResponse.Status
func (r ShowJobByNameResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ShowJobByNameResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RunJobResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON202      *Job
}

// Status returns HTTPResponse.Status
func (r RunJobResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RunJobResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListExecutionsByJobResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *[]Execution
}

// Status returns HTTPResponse.Status
func (r ListExecutionsByJobResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListExecutionsByJobResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ShowExecutionByIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Execution
}

// Status returns HTTPResponse.Status
func (r ShowExecutionByIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ShowExecutionByIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ToggleJobResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Job
}

// Status returns HTTPResponse.Status
func (r ToggleJobResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ToggleJobResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetLeaderResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Member
}

// Status returns HTTPResponse.Status
func (r GetLeaderResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetLeaderResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type LeaveResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *[]Member
}

// Status returns HTTPResponse.Status
func (r LeaveResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r LeaveResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetMemberResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *[]Member
}

// Status returns HTTPResponse.Status
func (r GetMemberResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetMemberResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RestoreResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *[]Restore
}

// Status returns HTTPResponse.Status
func (r RestoreResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RestoreResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// StatusWithResponse request returning *StatusResponse
func (c *ClientWithResponses) StatusWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*StatusResponse, error) {
	rsp, err := c.Status(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseStatusResponse(rsp)
}

// DeletePolicyWithResponse request returning *DeletePolicyResponse
func (c *ClientWithResponses) DeletePolicyWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeletePolicyResponse, error) {
	rsp, err := c.DeletePolicy(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeletePolicyResponse(rsp)
}

// ShowPolicyByNameWithResponse request returning *ShowPolicyByNameResponse
func (c *ClientWithResponses) ShowPolicyByNameWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*ShowPolicyByNameResponse, error) {
	rsp, err := c.ShowPolicyByName(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseShowPolicyByNameResponse(rsp)
}

// UpsertPolicyWithResponse request returning *UpsertPolicyResponse
func (c *ClientWithResponses) UpsertPolicyWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*UpsertPolicyResponse, error) {
	rsp, err := c.UpsertPolicy(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpsertPolicyResponse(rsp)
}

// BusyWithResponse request returning *BusyResponse
func (c *ClientWithResponses) BusyWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*BusyResponse, error) {
	rsp, err := c.Busy(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseBusyResponse(rsp)
}

// GetIsLeaderWithResponse request returning *GetIsLeaderResponse
func (c *ClientWithResponses) GetIsLeaderWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetIsLeaderResponse, error) {
	rsp, err := c.GetIsLeader(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetIsLeaderResponse(rsp)
}

// GetJobsWithResponse request returning *GetJobsResponse
func (c *ClientWithResponses) GetJobsWithResponse(ctx context.Context, params *GetJobsParams, reqEditors ...RequestEditorFn) (*GetJobsResponse, error) {
	rsp, err := c.GetJobs(ctx, params, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetJobsResponse(rsp)
}

// CreateOrUpdateJobPatchWithBodyWithResponse request with arbitrary body returning *CreateOrUpdateJobPatchResponse
func (c *ClientWithResponses) CreateOrUpdateJobPatchWithBodyWithResponse(ctx context.Context, params *CreateOrUpdateJobPatchParams, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateOrUpdateJobPatchResponse, error) {
	rsp, err := c.CreateOrUpdateJobPatchWithBody(ctx, params, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateOrUpdateJobPatchResponse(rsp)
}

func (c *ClientWithResponses) CreateOrUpdateJobPatchWithResponse(ctx context.Context, params *CreateOrUpdateJobPatchParams, body CreateOrUpdateJobPatchJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateOrUpdateJobPatchResponse, error) {
	rsp, err := c.CreateOrUpdateJobPatch(ctx, params, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateOrUpdateJobPatchResponse(rsp)
}

// CreateOrUpdateJobWithBodyWithResponse request with arbitrary body returning *CreateOrUpdateJobResponse
func (c *ClientWithResponses) CreateOrUpdateJobWithBodyWithResponse(ctx context.Context, params *CreateOrUpdateJobParams, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateOrUpdateJobResponse, error) {
	rsp, err := c.CreateOrUpdateJobWithBody(ctx, params, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateOrUpdateJobResponse(rsp)
}

func (c *ClientWithResponses) CreateOrUpdateJobWithResponse(ctx context.Context, params *CreateOrUpdateJobParams, body CreateOrUpdateJobJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateOrUpdateJobResponse, error) {
	rsp, err := c.CreateOrUpdateJob(ctx, params, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateOrUpdateJobResponse(rsp)
}

// DeleteJobWithResponse request returning *DeleteJobResponse
func (c *ClientWithResponses) DeleteJobWithResponse(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*DeleteJobResponse, error) {
	rsp, err := c.DeleteJob(ctx, jobName, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteJobResponse(rsp)
}

// ShowJobByNameWithResponse request returning *ShowJobByNameResponse
func (c *ClientWithResponses) ShowJobByNameWithResponse(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*ShowJobByNameResponse, error) {
	rsp, err := c.ShowJobByName(ctx, jobName, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseShowJobByNameResponse(rsp)
}

// RunJobWithResponse request returning *RunJobResponse
func (c *ClientWithResponses) RunJobWithResponse(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*RunJobResponse, error) {
	rsp, err := c.RunJob(ctx, jobName, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRunJobResponse(rsp)
}

// ListExecutionsByJobWithResponse request returning *ListExecutionsByJobResponse
func (c *ClientWithResponses) ListExecutionsByJobWithResponse(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*ListExecutionsByJobResponse, error) {
	rsp, err := c.ListExecutionsByJob(ctx, jobName, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListExecutionsByJobResponse(rsp)
}

// ShowExecutionByIDWithResponse request returning *ShowExecutionByIDResponse
func (c *ClientWithResponses) ShowExecutionByIDWithResponse(ctx context.Context, jobName string, execution string, reqEditors ...RequestEditorFn) (*ShowExecutionByIDResponse, error) {
	rsp, err := c.ShowExecutionByID(ctx, jobName, execution, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseShowExecutionByIDResponse(rsp)
}

// ToggleJobWithResponse request returning *ToggleJobResponse
func (c *ClientWithResponses) ToggleJobWithResponse(ctx context.Context, jobName string, reqEditors ...RequestEditorFn) (*ToggleJobResponse, error) {
	rsp, err := c.ToggleJob(ctx, jobName, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseToggleJobResponse(rsp)
}

// GetLeaderWithResponse request returning *GetLeaderResponse
func (c *ClientWithResponses) GetLeaderWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetLeaderResponse, error) {
	rsp, err := c.GetLeader(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetLeaderResponse(rsp)
}

// LeaveWithResponse request returning *LeaveResponse
func (c *ClientWithResponses) LeaveWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*LeaveResponse, error) {
	rsp, err := c.Leave(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseLeaveResponse(rsp)
}

// GetMemberWithResponse request returning *GetMemberResponse
func (c *ClientWithResponses) GetMemberWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetMemberResponse, error) {
	rsp, err := c.GetMember(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetMemberResponse(rsp)
}

// RestoreWithBodyWithResponse request with arbitrary body returning *RestoreResponse
func (c *ClientWithResponses) RestoreWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*RestoreResponse, error) {
	rsp, err := c.RestoreWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRestoreResponse(rsp)
}

// ParseStatusResponse parses an HTTP response from a StatusWithResponse call
func ParseStatusResponse(rsp *http.Response) (*StatusResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &StatusResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Status
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeletePolicyResponse parses an HTTP response from a DeletePolicyWithResponse call
func ParseDeletePolicyResponse(rsp *http.Response) (*DeletePolicyResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeletePolicyResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Policy
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseShowPolicyByNameResponse parses an HTTP response from a ShowPolicyByNameWithResponse call
func ParseShowPolicyByNameResponse(rsp *http.Response) (*ShowPolicyByNameResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ShowPolicyByNameResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Policy
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpsertPolicyResponse parses an HTTP response from a UpsertPolicyWithResponse call
func ParseUpsertPolicyResponse(rsp *http.Response) (*UpsertPolicyResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpsertPolicyResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 202:
		var dest Policy
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON202 = &dest

	}

	return response, nil
}

// ParseBusyResponse parses an HTTP response from a BusyWithResponse call
func ParseBusyResponse(rsp *http.Response) (*BusyResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &BusyResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest []Execution
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetIsLeaderResponse parses an HTTP response from a GetIsLeaderWithResponse call
func ParseGetIsLeaderResponse(rsp *http.Response) (*GetIsLeaderResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetIsLeaderResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	return response, nil
}

// ParseGetJobsResponse parses an HTTP response from a GetJobsWithResponse call
func ParseGetJobsResponse(rsp *http.Response) (*GetJobsResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetJobsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest []Job
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateOrUpdateJobPatchResponse parses an HTTP response from a CreateOrUpdateJobPatchWithResponse call
func ParseCreateOrUpdateJobPatchResponse(rsp *http.Response) (*CreateOrUpdateJobPatchResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateOrUpdateJobPatchResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Job
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	}

	return response, nil
}

// ParseCreateOrUpdateJobResponse parses an HTTP response from a CreateOrUpdateJobWithResponse call
func ParseCreateOrUpdateJobResponse(rsp *http.Response) (*CreateOrUpdateJobResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateOrUpdateJobResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Job
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	}

	return response, nil
}

// ParseDeleteJobResponse parses an HTTP response from a DeleteJobWithResponse call
func ParseDeleteJobResponse(rsp *http.Response) (*DeleteJobResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteJobResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Job
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseShowJobByNameResponse parses an HTTP response from a ShowJobByNameWithResponse call
func ParseShowJobByNameResponse(rsp *http.Response) (*ShowJobByNameResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ShowJobByNameResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Job
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseRunJobResponse parses an HTTP response from a RunJobWithResponse call
func ParseRunJobResponse(rsp *http.Response) (*RunJobResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &RunJobResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 202:
		var dest Job
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON202 = &dest

	}

	return response, nil
}

// ParseListExecutionsByJobResponse parses an HTTP response from a ListExecutionsByJobWithResponse call
func ParseListExecutionsByJobResponse(rsp *http.Response) (*ListExecutionsByJobResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ListExecutionsByJobResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest []Execution
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseShowExecutionByIDResponse parses an HTTP response from a ShowExecutionByIDWithResponse call
func ParseShowExecutionByIDResponse(rsp *http.Response) (*ShowExecutionByIDResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ShowExecutionByIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Execution
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseToggleJobResponse parses an HTTP response from a ToggleJobWithResponse call
func ParseToggleJobResponse(rsp *http.Response) (*ToggleJobResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ToggleJobResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Job
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetLeaderResponse parses an HTTP response from a GetLeaderWithResponse call
func ParseGetLeaderResponse(rsp *http.Response) (*GetLeaderResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetLeaderResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Member
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseLeaveResponse parses an HTTP response from a LeaveWithResponse call
func ParseLeaveResponse(rsp *http.Response) (*LeaveResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LeaveResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest []Member
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetMemberResponse parses an HTTP response from a GetMemberWithResponse call
func ParseGetMemberResponse(rsp *http.Response) (*GetMemberResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetMemberResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest []Member
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseRestoreResponse parses an HTTP response from a RestoreWithResponse call
func ParseRestoreResponse(rsp *http.Response) (*RestoreResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &RestoreResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest []Restore
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ServerInterface represents all server handlers.
type ServerInterface interface {

	// (GET /)
	Status(ctx echo.Context) error

	// (DELETE /acl/policies/{name})
	DeletePolicy(ctx echo.Context, name string) error

	// (GET /acl/policies/{name})
	ShowPolicyByName(ctx echo.Context, name string) error

	// (POST /acl/policies/{name})
	UpsertPolicy(ctx echo.Context, name string) error

	// (GET /busy)
	Busy(ctx echo.Context) error

	// (GET /isleader)
	GetIsLeader(ctx echo.Context) error

	// (GET /jobs)
	GetJobs(ctx echo.Context, params GetJobsParams) error

	// (PATCH /jobs)
	CreateOrUpdateJobPatch(ctx echo.Context, params CreateOrUpdateJobPatchParams) error

	// (POST /jobs)
	CreateOrUpdateJob(ctx echo.Context, params CreateOrUpdateJobParams) error

	// (DELETE /jobs/{job_name})
	DeleteJob(ctx echo.Context, jobName string) error

	// (GET /jobs/{job_name})
	ShowJobByName(ctx echo.Context, jobName string) error

	// (POST /jobs/{job_name})
	RunJob(ctx echo.Context, jobName string) error

	// (GET /jobs/{job_name}/executions)
	ListExecutionsByJob(ctx echo.Context, jobName string) error

	// (GET /jobs/{job_name}/executions/{execution})
	ShowExecutionByID(ctx echo.Context, jobName string, execution string) error

	// (POST /jobs/{job_name}/toggle)
	ToggleJob(ctx echo.Context, jobName string) error

	// (GET /leader)
	GetLeader(ctx echo.Context) error

	// (POST /leave)
	Leave(ctx echo.Context) error

	// (GET /members)
	GetMember(ctx echo.Context) error

	// (POST /restore)
	Restore(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// Status converts echo context to params.
func (w *ServerInterfaceWrapper) Status(ctx echo.Context) error {
	var err error

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.Status(ctx)
	return err
}

// DeletePolicy converts echo context to params.
func (w *ServerInterfaceWrapper) DeletePolicy(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "name" -------------
	var name string

	err = runtime.BindStyledParameterWithOptions("simple", "name", ctx.Param("name"), &name, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter name: %s", err))
	}

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.DeletePolicy(ctx, name)
	return err
}

// ShowPolicyByName converts echo context to params.
func (w *ServerInterfaceWrapper) ShowPolicyByName(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "name" -------------
	var name string

	err = runtime.BindStyledParameterWithOptions("simple", "name", ctx.Param("name"), &name, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter name: %s", err))
	}

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.ShowPolicyByName(ctx, name)
	return err
}

// UpsertPolicy converts echo context to params.
func (w *ServerInterfaceWrapper) UpsertPolicy(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "name" -------------
	var name string

	err = runtime.BindStyledParameterWithOptions("simple", "name", ctx.Param("name"), &name, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter name: %s", err))
	}

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.UpsertPolicy(ctx, name)
	return err
}

// Busy converts echo context to params.
func (w *ServerInterfaceWrapper) Busy(ctx echo.Context) error {
	var err error

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.Busy(ctx)
	return err
}

// GetIsLeader converts echo context to params.
func (w *ServerInterfaceWrapper) GetIsLeader(ctx echo.Context) error {
	var err error

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetIsLeader(ctx)
	return err
}

// GetJobs converts echo context to params.
func (w *ServerInterfaceWrapper) GetJobs(ctx echo.Context) error {
	var err error

	ctx.Set(TokenAuthScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetJobsParams
	// ------------- Optional query parameter "metadata" -------------

	err = runtime.BindQueryParameter("form", true, false, "metadata", ctx.QueryParams(), &params.Metadata)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter metadata: %s", err))
	}

	// ------------- Optional query parameter "_sort" -------------

	err = runtime.BindQueryParameter("form", true, false, "_sort", ctx.QueryParams(), &params.Sort)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter _sort: %s", err))
	}

	// ------------- Optional query parameter "_order" -------------

	err = runtime.BindQueryParameter("form", true, false, "_order", ctx.QueryParams(), &params.Order)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter _order: %s", err))
	}

	// ------------- Optional query parameter "q" -------------

	err = runtime.BindQueryParameter("form", true, false, "q", ctx.QueryParams(), &params.Q)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter q: %s", err))
	}

	// ------------- Optional query parameter "_start" -------------

	err = runtime.BindQueryParameter("form", true, false, "_start", ctx.QueryParams(), &params.Start)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter _start: %s", err))
	}

	// ------------- Optional query parameter "_end" -------------

	err = runtime.BindQueryParameter("form", true, false, "_end", ctx.QueryParams(), &params.End)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter _end: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetJobs(ctx, params)
	return err
}

// CreateOrUpdateJobPatch converts echo context to params.
func (w *ServerInterfaceWrapper) CreateOrUpdateJobPatch(ctx echo.Context) error {
	var err error

	ctx.Set(TokenAuthScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params CreateOrUpdateJobPatchParams
	// ------------- Optional query parameter "runoncreate" -------------

	err = runtime.BindQueryParameter("form", true, false, "runoncreate", ctx.QueryParams(), &params.Runoncreate)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter runoncreate: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.CreateOrUpdateJobPatch(ctx, params)
	return err
}

// CreateOrUpdateJob converts echo context to params.
func (w *ServerInterfaceWrapper) CreateOrUpdateJob(ctx echo.Context) error {
	var err error

	ctx.Set(TokenAuthScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params CreateOrUpdateJobParams
	// ------------- Optional query parameter "runoncreate" -------------

	err = runtime.BindQueryParameter("form", true, false, "runoncreate", ctx.QueryParams(), &params.Runoncreate)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter runoncreate: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.CreateOrUpdateJob(ctx, params)
	return err
}

// DeleteJob converts echo context to params.
func (w *ServerInterfaceWrapper) DeleteJob(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "job_name" -------------
	var jobName string

	err = runtime.BindStyledParameterWithOptions("simple", "job_name", ctx.Param("job_name"), &jobName, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter job_name: %s", err))
	}

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.DeleteJob(ctx, jobName)
	return err
}

// ShowJobByName converts echo context to params.
func (w *ServerInterfaceWrapper) ShowJobByName(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "job_name" -------------
	var jobName string

	err = runtime.BindStyledParameterWithOptions("simple", "job_name", ctx.Param("job_name"), &jobName, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter job_name: %s", err))
	}

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.ShowJobByName(ctx, jobName)
	return err
}

// RunJob converts echo context to params.
func (w *ServerInterfaceWrapper) RunJob(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "job_name" -------------
	var jobName string

	err = runtime.BindStyledParameterWithOptions("simple", "job_name", ctx.Param("job_name"), &jobName, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter job_name: %s", err))
	}

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.RunJob(ctx, jobName)
	return err
}

// ListExecutionsByJob converts echo context to params.
func (w *ServerInterfaceWrapper) ListExecutionsByJob(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "job_name" -------------
	var jobName string

	err = runtime.BindStyledParameterWithOptions("simple", "job_name", ctx.Param("job_name"), &jobName, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter job_name: %s", err))
	}

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.ListExecutionsByJob(ctx, jobName)
	return err
}

// ShowExecutionByID converts echo context to params.
func (w *ServerInterfaceWrapper) ShowExecutionByID(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "job_name" -------------
	var jobName string

	err = runtime.BindStyledParameterWithOptions("simple", "job_name", ctx.Param("job_name"), &jobName, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter job_name: %s", err))
	}

	// ------------- Path parameter "execution" -------------
	var execution string

	err = runtime.BindStyledParameterWithOptions("simple", "execution", ctx.Param("execution"), &execution, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter execution: %s", err))
	}

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.ShowExecutionByID(ctx, jobName, execution)
	return err
}

// ToggleJob converts echo context to params.
func (w *ServerInterfaceWrapper) ToggleJob(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "job_name" -------------
	var jobName string

	err = runtime.BindStyledParameterWithOptions("simple", "job_name", ctx.Param("job_name"), &jobName, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter job_name: %s", err))
	}

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.ToggleJob(ctx, jobName)
	return err
}

// GetLeader converts echo context to params.
func (w *ServerInterfaceWrapper) GetLeader(ctx echo.Context) error {
	var err error

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetLeader(ctx)
	return err
}

// Leave converts echo context to params.
func (w *ServerInterfaceWrapper) Leave(ctx echo.Context) error {
	var err error

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.Leave(ctx)
	return err
}

// GetMember converts echo context to params.
func (w *ServerInterfaceWrapper) GetMember(ctx echo.Context) error {
	var err error

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetMember(ctx)
	return err
}

// Restore converts echo context to params.
func (w *ServerInterfaceWrapper) Restore(ctx echo.Context) error {
	var err error

	ctx.Set(TokenAuthScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.Restore(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface) {
	RegisterHandlersWithBaseURL(router, si, "")
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/", wrapper.Status)
	router.DELETE(baseURL+"/acl/policies/:name", wrapper.DeletePolicy)
	router.GET(baseURL+"/acl/policies/:name", wrapper.ShowPolicyByName)
	router.POST(baseURL+"/acl/policies/:name", wrapper.UpsertPolicy)
	router.GET(baseURL+"/busy", wrapper.Busy)
	router.GET(baseURL+"/isleader", wrapper.GetIsLeader)
	router.GET(baseURL+"/jobs", wrapper.GetJobs)
	router.PATCH(baseURL+"/jobs", wrapper.CreateOrUpdateJobPatch)
	router.POST(baseURL+"/jobs", wrapper.CreateOrUpdateJob)
	router.DELETE(baseURL+"/jobs/:job_name", wrapper.DeleteJob)
	router.GET(baseURL+"/jobs/:job_name", wrapper.ShowJobByName)
	router.POST(baseURL+"/jobs/:job_name", wrapper.RunJob)
	router.GET(baseURL+"/jobs/:job_name/executions", wrapper.ListExecutionsByJob)
	router.GET(baseURL+"/jobs/:job_name/executions/:execution", wrapper.ShowExecutionByID)
	router.POST(baseURL+"/jobs/:job_name/toggle", wrapper.ToggleJob)
	router.GET(baseURL+"/leader", wrapper.GetLeader)
	router.POST(baseURL+"/leave", wrapper.Leave)
	router.GET(baseURL+"/members", wrapper.GetMember)
	router.POST(baseURL+"/restore", wrapper.Restore)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+xbfW/cNtL/KoT6AG2BzcpO0zypgQMaJ26bXJoYsXu4Q2I4XGm0y4QiVZKyvWfsdz/M",
	"kNJqV9R6nc1b7/JPXiRqZsj5zW+GQ+51kumy0gqUs8nBdWKzGZSc/glXkNVOaIX/ycFmRlT+v8lDxdq3",
	"zEBlwKIAxpkTJeTsrZ4wU6txMkoqoyswTgDJLIQSdgb5OXd9qZczUMzNoCO7GY/SlFDTZJQU2pT4dZJz",
	"B3dQXzJK3LyC5CCxzuCgxSh5qyfnipfQ14K20ZtRAle8rCRa9oo+2E/OIqKUzmFAFj5luiCjcRhzM+6C",
	"+ZDT40yXJVf5mrb8ndEqrk7Xrqojq1Nx4wSXzL9vtAbxyyVbU/QbSKlZYXTJHqPOqErruHEDTqF35NZG",
	"ZVfVds6wdZaBtX3hq842tWJhaFHL+VLSRGsJXCWLRftIT95C5pJRcnVnqu+IstIGAfzqOqm4myUHyVS4",
	"WT0ZZ7pMc4GmTC61eWdTWvn04l6KgmyyOAsiglx6Oj5qp+ihFIkA9hQx3oU+hk5eS/Q7t++Y0w0Q+mGQ",
	"aZXVxoDK5n3Rj5YvWaWlyOas0IaWHrHLpdSXaaHNRKyjil5FPZxDBSoH5c7f6knEEQ+N4XOWaeW4wDhr",
	"tFmPaP+5ZRrjU+Df6+GzogBNEA5KUtSzxQDPXyg5Tw6cqaE1lqMJZKuwfCIh71v5OLxh1nHX4hEV9qFC",
	"cirJ5/HIfS4yIBroru2YvaD3XI5jMAZjtDnPdK0icfK8Lidg0KaCC7SxxbVNBucslIMpGBJOw7XpSz4K",
	"b1gl66lQrLYIMU3hspx/1xl2BlJGcdBoOc+0KsQUlfE8F37SxysYjWBok1UVN7wEB8auGkMJhhjwIIFs",
	"ptm365T0LQXhalyTqZUwYKOkhLFH7zkRR+Cd7chIcuvOyZV9uc+4DVxHMMdw894ckj7g1zVtg/wX0dcm",
	"jyUTEhW+n/oSHM+54zs52hnOGkHM8akNMeMtXne3LgqRocBDbjKQWvG4fwfisheSf1hgWsk5k/oSDMu4",
	"BSbBIdLYd7USmc7h+xHLxVQ4O2K1ysHYTBtgmBdzbmfjfqofyPRwFYtsuHKdLLUJbDf6Q18qiODuBT5e",
	"5bOuwceSO9THToGX8aIBBZxDyYWMEAg+bqR7C1blV0H+z+EhZs2omoqbhuJ7Wk5nnlBTkXdm4vPHpZCS",
	"OSOmUzBrFR4NjSGpqyxqi9EYH9oQiP/PQJEcJN+ky3I2DbVs2hlJ6ceZgPwhBkdvWqJYcGbOeEPpy/js",
	"FVp3z2Kk3pQEkSRvNNbQWD5YKnQ7kF9bh5/hAsyc7e/Z4eJtmCaX9dv25Zrjro4s0Ak9H4ZpQ3NnWwRC",
	"GHtzNl3S4G0zKjLVDrx3ys0UHJX11rPeIFSvEwvmAgM7QWPifIer/W8snPqRE96wyxkYaCOHgmYCbUYY",
	"s8M5y6HgtXTEbbRfKgTInAnLLDiqOcvKzZmf1GhVFhYMQjGpMy4JEetIO6pxgdJDMFLEdgoUPX/WwmBx",
	"9ioJu6gW5GefqDp/qic+tyFGYqW5f7NanWeytg5M8w7d2q/LH+Z5ROCTY4YvENqr67X/093x/v0H4/3x",
	"/g//Hw3OxyBhyh08qiNyT8AULA8jWGW005mWzBf/jl2AIWogzNHuMuMq5DeH/teG2Qr4u1Wr7kWZqDHk",
	"d361tSElvxJlXb6vIT9uNkSo7Q0R6taG9DU/jxccKCbSD9iwQz/WJkJZ+JQp4q1VUQ9+unc/uhTHYX7D",
	"4PhQmLi7Uf8wJj4UFG7QPwiFnRBwIxRPBvIcVjIW1duVhEfqLMABmzlX2YM0nepcZ2NtpmmHz2bczkSm",
	"TZWiDPrjm9+JdIK+Fcv2o5ad7pq6ppZxqzPBcSdxKdxsuWLrqctU2Tkn3lvls4P7D+4/QHpfSW2jJLjg",
	"dYIfjPfGe7F096kaNX5hqRykTgkuziqlx6P+2PdVInGPdcU5H9g+v6xlrHIM0gy9XSvd6dXTkxfP4/n0",
	"k6ySN6JfNA/Ba2vY9YqctXVptIUmgW17F8GOTknHDNhauo1VViHC8hfaXHKT+9pvES23DFinTcT1Rzyb",
	"+Qa1HxEUj+PFLMsMYC4abg8HMecTnUfghyZHCnNLvW0ZGsYKIKf9xgQaq/Jxt1yfCMXNPLmpICNlscW4",
	"oaLvFEo5OC6kZXyia9fSXr9S4lPwdfsNWBmCBqXdCbcia1QO1/SdeYApdlB6siT1bbS5j8vCN+hfbDPC",
	"QlYb4eYnuNX1Vp3qd6Ae1sga1wlm1mQGPKeixLdckn/eob7bHRq5BBWvxN9hnixQrlCF7sPlX7qmfJvp",
	"sqyVyDAwaFokj9VWqCnj7OXRySnu15D12MPjJ0xfgGG/nZ4ej8NIv6mqbc2lnDMprAPFtGJIe+zNg70H",
	"e29oR4wfI8DBOjtmDyXuAX2I4kaGFtNCRn0Ebm1dhnia6/rbC2CFrlXOeHN2xCStA+OOvaE90Exbd0DK",
	"xq/Va+VNEyi+DJuG4ZlgtPaWwerCXXIDLJMCJTTT9RMkm7sznLTbuVvOzUBYa4zPZkeIkv08wgO/eLbS",
	"yoJlaFatPKMgHGlKPPeHVG8qA87N/4Ywe+NbuThBP5pGNILGrwkxwiGtJX56uEqobVkcYGlwR3P7A/Wm",
	"KlC8EslB8sN4f7yHVMLdjLCa4h9TiFTTv4Kz7I3npzfMI97rxgiktu+TvGUwiqYwU5R1d28vHLO4hqaq",
	"SqKnhFbpW+vPNH1/6KbuUeALCos1Olm2JhrtPqcTb7xKgmeSM3yY8kymVKQIsOk1huLCT1uCi6SIx/Sc",
	"8XAEFJu7HxKSOzXnmg48Jst+TRsOk3opx5uQ+wxYSWSng4JLCyPPH1SCtOwRaqZl3vHctFzMSD9pTmix",
	"FFtUo3w0b4Uy8D281fgmOVuM4pg8menLjQ7BAd4dh/Pnfpne2ykFuGz21Sldp1TaxrxCRZw2rK5y7pDp",
	"Nnjoj8qCcbcOGToodJpRafYZXXL3y3IJ0tqktvNBFn8JrjbK+gwSsvCy5I856BDF7QjF9uh50wJA94h/",
	"9Qh6V6YX1lcag8vyaAbZOyYK31IQCNlQm2jDCi3ppCu2Or+Ce2KfNeVcbJEiVXZHPs713t69TQMb9Rvm",
	"11whiM7tmbCObg4M2P8UP74h8n4R0oHx9w8m8/bssRt3Ppgo7P6sgfZGIe46oyOQGNrCtrcPmiDE2idZ",
	"jHpso41DFFPbfTuDzq02Ltkq8jcoZdogQL57ePIofXx08uj7LZXTZztpD94gwczBldtO85+7TZmOrYTK",
	"4WrbVcYvYjq753GblR6p/FYqge51ba/w7FMQ21t/OvJelDZKfozRyBPlwCgumb820WUG4gJKztxls9g5",
	"J7VPVtKzgks654wQhB/+wvxBg5/qyTGJ7fEF3XQ6Kis3/weXdeulNbMLFvoaI2Zgyk0uwVKDias5u8AP",
	"RyzjNW6P2uNq34SpcSNYQo5bdzlnvMAImABGvm8M0bWM0BzKl9NbrdeGoWNqpZX/Ooagzi2mCIJoP3wY",
	"2k0fpBogzPQx4r3gz73bDuVqQbPoQXr/Y1s1gNx7vWBCrkorycWazm6bbxXaI1ZJ4BYYHftPuVBMcgdm",
	"HGve9gw75HnTrVievArczl9wKfJOeH1GI7eK5WihvWsof43ir1H8kaL4hsgbs2MfMRkV3s2AHAqhqLP7",
	"PxXfTQmfXjeX5LdrRA3EuX8fje/+frq9Efb+/af2Zv8X2+64DeJj9Lup+TTgBHz7VE+2bztFHXG7ntN/",
	"vyPiedDffKb0N+CNl7XaJR7CL2c+owvufiEuiFBV2rkFuLEHsbnPhEPaX3nYw/lt/aUvQ1urc4L91w2i",
	"T98x63jxJjen1+2/F4MuJ3psxw1RZOvxw/mTxzv6+zO6exQzdUcgdu81f6F03gHgRwCc09Opv6sRp/1T",
	"ej9M+v79LrzvLfiafpfcf0MfnXi+6ZwXzRXfgcbzxrb5B5lvuJC88/mBBH6xAYi/aJNB5yenmtEH/ueg",
	"w0vwjKR+ikRRtpfyPuy5ipd7Q9oPgwZAEO4L/rVWoZm3X4XOxbY4Pl6Ge210fEI/s3vbXDeLFqtB3qae",
	"RFlLJypuXFpoU95pflG2XVisXJBbrN5ZizcfPoI3mlX7AO5o+Klz/YpYvnPx6tUZEqu/OetTQG1kcpDM",
	"nKsO0nT19lF6sZ8szhb/CQAA//8RqYVFij8AAA==",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %w", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	res := make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	resolvePath := PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		pathToFile := url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
