---
date: 2023-09-02
title: "dkron completion zsh"
slug: dkron_completion_zsh
url: /docs/pro/cli/dkron_completion_zsh/
---
## dkron completion zsh

Generate the autocompletion script for zsh

### Synopsis

Generate the autocompletion script for the zsh shell.

If shell completion is not already enabled in your environment you will need
to enable it.  You can execute the following once:

	echo "autoload -U compinit; compinit" >> ~/.zshrc

To load completions in your current shell session:

```
	source <(dkron completion zsh)
```

To load completions for every new session, execute once:

#### Linux:

	dkron completion zsh > "~/.zsh/completion/_dkron"

#### macOS:

	dkron completion zsh > $(brew --prefix)/share/zsh/site-functions/_dkron

You will need to start a new shell for this setup to take effect.


```
dkron completion zsh [flags]
```

### Options

```
  -h, --help              help for zsh
      --no-descriptions   disable completion descriptions
```

### Options inherited from parent commands

```
      --config string   config file (default is /etc/dkron/dkron.yml)
```

### SEE ALSO

* [dkron completion](/docs/pro/cli/dkron_completion/)	 - Generate the autocompletion script for the specified shell

###### Auto generated by spf13/cobra on 2-Sep-2023
