#!/usr/bin/env python3

import pathlib
from typing import Dict, List


def generate_spec(cwd: pathlib.Path, sources: dict) -> str:
    spec = """# Test Vector Specification

*This file is generated by sync.py. Do not edit by hand.*

"""

    for source_name, source_info in sorted(sources.items()):
        spec += f"## {source_name}\n\n"

        upstream_path = source_info["upstream_path"]
        vector_files = sorted(upstream_path.rglob("*.json"))

        for vector_file in vector_files:
            relative_path = vector_file.relative_to(upstream_path)
            converted_file = relative_path.with_suffix(".txt")

            spec += f"AWS-LC MUST test against `{converted_file}`.\n\n"

    return spec


def write_spec(cwd: pathlib.Path, sources: dict):
    spec_file = cwd / "vectors_spec.md"
    content = generate_spec(cwd, sources)
    spec_file.write_text(content)
